/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.function.Consumer;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.shared.NotFoundException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.SSEParseException;
import org.apache.jena.sparql.sse.builders.BuilderExpr;
import org.apache.jena.sparql.sse.builders.BuilderGraph;
import org.apache.jena.sparql.sse.builders.BuilderOp;
import org.apache.jena.sparql.sse.builders.BuilderPath;
import org.apache.jena.sparql.sse.builders.BuilderTable;
import org.apache.jena.sparql.sse.lang.ParseHandler;
import org.apache.jena.sparql.sse.lang.ParseHandlerPlain;
import org.apache.jena.sparql.sse.lang.ParseHandlerResolver;
import org.apache.jena.sparql.sse.lang.SSE_Parser;
import org.apache.jena.sparql.sse.writers.WriterExpr;
import org.apache.jena.sparql.sse.writers.WriterGraph;
import org.apache.jena.sparql.sse.writers.WriterNode;
import org.apache.jena.sparql.sse.writers.WriterOp;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.sparql.vocabulary.FOAF;
import org.apache.jena.sparql.vocabulary.ListPFunction;
import org.apache.jena.system.JenaSystem;
import org.apache.jena.util.FileUtils;
import org.apache.jena.vocabulary.DC;
import org.apache.jena.vocabulary.DCTerms;
import org.apache.jena.vocabulary.DCTypes;
import org.apache.jena.vocabulary.SKOS;
import org.apache.jena.vocabulary.SKOSXL;

public class SSE {
    private static PrefixMapping defaultPrefixMapPretty;
    protected static PrefixMapping prefixMapRead;
    protected static PrefixMapping prefixMapString;
    private static PrefixMapping defaultPrefixMapWrite;
    protected static PrefixMapping prefixMapWrite;
    private static boolean useResolver;
    private static String strForNull;

    private SSE() {
    }

    private static void readMap(String prefix, String uri) {
        defaultPrefixMapPretty.setNsPrefix(prefix, uri);
    }

    public static PrefixMapping getPrefixMapRead() {
        return prefixMapRead;
    }

    public static void setPrefixMapRead(PrefixMapping pmap) {
        prefixMapRead = pmap;
    }

    public static PrefixMapping getPrefixMapString() {
        return prefixMapString;
    }

    public static void setPrefixMapString(PrefixMapping pmap) {
        prefixMapString = pmap;
    }

    public static PrefixMapping getPrefixMapWrite() {
        return prefixMapWrite;
    }

    public static void setPrefixMapWrite(PrefixMapping pmap) {
        prefixMapWrite = pmap;
    }

    public static Node parseNode(String str2) {
        return SSE.parseNode(str2, null);
    }

    public static Node parseNode(String str2, PrefixMapping pmap) {
        return SSE.parseNode(new StringReader(str2), pmap);
    }

    public static Quad parseQuad(String s) {
        return SSE.parseQuad(s, null);
    }

    public static Quad parseQuad(String s, PrefixMapping pmap) {
        Item item = SSE.parse(s, pmap);
        if (!item.isList()) {
            throw new ARQException("Not a list: " + s);
        }
        return BuilderGraph.buildQuad(item.getList());
    }

    public static Triple parseTriple(String str2) {
        return SSE.parseTriple(str2, null);
    }

    public static Triple parseTriple(String str2, PrefixMapping pmap) {
        Item item = SSE.parse(str2, pmap);
        if (!item.isList()) {
            throw new ARQException("Not a list: " + str2);
        }
        return BuilderGraph.buildTriple(item.getList());
    }

    public static Path parsePath(String str2) {
        return SSE.parsePath(str2, null);
    }

    public static Path parsePath(String str2, PrefixMapping pmap) {
        Item item = SSE.parse(str2, pmap);
        if (!item.isList()) {
            throw new ARQException("Not a list: " + str2);
        }
        return BuilderPath.buildPath(item);
    }

    public static Expr parseExpr(String s) {
        return SSE.parseExpr(s, null);
    }

    public static Expr parseExpr(String s, PrefixMapping pmap) {
        Item item = SSE.parse(s, pmap);
        return BuilderExpr.buildExpr(item);
    }

    public static ExprList parseExprList(String s) {
        return SSE.parseExprList(s, null);
    }

    public static ExprList parseExprList(String s, PrefixMapping pmap) {
        Item item = SSE.parse(s, pmap);
        return BuilderExpr.buildExprOrExprList(item);
    }

    public static Graph parseGraph(String string) {
        return SSE.parseGraph(string, null);
    }

    public static Graph parseGraph(String string, PrefixMapping pmap) {
        Item item = SSE.parse(string, pmap);
        return BuilderGraph.buildGraph(item);
    }

    public static Graph readGraph(String filename) {
        return SSE.readGraph(filename, null);
    }

    public static Graph readGraph(String filename, PrefixMapping pmap) {
        Item item = SSE.readFile(filename, pmap);
        return BuilderGraph.buildGraph(item);
    }

    public static void readGraph(Graph graph, String filename) {
        SSE.readGraph(graph, filename, null);
    }

    public static void readGraph(Graph graph, String filename, PrefixMapping pmap) {
        Item item = SSE.readFile(filename, pmap);
        BuilderGraph.buildGraph(graph, item);
    }

    public static DatasetGraph parseDatasetGraph(String string) {
        return SSE.parseDatasetGraph(string, null);
    }

    public static DatasetGraph parseDatasetGraph(String string, PrefixMapping pmap) {
        Item item = SSE.parse(string, pmap);
        return BuilderGraph.buildDataset(item);
    }

    public static DatasetGraph readDatasetGraph(String filename) {
        return SSE.readDatasetGraph(filename, null);
    }

    public static DatasetGraph readDatasetGraph(String filename, PrefixMapping pmap) {
        Item item = SSE.readFile(filename, pmap);
        return BuilderGraph.buildDataset(item);
    }

    public static void readDatasetGraph(DatasetGraph dsg, String filename) {
        SSE.readDatasetGraph(dsg, filename, null);
    }

    public static void readDatasetGraph(DatasetGraph dsg, String filename, PrefixMapping pmap) {
        Item item = SSE.readFile(filename, pmap);
        BuilderGraph.buildDataset(dsg, item);
    }

    public static Op readOp(String filename) {
        return Algebra.read(filename);
    }

    public static Op parseOp(String s) {
        return Algebra.parse(s);
    }

    public static Op parseOp(String s, PrefixMapping pmap) {
        return Algebra.parse(s, pmap);
    }

    public static BasicPattern readBGP(String filename) {
        Item item = SSE.readFile(filename, null);
        return BuilderOp.buildBGP(item);
    }

    public static BasicPattern parseBGP(String s) {
        return SSE.parseBGP(s, SSE.getPrefixMapRead());
    }

    public static BasicPattern parseBGP(String s, PrefixMapping pmap) {
        Item item = SSE.parse(s, pmap);
        return BuilderOp.buildBGP(item);
    }

    public static Table readTable(String filename) {
        return SSE.readTable(filename, null);
    }

    public static Table readTable(String filename, PrefixMapping pmap) {
        Item item = SSE.readFile(filename, pmap);
        return BuilderTable.build(item);
    }

    public static Table parseTable(String s) {
        return SSE.parseTable(s, null);
    }

    public static Table parseTable(String s, PrefixMapping pmap) {
        Item item = SSE.parse(s, pmap);
        return BuilderTable.build(item);
    }

    public static Item readFile(String filename) {
        return SSE.readFile(filename, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Item readFile(String filename, PrefixMapping pmap) {
        Item item;
        FileInputStream in;
        block6: {
            in = null;
            in = new FileInputStream(filename);
            long len = in.getChannel().size();
            if (len != 0L) break block6;
            Item item2 = Item.nil;
            IO.close((Closeable)in);
            return item2;
        }
        try {
            item = SSE.parse(in, pmap);
        }
        catch (FileNotFoundException ex) {
            try {
                throw new NotFoundException("Not found: " + filename);
                catch (IOException ex2) {
                    throw new ARQException("IOExeption: " + filename, ex2);
                }
            }
            catch (Throwable throwable) {
                IO.close(in);
                throw throwable;
            }
        }
        IO.close((Closeable)in);
        return item;
    }

    public static Item parseRaw(String str2) {
        return SSE.parse(str2, (PrefixMapping)new PrefixMappingImpl());
    }

    public static Item parse(String str2) {
        return SSE.parse(str2, null);
    }

    public static Item parse(String str2, PrefixMapping pmap) {
        return SSE.parse(new StringReader(str2), pmap);
    }

    public static Item parse(InputStream in) {
        return SSE.parse(in, null);
    }

    public static Item parse(InputStream in, PrefixMapping pmap) {
        BufferedReader reader = FileUtils.asBufferedUTF8((InputStream)in);
        return SSE.parse(reader, pmap);
    }

    public static void setUseResolver(boolean flag) {
        useResolver = flag;
    }

    private static ParseHandler createParseHandler(PrefixMapping pmap) {
        if (useResolver) {
            Prologue prologue = new Prologue(pmap);
            return new ParseHandlerResolver(prologue);
        }
        return new ParseHandlerPlain();
    }

    private static Node parseNode(Reader reader, PrefixMapping pmap) {
        Item item = SSE.parseTerm(reader, pmap);
        if (item.isSymbol()) {
            String str2 = item.getSymbol();
            if ("true".equalsIgnoreCase(str2)) {
                return NodeConst.nodeTrue;
            }
            if ("false".equalsIgnoreCase(str2)) {
                return NodeConst.nodeFalse;
            }
            throw new SSEParseException("Not a node: " + item, item.getLine(), item.getColumn());
        }
        if (!item.isNode()) {
            throw new SSEParseException("Not a node: " + item, item.getLine(), item.getColumn());
        }
        return item.getNode();
    }

    private static String parseSymbol(Reader reader, PrefixMapping pmap) {
        Item item = SSE.parseTerm(reader, pmap);
        if (!item.isSymbol()) {
            throw new SSEParseException("Not a symbol: " + item, item.getLine(), item.getColumn());
        }
        return item.getSymbol();
    }

    public static Item parseItem(String str2) {
        return SSE.parse(str2, null);
    }

    public static Item parseItem(String str2, PrefixMapping pmap) {
        return SSE.parse(new StringReader(str2), pmap);
    }

    private static Item parseTerm(Reader reader, PrefixMapping pmap) {
        if (pmap == null) {
            pmap = SSE.getPrefixMapRead();
        }
        ParseHandler handler = SSE.createParseHandler(pmap);
        SSE_Parser.term(reader, handler);
        return handler.getItem();
    }

    public static Item parse(Reader reader) {
        return SSE.parse(reader, null);
    }

    public static Item parse(Reader reader, PrefixMapping pmap) {
        if (pmap == null) {
            pmap = SSE.getPrefixMapRead();
        }
        ParseHandler handler = SSE.createParseHandler(pmap);
        SSE_Parser.parse(reader, handler);
        return handler.getItem();
    }

    public static String str(Node node) {
        return SSE.str(node, SSE.getPrefixMapString());
    }

    public static String str(Node node, PrefixMapping pmap) {
        if (node == null) {
            return strForNull;
        }
        return SSE.string(out -> WriterNode.output((IndentedWriter)out, node, SSE.sCxt(pmap)));
    }

    public static String str(Triple triple) {
        return SSE.str(triple, SSE.getPrefixMapString());
    }

    public static String str(Triple triple, PrefixMapping pmap) {
        if (triple == null) {
            return strForNull;
        }
        return SSE.string(out -> WriterNode.outputNoTag((IndentedWriter)out, triple, SSE.sCxt(pmap)));
    }

    public static String strPlain(Triple triple) {
        return SSE.strPlain(triple, SSE.getPrefixMapString());
    }

    public static String strPlain(Triple triple, PrefixMapping pmap) {
        if (triple == null) {
            return strForNull;
        }
        return SSE.string(out -> WriterNode.outputPlain((IndentedWriter)out, triple, SSE.sCxt(pmap)));
    }

    public static String str(Quad quad) {
        return SSE.str(quad, SSE.getPrefixMapString());
    }

    public static String str(Quad quad, PrefixMapping pmap) {
        if (quad == null) {
            return strForNull;
        }
        return SSE.string(out -> WriterNode.outputNoTag((IndentedWriter)out, quad, SSE.sCxt(pmap)));
    }

    public static String strPlain(Quad quad) {
        return SSE.strPlain(quad, SSE.getPrefixMapString());
    }

    public static String strPlain(Quad quad, PrefixMapping pmap) {
        if (quad == null) {
            return strForNull;
        }
        return SSE.string(out -> WriterNode.outputPlain((IndentedWriter)out, quad, SSE.sCxt(pmap)));
    }

    public static String str(Graph graph) {
        return SSE.str(graph, SSE.getPrefixMapString());
    }

    public static String str(Graph graph, PrefixMapping pmap) {
        if (graph == null) {
            return strForNull;
        }
        return SSE.string(out -> WriterGraph.output((IndentedWriter)out, graph, SSE.sCxt(pmap)));
    }

    public static String str(DatasetGraph dsg) {
        return SSE.str(dsg, SSE.getPrefixMapString());
    }

    public static String str(DatasetGraph dsg, PrefixMapping pmap) {
        if (dsg == null) {
            return strForNull;
        }
        return SSE.string(out -> WriterGraph.output((IndentedWriter)out, dsg, SSE.sCxt(pmap)));
    }

    public static String str(Expr expr) {
        return SSE.str(expr, SSE.getPrefixMapString());
    }

    public static String str(Expr expr, PrefixMapping pmap) {
        if (expr == null) {
            return strForNull;
        }
        return SSE.string(out -> WriterExpr.output((IndentedWriter)out, expr, SSE.sCxt(pmap)));
    }

    public static String str(BasicPattern bgp) {
        return SSE.str(bgp, SSE.getPrefixMapString());
    }

    public static String str(BasicPattern bgp, PrefixMapping pmap) {
        if (bgp == null) {
            return strForNull;
        }
        return SSE.string(out -> WriterGraph.output((IndentedWriter)out, bgp, SSE.sCxt(pmap)));
    }

    public static String str(Op op) {
        return SSE.str(op, SSE.getPrefixMapString());
    }

    public static String str(Op op, PrefixMapping pmap) {
        if (op == null) {
            return strForNull;
        }
        return SSE.string(out -> WriterOp.output((IndentedWriter)out, op, SSE.sCxt(pmap)));
    }

    private static String string(Consumer<IndentedLineBuffer> action) {
        IndentedLineBuffer x = new IndentedLineBuffer();
        action.accept(x);
        return x.asString();
    }

    @Deprecated
    public static String format(Node node) {
        return FmtUtils.stringForNode(node);
    }

    @Deprecated
    public static String format(Node node, PrefixMapping pmap) {
        return FmtUtils.stringForNode(node, pmap);
    }

    public static void write(Op op) {
        WriterOp.output(IndentedWriter.stdout, op);
        IndentedWriter.stdout.flush();
    }

    public static void write(OutputStream out, Op op) {
        WriterOp.output(out, op);
    }

    public static void write(IndentedWriter out, Op op) {
        WriterOp.output(out, op);
    }

    public static void write(Graph graph) {
        SSE.write(IndentedWriter.stdout, graph);
        IndentedWriter.stdout.flush();
    }

    public static void write(OutputStream out, Graph graph) {
        IndentedWriter iOut = new IndentedWriter(out);
        SSE.write(iOut, graph);
        iOut.flush();
    }

    public static void write(IndentedWriter out, Graph graph) {
        WriterGraph.output(out, graph, new SerializationContext(graph.getPrefixMapping()));
        out.ensureStartOfLine();
    }

    public static void write(Model model) {
        SSE.write(IndentedWriter.stdout, model);
        IndentedWriter.stdout.flush();
    }

    public static void write(OutputStream out, Model model) {
        IndentedWriter iOut = new IndentedWriter(out);
        SSE.write(iOut, model);
        iOut.flush();
    }

    public static void write(IndentedWriter out, Model model) {
        WriterGraph.output(out, model.getGraph(), new SerializationContext((PrefixMapping)model));
    }

    public static void write(DatasetGraph dataset) {
        SSE.write(IndentedWriter.stdout, dataset);
        IndentedWriter.stdout.flush();
    }

    public static void write(OutputStream out, DatasetGraph dataset) {
        IndentedWriter iOut = new IndentedWriter(out);
        SSE.write(iOut, dataset);
        iOut.flush();
    }

    public static void write(IndentedWriter out, DatasetGraph dataset) {
        WriterGraph.output(out, dataset, SSE.sCxt(dataset.getDefaultGraph()));
    }

    public static void write(Dataset dataset) {
        SSE.write(dataset.asDatasetGraph());
    }

    public static void write(OutputStream out, Dataset dataset) {
        SSE.write(out, dataset.asDatasetGraph());
    }

    public static void write(IndentedWriter out, Dataset dataset) {
        SSE.write(out, dataset.asDatasetGraph());
    }

    public static void write(BasicPattern pattern) {
        SSE.write(IndentedWriter.stdout, pattern);
        IndentedWriter.stdout.flush();
    }

    public static void write(IndentedWriter out, BasicPattern pattern) {
        SSE.write(IndentedWriter.stdout, pattern, null);
        IndentedWriter.stdout.flush();
    }

    public static void write(IndentedWriter out, BasicPattern pattern, PrefixMapping pMap) {
        WriterGraph.output(out, pattern, SSE.sCxt(pMap));
        out.flush();
    }

    public static void write(Triple triple) {
        SSE.write(IndentedWriter.stdout, triple);
        IndentedWriter.stdout.flush();
    }

    public static void write(OutputStream out, Triple triple) {
        IndentedWriter iOut = new IndentedWriter(out);
        SSE.write(iOut, triple);
        iOut.flush();
    }

    public static void write(IndentedWriter out, Triple triple) {
        WriterNode.output(out, triple, SSE.sCxt(SSE.getPrefixMapWrite()));
        out.flush();
    }

    public static void write(Quad quad) {
        SSE.write(IndentedWriter.stdout, quad);
        IndentedWriter.stdout.flush();
    }

    public static void write(OutputStream out, Quad quad) {
        IndentedWriter iOut = new IndentedWriter(out);
        SSE.write(iOut, quad);
        iOut.flush();
    }

    public static void write(IndentedWriter out, Quad quad) {
        WriterNode.output(out, quad, SSE.sCxt(SSE.getPrefixMapWrite()));
        out.flush();
    }

    public static void write(Node node) {
        SSE.write(IndentedWriter.stdout, node);
        IndentedWriter.stdout.flush();
    }

    public static void write(OutputStream out, Node node) {
        IndentedWriter iOut = new IndentedWriter(out);
        SSE.write(iOut, node);
        iOut.flush();
    }

    public static void write(IndentedWriter out, Node node) {
        WriterNode.output(IndentedWriter.stdout, node, SSE.sCxt(SSE.getPrefixMapWrite()));
        IndentedWriter.stdout.flush();
    }

    public static SerializationContext sCxt(Graph graph) {
        if (graph != null) {
            return SSE.sCxt(graph.getPrefixMapping());
        }
        return new SerializationContext();
    }

    public static SerializationContext sCxt(PrefixMapping pmap) {
        if (pmap != null) {
            return new SerializationContext(pmap);
        }
        return new SerializationContext();
    }

    static {
        JenaSystem.init();
        defaultPrefixMapPretty = new PrefixMappingImpl();
        SSE.readMap("rdf", ARQConstants.rdfPrefix);
        SSE.readMap("rdfs", ARQConstants.rdfsPrefix);
        SSE.readMap("xsd", "http://www.w3.org/2001/XMLSchema#");
        SSE.readMap("owl", ARQConstants.owlPrefix);
        SSE.readMap("foaf", FOAF.getURI());
        SSE.readMap("skos", SKOS.getURI());
        SSE.readMap("skosxl", SKOSXL.getURI());
        SSE.readMap("dc", DC.getURI());
        SSE.readMap("dcterms", DCTerms.getURI());
        SSE.readMap("dctypes", DCTypes.getURI());
        SSE.readMap("fn", "http://www.w3.org/2005/xpath-functions#");
        SSE.readMap("op", "http://www.w3.org/2005/xpath-functions#");
        SSE.readMap("math", "http://www.w3.org/2005/xpath-functions/math#");
        SSE.readMap("fns", "http://www.w3.org/ns/sparql#");
        SSE.readMap("afn", "http://jena.apache.org/ARQ/function#");
        SSE.readMap("apf", "http://jena.apache.org/ARQ/procedure#");
        SSE.readMap("agg", "http://jena.apache.org/ARQ/function/aggregate#");
        SSE.readMap("list", ListPFunction.getURI());
        SSE.readMap("ex", "http://example.org/");
        SSE.readMap("ns", "http://example.org/ns#");
        SSE.readMap("", "http://example/");
        prefixMapRead = defaultPrefixMapPretty;
        prefixMapString = new PrefixMappingImpl();
        prefixMapString.setNsPrefixes(defaultPrefixMapPretty);
        defaultPrefixMapWrite = new PrefixMappingImpl();
        defaultPrefixMapWrite.setNsPrefix("rdf", ARQConstants.rdfPrefix);
        defaultPrefixMapWrite.setNsPrefix("rdfs", ARQConstants.rdfsPrefix);
        defaultPrefixMapWrite.setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
        prefixMapWrite = defaultPrefixMapWrite;
        useResolver = true;
        strForNull = "<<null>>";
    }
}

