/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingMap;
import org.apache.jena.sparql.engine.iterator.QueryIterProcessBinding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.serializer.SerializationContext;

public class QueryIterAssign
extends QueryIterProcessBinding {
    private VarExprList exprs;
    private final boolean mustBeNewVar;

    public QueryIterAssign(QueryIterator input, Var var, Expr expr, ExecutionContext qCxt) {
        this(input, new VarExprList(var, expr), qCxt, false);
    }

    public QueryIterAssign(QueryIterator input, VarExprList exprs, ExecutionContext qCxt, boolean mustBeNewVar) {
        super(input, qCxt);
        this.exprs = exprs;
        this.mustBeNewVar = mustBeNewVar;
    }

    @Override
    public Binding accept(Binding binding) {
        BindingMap b = BindingFactory.create(binding);
        for (Var v : this.exprs.getVars()) {
            Node n = this.exprs.get(v, b, this.getExecContext());
            if (n == null) continue;
            if (b.contains(v)) {
                Node n2 = b.get(v);
                if (n2.sameValueAs((Object)n)) continue;
                return null;
            }
            b.add(v, n);
        }
        return b;
    }

    @Override
    protected void details(IndentedWriter out, SerializationContext cxt) {
        out.print(Lib.className((Object)this));
        out.print(" ");
        out.print(this.exprs.toString());
    }
}

