/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.jena.atlas.data.SerializationFactory;
import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.lang.LangNQuads;
import org.apache.jena.riot.lang.LangNTriples;
import org.apache.jena.riot.out.NodeToLabel;
import org.apache.jena.riot.out.SinkQuadOutput;
import org.apache.jena.riot.out.SinkTripleOutput;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingInputStream;
import org.apache.jena.sparql.engine.binding.BindingOutputStream;

public class SerializationFactoryFinder {
    public static SerializationFactory<Binding> bindingSerializationFactory() {
        return new SerializationFactory<Binding>(){

            @Override
            public Sink<Binding> createSerializer(OutputStream out) {
                return new BindingOutputStream(out);
            }

            @Override
            public Iterator<Binding> createDeserializer(InputStream in) {
                return new BindingInputStream(in);
            }

            @Override
            public long getEstimatedMemorySize(Binding item) {
                return 0L;
            }
        };
    }

    public static SerializationFactory<Triple> tripleSerializationFactory() {
        return new SerializationFactory<Triple>(){

            @Override
            public Sink<Triple> createSerializer(OutputStream out) {
                return new SinkTripleOutput(out, null, NodeToLabel.createBNodeByLabelEncoded());
            }

            @Override
            public Iterator<Triple> createDeserializer(InputStream in) {
                Tokenizer tokenizer = TokenizerFactory.makeTokenizerASCII(in);
                ParserProfile profile = RiotLib.createParserProfile(RiotLib.factoryRDF(LabelToNode.createUseLabelEncoded()), ErrorHandlerFactory.errorHandlerNoWarnings, IRIResolver.createNoResolve(), false);
                LangNTriples parser = new LangNTriples(tokenizer, profile, null);
                return parser;
            }

            @Override
            public long getEstimatedMemorySize(Triple item) {
                return 0L;
            }
        };
    }

    public static SerializationFactory<Quad> quadSerializationFactory() {
        return new SerializationFactory<Quad>(){

            @Override
            public Sink<Quad> createSerializer(OutputStream out) {
                return new SinkQuadOutput(out, null, NodeToLabel.createBNodeByLabelEncoded());
            }

            @Override
            public Iterator<Quad> createDeserializer(InputStream in) {
                Tokenizer tokenizer = TokenizerFactory.makeTokenizerASCII(in);
                ParserProfile profile = RiotLib.createParserProfile(RiotLib.factoryRDF(LabelToNode.createUseLabelEncoded()), ErrorHandlerFactory.errorHandlerNoWarnings, IRIResolver.createNoResolve(), false);
                LangNQuads parser = new LangNQuads(tokenizer, profile, null);
                return parser;
            }

            @Override
            public long getEstimatedMemorySize(Quad item) {
                return 0L;
            }
        };
    }
}

