/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.data;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.jena.atlas.data.DistinctDataNet;
import org.apache.jena.atlas.data.ThresholdPolicy;
import org.apache.jena.atlas.data.ThresholdPolicyCount;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.system.SerializationFactoryFinder;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingComparator;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingMap;
import org.apache.jena.sparql.resultset.ResultSetCompare;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.sse.builders.BuilderBinding;
import org.apache.jena.sparql.util.NodeUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestDistinctDataNet {
    private static final String LETTERS = "qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM";
    Random random = new Random();
    static Binding b12 = TestDistinctDataNet.build("(?a 1) (?b 2)");
    static Binding b19 = TestDistinctDataNet.build("(?a 1) (?b 9)");
    static Binding b02 = TestDistinctDataNet.build("(?b 2)");
    static Binding b10 = TestDistinctDataNet.build("(?a 1)");
    static Binding b0 = TestDistinctDataNet.build("");
    static Binding bb1 = TestDistinctDataNet.build("(?a _:XYZ) (?b 1)");
    static Binding x10 = TestDistinctDataNet.build("(?x <http://example/abc>)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDistinct() {
        ArrayList<Binding> undistinct = new ArrayList<Binding>();
        undistinct.add(b12);
        undistinct.add(b19);
        undistinct.add(b02);
        undistinct.add(b12);
        undistinct.add(b19);
        undistinct.add(b12);
        undistinct.add(b02);
        undistinct.add(x10);
        List control = Iter.toList((Iterator)Iter.distinct(undistinct.iterator()));
        ArrayList distinct = new ArrayList();
        try (DistinctDataNet db = new DistinctDataNet((ThresholdPolicy)new ThresholdPolicyCount(2L), SerializationFactoryFinder.bindingSerializationFactory(), (Comparator)new BindingComparator(new ArrayList()));){
            db.addAll(undistinct);
            Iterator iter = db.iterator();
            while (iter.hasNext()) {
                distinct.add(iter.next());
            }
            Iter.close((Iterator)iter);
        }
        Assert.assertEquals((long)control.size(), (long)distinct.size());
        Assert.assertTrue((boolean)ResultSetCompare.equalsByTest((Collection)control, distinct, (NodeUtils.EqualityTest)NodeUtils.sameTerm));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDistinct2() {
        ArrayList<Binding> undistinct = new ArrayList<Binding>();
        undistinct.add(b12);
        undistinct.add(b19);
        undistinct.add(b02);
        undistinct.add(b12);
        undistinct.add(b19);
        undistinct.add(b12);
        undistinct.add(b02);
        undistinct.add(x10);
        List control = Iter.toList((Iterator)Iter.distinct(undistinct.iterator()));
        ArrayList<Object> distinct = new ArrayList<Object>();
        try (DistinctDataNet db = new DistinctDataNet((ThresholdPolicy)new ThresholdPolicyCount(2L), SerializationFactoryFinder.bindingSerializationFactory(), (Comparator)new BindingComparator(new ArrayList()));){
            for (Binding b : undistinct) {
                if (!db.netAdd((Object)b)) continue;
                distinct.add(b);
            }
            Iterator iter = db.netIterator();
            while (iter.hasNext()) {
                distinct.add(iter.next());
            }
            Iter.close((Iterator)iter);
        }
        Assert.assertEquals((long)control.size(), (long)distinct.size());
        Assert.assertTrue((boolean)ResultSetCompare.equalsByTest((Collection)control, distinct, (NodeUtils.EqualityTest)NodeUtils.sameTerm));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTemporaryFilesAreCleanedUpAfterCompletion() {
        int count;
        ArrayList<Binding> undistinct = new ArrayList<Binding>();
        this.random = new Random();
        Var[] vars = new Var[]{Var.alloc((String)"1"), Var.alloc((String)"2"), Var.alloc((String)"3"), Var.alloc((String)"4"), Var.alloc((String)"5"), Var.alloc((String)"6"), Var.alloc((String)"7"), Var.alloc((String)"8"), Var.alloc((String)"9"), Var.alloc((String)"0")};
        for (int i = 0; i < 500; ++i) {
            undistinct.add(this.randomBinding(vars));
        }
        ArrayList spillFiles = new ArrayList();
        try (DistinctDataNet db = new DistinctDataNet((ThresholdPolicy)new ThresholdPolicyCount(10L), SerializationFactoryFinder.bindingSerializationFactory(), (Comparator)new BindingComparator(new ArrayList()));){
            db.addAll(undistinct);
            spillFiles.addAll(db.getSpillFiles());
            count = 0;
            for (File file : spillFiles) {
                if (!file.exists()) continue;
                ++count;
            }
            Assert.assertEquals((long)49L, (long)count);
            Iterator iter = db.iterator();
            while (iter.hasNext()) {
                iter.next();
            }
            Iter.close((Iterator)iter);
        }
        count = 0;
        for (File file : spillFiles) {
            if (!file.exists()) continue;
            ++count;
        }
        Assert.assertEquals((long)0L, (long)count);
    }

    private void testDiff(String first, String second, String expected) {
        DistinctDataNet.SortedDiffIterator.create(Arrays.asList(first.split(" ")).iterator(), Arrays.asList(second.split(" ")).iterator());
    }

    private void testDiff(String[] first, String[] second, String expected) {
        DistinctDataNet.SortedDiffIterator sdi = DistinctDataNet.SortedDiffIterator.create(Arrays.asList(first).iterator(), Arrays.asList(second).iterator());
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        while (sdi.hasNext()) {
            if (!firstTime) {
                sb.append(" ");
            }
            firstTime = false;
            String s = (String)sdi.next();
            if (null == s) {
                s = "null";
            }
            sb.append(s);
        }
        Assert.assertEquals((Object)expected, (Object)sb.toString());
    }

    @Test
    public void testSortedDiffIterator() {
        this.testDiff("a b e g i j", "b g h", "a e i j");
        this.testDiff("a b e g i j", "", "a b e g i j");
        this.testDiff("", "b g h", "");
        this.testDiff("", "", "");
        this.testDiff("a", "a", "");
        this.testDiff("a", "b", "a");
        this.testDiff("b", "a", "b");
        this.testDiff("a b e g i j", "b g h z", "a e i j");
        this.testDiff("a b c", "a b c", "");
        this.testDiff(new String[]{null, "a", "b", "e", "g", "i", "j"}, new String[]{"b", "g", "h"}, "null a e i j");
        this.testDiff(new String[]{"a", "b", "e", "g", "i", "j"}, new String[]{null, "b", "g", "h"}, "a e i j");
        this.testDiff(new String[]{null, "a", "b", "e", "g", "i", "j"}, new String[]{null, "b", "g", "h"}, "a e i j");
    }

    private static Binding build(String string) {
        Item item = SSE.parse((String)("(binding " + string + ")"));
        return BuilderBinding.build((Item)item);
    }

    private Binding randomBinding(Var[] vars) {
        BindingMap binding = BindingFactory.create();
        binding.add(vars[0], NodeFactory.createBlankNode());
        binding.add(vars[1], NodeFactory.createURI((String)this.randomURI()));
        binding.add(vars[2], NodeFactory.createURI((String)this.randomURI()));
        binding.add(vars[3], NodeFactory.createLiteral((String)this.randomString(20)));
        binding.add(vars[4], NodeFactory.createBlankNode());
        binding.add(vars[5], NodeFactory.createURI((String)this.randomURI()));
        binding.add(vars[6], NodeFactory.createURI((String)this.randomURI()));
        binding.add(vars[7], NodeFactory.createLiteral((String)this.randomString(5)));
        binding.add(vars[8], NodeFactory.createLiteral((String)("" + this.random.nextInt()), (RDFDatatype)XSDDatatype.XSDinteger));
        binding.add(vars[9], NodeFactory.createBlankNode());
        return binding;
    }

    public String randomURI() {
        return String.format("http://%s.example.com/%s", this.randomString(10), this.randomString(10));
    }

    public String randomString(int length) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append(LETTERS.charAt(this.random.nextInt(LETTERS.length())));
        }
        return builder.toString();
    }
}

