/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.RiotException;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.vocabulary.RDF;
import org.junit.Assert;
import org.junit.Test;

public class TestJsonLDReader {
    @Test
    public final void simpleReadTest() {
        try {
            String jsonld = this.someSchemaDorOrgJsonld();
            Model m = ModelFactory.createDefaultModel();
            try (StringReader reader = new StringReader(jsonld);){
                m.read((Reader)reader, null, "JSON-LD");
            }
            this.assertJohnDoeIsOK(m);
        }
        catch (RiotException riotException) {
            // empty catch block
        }
    }

    @Test
    public final void overrideAtContextTest() throws JsonGenerationException, IOException {
        String jsonld = this.someSchemaDorOrgJsonld();
        String jsonldContext = "{\"name\":{\"@id\":\"http://schema.org/name\"},\"Person\": {\"@id\": \"http://schema.org/Person\"}}";
        Context jenaCtx = new Context();
        Object jsonldContextAsMap = JsonUtils.fromInputStream((InputStream)new ByteArrayInputStream(jsonldContext.getBytes(StandardCharsets.UTF_8)));
        jenaCtx.set(RIOT.JSONLD_CONTEXT, jsonldContextAsMap);
        Dataset ds = this.jsonld2dataset(jsonld, jenaCtx);
        this.assertJohnDoeIsOK(ds.getDefaultModel());
    }

    @Test
    public final void overrideAtContextByURITest() throws JsonGenerationException, IOException {
        String jsonld = "{\"@id\":\"_:b0\",\"@type\":\"Person\",\"name\":\"John Doe\",\"@context\":\"http://pseudo.schema.org/\"}";
        String jsonldContext = "\"http://schema.org\"";
        Context jenaCtx = new Context();
        Object jsonldContextAsObject = JsonUtils.fromInputStream((InputStream)new ByteArrayInputStream(jsonldContext.getBytes(StandardCharsets.UTF_8)));
        jenaCtx.set(RIOT.JSONLD_CONTEXT, jsonldContextAsObject);
        try {
            Dataset ds = this.jsonld2dataset(jsonld, jenaCtx);
            this.assertJohnDoeIsOK(ds.getDefaultModel());
        }
        catch (RiotException riotException) {
            // empty catch block
        }
    }

    private Dataset jsonld2dataset(String jsonld, Context jenaCtx) throws IOException {
        Dataset ds = DatasetFactory.create();
        try (ByteArrayInputStream in = new ByteArrayInputStream(jsonld.getBytes(StandardCharsets.UTF_8));){
            RDFParser.create().source((InputStream)in).lang(Lang.JSONLD).context(jenaCtx).parse(ds.asDatasetGraph());
        }
        return ds;
    }

    private String someSchemaDorOrgJsonld() {
        return "{\"@id\":\"_:b0\",\"@type\":\"Person\",\"name\":\"John Doe\",\"@context\":\"http://schema.org/\"}";
    }

    private void assertJohnDoeIsOK(Model m) {
        Assert.assertTrue((boolean)m.contains(null, RDF.type, (RDFNode)m.createResource("http://schema.org/Person")));
        Assert.assertTrue((boolean)m.contains(null, m.createProperty("http://schema.org/name"), "John Doe"));
    }
}

