/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestLangRIOT
extends BaseTest {
    @BeforeClass
    public static void beforeClass() {
        RDFLanguages.init();
    }

    @Test
    public void lang_01() {
        this.test(RDFLanguages.NTRIPLES, "NT");
    }

    @Test
    public void lang_02() {
        this.test(RDFLanguages.NTRIPLES, "N-Triples");
    }

    @Test
    public void lang_03() {
        this.test(RDFLanguages.NTRIPLES, "N-TRIPLES");
    }

    @Test
    public void lang_04() {
        this.test(RDFLanguages.NTRIPLES, "NTRIPLE");
    }

    @Test
    public void lang_05() {
        this.test(RDFLanguages.NTRIPLES, "NTRIPLES");
    }

    @Test
    public void lang_11() {
        this.test(RDFLanguages.TURTLE, "TTL");
    }

    @Test
    public void lang_12() {
        this.test(RDFLanguages.TURTLE, "TUrtLE");
    }

    @Test
    public void lang_21() {
        this.test(RDFLanguages.RDFXML, "RDF/XML");
    }

    @Test
    public void lang_22() {
        this.test(RDFLanguages.RDFXML, "RDFXML");
    }

    @Test
    public void lang_23() {
        this.test(RDFLanguages.RDFXML, "RDF/XML-ABBREV");
    }

    @Test
    public void lang_30() {
        this.test(RDFLanguages.RDFJSON, "RDFJSON");
    }

    @Test
    public void lang_31() {
        this.test(RDFLanguages.RDFJSON, "RDF/json");
    }

    @Test
    public void lang_40() {
        this.test(RDFLanguages.NQUADS, "N-QUADS");
    }

    @Test
    public void lang_41() {
        this.test(RDFLanguages.NQUADS, "NQuads");
    }

    @Test
    public void lang_50() {
        this.test(RDFLanguages.TRIG, "TriG");
    }

    @Test
    public void lang_51() {
        this.test(RDFLanguages.TRIG, "trig");
    }

    @Test
    public void lang_52() {
        this.test(RDFLanguages.TRIG, "TRIG");
    }

    @Test
    public void guess_01() {
        this.guess("D.nt", RDFLanguages.NTRIPLES);
    }

    @Test
    public void guess_02() {
        this.guess("D.ttl.nt", RDFLanguages.NTRIPLES);
    }

    @Test
    public void guess_03() {
        this.guess("D.ttl", RDFLanguages.TURTLE);
    }

    @Test
    public void guess_04() {
        this.guess("D.rdf", RDFLanguages.RDFXML);
    }

    @Test
    public void guess_06() {
        this.guess("D.rj", RDFLanguages.RDFJSON);
    }

    @Test
    public void guess_08() {
        this.guess("D.nq", RDFLanguages.NQUADS);
    }

    @Test
    public void guess_09() {
        this.guess("D.trig", RDFLanguages.TRIG);
    }

    @Test
    public void guess_10() {
        this.guess("D.jsonld", RDFLanguages.JSONLD);
    }

    @Test
    public void guess_11() {
        this.guess("http://example/foo/bar.ttl#frag", RDFLanguages.TTL);
    }

    @Test
    public void guess_12() {
        this.guess("bar.ttl#frag", RDFLanguages.TTL);
    }

    private void test(Lang expected, String string) {
        Lang lang = RDFLanguages.nameToLang((String)string);
        TestLangRIOT.assertEquals((Object)expected, (Object)lang);
    }

    private void guess(String filename, Lang expected) {
        Lang lang = RDFLanguages.filenameToLang((String)filename);
        TestLangRIOT.assertEquals((Object)expected, (Object)lang);
    }
}

