/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.ErrorHandlerTestLib;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.Context;
import org.junit.Test;

public class TestReadData
extends BaseTest {
    private static final String directory = "testing/RIOT/Reader";
    private static Context context = new Context();

    @Test
    public void read_01() {
        TestReadData.read("D.nq");
    }

    @Test
    public void read_02() {
        TestReadData.read("D.trig");
    }

    @Test
    public void read_03() {
        TestReadData.read("D.nq", RDFLanguages.NQUADS);
    }

    @Test
    public void read_04() {
        TestReadData.read("D.trig", RDFLanguages.TRIG);
    }

    @Test
    public void read_11() {
        TestReadData.read("D.nq", "N-Quads");
    }

    @Test
    public void read_12() {
        TestReadData.read("D.nq", "NQuads");
    }

    @Test
    public void read_13() {
        TestReadData.read("D.nq", "NQ");
    }

    @Test
    public void read_14() {
        TestReadData.read("D.trig", "TriG");
    }

    @Test
    public void read_15() {
        TestReadData.read("D.trig", "trig");
    }

    @Test
    public void read_21() {
        TestReadData.read("D-nq", RDFLanguages.NQUADS);
    }

    @Test
    public void read_22() {
        TestReadData.read("D-trig", RDFLanguages.TRIG);
    }

    @Test
    public void read_23() {
        TestReadData.read("D-nq", "NQuads");
    }

    @Test
    public void read_24() {
        TestReadData.read("D-trig", "TRIG");
    }

    @Test
    public void read_input_1() throws IOException {
        TestReadData.read_stream("D.nq", "NQ");
    }

    @Test
    public void read_input_2() throws IOException {
        TestReadData.read_stream("D.trig", "trig");
    }

    @Test
    public void load_01() {
        RDFDataMgr.loadModel((String)TestReadData.filename("D.nt"));
    }

    @Test
    public void load_02() {
        RDFDataMgr.loadModel((String)TestReadData.filename("D.nt"), (Lang)RDFLanguages.NTRIPLES);
    }

    @Test
    public void load_03() {
        RDFDataMgr.loadModel((String)TestReadData.filename("D-nt"), (Lang)RDFLanguages.NTRIPLES);
    }

    @Test
    public void load_04() {
        RDFDataMgr.loadDataset((String)TestReadData.filename("D.nq"));
    }

    @Test
    public void load_05() {
        RDFDataMgr.loadDataset((String)TestReadData.filename("D.nq"), (Lang)RDFLanguages.NQUADS);
    }

    @Test
    public void load_06() {
        RDFDataMgr.loadDataset((String)TestReadData.filename("D-nq"), (Lang)RDFLanguages.NQUADS);
    }

    @Test
    public void load_11() {
        RDFDataMgr.loadGraph((String)TestReadData.filename("D.nt"));
    }

    @Test
    public void load_12() {
        RDFDataMgr.loadGraph((String)TestReadData.filename("D.nt"), (Lang)RDFLanguages.NTRIPLES);
    }

    @Test
    public void load_13() {
        RDFDataMgr.loadGraph((String)TestReadData.filename("D-nt"), (Lang)RDFLanguages.NTRIPLES);
    }

    @Test
    public void load_14() {
        RDFDataMgr.loadDatasetGraph((String)TestReadData.filename("D.nq"));
    }

    @Test
    public void load_15() {
        RDFDataMgr.loadDatasetGraph((String)TestReadData.filename("D.nq"), (Lang)RDFLanguages.NQUADS);
    }

    @Test
    public void load_16() {
        RDFDataMgr.loadDatasetGraph((String)TestReadData.filename("D-nq"), (Lang)RDFLanguages.NQUADS);
    }

    @Test
    public void load_17() {
        DatasetGraph dsg = RDFDataMgr.loadDatasetGraph((String)TestReadData.filename("D.ttl"));
        TestReadData.assertFalse((boolean)dsg.getDefaultGraph().isEmpty());
        TestReadData.assertEquals((long)0L, (long)Iter.count((Iterator)dsg.listGraphNodes()));
    }

    @Test
    public void load_18() {
        ErrorHandler err = ErrorHandlerFactory.getDefaultErrorHandler();
        try {
            Graph g2;
            ErrorHandlerFactory.setDefaultErrorHandler((ErrorHandler)new ErrorHandlerTestLib.ErrorHandlerEx());
            try {
                g2 = RDFDataMgr.loadGraph((String)TestReadData.filename("D.trig"));
                TestReadData.fail((String)"No expection generated");
            }
            catch (ErrorHandlerTestLib.ExWarning g2) {
                // empty catch block
            }
            ErrorHandlerFactory.setDefaultErrorHandler((ErrorHandler)ErrorHandlerFactory.errorHandlerNoLogging);
            g2 = RDFDataMgr.loadGraph((String)TestReadData.filename("D.trig"));
            TestReadData.assertFalse((boolean)g2.isEmpty());
            TestReadData.assertEquals((long)1L, (long)g2.size());
        }
        finally {
            ErrorHandlerFactory.setDefaultErrorHandler((ErrorHandler)err);
        }
    }

    private static String filename(String filename) {
        return "testing/RIOT/Reader/" + filename;
    }

    private static void read(String dataurl) {
        TestReadData.read(dataurl, (Lang)null);
    }

    private static void read(String dataurl, String lang) {
        TestReadData.read(dataurl, RDFLanguages.nameToLang((String)lang));
    }

    private static void read(String dataurl, Lang lang) {
        dataurl = TestReadData.filename(dataurl);
        Dataset ds = DatasetFactory.createMem();
        RDFDataMgr.read((Dataset)ds, (String)dataurl, (Lang)lang);
    }

    private static void read_stream(String filename, String lang) throws IOException {
        TestReadData.read_stream(filename, RDFLanguages.nameToLang((String)lang));
    }

    private static void read_stream(String filename, Lang lang) throws IOException {
        filename = TestReadData.filename(filename);
        Dataset ds0 = DatasetFactory.createMem();
        try (FileInputStream in0 = new FileInputStream(filename);){
            RDFDataMgr.read((Dataset)ds0, (InputStream)in0, (String)"http://example/base2", (Lang)lang);
        }
        Dataset ds1 = DatasetFactory.createMem();
        try (FileInputStream in1 = new FileInputStream(filename);){
            RDFDataMgr.read((Dataset)ds1, (InputStream)in1, null, (Lang)lang);
        }
    }

    private static Model loadModel(String uri) {
        return RDFDataMgr.loadModel((String)TestReadData.filename(uri));
    }
}

