/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.adapters;

import java.io.InputStream;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.adapters.AdapterFileManager;
import org.apache.jena.riot.system.stream.StreamManager;
import org.apache.jena.shared.NotFoundException;
import org.apache.jena.util.FileManager;
import org.apache.jena.util.LocationMapper;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFileManager
extends BaseTest {
    static Logger log = LoggerFactory.getLogger(TestFileManager.class);
    public static final String testingDir = "testing/RIOT/FileManager";
    static final String filename = "fmgr-test-file";
    static final String filenameNonExistent = "fmgr-test-file-1421";
    static final String fileModel = "foo.ttl";
    static final String zipname = "testing/RIOT/FileManager/fmgr-test.zip";

    @Test
    public void testFileManagerFileLocator() {
        FileManager fileManager = new FileManager();
        fileManager.addLocatorFile();
        InputStream in = fileManager.open("testing/RIOT/FileManager/fmgr-test-file");
        TestFileManager.assertNotNull((Object)in);
        this.closeInputStream(in);
    }

    @Test
    public void testFileManagerFileLocatorWithDir() {
        FileManager fileManager = new FileManager();
        fileManager.addLocatorFile(testingDir);
        InputStream in = fileManager.open(filename);
        TestFileManager.assertNotNull((Object)in);
        this.closeInputStream(in);
    }

    @Test
    public void testFileManagerNoFile() {
        FileManager fileManager = new FileManager();
        fileManager.addLocatorFile();
        try {
            InputStream in = fileManager.open(filenameNonExistent);
            this.closeInputStream(in);
            TestFileManager.assertNull((String)"Found non-existant file: fmgr-test-file-1421", (Object)in);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test(expected=NotFoundException.class)
    public void testFileManagerNoFile2() {
        FileManager fileManager = new FileManager();
        fileManager.addLocatorFile();
        fileManager.readModel(ModelFactory.createDefaultModel(), filenameNonExistent);
    }

    @Test(expected=NotFoundException.class)
    public void testFileManagerNoFile3() {
        AdapterFileManager fileManager = new AdapterFileManager(new StreamManager(), new org.apache.jena.riot.system.stream.LocationMapper());
        fileManager.addLocatorFile();
        fileManager.readModel(ModelFactory.createDefaultModel(), filenameNonExistent);
    }

    @Test
    public void testFileManagerLocatorClassLoader() {
        FileManager fileManager = new FileManager();
        fileManager.addLocatorClassLoader(fileManager.getClass().getClassLoader());
        InputStream in = fileManager.open("java/lang/String.class");
        TestFileManager.assertNotNull((Object)in);
        this.closeInputStream(in);
    }

    @Test
    public void testFileManagerLocatorClassLoaderNotFound() {
        FileManager fileManager = new FileManager();
        fileManager.addLocatorClassLoader(fileManager.getClass().getClassLoader());
        try {
            InputStream in = fileManager.open("not/java/lang/String.class");
            this.closeInputStream(in);
            TestFileManager.assertNull((String)"Found non-existant class", (Object)in);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testFileManagerLocatorZip() {
        FileManager fileManager = new FileManager();
        try {
            fileManager.addLocatorZip(zipname);
        }
        catch (Exception ex) {
            TestFileManager.fail((String)"Failed to create a filemanager and add a zip locator");
        }
        InputStream in = fileManager.open(filename);
        TestFileManager.assertNotNull((Object)in);
        this.closeInputStream(in);
    }

    @Test
    public void testFileManagerLocatorZipNonFound() {
        FileManager fileManager = new FileManager();
        try {
            fileManager.addLocatorZip(zipname);
        }
        catch (Exception ex) {
            TestFileManager.fail((String)"Failed to create a filemanager and add a zip locator");
        }
        try {
            InputStream in = fileManager.open(filenameNonExistent);
            this.closeInputStream(in);
            TestFileManager.assertNull((String)"Found non-existant zip file member", (Object)in);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testFileManagerClone() {
        FileManager fileManager1 = new FileManager();
        FileManager fileManager2 = fileManager1.clone();
        fileManager1.addLocatorFile();
        InputStream in = fileManager1.open("testing/RIOT/FileManager/fmgr-test-file");
        TestFileManager.assertNotNull((Object)in);
        this.closeInputStream(in);
        try {
            in = fileManager2.open("testing/RIOT/FileManager/fmgr-test-file");
            this.closeInputStream(in);
            TestFileManager.assertNull((String)"Found file via wrong FileManager", (Object)in);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testFileManagerReadOntModel() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        FileManager.get().readModel((Model)model, "testing/RIOT/FileManager/data.ttl");
        Individual ind = model.getIndividual("http://example.com/individual");
        String t = ind.getOntClass().getURI();
        TestFileManager.assertEquals((Object)"http://example.com/T", (Object)t);
        long c1 = model.size();
        model.loadImports();
        long c2 = model.size();
        TestFileManager.assertEquals((long)c1, (long)c2);
    }

    @Test
    public void testLocationMappingURLtoFileOpen() {
        LocationMapper locMap = new LocationMapper("location-mapping-test.ttl;testing/RIOT/FileManager/location-mapping-test.ttl");
        FileManager fileManager = new FileManager(locMap);
        fileManager.addLocatorFile();
        InputStream in = fileManager.open("http://example.org/file");
        TestFileManager.assertNotNull((Object)in);
        this.closeInputStream(in);
    }

    @Test
    public void testLocationMappingURLtoFileOpenNotFound() {
        LocationMapper locMap = new LocationMapper("location-mapping-test.ttl;testing/RIOT/FileManager/location-mapping-test.ttl");
        FileManager fileManager = new FileManager(locMap);
        fileManager.addLocatorClassLoader(fileManager.getClass().getClassLoader());
        try {
            InputStream in = fileManager.open("http://example.org/file");
            this.closeInputStream(in);
            TestFileManager.assertNull((String)"Found nont-existant URL", null);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testCache1() {
        FileManager fileManager = new FileManager();
        fileManager.addLocatorFile(testingDir);
        Model m1 = fileManager.loadModel(fileModel);
        Model m2 = fileManager.loadModel(fileModel);
        TestFileManager.assertNotSame((Object)m1, (Object)m2);
    }

    @Test
    public void testCache2() {
        FileManager.setGlobalFileManager((FileManager)AdapterFileManager.get());
        FileManager fileManager = FileManager.get();
        fileManager.addLocatorFile(testingDir);
        fileManager.setModelCaching(true);
        Model m1 = fileManager.loadModel(fileModel);
        Model m2 = fileManager.loadModel(fileModel);
        TestFileManager.assertSame((Object)m1, (Object)m2);
    }

    @Test
    public void testCache3() {
        FileManager fileManager = FileManager.get();
        fileManager.addLocatorFile(testingDir);
        fileManager.setModelCaching(true);
        Model m1 = fileManager.loadModel(fileModel);
        Model m2 = fileManager.loadModel(fileModel);
        TestFileManager.assertSame((Object)m1, (Object)m2);
        fileManager.removeCacheModel(fileModel);
        Model m3 = fileManager.loadModel(fileModel);
        TestFileManager.assertNotSame((Object)m1, (Object)m3);
        fileManager.resetCache();
        Model m4 = fileManager.loadModel(fileModel);
        Model m5 = fileManager.loadModel(fileModel);
        TestFileManager.assertSame((Object)m4, (Object)m5);
        TestFileManager.assertNotSame((Object)m1, (Object)m4);
        TestFileManager.assertNotSame((Object)m3, (Object)m4);
    }

    private void closeInputStream(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

