/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.graph.Node;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.riot.ErrorHandlerTestLib;
import org.apache.jena.riot.checker.CheckerIRI;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.riot.system.RiotLib;
import org.junit.Test;

public class TestIRI
extends BaseTest {
    protected static final ErrorHandler handler = new ErrorHandlerTestLib.ErrorHandlerEx();
    static IRIFactory factory = IRIResolver.iriFactory();

    @Test
    public void iri1() {
        this.testIRI("http://example/");
    }

    @Test
    public void iri2() {
        this.testIRI("http://example/.");
    }

    @Test(expected=ErrorHandlerTestLib.ExError.class)
    public void iriErr1() {
        this.testIRI("example");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void iriWarn1() {
        this.testIRI("http:");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void iriWarn2() {
        this.testIRI("http:///::");
    }

    private void testIRI(String uriStr) {
        IRI iri = factory.create(uriStr);
        CheckerIRI.iriViolations((IRI)iri, (ErrorHandler)handler);
    }

    @Test
    public void bNodeIRI_1() {
        Node n = RiotLib.createIRIorBNode((String)"_:abc");
        TestIRI.assertTrue((boolean)n.isBlank());
        TestIRI.assertEquals((Object)"abc", (Object)n.getBlankNodeLabel());
    }

    @Test
    public void bNodeIRI_2() {
        Node n = RiotLib.createIRIorBNode((String)"abc");
        TestIRI.assertTrue((boolean)n.isURI());
        TestIRI.assertEquals((Object)"abc", (Object)n.getURI());
    }
}

