/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import java.util.ArrayList;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.out.NodeToLabel;
import org.apache.jena.riot.system.SyntaxLabels;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestNodeToLabel
extends BaseTest {
    private NodeToLabelFactory factory;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> data() {
        ArrayList<Object[]> x = new ArrayList<Object[]>();
        NodeToLabelFactory f0 = new NodeToLabelFactory(){

            @Override
            public NodeToLabel create() {
                return SyntaxLabels.createNodeToLabel();
            }

            public String toString() {
                return "SyntaxLabels.createNodeToLabel";
            }
        };
        NodeToLabelFactory f1 = new NodeToLabelFactory(){

            @Override
            public NodeToLabel create() {
                return NodeToLabel.createBNodeByIRI();
            }

            public String toString() {
                return "NodeToLabel.createBNodeByIRI()";
            }
        };
        NodeToLabelFactory f2 = new NodeToLabelFactory(){

            @Override
            public NodeToLabel create() {
                return NodeToLabel.createBNodeByLabelAsGiven();
            }

            public String toString() {
                return "NodeToLabel.createBNodeByLabelAsGiven()";
            }
        };
        NodeToLabelFactory f3 = new NodeToLabelFactory(){

            @Override
            public NodeToLabel create() {
                return NodeToLabel.createBNodeByLabelEncoded();
            }

            public String toString() {
                return "NodeToLabel.createBNodeByLabelEncoded()";
            }
        };
        NodeToLabelFactory f4 = new NodeToLabelFactory(){

            @Override
            public NodeToLabel create() {
                return NodeToLabel.labelByInternal();
            }

            public String toString() {
                return "NodeToLabel.labelByInternal()";
            }
        };
        x.add(new Object[]{f0});
        x.add(new Object[]{f1});
        x.add(new Object[]{f2});
        x.add(new Object[]{f3});
        x.add(new Object[]{f4});
        return x;
    }

    public TestNodeToLabel(NodeToLabelFactory factory) {
        this.factory = factory;
    }

    @Test
    public void node2label_01() {
        NodeToLabel mapper = this.factory.create();
        String x1 = (String)mapper.create();
        String x2 = (String)mapper.create();
        TestNodeToLabel.assertNotNull((Object)x1);
        TestNodeToLabel.assertNotNull((Object)x2);
        TestNodeToLabel.assertNotEquals((Object)x1, (Object)x2);
    }

    @Test
    public void node2label_02() {
        NodeToLabel mapper = this.factory.create();
        Node x = NodeFactory.createBlankNode();
        String s1 = (String)mapper.get(null, (Object)x);
        String s2 = (String)mapper.get(null, (Object)x);
        TestNodeToLabel.assertNotNull((Object)s1);
        TestNodeToLabel.assertNotNull((Object)s2);
        TestNodeToLabel.assertEquals((Object)s1, (Object)s2);
    }

    @Test
    public void node2label_03() {
        NodeToLabel mapper = this.factory.create();
        Node x1 = NodeFactory.createBlankNode();
        Node x2 = NodeFactory.createBlankNode();
        String s1 = (String)mapper.get(null, (Object)x1);
        String s2 = (String)mapper.get(null, (Object)x2);
        TestNodeToLabel.assertNotNull((Object)s1);
        TestNodeToLabel.assertNotNull((Object)s2);
        TestNodeToLabel.assertNotEquals((Object)s1, (Object)s2);
    }

    public static interface NodeToLabelFactory {
        public NodeToLabel create();
    }
}

