/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.lang.LangNQuads;
import org.apache.jena.riot.lang.LangNTriples;
import org.apache.jena.riot.lang.LangTurtle;
import org.apache.jena.riot.lang.RiotParsers;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.ParserProfileStd;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Test;

public class TestParserFactory
extends BaseTest {
    @Test
    public void ntriples_01() {
        String s = "<x> <p> <q> .";
        CatchParserOutput sink = this.parseCapture(s, Lang.NT);
        TestParserFactory.assertEquals((long)1L, (long)sink.startCalled);
        TestParserFactory.assertEquals((long)1L, (long)sink.finishCalled);
        TestParserFactory.assertEquals((long)1L, (long)sink.triples.size());
        TestParserFactory.assertEquals((long)0L, (long)sink.quads.size());
        Triple t = SSE.parseTriple((String)"(<x> <p> <q>)");
        TestParserFactory.assertEquals((Object)t, (Object)TestParserFactory.last(sink.triples));
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerString((String)"<x> <p> <q> .");
        sink = new CatchParserOutput();
        ParserProfile profile = this.makeParserProfile(IRIResolver.createNoResolve(), null, false);
        LangNTriples parser = RiotParsers.createParserNTriples((Tokenizer)tokenizer, (StreamRDF)sink, (ParserProfile)profile);
        parser.parse();
        TestParserFactory.assertEquals((long)1L, (long)sink.startCalled);
        TestParserFactory.assertEquals((long)1L, (long)sink.finishCalled);
        TestParserFactory.assertEquals((long)1L, (long)sink.triples.size());
        TestParserFactory.assertEquals((long)0L, (long)sink.quads.size());
        TestParserFactory.assertEquals((Object)SSE.parseTriple((String)"(<x> <p> <q>)"), (Object)TestParserFactory.last(sink.triples));
    }

    @Test
    public void turtle_01() {
        String s = "<x> <p> <q> .";
        CatchParserOutput sink = this.parseCapture(s, Lang.TTL);
        TestParserFactory.assertEquals((long)1L, (long)sink.startCalled);
        TestParserFactory.assertEquals((long)1L, (long)sink.finishCalled);
        TestParserFactory.assertEquals((long)1L, (long)sink.triples.size());
        TestParserFactory.assertEquals((long)0L, (long)sink.quads.size());
        Triple t = SSE.parseTriple((String)"(<http://base/x> <http://base/p> <http://base/q>)");
        TestParserFactory.assertEquals((Object)t, (Object)TestParserFactory.last(sink.triples));
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerString((String)"<x> <p> <q> .");
        sink = new CatchParserOutput();
        ParserProfile maker = this.makeParserProfile(IRIResolver.create((String)"http://base/"), null, true);
        LangTurtle parser = RiotParsers.createParserTurtle((Tokenizer)tokenizer, (StreamRDF)sink, (ParserProfile)maker);
        parser.parse();
        TestParserFactory.assertEquals((long)1L, (long)sink.startCalled);
        TestParserFactory.assertEquals((long)1L, (long)sink.finishCalled);
        TestParserFactory.assertEquals((long)1L, (long)sink.triples.size());
        TestParserFactory.assertEquals((long)0L, (long)sink.quads.size());
        TestParserFactory.assertEquals((Object)SSE.parseTriple((String)"(<http://base/x> <http://base/p> <http://base/q>)"), (Object)TestParserFactory.last(sink.triples));
    }

    private ParserProfile makeParserProfile(IRIResolver resolver, ErrorHandler errorHandler, boolean checking) {
        if (errorHandler == null) {
            errorHandler = ErrorHandlerFactory.errorHandlerStd;
        }
        return new ParserProfileStd(RiotLib.factoryRDF(), errorHandler, resolver, PrefixMapFactory.createForInput(), RIOT.getContext().copy(), checking, false);
    }

    @Test
    public void nquads_01() {
        String s = "<x> <p> <q> <g> .";
        CatchParserOutput sink = this.parseCapture(s, Lang.NQ);
        TestParserFactory.assertEquals((long)1L, (long)sink.startCalled);
        TestParserFactory.assertEquals((long)1L, (long)sink.finishCalled);
        TestParserFactory.assertEquals((long)0L, (long)sink.triples.size());
        TestParserFactory.assertEquals((long)1L, (long)sink.quads.size());
        Quad q = SSE.parseQuad((String)"(<g> <x> <p> <q>)");
        TestParserFactory.assertEquals((Object)q, (Object)TestParserFactory.last(sink.quads));
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerString((String)"<x> <p> <q> <g>.");
        sink = new CatchParserOutput();
        ParserProfile x = this.makeParserProfile(IRIResolver.createNoResolve(), null, false);
        LangNQuads parser = RiotParsers.createParserNQuads((Tokenizer)tokenizer, (StreamRDF)sink, (ParserProfile)x);
        parser.parse();
        TestParserFactory.assertEquals((long)1L, (long)sink.startCalled);
        TestParserFactory.assertEquals((long)1L, (long)sink.finishCalled);
        TestParserFactory.assertEquals((long)0L, (long)sink.triples.size());
        TestParserFactory.assertEquals((long)1L, (long)sink.quads.size());
        Quad q2 = SSE.parseQuad((String)"(<g> <x> <p> <q>)");
        TestParserFactory.assertEquals((Object)q2, (Object)TestParserFactory.last(sink.quads));
    }

    @Test
    public void trig_01() {
        String s = "{ <x> <p> <q> }";
        CatchParserOutput sink = this.parseCapture(s, Lang.TRIG);
        TestParserFactory.assertEquals((long)1L, (long)sink.startCalled);
        TestParserFactory.assertEquals((long)1L, (long)sink.finishCalled);
        TestParserFactory.assertEquals((long)0L, (long)sink.triples.size());
        TestParserFactory.assertEquals((long)1L, (long)sink.quads.size());
        Triple t = SSE.parseTriple((String)"(<http://base/x> <http://base/p> <http://base/q>)");
        Quad q = new Quad(Quad.tripleInQuad, t);
        TestParserFactory.assertEquals((Object)q, (Object)TestParserFactory.last(sink.quads));
    }

    @Test
    public void trig_02() {
        String s = "<g> { <x> <p> <q> }";
        CatchParserOutput sink = this.parseCapture(s, Lang.TRIG);
        TestParserFactory.assertEquals((long)1L, (long)sink.startCalled);
        TestParserFactory.assertEquals((long)1L, (long)sink.finishCalled);
        TestParserFactory.assertEquals((long)0L, (long)sink.triples.size());
        TestParserFactory.assertEquals((long)1L, (long)sink.quads.size());
        Quad q = SSE.parseQuad((String)"(<http://base/g> <http://base/x> <http://base/p> <http://base/q>)");
        TestParserFactory.assertEquals((Object)q, (Object)TestParserFactory.last(sink.quads));
    }

    private CatchParserOutput parseCapture(String s, Lang lang) {
        CatchParserOutput sink = new CatchParserOutput();
        RDFParser.create().source(new StringReader(s)).base("http://base/").lang(lang).parse((StreamRDF)sink);
        return sink;
    }

    private static <T> T last(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    static class CatchParserOutput
    implements StreamRDF {
        List<Triple> triples = new ArrayList<Triple>();
        List<Quad> quads = new ArrayList<Quad>();
        List<Pair<String, String>> prefixes = new ArrayList<Pair<String, String>>();
        List<String> bases = new ArrayList<String>();
        int startCalled = 0;
        int finishCalled = 0;

        CatchParserOutput() {
        }

        public void start() {
            ++this.startCalled;
        }

        public void triple(Triple triple) {
            this.triples.add(triple);
        }

        public void quad(Quad quad) {
            this.quads.add(quad);
        }

        public void base(String base) {
            this.bases.add(base);
        }

        public void prefix(String prefix, String iri) {
            this.prefixes.add((Pair<String, String>)Pair.create((Object)prefix, (Object)iri));
        }

        public void finish() {
            ++this.finishCalled;
        }
    }
}

