/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang.extra;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.lang.extra.TurtleJavaccReaderRIOT;
import org.apache.jena.riot.langsuite.UnitTestBadEval;
import org.apache.jena.riot.langsuite.UnitTestBadSyntax;
import org.apache.jena.riot.langsuite.UnitTestEval;
import org.apache.jena.riot.langsuite.UnitTestSyntax;
import org.apache.jena.riot.langsuite.VocabLangRDF;
import org.apache.jena.sparql.junit.EarlReport;
import org.apache.jena.util.junit.TestFactoryManifest;
import org.apache.jena.util.junit.TestUtils;
import org.apache.jena.vocabulary.RDF;

public class FactoryTestTurtleJavacc
extends TestFactoryManifest {
    public static String assumedRootURIex = "http://example/base/";
    public static String assumedRootURITurtle = "http://www.w3.org/2013/TurtleTests/";
    public static String assumedRootURITriG = "http://www.w3.org/2013/TriGTests/";
    public static EarlReport report = null;
    private Resource dftTestType;
    private String labelPrefix;

    public static TestSuite make(String manifest, Resource dftTestType, String labelPrefix) {
        return new FactoryTestTurtleJavacc(dftTestType, labelPrefix).process(manifest);
    }

    public FactoryTestTurtleJavacc(Resource dftTestType, String labelPrefix) {
        this.dftTestType = dftTestType;
        this.labelPrefix = labelPrefix;
    }

    public Test makeTest(Resource manifest, Resource item, String testName, Resource action, Resource result) {
        Lang lang = TurtleJavaccReaderRIOT.lang;
        try {
            Resource r = TestUtils.getResource((Resource)item, (Property)RDF.type);
            if (r == null) {
                r = this.dftTestType;
            }
            if (r == null) {
                throw new RiotException("Can't determine the test type");
            }
            if (this.labelPrefix != null) {
                testName = this.labelPrefix + testName;
            }
            Resource input = action;
            Resource output = result;
            if (r.equals((Object)VocabLangRDF.TestPositiveSyntaxTTL)) {
                return new UnitTestSyntax(testName, item.getURI(), input.getURI(), lang, report);
            }
            if (r.equals((Object)VocabLangRDF.TestNegativeSyntaxTTL)) {
                return new UnitTestBadSyntax(testName, item.getURI(), input.getURI(), lang, report);
            }
            if (r.equals((Object)VocabLangRDF.TestEvalTTL)) {
                String base = FactoryTestTurtleJavacc.rebase(input, assumedRootURITurtle);
                return new UnitTestEval(testName, item.getURI(), input.getURI(), result.getURI(), base, lang, report);
            }
            if (r.equals((Object)VocabLangRDF.TestNegativeEvalTTL)) {
                return new UnitTestBadEval(testName, item.getURI(), input.getURI(), lang, report);
            }
            System.err.println("Unrecognized turtle test : (" + r + ")" + testName);
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            System.err.println("Failed to grok test : " + testName);
            return null;
        }
    }

    private static String rebase(Resource input, String baseIRI) {
        String x = input.getLocalName();
        baseIRI = baseIRI + x;
        return baseIRI;
    }
}

