/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.langsuite;

import org.apache.jena.graph.Graph;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.langsuite.LangTestCase;
import org.apache.jena.riot.langsuite.Parse;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.junit.EarlReport;
import org.junit.After;
import org.junit.Before;

public class UnitTestBadEval
extends LangTestCase {
    private final String uri;
    private final Lang lang;
    protected ErrorHandler installed;

    public UnitTestBadEval(String name, String testURI, String uri, Lang lang, EarlReport earl) {
        super(name, testURI, earl);
        this.uri = uri;
        this.lang = lang;
    }

    @Override
    @Before
    public void _setUp() {
        this.installed = ErrorHandlerFactory.getDefaultErrorHandler();
        ErrorHandlerFactory.setDefaultErrorHandler((ErrorHandler)ErrorHandlerFactory.errorHandlerStrictSilent());
    }

    @Override
    @After
    public void _tearDown() {
        ErrorHandlerFactory.setDefaultErrorHandler((ErrorHandler)this.installed);
    }

    @Override
    public void runTestForReal() {
        if (RDFLanguages.isTriples((Lang)this.lang)) {
            this.run3();
        } else {
            this.run4();
        }
    }

    private void run3() {
        Graph graph = GraphFactory.createDefaultGraph();
        try {
            Parse.parse(graph, this.uri, this.lang);
            UnitTestBadEval.fail((String)"Managed to read a bad evaluation test without error");
        }
        catch (JenaException jenaException) {
        }
        catch (RuntimeException ex) {
            ex.printStackTrace(System.err);
            throw ex;
        }
    }

    private void run4() {
        DatasetGraph dsg = DatasetGraphFactory.createGeneral();
        try {
            Parse.parse(dsg, this.uri, this.lang);
            UnitTestBadEval.fail((String)"Managed to read a bad evaluation test without error");
        }
        catch (JenaException jenaException) {
        }
        catch (RuntimeException ex) {
            ex.printStackTrace(System.err);
            throw ex;
        }
    }
}

