/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.langsuite;

import org.apache.jena.atlas.legacy.BaseTest2;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.langsuite.LangTestCase;
import org.apache.jena.riot.langsuite.Parse;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.junit.EarlReport;

public class UnitTestBadSyntax
extends LangTestCase {
    private final String uri;
    private final Lang lang;
    private static ErrorHandler errorHandlerTestStrict = new ErrorHandler(){

        public void warning(String message, long line, long col) {
            throw new RiotException(SysRIOT.fmtMessage((String)message, (long)line, (long)col));
        }

        public void error(String message, long line, long col) {
            throw new RiotException(SysRIOT.fmtMessage((String)message, (long)line, (long)col));
        }

        public void fatal(String message, long line, long col) {
            throw new RiotException(SysRIOT.fmtMessage((String)message, (long)line, (long)col));
        }
    };

    public UnitTestBadSyntax(String name, String testURI, String uri, Lang lang, EarlReport earl) {
        super(name, testURI, earl);
        this.uri = uri;
        this.lang = lang;
    }

    @Override
    protected void _setUp() {
        BaseTest2.setTestLogging(ErrorHandlerFactory.errorHandlerStrictNoLogging);
    }

    @Override
    protected void _tearDown() {
        BaseTest2.unsetTestLogging();
    }

    @Override
    public void runTestForReal() {
        if (RDFLanguages.isTriples((Lang)this.lang)) {
            this.run3();
        } else {
            this.run4();
        }
    }

    private void run3() {
        Graph graph = GraphFactory.createDefaultGraph();
        try {
            Parse.parse(graph, this.uri, this.lang);
        }
        catch (RiotException ex) {
            return;
        }
        catch (RuntimeException ex) {
            ex.printStackTrace(System.err);
            UnitTestBadSyntax.fail((String)"Unexpected exception");
        }
        UnitTestBadSyntax.fail((String)"Bad syntax test succeed in parsing the file");
    }

    private void run4() {
        DatasetGraph dsg = DatasetGraphFactory.createGeneral();
        try {
            Parse.parse(dsg, this.uri, this.lang);
        }
        catch (RiotException ex) {
            return;
        }
        catch (RuntimeException ex) {
            ex.printStackTrace(System.err);
            UnitTestBadSyntax.fail((String)"Unexpected exception");
        }
        UnitTestBadSyntax.fail((String)"Bad syntax test succeed in parsing the file");
    }
}

