/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.langsuite;

import org.apache.jena.graph.Graph;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.langsuite.LangTestCase;
import org.apache.jena.riot.langsuite.Parse;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.junit.EarlReport;

public class UnitTestSyntax
extends LangTestCase {
    private final String uri;
    private final Lang lang;

    public UnitTestSyntax(String name, String testURI, String uri, Lang lang, EarlReport earl) {
        super(name, testURI, earl);
        this.uri = uri;
        this.lang = lang;
    }

    @Override
    public void runTestForReal() {
        if (RDFLanguages.isTriples((Lang)this.lang)) {
            this.run3();
        } else {
            this.run4();
        }
    }

    private void run3() {
        Graph graph = GraphFactory.createDefaultGraph();
        Parse.parse(graph, this.uri, this.lang);
    }

    private void run4() {
        DatasetGraph dsg = DatasetGraphFactory.createGeneral();
        Parse.parse(dsg, this.uri, this.lang);
    }

    @Override
    protected void _setUp() {
    }

    @Override
    protected void _tearDown() {
    }
}

