/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.out;

import org.apache.jena.JenaRuntime;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.StringWriterI;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.atlas.lib.CharSpace;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterNT;
import org.apache.jena.riot.out.NodeFormatterTTL;
import org.apache.jena.riot.out.NodeFormatterTTL_MultiLine;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.junit.Test;

public class TestNodeFmt
extends BaseTest {
    private static String base = "http://example.org/base";
    private static PrefixMap prefixMap = PrefixMapFactory.createForOutput();
    private static NodeFormatter nodeFormatterNTutf8;
    private static NodeFormatter nodeFormatterNTascii;
    private static NodeFormatter nodeFormatterTTL;
    private static String QuoteDouble3;
    private static String QuoteSingle3;
    private static NodeFormatter nodeFormatterTTL_ML;

    public static void test(NodeFormatter nodeFormatter, String str) {
        TestNodeFmt.test(nodeFormatter, str, str);
    }

    public static void test(NodeFormatter nodeFormatter, String nStr, String str) {
        Node n = NodeFactoryExtra.parseNode((String)nStr);
        TestNodeFmt.test(nodeFormatter, n, str);
    }

    public static void test(NodeFormatter nodeFormatter, Node n, String str) {
        StringWriterI sw = new StringWriterI();
        nodeFormatter.format((AWriter)sw, n);
        String str2 = sw.toString();
        TestNodeFmt.assertEquals((Object)str, (Object)str2);
    }

    @Test
    public void nodefmt_nt_01() {
        TestNodeFmt.test(nodeFormatterNTutf8, "?x");
    }

    @Test
    public void nodefmt_nt_02() {
        TestNodeFmt.test(nodeFormatterNTutf8, "?xyz");
    }

    @Test
    public void nodefmt_nt_03() {
        TestNodeFmt.test(nodeFormatterNTutf8, (Node)Var.alloc((String)""), "?");
    }

    @Test
    public void nodefmt_nt_04() {
        TestNodeFmt.test(nodeFormatterNTutf8, (Node)Var.alloc((String)"?"), "??");
    }

    @Test
    public void nodefmt_nt_05() {
        TestNodeFmt.test(nodeFormatterNTutf8, "'abc'", "\"abc\"");
    }

    @Test
    public void nodefmt_nt_05a() {
        TestNodeFmt.test(nodeFormatterNTutf8, "\"abc\"");
    }

    @Test
    public void nodefmt_nt_06() {
        TestNodeFmt.test(nodeFormatterNTutf8, "\"\"");
    }

    @Test
    public void nodefmt_nt_06a() {
        TestNodeFmt.test(nodeFormatterNTutf8, "''", "\"\"");
    }

    @Test
    public void nodefmt_nt_07() {
        TestNodeFmt.test(nodeFormatterNTutf8, "'abc'@en", "\"abc\"@en");
    }

    @Test
    public void nodefmt_nt_07a() {
        TestNodeFmt.test(nodeFormatterNTutf8, "\"abc\"@en");
    }

    @Test
    public void nodefmt_nt_08() {
        TestNodeFmt.test(nodeFormatterNTutf8, "\"123\"^^<http://www.w3.org/2001/XMLSchema#integer>");
    }

    @Test
    public void nodefmt_nt_09() {
        TestNodeFmt.test(nodeFormatterNTutf8, Node.ANY, "ANY");
    }

    @Test
    public void nodefmt_nt_10() {
        TestNodeFmt.test(nodeFormatterNTutf8, "'\u03a9'", "\"\u03a9\"");
    }

    @Test
    public void nodefmt_nt_11() {
        TestNodeFmt.test(nodeFormatterNTascii, "'\u03a9'", "\"\\u03A9\"");
    }

    @Test
    public void nodefmt_nt_12() {
        TestNodeFmt.test(nodeFormatterNTascii, "<http://example/>");
    }

    @Test
    public void nodefmt_nt_13() {
        TestNodeFmt.test(nodeFormatterNTascii, "\"abc\"^^<http://example/dt>");
    }

    @Test
    public void nodefmt_nt_14() {
        TestNodeFmt.test(nodeFormatterNTascii, "'\u00e9'", "\"\\u00E9\"");
    }

    @Test
    public void nodefmt_nt_15() {
        TestNodeFmt.test(nodeFormatterNTascii, "'\\n\\t\\f'", "\"\\n\\t\\f\"");
    }

    @Test
    public void nodefmt_rdf11_01() {
        if (JenaRuntime.isRDF11) {
            TestNodeFmt.test(nodeFormatterNTutf8, "'abc'^^xsd:string", "\"abc\"");
        } else {
            TestNodeFmt.test(nodeFormatterNTutf8, "'abc'^^xsd:string", "\"abc\"^^<http://www.w3.org/2001/XMLSchema#string>");
        }
    }

    @Test
    public void nodefmt_rdf11_02() {
        TestNodeFmt.test(nodeFormatterNTutf8, "'abc'^^rdf:langString", "\"abc\"^^<http://www.w3.org/1999/02/22-rdf-syntax-ns#langString>");
    }

    @Test
    public void nodefmt_ttl_01() {
        TestNodeFmt.test(nodeFormatterTTL, "?x");
    }

    @Test
    public void nodefmt_ttl_02() {
        TestNodeFmt.test(nodeFormatterTTL, "?xyz");
    }

    @Test
    public void nodefmt_ttl_03() {
        TestNodeFmt.test(nodeFormatterTTL, (Node)Var.alloc((String)""), "?");
    }

    @Test
    public void nodefmt_ttl_04() {
        TestNodeFmt.test(nodeFormatterTTL, (Node)Var.alloc((String)"?"), "??");
    }

    @Test
    public void nodefmt_ttl_05() {
        TestNodeFmt.test(nodeFormatterTTL, "\"abc\"");
    }

    @Test
    public void nodefmt_ttl_06() {
        TestNodeFmt.test(nodeFormatterTTL, "\"\"");
    }

    @Test
    public void nodefmt_ttl_07() {
        TestNodeFmt.test(nodeFormatterTTL, "\"abc\"@en");
    }

    @Test
    public void nodefmt_ttl_08() {
        TestNodeFmt.test(nodeFormatterTTL, Node.ANY, "ANY");
    }

    @Test
    public void nodefmt_ttl_11() {
        TestNodeFmt.test(nodeFormatterTTL, "<http://example.com/resources>");
    }

    @Test
    public void nodefmt_ttl_12() {
        TestNodeFmt.test(nodeFormatterTTL, "<http://example/ex/>", "ex:");
    }

    @Test
    public void nodefmt_ttl_13() {
        TestNodeFmt.test(nodeFormatterTTL, "<http://example/ex/abc>", "ex:abc");
    }

    @Test
    public void nodefmt_ttl_14() {
        TestNodeFmt.test(nodeFormatterTTL, "<http://example/ex/ab/c>", "<http://example/ex/ab/c>");
    }

    @Test
    public void nodefmt_ttl_15() {
        TestNodeFmt.test(nodeFormatterTTL, "<http://example/p>", ":");
    }

    @Test
    public void nodefmt_ttl_16() {
        TestNodeFmt.test(nodeFormatterTTL, "<http://example/p#a>", "<http://example/p#a>");
    }

    @Test
    public void nodefmt_ttl_17() {
        TestNodeFmt.test(nodeFormatterTTL, "<http://example.org/foo>", "<foo>");
    }

    @Test
    public void nodefmt_ttl_18() {
        TestNodeFmt.test(nodeFormatterTTL, "<http://example.org/base#bar>", "<#bar>");
    }

    @Test
    public void nodefmt_ttl_19() {
        TestNodeFmt.test(nodeFormatterTTL, "<http://example/ex/abc.>", "<http://example/ex/abc.>");
    }

    @Test
    public void nodefmt_ttl_20() {
        TestNodeFmt.test(nodeFormatterTTL, "<http://example/ex/abc.x>", "ex:abc.x");
    }

    @Test
    public void nodefmt_ttl_21() {
        TestNodeFmt.test(nodeFormatterTTL, "<http://example/ex/abc456.123>", "ex:abc456.123");
    }

    @Test
    public void nodefmt_ttl_22() {
        TestNodeFmt.test(nodeFormatterTTL, "<http://example/ex/abc:x>", "ex:abc:x");
    }

    @Test
    public void nodefmt_ttl_23() {
        TestNodeFmt.test(nodeFormatterTTL, "<http://example/ex/001234>", "ex:001234");
    }

    @Test
    public void nodefmt_ttl_24() {
        TestNodeFmt.test(nodeFormatterTTL, "<urn:test:abc:x>", "ns:abc:x");
    }

    @Test
    public void nodefmt_ttl_25() {
        TestNodeFmt.test(nodeFormatterTTL, "<urn:test:00:1234>", "ns:00:1234");
    }

    @Test
    public void nodefmt_ttl_26() {
        TestNodeFmt.test(nodeFormatterTTL, "<http://example/ex/::>", "ex:::");
    }

    @Test
    public void nodefmt_ttl_29() {
        TestNodeFmt.test(nodeFormatterTTL, "'\u03a9'", "\"\u03a9\"");
    }

    @Test
    public void prefixedname_01() {
        this.testPrefix("", "");
    }

    private void testPrefix(String prefix, String local) {
        TestNodeFmt.assertTrue((boolean)NodeFormatterTTL.safeForPrefix((String)prefix));
        TestNodeFmt.assertTrue((boolean)NodeFormatterTTL.safeForPrefixLocalname((String)local));
    }

    @Test
    public void nodefmt_ttl_30() {
        TestNodeFmt.test(nodeFormatterTTL, "'123'^^<http://www.w3.org/2001/XMLSchema#integer>", "123");
    }

    @Test
    public void nodefmt_ttl_31() {
        TestNodeFmt.test(nodeFormatterTTL, "'123.0'^^<http://www.w3.org/2001/XMLSchema#integer>", "\"123.0\"^^<http://www.w3.org/2001/XMLSchema#integer>");
    }

    @Test
    public void nodefmt_ttl_32() {
        TestNodeFmt.test(nodeFormatterTTL, "''^^<http://www.w3.org/2001/XMLSchema#integer>", "\"\"^^<http://www.w3.org/2001/XMLSchema#integer>");
    }

    @Test
    public void nodefmt_ttl_33() {
        TestNodeFmt.test(nodeFormatterTTL, "'abc'^^<http://www.w3.org/2001/XMLSchema#integer>", "\"abc\"^^<http://www.w3.org/2001/XMLSchema#integer>");
    }

    @Test
    public void nodefmt_ttl_34() {
        TestNodeFmt.test(nodeFormatterTTL, "'+123'^^<http://www.w3.org/2001/XMLSchema#integer>", "+123");
    }

    @Test
    public void nodefmt_ttl_35() {
        TestNodeFmt.test(nodeFormatterTTL, "'-1'^^<http://www.w3.org/2001/XMLSchema#integer>", "-1");
    }

    @Test
    public void nodefmt_ttl_40() {
        TestNodeFmt.test(nodeFormatterTTL, "'123'^^<http://www.w3.org/2001/XMLSchema#decimal>", "\"123\"^^<http://www.w3.org/2001/XMLSchema#decimal>");
    }

    @Test
    public void nodefmt_ttl_41() {
        TestNodeFmt.test(nodeFormatterTTL, "'123.0'^^<http://www.w3.org/2001/XMLSchema#decimal>", "123.0");
    }

    @Test
    public void nodefmt_ttl_42() {
        TestNodeFmt.test(nodeFormatterTTL, "''^^<http://www.w3.org/2001/XMLSchema#decimal>", "\"\"^^<http://www.w3.org/2001/XMLSchema#decimal>");
    }

    @Test
    public void nodefmt_ttl_43() {
        TestNodeFmt.test(nodeFormatterTTL, "'abc'^^<http://www.w3.org/2001/XMLSchema#decimal>", "\"abc\"^^<http://www.w3.org/2001/XMLSchema#decimal>");
    }

    @Test
    public void nodefmt_ttl_44() {
        TestNodeFmt.test(nodeFormatterTTL, "'+123.0'^^<http://www.w3.org/2001/XMLSchema#decimal>", "+123.0");
    }

    @Test
    public void nodefmt_ttl_45() {
        TestNodeFmt.test(nodeFormatterTTL, "'-1.0'^^<http://www.w3.org/2001/XMLSchema#decimal>", "-1.0");
    }

    @Test
    public void nodefmt_ttl_46() {
        TestNodeFmt.test(nodeFormatterTTL, "'.1'^^<http://www.w3.org/2001/XMLSchema#decimal>", ".1");
    }

    @Test
    public void nodefmt_ttl_47() {
        TestNodeFmt.test(nodeFormatterTTL, "'-.1'^^<http://www.w3.org/2001/XMLSchema#decimal>", "-.1");
    }

    @Test
    public void nodefmt_ttl_48() {
        TestNodeFmt.test(nodeFormatterTTL, "\"1.\"^^<http://www.w3.org/2001/XMLSchema#decimal>", "\"1.\"^^<http://www.w3.org/2001/XMLSchema#decimal>");
    }

    @Test
    public void nodefmt_ttl_49() {
        TestNodeFmt.test(nodeFormatterTTL, "'.45'^^<http://www.w3.org/2001/XMLSchema#decimal>", ".45");
    }

    @Test
    public void nodefmt_ttl_50() {
        TestNodeFmt.test(nodeFormatterTTL, "'123'^^<http://www.w3.org/2001/XMLSchema#double>", "\"123\"^^<http://www.w3.org/2001/XMLSchema#double>");
    }

    @Test
    public void nodefmt_ttl_51() {
        TestNodeFmt.test(nodeFormatterTTL, "'123.0'^^<http://www.w3.org/2001/XMLSchema#double>", "\"123.0\"^^<http://www.w3.org/2001/XMLSchema#double>");
    }

    @Test
    public void nodefmt_ttl_52() {
        TestNodeFmt.test(nodeFormatterTTL, "'123.0e0'^^<http://www.w3.org/2001/XMLSchema#double>", "123.0e0");
    }

    @Test
    public void nodefmt_ttl_53() {
        TestNodeFmt.test(nodeFormatterTTL, "'123e0'^^<http://www.w3.org/2001/XMLSchema#double>", "123e0");
    }

    @Test
    public void nodefmt_ttl_54() {
        TestNodeFmt.test(nodeFormatterTTL, "'.1e0'^^<http://www.w3.org/2001/XMLSchema#double>", ".1e0");
    }

    @Test
    public void nodefmt_ttl_55() {
        TestNodeFmt.test(nodeFormatterTTL, "'123.0e+10'^^<http://www.w3.org/2001/XMLSchema#double>", "123.0e+10");
    }

    @Test
    public void nodefmt_ttl_56() {
        TestNodeFmt.test(nodeFormatterTTL, "'123.0e-10'^^<http://www.w3.org/2001/XMLSchema#double>", "123.0e-10");
    }

    @Test
    public void nodefmt_ttl_57() {
        TestNodeFmt.test(nodeFormatterTTL, "''^^<http://www.w3.org/2001/XMLSchema#double>", "\"\"^^<http://www.w3.org/2001/XMLSchema#double>");
    }

    @Test
    public void nodefmt_ttl_58() {
        TestNodeFmt.test(nodeFormatterTTL, "'+123.0e-10'^^<http://www.w3.org/2001/XMLSchema#double>", "+123.0e-10");
    }

    @Test
    public void nodefmt_ttl_59() {
        TestNodeFmt.test(nodeFormatterTTL, "'-123.0e-10'^^<http://www.w3.org/2001/XMLSchema#double>", "-123.0e-10");
    }

    @Test
    public void nodefmt_ttl_60() {
        TestNodeFmt.test(nodeFormatterTTL, "'-123.e-10'^^<http://www.w3.org/2001/XMLSchema#double>", "-123.e-10");
    }

    @Test
    public void nodefmt_ttl_61() {
        TestNodeFmt.test(nodeFormatterTTL, "'.1e-10'^^<http://www.w3.org/2001/XMLSchema#double>", ".1e-10");
    }

    @Test
    public void nodefmt_ttl_62() {
        TestNodeFmt.test(nodeFormatterTTL, "'.e9'^^<http://www.w3.org/2001/XMLSchema#double>", "\".e9\"^^<http://www.w3.org/2001/XMLSchema#double>");
    }

    @Test
    public void nodefmt_ttl_70() {
        TestNodeFmt.test(nodeFormatterTTL, "'true'^^<http://www.w3.org/2001/XMLSchema#boolean>", "true");
    }

    @Test
    public void nodefmt_ttl_71() {
        TestNodeFmt.test(nodeFormatterTTL, "'1'^^<http://www.w3.org/2001/XMLSchema#boolean>", "\"1\"^^<http://www.w3.org/2001/XMLSchema#boolean>");
    }

    @Test
    public void nodefmt_ttl_72() {
        TestNodeFmt.test(nodeFormatterTTL, "'false'^^<http://www.w3.org/2001/XMLSchema#boolean>", "false");
    }

    @Test
    public void nodefmt_ttl_73() {
        TestNodeFmt.test(nodeFormatterTTL, "'0'^^<http://www.w3.org/2001/XMLSchema#boolean>", "\"0\"^^<http://www.w3.org/2001/XMLSchema#boolean>");
    }

    @Test
    public void nodefmt_ttl_74() {
        TestNodeFmt.test(nodeFormatterTTL, "'False'^^<http://www.w3.org/2001/XMLSchema#boolean>", "\"False\"^^<http://www.w3.org/2001/XMLSchema#boolean>");
    }

    @Test
    public void nodefmt_ttl_75() {
        TestNodeFmt.test(nodeFormatterTTL, "'True'^^<http://www.w3.org/2001/XMLSchema#boolean>", "\"True\"^^<http://www.w3.org/2001/XMLSchema#boolean>");
    }

    @Test
    public void nodefmt_ttl_ML_01() {
        TestNodeFmt.test(nodeFormatterTTL_ML, "'A\\nB'", QuoteDouble3 + "A\nB" + QuoteDouble3);
    }

    @Test
    public void nodefmt_ttl_ML_02() {
        TestNodeFmt.test(nodeFormatterTTL_ML, "'A\\nB'@en", QuoteDouble3 + "A\nB" + QuoteDouble3 + "@en");
    }

    @Test
    public void nodefmt_ttl_ML_03() {
        TestNodeFmt.test(nodeFormatterTTL_ML, "'A\\nB'^^:ex\\/datatype", QuoteDouble3 + "A\nB" + QuoteDouble3 + "^^ex:datatype");
    }

    static {
        prefixMap.add(":", "http://example/p");
        prefixMap.add("ex", "http://example/ex/");
        prefixMap.add("ns", "urn:test:");
        nodeFormatterNTutf8 = new NodeFormatterNT(CharSpace.UTF8);
        nodeFormatterNTascii = new NodeFormatterNT(CharSpace.ASCII);
        nodeFormatterTTL = new NodeFormatterTTL(base, prefixMap);
        QuoteDouble3 = "\"\"\"";
        QuoteSingle3 = "'''";
        nodeFormatterTTL_ML = new NodeFormatterTTL_MultiLine(base, prefixMap);
    }
}

