/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.junit.Test;

public abstract class AbstractTestPrefixMap
extends BaseTest {
    protected IRIFactory factory = IRIResolver.iriFactory();

    protected abstract PrefixMap getPrefixMap();

    @Test
    public void prefixMap_basic_01() {
        PrefixMap pmap = this.getPrefixMap();
        AbstractTestPrefixMap.assertTrue((boolean)pmap.isEmpty());
        AbstractTestPrefixMap.assertEquals((long)0L, (long)pmap.size());
        AbstractTestPrefixMap.assertTrue((boolean)pmap.getMapping().isEmpty());
        AbstractTestPrefixMap.assertTrue((boolean)pmap.getMappingCopy().isEmpty());
        AbstractTestPrefixMap.assertTrue((boolean)pmap.getMappingCopyStr().isEmpty());
    }

    @Test
    public void prefixMap_basic_02() {
        PrefixMap pmap = this.getPrefixMap();
        pmap.add("", "http://example/");
        AbstractTestPrefixMap.assertFalse((boolean)pmap.isEmpty());
        AbstractTestPrefixMap.assertEquals((long)1L, (long)pmap.size());
        AbstractTestPrefixMap.assertTrue((boolean)pmap.contains(""));
        AbstractTestPrefixMap.assertTrue((boolean)pmap.getMapping().containsKey(""));
        AbstractTestPrefixMap.assertTrue((boolean)pmap.getMappingCopy().containsKey(""));
        AbstractTestPrefixMap.assertTrue((boolean)pmap.getMappingCopyStr().containsKey(""));
    }

    @Test
    public void prefixMap_basic_03() {
        PrefixMap pmap = this.getPrefixMap();
        pmap.add("", "http://example/");
        pmap.add("org", "http://example.org/");
        AbstractTestPrefixMap.assertTrue((boolean)pmap.contains(""));
        AbstractTestPrefixMap.assertTrue((boolean)pmap.contains("org"));
        AbstractTestPrefixMap.assertFalse((boolean)pmap.isEmpty());
        AbstractTestPrefixMap.assertEquals((long)2L, (long)pmap.size());
    }

    @Test
    public void prefixMap_basic_04() {
        PrefixMap pmap1 = this.getPrefixMap();
        pmap1.add("", "http://example/");
        pmap1.add("org", "http://example.org/");
        PrefixMap pmap2 = this.getPrefixMap();
        pmap2.putAll(pmap1);
        AbstractTestPrefixMap.assertTrue((boolean)pmap2.contains(""));
        AbstractTestPrefixMap.assertTrue((boolean)pmap2.contains("org"));
        AbstractTestPrefixMap.assertFalse((boolean)pmap2.isEmpty());
        AbstractTestPrefixMap.assertEquals((long)2L, (long)pmap2.size());
    }

    @Test
    public void prefixMap_expand_01() {
        PrefixMap pmap = this.getPrefixMap();
        this.add(pmap, "", "http://example/");
        String x = pmap.expand("", "x");
        AbstractTestPrefixMap.assertEquals((Object)"http://example/x", (Object)x);
    }

    @Test
    public void prefixMap_expand_02() {
        PrefixMap pmap = this.getPrefixMap();
        this.add(pmap, "ex", "http://example/");
        String x = pmap.expand("", "x");
        AbstractTestPrefixMap.assertNull((Object)x);
    }

    @Test
    public void prefixMap_expand_03() {
        PrefixMap pmap = this.getPrefixMap();
        this.add(pmap, "ex", "http://example/");
        this.add(pmap, "ex", "http://example/");
        String x = pmap.expand("", "x");
        AbstractTestPrefixMap.assertNull((Object)x);
    }

    @Test
    public void prefixMap_expand_04() {
        PrefixMap pmap = this.getPrefixMap();
        this.add(pmap, "ex", "http://example/");
        this.add(pmap, "ex", "http://elsewhere/ns#");
        String x = pmap.expand("ex", "x");
        AbstractTestPrefixMap.assertEquals((Object)"http://elsewhere/ns#x", (Object)x);
    }

    @Test
    public void prefixMap_delete_01() {
        PrefixMap pmap = this.getPrefixMap();
        pmap.delete("ex");
    }

    @Test
    public void prefixMap_delete_02() {
        PrefixMap pmap = this.getPrefixMap();
        this.add(pmap, "ex", "http://example/");
        String x = pmap.expand("ex", "x");
        AbstractTestPrefixMap.assertEquals((Object)"http://example/x", (Object)x);
        pmap.delete("ex");
        x = pmap.expand("ex", "x");
        AbstractTestPrefixMap.assertNull((Object)x);
    }

    @Test
    public void prefixMap_abbrev_01() {
        PrefixMap pmap = this.getPrefixMap();
        String x = pmap.abbreviate("http://example/x");
        AbstractTestPrefixMap.assertNull((Object)x);
    }

    @Test
    public void prefixMap_abbrev_02() {
        PrefixMap pmap = this.getPrefixMap();
        this.add(pmap, "ex", "http://elsewhere/ns#");
        String x = pmap.abbreviate("http://example/x");
        AbstractTestPrefixMap.assertNull((Object)x);
    }

    @Test
    public void prefixMap_abbrev_03() {
        PrefixMap pmap = this.getPrefixMap();
        this.add(pmap, "ex", "http://example/");
        this.add(pmap, "eg", "http://elsewhere/ns#");
        String x = pmap.abbreviate("http://example/x");
        AbstractTestPrefixMap.assertEquals((Object)"ex:x", (Object)x);
    }

    @Test
    public void prefixMap_abbrev_04() {
        PrefixMap pmap = this.getPrefixMap();
        this.add(pmap, "ex", "http://example/");
        this.add(pmap, "eg", "http://example/ns#");
        String x = pmap.abbreviate("http://example/x");
        AbstractTestPrefixMap.assertEquals((Object)"ex:x", (Object)x);
    }

    @Test
    public void prefixMap_abbrev_05() {
        PrefixMap pmap = this.getPrefixMap();
        this.add(pmap, "ex", "http://example/");
        this.add(pmap, "eg", "http://example/");
        String x = pmap.abbreviate("http://example/x");
        AbstractTestPrefixMap.assertNotNull((Object)x);
        AbstractTestPrefixMap.assertTrue((x.equals("ex:x") || x.equals("eg:x") ? 1 : 0) != 0);
    }

    @Test
    public void prefixMap_abbrev_06() {
        PrefixMap pmap = this.getPrefixMap();
        for (int i = 1; i <= 100; ++i) {
            this.add(pmap, "ns" + i, "http://example/ns" + i + "#");
        }
        String x = pmap.abbreviate("http://example/ns100#x");
        AbstractTestPrefixMap.assertEquals((Object)"ns100:x", (Object)x);
    }

    protected PrefixMap create() {
        PrefixMap pm = this.getPrefixMap();
        pm.add("p0", "http://example/a/");
        pm.add("p1", "http://example/a/b");
        pm.add("p2", "http://example/a/b/");
        pm.add("p3", "http://example/a/b#");
        pm.add("q1", "http://example/a");
        pm.add("q2", "http://example/a#");
        return pm;
    }

    @Test
    public void prefixMap_abbrev_10() {
        this.pmTest("http://example/a/b", "p1:", "p0:b");
    }

    @Test
    public void prefixMap_abbrev_11() {
        this.pmTest("http://example/a/bcd", "p1:cd", "p0:bcd");
    }

    @Test
    public void prefixMap_abbrev_12() {
        this.pmTest("http://example/a/b/c", "p2:c");
    }

    @Test
    public void prefixMap_abbrev_13() {
        this.pmTest("http://example/a/b/c/", new String[0]);
    }

    @Test
    public void prefixMap_abbrev_14() {
        this.pmTest("http://example/a/b/c/d", new String[0]);
    }

    @Test
    public void prefixMap_abbrev_15() {
        this.pmTest("http://example/a/b#x", "p3:x");
    }

    @Test
    public void prefixMap_abbrev_16() {
        this.pmTest("http://example/a#z", "q2:z");
    }

    @Test
    public void prefixMap_abbrev_17() {
        this.pmTest("http://example/a/", "p0:");
    }

    @Test
    public void prefixMap_abbrev_18() {
        this.pmTest("http://example/a", "q1:");
    }

    @Test
    public void prefixMap_abbrev_20() {
        PrefixMap pmap = PrefixMapFactory.create();
        pmap.add("ex", "http://example/");
        pmap.delete("ex");
        String x = pmap.abbreviate("http://example/s");
        AbstractTestPrefixMap.assertNull((Object)x);
    }

    public void pmTest(String iriStr, String ... expected) {
        PrefixMap pm = this.create();
        String x = pm.abbreviate(iriStr);
        if (expected.length == 0) {
            AbstractTestPrefixMap.assertNull((String)("expected no abbreviation for " + iriStr), (Object)x);
            return;
        }
        for (String possible : expected) {
            if (!possible.equals(x)) continue;
            return;
        }
        AbstractTestPrefixMap.fail((String)("Expected one of " + String.join((CharSequence)" , ", expected) + " but got " + x));
    }

    protected void add(PrefixMap pmap, String prefix, String uri) {
        pmap.add(prefix, this.factory.create(uri));
    }
}

