/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import org.apache.jena.graph.Node;
import org.apache.jena.riot.ErrorHandlerTestLib;
import org.apache.jena.riot.system.Checker;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.shared.impl.JenaParameters;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestChecker {
    static Checker checker = new Checker((ErrorHandler)new ErrorHandlerTestLib.ErrorHandlerEx());
    boolean b;

    @Before
    public void before() {
        this.b = JenaParameters.enableWhitespaceCheckingOfTypedLiterals;
    }

    @After
    public void after() {
        JenaParameters.enableWhitespaceCheckingOfTypedLiterals = this.b;
    }

    @Test
    public void checker01() {
        TestChecker.check("''");
    }

    @Test
    public void checker02() {
        TestChecker.check("''@en");
    }

    @Test
    public void checker03() {
        TestChecker.check("<http://example/x>");
    }

    @Test(expected=ErrorHandlerTestLib.ExError.class)
    public void checker04() {
        TestChecker.check("<x>");
    }

    @Test
    public void checker05() {
        TestChecker.check("<urn:abc>");
    }

    @Test
    public void checker06() {
        TestChecker.check("<urn:abc:>");
    }

    @Test
    public void checker07() {
        TestChecker.check("<urn:abc:y>");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void checker10() {
        TestChecker.check("''^^xsd:dateTime");
    }

    @Test
    public void checker11() {
        TestChecker.check("'  2010-05-19T01:01:01.01+01:00'^^xsd:dateTime");
    }

    @Test
    public void checker12() {
        TestChecker.check("'\\n2010-05-19T01:01:01.01+01:00\\t\\r  '^^xsd:dateTime");
    }

    @Test
    public void checker13() {
        TestChecker.check("' 123'^^xsd:integer");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void checker14() {
        TestChecker.check("'12 3'^^xsd:integer");
    }

    @Test
    public void checker15() {
        TestChecker.check("'\\n123'^^xsd:integer");
    }

    @Test
    public void checker16() {
        TestChecker.check("'123.0  '^^xsd:float");
    }

    @Test
    public void checker17() {
        TestChecker.check("'123.0\\n'^^xsd:double");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void checker20() {
        TestChecker.check("'XYZ'^^xsd:integer");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void checker21() {
        TestChecker.check("'XYZ'@abcdefghijklmn");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void checker30() {
        TestChecker.check("<http://base/[]iri>");
    }

    @Test
    public void checker40() {
        TestChecker.check("\"<x></x>\"^^rdf:XMLLiteral");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void checker41() {
        TestChecker.check("\"<x>\"^^rdf:XMLLiteral");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void checker42() {
        TestChecker.check("\"<x><y></x></y>\"^^rdf:XMLLiteral");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void checker43() {
        TestChecker.check("\"<x/>\"^^rdf:XMLLiteral");
    }

    @Test
    public void checker44() {
        TestChecker.check("'''<x xmlns=\"http://example/ns#\" attr=\"foo\"></x>'''^^rdf:XMLLiteral");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void checker45() {
        TestChecker.check("'''<x attr=\"foo\" xmlns=\"http://example/ns#\"></x>'''^^rdf:XMLLiteral");
    }

    private static void check(String string) {
        Node n = NodeFactoryExtra.parseNode((String)string);
        checker.check(n, -1L, -1L);
    }
}

