/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import org.apache.jena.rdf.model.impl.RDFWriterFImpl;
import org.apache.jena.riot.IO_Jena;
import org.apache.jena.riot.adapters.RDFWriterRIOT;
import org.apache.jena.shared.NoWriterForLangException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestIO_JenaWriters {
    @BeforeClass
    public static void beforeClass() {
    }

    @AfterClass
    public static void afterClass() {
        IO_Jena.wireIntoJena();
    }

    @Test
    public void testWireIntoJena() {
        IO_Jena.wireIntoJena();
        RDFWriterFImpl writerF = new RDFWriterFImpl();
        Assert.assertEquals(RDFWriterRIOT.class, writerF.getWriter().getClass());
        Assert.assertEquals(RDFWriterRIOT.class, writerF.getWriter("RDF/XML").getClass());
        Assert.assertEquals(RDFWriterRIOT.class, writerF.getWriter("RDF/XML-ABBREV").getClass());
        Assert.assertEquals(RDFWriterRIOT.class, writerF.getWriter("N-TRIPLE").getClass());
        Assert.assertEquals(RDFWriterRIOT.class, writerF.getWriter("N-Triples").getClass());
        Assert.assertEquals(RDFWriterRIOT.class, writerF.getWriter("N-TRIPLE").getClass());
        Assert.assertEquals(RDFWriterRIOT.class, writerF.getWriter("NT").getClass());
        Assert.assertEquals(RDFWriterRIOT.class, writerF.getWriter("N3").getClass());
        Assert.assertEquals(RDFWriterRIOT.class, writerF.getWriter("N3-PP").getClass());
        Assert.assertEquals(RDFWriterRIOT.class, writerF.getWriter("N3-PLAIN").getClass());
        Assert.assertEquals(RDFWriterRIOT.class, writerF.getWriter("N3-TRIPLES").getClass());
        Assert.assertEquals(RDFWriterRIOT.class, writerF.getWriter("N3-TRIPLE").getClass());
        Assert.assertEquals(RDFWriterRIOT.class, writerF.getWriter("TURTLE").getClass());
        Assert.assertEquals(RDFWriterRIOT.class, writerF.getWriter("Turtle").getClass());
        Assert.assertEquals(RDFWriterRIOT.class, writerF.getWriter("TTL").getClass());
        Assert.assertEquals(RDFWriterRIOT.class, writerF.getWriter("RDF/JSON").getClass());
        Assert.assertEquals(RDFWriterRIOT.class, writerF.getWriter("RDFJSON").getClass());
    }

    @Test
    public void testResetJena() {
        IO_Jena.wireIntoJena();
        IO_Jena.resetJena();
        RDFWriterFImpl writerF = new RDFWriterFImpl();
        Assert.assertNotEquals(RDFWriterRIOT.class, writerF.getWriter().getClass());
        Assert.assertNotEquals(RDFWriterRIOT.class, writerF.getWriter("RDF/XML").getClass());
        Assert.assertNotEquals(RDFWriterRIOT.class, writerF.getWriter("RDF/XML-ABBREV").getClass());
        Assert.assertNotEquals(RDFWriterRIOT.class, writerF.getWriter("N-TRIPLE").getClass());
        Assert.assertNotEquals(RDFWriterRIOT.class, writerF.getWriter("N-Triples").getClass());
        Assert.assertNotEquals(RDFWriterRIOT.class, writerF.getWriter("N-TRIPLE").getClass());
        Assert.assertNotEquals(RDFWriterRIOT.class, writerF.getWriter("N3").getClass());
        Assert.assertNotEquals(RDFWriterRIOT.class, writerF.getWriter("N3-PP").getClass());
        Assert.assertNotEquals(RDFWriterRIOT.class, writerF.getWriter("N3-PLAIN").getClass());
        Assert.assertNotEquals(RDFWriterRIOT.class, writerF.getWriter("N3-TRIPLES").getClass());
        Assert.assertNotEquals(RDFWriterRIOT.class, writerF.getWriter("N3-TRIPLE").getClass());
        Assert.assertNotEquals(RDFWriterRIOT.class, writerF.getWriter("TURTLE").getClass());
        Assert.assertNotEquals(RDFWriterRIOT.class, writerF.getWriter("Turtle").getClass());
        Assert.assertNotEquals(RDFWriterRIOT.class, writerF.getWriter("TTL").getClass());
        try {
            writerF.getWriter("NT");
            Assert.fail((String)"Exception expected");
        }
        catch (NoWriterForLangException noWriterForLangException) {
            // empty catch block
        }
        try {
            writerF.getWriter("RDF/JSON");
            Assert.fail((String)"Exception expected");
        }
        catch (NoWriterForLangException noWriterForLangException) {
            // empty catch block
        }
        try {
            writerF.getWriter("RDFJSON");
            Assert.fail((String)"Exception expected");
        }
        catch (NoWriterForLangException noWriterForLangException) {
            // empty catch block
        }
        IO_Jena.wireIntoJena();
    }
}

