/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.IsoMatcher;
import org.junit.Assert;
import org.junit.Test;

public class TestJsonLDReadWrite
extends BaseTest {
    private static String DIR = "testing/RIOT/jsonld/";

    @Test
    public void read_g01() {
        this.graphJ2R("graph1.jsonld", "graph1.ttl");
    }

    @Test
    public void read_g02() {
        this.graphJ2R("graph2.jsonld", "graph2.ttl");
    }

    @Test
    public void read_ds01() {
        this.datasetJ2R("graph1.jsonld", "graph1.ttl");
    }

    @Test
    public void read_ds02() {
        this.datasetJ2R("graph2.jsonld", "graph2.ttl");
    }

    @Test
    public void read_ds03() {
        this.datasetJ2R("dataset1.jsonld", "dataset1.trig");
    }

    private void graphJ2R(String inFile, String outFile) {
        inFile = DIR + inFile;
        outFile = DIR + outFile;
        Model model1 = RDFDataMgr.loadModel((String)inFile);
        Model model2 = RDFDataMgr.loadModel((String)outFile);
        TestJsonLDReadWrite.assertTrue((boolean)model1.isIsomorphicWith(model2));
    }

    private void datasetJ2R(String inFile, String outFile) {
        inFile = DIR + inFile;
        outFile = DIR + outFile;
        RDFDataMgr.loadDataset((String)inFile);
        RDFDataMgr.loadDataset((String)outFile);
    }

    @Test
    public void roundtrip_01() {
        TestJsonLDReadWrite.rtRJRg("graph1.ttl");
    }

    @Test
    public void roundtrip_02() {
        TestJsonLDReadWrite.rtRJRds("graph1.ttl");
    }

    @Test
    public void roundtrip_03() {
        TestJsonLDReadWrite.rtRJRds("dataset1.trig");
    }

    static void rtRJRg(String filename) {
        filename = DIR + filename;
        Model model = RDFDataMgr.loadModel((String)filename);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        RDFDataMgr.write((OutputStream)out, (Model)model, (Lang)RDFLanguages.JSONLD);
        ByteArrayInputStream r = new ByteArrayInputStream(out.toByteArray());
        Model model2 = ModelFactory.createDefaultModel();
        RDFDataMgr.read((Model)model2, (InputStream)r, null, (Lang)RDFLanguages.JSONLD);
        if (!model.isIsomorphicWith(model2)) {
            System.out.println("## ---- DIFFERENT");
        }
        TestJsonLDReadWrite.assertTrue((boolean)model.isIsomorphicWith(model2));
        TestJsonLDReadWrite.checkNamespaces(model2, model.getNsPrefixMap());
    }

    static void rtRJRds(String filename) {
        filename = DIR + filename;
        Dataset ds1 = RDFDataMgr.loadDataset((String)filename);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        RDFDataMgr.write((OutputStream)out, (Dataset)ds1, (Lang)RDFLanguages.JSONLD);
        ByteArrayInputStream r = new ByteArrayInputStream(out.toByteArray());
        Dataset ds2 = DatasetFactory.createMem();
        RDFDataMgr.read((Dataset)ds2, (InputStream)r, null, (Lang)RDFLanguages.JSONLD);
        if (!TestJsonLDReadWrite.isIsomorphic(ds1, ds2)) {
            SSE.write((Dataset)ds1);
            SSE.write((Dataset)ds2);
        }
        TestJsonLDReadWrite.assertTrue((boolean)TestJsonLDReadWrite.isIsomorphic(ds1, ds2));
        TestJsonLDReadWrite.checkNamespaces(ds2.getDefaultModel(), ds1.getDefaultModel().getNsPrefixMap());
        Iterator graphNames = ds2.listNames();
        while (graphNames.hasNext()) {
            String gn = (String)graphNames.next();
            TestJsonLDReadWrite.checkNamespaces(ds2.getNamedModel(gn), ds1.getNamedModel(gn).getNsPrefixMap());
        }
    }

    private static boolean isIsomorphic(Dataset ds1, Dataset ds2) {
        return IsoMatcher.isomorphic((DatasetGraph)ds1.asDatasetGraph(), (DatasetGraph)ds2.asDatasetGraph());
    }

    private static void checkNamespaces(Model m, Map<String, String> namespaces) {
        if (namespaces == null) {
            return;
        }
        for (String prefix : namespaces.keySet()) {
            if (prefix.isEmpty()) continue;
            Assert.assertEquals((String)("Model does contain expected namespace " + prefix + ": <" + namespaces.get(prefix) + ">"), (Object)namespaces.get(prefix), (Object)m.getNsPrefixURI(prefix));
        }
    }
}

