/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.lang.StreamRDFCounting;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Test;

public class TestStreamRDF
extends BaseTest {
    private static Triple triple1 = SSE.parseTriple((String)"(<s> <p> <o>)");
    private static Quad quad1 = SSE.parseQuad((String)"(<g> <s> <p> <o>)");

    @Test
    public void stream_count_01() {
        StreamRDFCounting stream = StreamRDFLib.count();
        stream.start();
        TestStreamRDF.assertEquals((long)0L, (long)stream.count());
        stream.triple(triple1);
        TestStreamRDF.assertEquals((long)1L, (long)stream.count());
        stream.triple(triple1);
        TestStreamRDF.assertEquals((long)2L, (long)stream.count());
        stream.finish();
        TestStreamRDF.assertEquals((long)2L, (long)stream.count());
        TestStreamRDF.assertEquals((long)2L, (long)stream.countTriples());
        TestStreamRDF.assertEquals((long)0L, (long)stream.countQuads());
    }

    @Test
    public void stream_count_02() {
        StreamRDFCounting stream = StreamRDFLib.count();
        stream.start();
        stream.triple(triple1);
        stream.quad(quad1);
        TestStreamRDF.assertEquals((long)2L, (long)stream.count());
        TestStreamRDF.assertEquals((long)1L, (long)stream.countTriples());
        TestStreamRDF.assertEquals((long)1L, (long)stream.countQuads());
        stream.finish();
    }
}

