/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.tokens;

import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.TokenType;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestTokenForNode
extends BaseTest {
    static String base = "http://localhost/";
    static PrefixMap prefixMap = PrefixMapFactory.create();

    @BeforeClass
    public static void beforeClass() {
        prefixMap.add("ex", "http://example/");
    }

    @Test
    public void tokenForNode01() {
        TestTokenForNode.test("'x'", TokenType.STRING, "x", null, null, null);
    }

    @Test
    public void tokenForNode02() {
        TestTokenForNode.test("<x>", TokenType.IRI, "x", null, null, null);
    }

    @Test
    public void tokenForNode03() {
        TestTokenForNode.test("'en'@lang", TokenType.LITERAL_LANG, "en", "lang", new Token(TokenType.STRING, "en"), null);
    }

    @Test
    public void tokenForNode04() {
        Token sub = new Token(-1L, -1L);
        sub.setType(TokenType.IRI);
        sub.setImage("dtype");
        TestTokenForNode.test("'lex'^^<dtype>", TokenType.LITERAL_DT, "lex", null, new Token(TokenType.STRING, "lex"), sub);
    }

    @Test
    public void tokenForNode05() {
        TestTokenForNode.test("<http://localhost/foo>", TokenType.IRI, "foo", null, null, null);
    }

    @Test
    public void tokenForNode06() {
        TestTokenForNode.test("<http://example/bar>", TokenType.PREFIXED_NAME, "ex", "bar", null, null);
    }

    @Test
    public void tokenForNode07() {
        TestTokenForNode.test(NodeFactory.createBlankNode((String)"abc"), TokenType.BNODE, "abc", null, null, null);
    }

    @Test
    public void tokenForNode08() {
        TestTokenForNode.test(Node.ANY, TokenType.KEYWORD, "ANY", null, null, null);
    }

    @Test
    public void tokenForNode20() {
        TestTokenForNode.test("123", TokenType.INTEGER, "123", null, null, null);
    }

    @Test
    public void tokenForNode21() {
        TestTokenForNode.test("123.0", TokenType.DECIMAL, "123.0", null, null, null);
    }

    @Test
    public void tokenForNode22() {
        TestTokenForNode.test("12e0", TokenType.DOUBLE, "12e0", null, null, null);
    }

    private static void test(String nodeStr, TokenType type, String image, String image2, Token subToken1, Token subToken2) {
        Node n = NodeFactoryExtra.parseNode((String)nodeStr);
        TestTokenForNode.test(n, type, image, image2, subToken1, subToken2);
    }

    private static void test(Node node, TokenType type, String image, String image2, Token subToken1, Token subToken2) {
        Token t = Token.tokenForNode((Node)node, (String)base, (PrefixMap)prefixMap);
        TestTokenForNode.assertEquals((Object)type, (Object)t.getType());
        TestTokenForNode.assertEquals((Object)image, (Object)t.getImage());
        TestTokenForNode.assertEquals((Object)image2, (Object)t.getImage2());
        TestTokenForNode.assertEquals((Object)subToken1, (Object)t.getSubToken1());
        TestTokenForNode.assertEquals((Object)subToken2, (Object)t.getSubToken2());
    }
}

