/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import com.fasterxml.jackson.core.JsonParseException;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Map;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.json.JsonString;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.JsonLDWriteContext;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFWriter;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.writer.JsonLDWriter;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.vocabulary.FOAF;
import org.apache.jena.vocabulary.RDF;
import org.apache.log4j.Logger;
import org.junit.Test;

public class TestJsonLDWriter
extends BaseTest {
    private static RDFFormat[] JSON_LD_FORMATS = new RDFFormat[]{RDFFormat.JSONLD_COMPACT_PRETTY, RDFFormat.JSONLD_FLATTEN_PRETTY, RDFFormat.JSONLD_EXPAND_PRETTY, RDFFormat.JSONLD_FRAME_PRETTY, RDFFormat.JSONLD_COMPACT_FLAT, RDFFormat.JSONLD_FLATTEN_FLAT, RDFFormat.JSONLD_EXPAND_FLAT, RDFFormat.JSONLD_FRAME_FLAT};

    @Test
    public final void prettyIsNotFlat() {
        String ns = "http://www.a.com/foo/";
        Model m = this.simpleModel(ns);
        m.setNsPrefix("ex", ns);
        String s = this.toString(m, RDFFormat.JSONLD_EXPAND_PRETTY, null);
        TestJsonLDWriter.assertTrue((boolean)s.trim().contains("\n"));
        s = this.toString(m, RDFFormat.JSONLD_COMPACT_PRETTY, null);
        TestJsonLDWriter.assertTrue((boolean)s.trim().contains("\n"));
        s = this.toString(m, RDFFormat.JSONLD_FLATTEN_PRETTY, null);
        TestJsonLDWriter.assertTrue((boolean)s.trim().contains("\n"));
        s = this.toString(m, RDFFormat.JSONLD_EXPAND_FLAT, null);
        TestJsonLDWriter.assertFalse((boolean)s.trim().contains("\n"));
        s = this.toString(m, RDFFormat.JSONLD_COMPACT_FLAT, null);
        TestJsonLDWriter.assertFalse((boolean)s.trim().contains("\n"));
        s = this.toString(m, RDFFormat.JSONLD_FLATTEN_FLAT, null);
        TestJsonLDWriter.assertFalse((boolean)s.trim().contains("\n"));
        TestJsonLDWriter.assertFalse((boolean)s.trim().contains("\n"));
    }

    @Test
    public final void contextOrNot() {
        String ns = "http://www.a.com/foo/";
        Model m = this.simpleModel(ns);
        m.setNsPrefix("ex", ns);
        String s = this.toString(m, RDFFormat.JSONLD_EXPAND_PRETTY, null);
        TestJsonLDWriter.assertFalse((boolean)s.contains("@context"));
        s = this.toString(m, RDFFormat.JSONLD_EXPAND_FLAT, null);
        TestJsonLDWriter.assertFalse((boolean)s.contains("@context"));
        s = this.toString(m, RDFFormat.JSONLD_COMPACT_PRETTY, null);
        TestJsonLDWriter.assertTrue((boolean)s.contains("@context"));
        s = this.toString(m, RDFFormat.JSONLD_COMPACT_FLAT, null);
        TestJsonLDWriter.assertTrue((boolean)s.contains("@context"));
        s = this.toString(m, RDFFormat.JSONLD_FLATTEN_PRETTY, null);
        TestJsonLDWriter.assertTrue((boolean)s.contains("@context"));
        s = this.toString(m, RDFFormat.JSONLD_FLATTEN_FLAT, null);
        TestJsonLDWriter.assertTrue((boolean)s.contains("@context"));
    }

    private Model simpleModel(String ns) {
        Model m = ModelFactory.createDefaultModel();
        Resource s = m.createResource(ns + "s");
        Property p = m.createProperty(ns + "p");
        Resource o = m.createResource(ns + "o");
        m.add(s, p, (RDFNode)o);
        return m;
    }

    @Test
    public final void roundTrip() {
        String ns = "http://www.a.com/foo/";
        Model m = this.simpleModel(ns);
        m.setNsPrefix("ex", ns);
        for (RDFFormat f : JSON_LD_FORMATS) {
            if (((RDFFormat.JSONLDVariant)f.getVariant()).isFrame()) continue;
            String s = this.toString(m, f, null);
            Model m2 = this.parse(s);
            TestJsonLDWriter.assertTrue((boolean)m2.isIsomorphicWith(m));
        }
    }

    @Test
    public final void noEmptyPrefixInContext() {
        String ns = "http://www.a.com/foo/";
        Model m = this.simpleModel(ns);
        m.setNsPrefix("", ns);
        String jsonld = this.toString(m, RDFFormat.JSONLD_COMPACT_PRETTY, null);
        TestJsonLDWriter.assertFalse((boolean)jsonld.contains("\"\""));
        Model m2 = this.parse(jsonld);
        TestJsonLDWriter.assertTrue((boolean)m2.isIsomorphicWith(m));
    }

    @Test
    public void testSettingContextAsJsonString() {
        String ns = "http://www.a.com/foo/";
        Model m = this.simpleModel(ns);
        m.setNsPrefix("ex", ns);
        String s1 = this.toString(m, RDFFormat.JSONLD_COMPACT_FLAT, null);
        String prefixStringInResult = "\"ex\":\"" + ns + "\"";
        TestJsonLDWriter.assertTrue((boolean)s1.contains(prefixStringInResult));
        Model m1 = this.parse(s1);
        JsonObject obj = new JsonObject();
        obj.put("@id", ns + "p");
        obj.put("@type", "@id");
        JsonObject json = new JsonObject();
        json.put("p", (JsonValue)obj);
        json.put("ex", ns);
        String js = json.toString();
        m.removeNsPrefix("ex");
        String s2 = this.toString(m, RDFFormat.JSONLD_COMPACT_PRETTY, null);
        TestJsonLDWriter.assertFalse((boolean)s2.contains(prefixStringInResult));
        JsonLDWriteContext jenaCtx = new JsonLDWriteContext();
        jenaCtx.setJsonLDContext(js);
        String s3 = this.toString(m, RDFFormat.JSONLD_COMPACT_FLAT, (Context)jenaCtx);
        TestJsonLDWriter.assertTrue((s3.length() == s1.length() ? 1 : 0) != 0);
        TestJsonLDWriter.assertTrue((boolean)s3.contains(prefixStringInResult));
        Model m3 = this.parse(s3);
        TestJsonLDWriter.assertTrue((boolean)m3.isIsomorphicWith(m));
        TestJsonLDWriter.assertTrue((boolean)m3.isIsomorphicWith(m1));
        js = "{\"@context\":" + js + "}";
        jenaCtx.setJsonLDContext(js);
        String s4 = this.toString(m, RDFFormat.JSONLD_COMPACT_FLAT, (Context)jenaCtx);
        TestJsonLDWriter.assertTrue((s4.length() == s1.length() ? 1 : 0) != 0);
        TestJsonLDWriter.assertTrue((boolean)s4.contains(prefixStringInResult));
        Model m4 = this.parse(s4);
        TestJsonLDWriter.assertTrue((boolean)m4.isIsomorphicWith(m));
        TestJsonLDWriter.assertTrue((boolean)m4.isIsomorphicWith(m1));
    }

    @Test
    public void testSettingContextAsObjectExpectedByJsonldAPI() {
        String ns = "http://www.a.com/foo/";
        Model m = this.simpleModel(ns);
        m.setNsPrefix("ex", ns);
        String s1 = this.toString(m, RDFFormat.JSONLD_COMPACT_FLAT, null);
        String prefixStringInResult = "\"ex\":\"" + ns + "\"";
        TestJsonLDWriter.assertTrue((boolean)s1.contains(prefixStringInResult));
        Model m1 = this.parse(s1);
        Object ctx = JsonLDWriter.createJsonldContext((Graph)m.getGraph());
        m.removeNsPrefix("ex");
        String s2 = this.toString(m, RDFFormat.JSONLD_COMPACT_PRETTY, null);
        TestJsonLDWriter.assertFalse((boolean)s2.contains(prefixStringInResult));
        Context jenaCtx = new Context();
        jenaCtx.set(JsonLDWriter.JSONLD_CONTEXT, ctx);
        String s3 = this.toString(m, RDFFormat.JSONLD_COMPACT_FLAT, jenaCtx);
        TestJsonLDWriter.assertTrue((s3.length() == s1.length() ? 1 : 0) != 0);
        TestJsonLDWriter.assertTrue((boolean)s3.contains(prefixStringInResult));
        Model m3 = this.parse(s3);
        TestJsonLDWriter.assertTrue((boolean)m3.isIsomorphicWith(m));
        TestJsonLDWriter.assertTrue((boolean)m3.isIsomorphicWith(m1));
    }

    @Test
    public final void testContextByUri() {
        Model m = ModelFactory.createDefaultModel();
        String ns = "http://schema.org/";
        Resource s = m.createResource();
        m.add(s, m.createProperty(ns + "name"), "Jane Doe");
        m.add(s, m.createProperty(ns + "url"), "http://www.janedoe.com");
        m.add(s, RDF.type, "Person");
        JsonLDWriteContext jenaContext = new JsonLDWriteContext();
        try {
            jenaContext.set(JsonLDWriter.JSONLD_CONTEXT, (Object)"{\"@context\" : \"http://schema.org/\"}");
            String jsonld = this.toString(m, RDFFormat.JSONLD, (Context)jenaContext);
            Model model = this.parse(jsonld);
        }
        catch (Throwable e) {
            String mess = e.getMessage();
            if (mess != null && mess.contains("loading remote context failed")) {
                Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)mess);
                e.printStackTrace();
            }
            throw e;
        }
    }

    @Test
    public void testSubstitutingContext() {
        Model m = ModelFactory.createDefaultModel();
        String ns = "http://schema.org/";
        Resource person = m.createResource(ns + "Person");
        Resource s = m.createResource();
        m.add(s, m.createProperty(ns + "name"), "Jane Doe");
        m.add(s, m.createProperty(ns + "url"), "http://www.janedoe.com");
        m.add(s, m.createProperty(ns + "jobTitle"), "Professor");
        m.add(s, RDF.type, (RDFNode)person);
        JsonLDWriteContext jenaCtx = new JsonLDWriteContext();
        jenaCtx.setJsonLDContextSubstitution(new JsonString(ns).toString());
        String jsonld = this.toString(m, RDFFormat.JSONLD_COMPACT_FLAT, (Context)jenaCtx);
        String c = "\"@context\":\"http://schema.org/\"";
        TestJsonLDWriter.assertTrue((boolean)jsonld.contains(c));
        String ctx = "{\"jobTitle\":{\"@id\":\"http://ex.com/jobTitle\"},\"url\":{\"@id\":\"http://ex.com/url\"},\"name\":{\"@id\":\"http://ex.com/name\"}}";
        jenaCtx.setJsonLDContextSubstitution(ctx);
        jsonld = this.toString(m, RDFFormat.JSONLD_COMPACT_FLAT, (Context)jenaCtx);
        TestJsonLDWriter.assertTrue((boolean)jsonld.contains("http://ex.com/name"));
    }

    @Test
    public final void testFrames() throws JsonParseException, IOException {
        Model m = ModelFactory.createDefaultModel();
        String ns = "http://schema.org/";
        Resource person = m.createResource(ns + "Person");
        Resource s = m.createResource();
        m.add(s, m.createProperty(ns + "name"), "Jane Doe");
        m.add(s, m.createProperty(ns + "url"), "http://www.janedoe.com");
        m.add(s, m.createProperty(ns + "jobTitle"), "Professor");
        m.add(s, RDF.type, (RDFNode)person);
        s = m.createResource();
        m.add(s, m.createProperty(ns + "name"), "Gado Salamatou");
        m.add(s, m.createProperty(ns + "url"), "http://www.salamatou.com");
        m.add(s, RDF.type, (RDFNode)person);
        s = m.createResource();
        m.add(s, m.createProperty(ns + "name"), "Not a person");
        m.add(s, RDF.type, (RDFNode)m.createResource(ns + "Event"));
        Context jenaCtx = new Context();
        JsonObject frame = new JsonObject();
        frame.put("@type", ns + "Person");
        jenaCtx.set(JsonLDWriter.JSONLD_FRAME, (Object)frame.toString());
        String jsonld = this.toString(m, RDFFormat.JSONLD_FRAME_PRETTY, jenaCtx);
        Model m2 = this.parse(jsonld);
        TestJsonLDWriter.assertTrue((m2.listStatements((Resource)null, RDF.type, (RDFNode)null).toList().size() == 2 ? 1 : 0) != 0);
        TestJsonLDWriter.assertTrue((m2.listStatements((Resource)null, RDF.type, (RDFNode)person).toList().size() == 2 ? 1 : 0) != 0);
        TestJsonLDWriter.assertTrue((boolean)jsonld.trim().contains("\n"));
        frame = new JsonObject();
        frame.put("http://schema.org/jobTitle", (JsonValue)new JsonObject());
        jenaCtx.set(JsonLDWriter.JSONLD_FRAME, JsonUtils.fromString((String)frame.toString()));
        jsonld = this.toString(m, RDFFormat.JSONLD_FRAME_FLAT, jenaCtx);
        m2 = this.parse(jsonld);
        TestJsonLDWriter.assertTrue((m2.listStatements((Resource)null, RDF.type, (RDFNode)null).toList().size() == 1 ? 1 : 0) != 0);
        TestJsonLDWriter.assertTrue((m2.listStatements((Resource)null, m.createProperty(ns + "jobTitle"), (RDFNode)null).toList().size() == 1 ? 1 : 0) != 0);
        TestJsonLDWriter.assertFalse((boolean)jsonld.trim().contains("\n"));
    }

    @Test
    public final void testStringPropsInContext() {
        Model m = ModelFactory.createDefaultModel();
        String ns = "http://www.a.com/foo/";
        Resource s = m.createResource(ns + "s");
        m.add(s, m.createProperty(ns + "plangstring"), "a langstring", "fr");
        m.add(s, m.createProperty(ns + "pint"), (RDFNode)m.createTypedLiteral(42));
        m.add(s, m.createProperty(ns + "pfloat"), (RDFNode)m.createTypedLiteral(1789.14f));
        m.add(s, m.createProperty(ns + "pstring"), (RDFNode)m.createTypedLiteral("a TypedLiteral atring"));
        String jsonld = this.toString(m, RDFFormat.JSONLD_FLAT, null);
        String vv = "\"plangstring\":{\"@language\":\"fr\",\"@value\":\"a langstring\"}";
        TestJsonLDWriter.assertTrue((boolean)jsonld.contains(vv));
    }

    @Test
    public final void clashOfPropLocalnames() {
        Model m = ModelFactory.createDefaultModel();
        Resource s = m.createResource();
        String ns1 = "http://schema.org/";
        String ns2 = "http://ex.com/";
        m.add(s, m.createProperty(ns1 + "name"), "schema.org name");
        m.add(s, m.createProperty(ns2 + "name"), "ex.com name");
        String jsonld = this.toString(m, RDFFormat.JSONLD, null);
        TestJsonLDWriter.assertTrue((boolean)jsonld.contains("\"name\" : \""));
        TestJsonLDWriter.assertTrue((boolean)jsonld.contains("/name\" : \""));
        m.setNsPrefix("ns1", ns1);
        m.setNsPrefix("ns2", "http://ex.com/");
        jsonld = this.toString(m, RDFFormat.JSONLD, null);
        TestJsonLDWriter.assertTrue((boolean)jsonld.contains("\"name\" : \""));
        TestJsonLDWriter.assertTrue((jsonld.contains("\"ns1:name\" : \"") || jsonld.contains("\"ns2:name\" : \"") ? 1 : 0) != 0);
    }

    @Test
    public final void jsonldOptions() {
        Model m = ModelFactory.createDefaultModel();
        String ns = "http://schema.org/";
        Resource s = m.createResource();
        m.add(s, m.createProperty(ns + "name"), "Jane Doe");
        m.add(s, m.createProperty(ns + "url"), "http://www.janedoe.com");
        m.add(s, m.createProperty(ns + "jobTitle"), "Professor");
        String jsonld = this.toString(m, RDFFormat.JSONLD, null);
        TestJsonLDWriter.assertFalse((boolean)jsonld.contains("@graph"));
        TestJsonLDWriter.assertTrue((boolean)jsonld.contains("\"jobTitle\" : \"Professor\""));
        JsonLDWriteContext jenaCtx = new JsonLDWriteContext();
        JsonLdOptions opts = new JsonLdOptions(null);
        opts.setCompactArrays(Boolean.valueOf(false));
        jenaCtx.setOptions(opts);
        jsonld = this.toString(m, RDFFormat.JSONLD, (Context)jenaCtx);
        TestJsonLDWriter.assertTrue((boolean)jsonld.contains("@graph"));
        TestJsonLDWriter.assertTrue((boolean)jsonld.contains("\"jobTitle\" : [ \"Professor\" ]"));
    }

    @Test
    public final void atVocab() throws JsonParseException, JsonLdError, IOException {
        Model m = ModelFactory.createDefaultModel();
        String ns = "http://schema.org/";
        Resource person = m.createResource(ns + "Person");
        Resource s = m.createResource("http://doe.com/jane");
        m.add(s, m.createProperty(ns + "name"), "Jane Doe");
        m.add(s, RDF.type, (RDFNode)person);
        Resource s2 = m.createResource("http://doe.com/joe");
        m.add(s2, m.createProperty(ns + "name"), "John Doe");
        m.add(s2, RDF.type, (RDFNode)person);
        m.add(s, m.createProperty(ns + "knows"), (RDFNode)s2);
        m.setNsPrefix("", ns);
        String jsonld = this.toString(m, RDFFormat.JSONLD, null);
        TestJsonLDWriter.assertTrue((boolean)jsonld.contains("@vocab"));
    }

    @Test
    public final void atVocabJENA1292() throws JsonParseException, JsonLdError, IOException {
        Model m = ModelFactory.createDefaultModel();
        String ns = "http://schema.org/";
        Resource person = m.createResource(ns + "Person");
        Resource s = m.createResource();
        m.add(s, m.createProperty(ns + "name"), "Jane Doe");
        m.add(s, m.createProperty(ns + "url"), "http://www.janedoe.com");
        m.add(s, m.createProperty(ns + "jobTitle"), "Professor");
        m.add(s, FOAF.nick, "jd");
        m.add(s, RDF.type, (RDFNode)person);
        m.setNsPrefix("", ns);
        DatasetGraph g = DatasetFactory.wrap((Model)m).asDatasetGraph();
        PrefixMap pm = RiotLib.prefixMap((DatasetGraph)g);
        String base = null;
        Context jenaContext = null;
        Map map = (Map)JsonLDWriter.toJsonLDJavaAPI((RDFFormat.JSONLDVariant)((RDFFormat.JSONLDVariant)RDFFormat.JSONLD.getVariant()), (DatasetGraph)g, (PrefixMap)pm, base, jenaContext);
        Map ctx = (Map)map.get("@context");
        ArrayList remove = new ArrayList();
        for (Map.Entry e : ctx.entrySet()) {
            Object o = e.getValue();
            if (o instanceof Map) {
                o = ((Map)o).get("@id");
            }
            if (o == null || !(o instanceof String) || !((String)o).equals(ns + (String)e.getKey())) continue;
            remove.add(e.getKey());
        }
        for (String key : remove) {
            ctx.remove(key);
        }
        ctx.put("@vocab", "http://schema.org/");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String toString(Model m, RDFFormat f, Context jenaContext) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            RDFWriter.create().source(m).format(f).context(jenaContext).output((OutputStream)out);
            out.flush();
            String string = out.toString("UTF-8");
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Model parse(String jsonld) {
        Model m = ModelFactory.createDefaultModel();
        StringReader reader = new StringReader(jsonld);
        m.read((Reader)reader, null, "JSON-LD");
        return m;
    }
}

