/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.junit.Assert;
import org.junit.Test;

public class TestTurtleWriter {
    static String cycle1 = "_:a <urn:p> _:b . _:b <urn:q> _:a .";
    static String cycle2 = "_:a <urn:p> _:b . _:b <urn:q> _:a . _:a <urn:r> \"abc\" . ";

    static void blankNodeLang(String testdata, RDFFormat lang) {
        StringReader r = new StringReader(testdata);
        Model m = ModelFactory.createDefaultModel();
        RDFDataMgr.read((Model)m, (StringReader)r, null, (Lang)RDFLanguages.NTRIPLES);
        Assert.assertTrue((m.size() > 0L ? 1 : 0) != 0);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        RDFDataMgr.write((OutputStream)output, (Model)m, (RDFFormat)lang);
        ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
        Model m2 = ModelFactory.createDefaultModel();
        RDFDataMgr.read((Model)m2, (InputStream)input, (Lang)lang.getLang());
        Assert.assertTrue((m2.size() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)m.isIsomorphicWith(m2));
    }

    @Test
    public void bnode_cycles_01() {
        TestTurtleWriter.blankNodeLang(cycle1, RDFFormat.TURTLE);
    }

    @Test
    public void bnode_cycles_02() {
        TestTurtleWriter.blankNodeLang(cycle1, RDFFormat.TURTLE_BLOCKS);
    }

    @Test
    public void bnode_cycles_03() {
        TestTurtleWriter.blankNodeLang(cycle1, RDFFormat.TURTLE_FLAT);
    }

    @Test
    public void bnode_cycles_04() {
        TestTurtleWriter.blankNodeLang(cycle1, RDFFormat.TURTLE_PRETTY);
    }

    @Test
    public void bnode_cycles_05() {
        TestTurtleWriter.blankNodeLang(cycle2, RDFFormat.TURTLE);
    }

    @Test
    public void bnode_cycles_06() {
        TestTurtleWriter.blankNodeLang(cycle2, RDFFormat.TURTLE_BLOCKS);
    }

    @Test
    public void bnode_cycles_07() {
        TestTurtleWriter.blankNodeLang(cycle2, RDFFormat.TURTLE_FLAT);
    }

    @Test
    public void bnode_cycles_08() {
        TestTurtleWriter.blankNodeLang(cycle2, RDFFormat.TURTLE_PRETTY);
    }

    @Test
    public void bnode_cycles() {
        Model m = RDFDataMgr.loadModel((String)"testing/DAWG-Final/construct/data-ident.ttl");
        Assert.assertTrue((m.size() > 0L ? 1 : 0) != 0);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        RDFDataMgr.write((OutputStream)output, (Model)m, (Lang)Lang.TURTLE);
        ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
        Model m2 = ModelFactory.createDefaultModel();
        RDFDataMgr.read((Model)m2, (InputStream)input, (Lang)Lang.TURTLE);
        Assert.assertTrue((m2.size() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)m.isIsomorphicWith(m2));
    }
}

