/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra;

import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.engine.main.JoinClassifier;
import org.apache.jena.sparql.engine.main.LeftJoinClassifier;
import org.apache.jena.sparql.syntax.Element;
import org.junit.Test;

public class TestClassify
extends BaseTest {
    @Test
    public void testClassify_Join_01() {
        TestClassify.classifyJ("{?s :p :o . { ?s :p :o FILTER(true) } }", true);
    }

    @Test
    public void testClassify_Join_02() {
        TestClassify.classifyJ("{?s :p :o . { ?s :p :o FILTER(?s) } }", true);
    }

    @Test
    public void testClassify_Join_03() {
        TestClassify.classifyJ("{?s :p :o . { ?s :p ?o FILTER(?o) } }", true);
    }

    @Test
    public void testClassify_Join_04() {
        TestClassify.classifyJ("{?s :p :o . { ?s :p :o FILTER(?o) } }", true);
    }

    @Test
    public void testClassify_Join_05() {
        TestClassify.classifyJ("{?s :p :o . { ?x :p :o FILTER(?s) } }", false);
    }

    @Test
    public void testClassify_Join_06() {
        TestClassify.classifyJ("{ { ?s :p :o FILTER(true) } ?s :p :o }", true);
    }

    @Test
    public void testClassify_Join_07() {
        TestClassify.classifyJ("{ { ?s :p :o FILTER(?s) }   ?s :p :o }", true);
    }

    @Test
    public void testClassify_Join_08() {
        TestClassify.classifyJ("{ { ?s :p ?o FILTER(?o) }   ?s :p :o }", true);
    }

    @Test
    public void testClassify_Join_09() {
        TestClassify.classifyJ("{ { ?s :p :o FILTER(?o) }   ?s :p :o }", true);
    }

    @Test
    public void testClassify_Join_10() {
        TestClassify.classifyJ("{ { ?x :p :o FILTER(?s) }   ?s :p :o }", true);
    }

    @Test
    public void testClassify_Join_11() {
        TestClassify.classifyJ("{?s :p :o . { OPTIONAL { ?s :p :o } } }", false);
    }

    @Test
    public void testClassify_Join_12() {
        TestClassify.classifyJ("{?s :p :o . { OPTIONAL { ?s :p :o FILTER(?s) } } }", false);
    }

    @Test
    public void testClassify_Join_13() {
        TestClassify.classifyJ("{?s :p :o . { ?x :p :o OPTIONAL { :s :p :o FILTER(?x) } } }", true);
    }

    @Test
    public void testClassify_Join_14() {
        TestClassify.classifyJ("{?s :p :o . { OPTIONAL { :s :p :o FILTER(?o) } } }", true);
    }

    @Test
    public void testClassify_Join_14a() {
        TestClassify.classifyJ("{?s :p :o . { OPTIONAL { :s :p ?o FILTER(?o) } } }", true);
    }

    @Test
    public void testClassify_Join_14b() {
        TestClassify.classifyJ("{?s :p ?o . { OPTIONAL { :s :p :o FILTER(?o) } } }", false);
    }

    @Test
    public void testClassify_Join_15() {
        TestClassify.classifyJ("{?s :p :o . { OPTIONAL { ?x :p :o FILTER(?s) } } }", false);
    }

    @Test
    public void testClassify_Join_20() {
        TestClassify.classifyJ("{ {?s :p ?x } . { {} OPTIONAL { :s :p ?x } } }", false);
    }

    @Test
    public void testClassify_Join_21() {
        TestClassify.classifyJ("{ { {} OPTIONAL { :s :p ?x } } {?s :p ?x } }", true);
    }

    @Test
    public void testClassify_Join_31() {
        TestClassify.classifyJ("{ ?x ?y ?z {SELECT ?s { ?s ?p ?o} } }", true);
    }

    @Test
    public void testClassify_Join_32() {
        TestClassify.classifyJ("{ GRAPH ?g { ?x ?y ?z } { FILTER (?a) } }", true);
    }

    @Test
    public void testClassify_Join_33() {
        TestClassify.classifyJ("{ GRAPH ?g { ?x ?y ?z } { FILTER (?z) } }", false);
    }

    @Test
    public void testClassify_Join_34() {
        TestClassify.classifyJ("{ GRAPH ?g { ?x ?y ?z } { ?a ?b ?z FILTER (?z) } }", true);
    }

    @Test
    public void testClassify_Join_35() {
        TestClassify.classifyJ("{ GRAPH ?g { ?x ?y ?z } { OPTIONAL{?a ?b ?z} FILTER (?z) } }", false);
    }

    @Test
    public void testClassify_Join_41() {
        TestClassify.classifyJ("{ ?x ?y ?z { ?x1 ?y1 ?z1 BIND(?z+2 AS ?A) } UNION { ?x1 ?y1 ?z1 }}", false);
    }

    @Test
    public void testClassify_Join_42() {
        TestClassify.classifyJ("{ ?x ?y ?z { BIND(?z+2 AS ?A) } UNION { BIND(?z+2 AS ?B) }}", false);
    }

    @Test
    public void testClassify_Join_43() {
        TestClassify.classifyJ("{ ?x ?y ?z { LET(?A := ?z+2) } UNION { }}", false);
    }

    @Test
    public void testClassify_Join_44() {
        TestClassify.classifyJ("{ BIND(<x> AS ?typeX) { BIND(?typeX AS ?type) } }", false);
    }

    @Test
    public void testClassify_Join_45() {
        TestClassify.classifyJ("{ BIND(<x> AS ?typeX) { BIND(?typeX AS ?type) ?s ?p ?o FILTER(?o=?type) } }", false);
    }

    @Test
    public void testClassify_Join_50() {
        TestClassify.classifyJ("{ ?x ?y ?z { ?x1 ?y1 ?z1 MINUS { ?a ?b ?c } } UNION {} }", false);
    }

    @Test
    public void testClassify_Join_51() {
        String x1 = "{ ?s ?p ?o   GRAPH ?g { ?s1 ?p ?o1 FILTER EXISTS {  [] ?p ?unique } }  }";
        TestClassify.classifyJ(x1, true);
    }

    @Test
    public void testClassify_Join_52() {
        String x1 = "{ ?s  ?p  ?V0 GRAPH ?g { ?s1  ?p  ?o1 FILTER EXISTS { _:b0  ?p  ?V1 } } }";
        TestClassify.classifyJ(x1, true);
    }

    @Test
    public void testClassify_Join_53() {
        String x1 = "{ ?s  ?p  ?V GRAPH ?g { ?s1  ?p  ?o1 FILTER EXISTS { _:b0  ?p  ?V } } }";
        TestClassify.classifyJ(x1, false);
    }

    public static void classifyJ(String pattern, boolean expected) {
        boolean nonLinear;
        String qs1 = "PREFIX : <http://example/>\n";
        String qs = qs1 + "SELECT * " + pattern;
        Query query = QueryFactory.create((String)qs, (Syntax)Syntax.syntaxARQ);
        Op op = Algebra.compile((Element)query.getQueryPattern());
        if (!(op instanceof OpJoin)) {
            TestClassify.fail((String)("Not a join: " + pattern));
        }
        if ((nonLinear = JoinClassifier.isLinear((OpJoin)((OpJoin)op))) != expected) {
            System.out.println(query);
            System.out.println(op);
        }
        TestClassify.assertEquals((String)("Join: " + pattern), (Object)expected, (Object)nonLinear);
    }

    @Test
    public void testClassify_LeftJoin_01() {
        this.classifyLJ("{ ?s ?p ?o OPTIONAL { ?s1 ?p2 ?x} }", true);
    }

    @Test
    public void testClassify_LeftJoin_02() {
        this.classifyLJ("{ ?s ?p ?o OPTIONAL { ?s1 ?p2 ?o3 OPTIONAL { ?s1 ?p2 ?x} } }", true);
    }

    @Test
    public void testClassify_LeftJoin_03() {
        this.classifyLJ("{ ?s ?p ?x OPTIONAL { ?s1 ?p2 ?o3 OPTIONAL { ?s1 :p ?o3} } }", true);
    }

    @Test
    public void testClassify_LeftJoin_04() {
        this.classifyLJ("{ ?s ?p ?x OPTIONAL { ?s1 ?p2 ?o3 OPTIONAL { ?s1 :p ?x} } }", false);
    }

    @Test
    public void testClassify_LeftJoin_05() {
        this.classifyLJ("{ ?s ?p ?x OPTIONAL { ?s ?p ?x OPTIONAL { ?s ?p ?x } } }", true);
    }

    @Test
    public void testClassify_LeftJoin_06() {
        this.classifyLJ("{ ?s ?p ?x OPTIONAL { { ?s ?p ?o FILTER(?x) } } }", false);
    }

    @Test
    public void testClassify_LeftJoin_07() {
        this.classifyLJ("{ ?s ?p ?x OPTIONAL { ?s ?p ?x1 OPTIONAL { ?s ?p ?x2 FILTER(?x) } } }", false);
    }

    @Test
    public void testClassify_LeftJoin_10() {
        this.classifyLJ("{ ?s ?p ?x OPTIONAL { SELECT ?s { ?s ?p ?o } } }", false);
    }

    @Test
    public void testClassify_LeftJoin_11() {
        this.classifyLJ("{ ?s ?p ?x OPTIONAL { ?s1 ?p2 ?x . BIND(?x AS ?test) } }", true);
    }

    @Test
    public void testClassify_LeftJoin_12() {
        this.classifyLJ("{ ?s ?p ?x OPTIONAL { ?s1 ?p2 ?x . BIND(?s AS ?test) } }", false);
    }

    @Test
    public void testClassify_LeftJoin_13() {
        this.classifyLJ("{ ?s ?p ?x OPTIONAL { ?s1 ?p2 ?x . BIND(CONCAT(?s, ?x) AS ?test) } }", false);
    }

    @Test
    public void testClassify_LeftJoin_14() {
        this.classifyLJ("{ ?s ?p ?x OPTIONAL { ?s1 ?p2 ?x . BIND(CONCAT(?s1, ?p1, ?p2, ?x) AS ?test) } }", false);
    }

    @Test
    public void testClassify_LeftJoin_15() {
        this.classifyLJ("{ ?s ?p ?x OPTIONAL { BIND(?x AS ?test) OPTIONAL { ?x ?p1 ?o1 } } }", false);
    }

    private void classifyLJ(String pattern, boolean expected) {
        String qs1 = "PREFIX : <http://example/>\n";
        String qs = qs1 + "SELECT * " + pattern;
        Query query = QueryFactory.create((String)qs, (Syntax)Syntax.syntaxARQ);
        Op op = Algebra.compile((Element)query.getQueryPattern());
        if (!(op instanceof OpLeftJoin)) {
            TestClassify.fail((String)("Not a leftjoin: " + pattern));
        }
        boolean nonLinear = LeftJoinClassifier.isLinear((OpLeftJoin)((OpLeftJoin)op));
        TestClassify.assertEquals((String)("LeftJoin: " + pattern), (Object)expected, (Object)nonLinear);
    }
}

