/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.optimize;

import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.optimize.TransformEliminateAssignments;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;
import org.junit.Test;

public class TestTransformEliminateAssignments {
    private void test(String input, String ... output) {
        this.test(input, false, output);
    }

    private void test(String input, boolean aggressive, String ... output) {
        Op original = SSE.parseOp((String)input);
        this.test(original, aggressive, output);
    }

    private void test(Op original, boolean aggressive, String ... output) {
        Op actual = TransformEliminateAssignments.eliminate((Op)original, (boolean)aggressive);
        if (output == null) {
            Assert.assertEquals((Object)original, (Object)actual);
        } else {
            Op expected = SSE.parseOp((String)StrUtils.strjoinNL((String[])output));
            Assert.assertEquals((Object)expected, (Object)actual);
        }
    }

    private void testNoChange(String ... input) {
        this.testNoChange(false, input);
    }

    private void testNoChangeAggressive(String ... input) {
        this.testNoChange(true, input);
    }

    private void testNoChange(boolean aggressive, String ... input) {
        this.test(StrUtils.strjoinNL((String[])input), aggressive, (String[])null);
    }

    @Test
    public void unused_01() {
        this.test(StrUtils.strjoinNL((String[])new String[]{"(project (?y)", "  (extend (?x true)", "    (table unit)))"}), "(project (?y)", "  (table unit))");
    }

    @Test
    public void unused_02() {
        this.test(StrUtils.strjoinNL((String[])new String[]{"(project (?y)", "  (extend ((?x true) (?y false))", "    (table unit)))"}), "(project (?y)", "  (extend (?y false)", "    (table unit)))");
    }

    @Test
    public void filter_01() {
        this.test(StrUtils.strjoinNL((String[])new String[]{"(project (?y)", "  (filter (exprlist ?x)", "    (extend (?x true)", "      (table unit))))"}), "(project (?y)", "  (filter (exprlist true)", "    (table unit)))");
    }

    @Test
    public void filter_02() {
        this.test(StrUtils.strjoinNL((String[])new String[]{"(project (?z)", "  (filter (exprlist ?x)", "    (extend ((?x true) (?y false))", "      (table unit))))"}), "(project (?z)", "  (filter (exprlist true)", "    (table unit)))");
    }

    @Test
    public void extend_01() {
        this.test(StrUtils.strjoinNL((String[])new String[]{"(project (?y)", "  (extend ((?x true) (?y ?x))", "    (table unit)))"}), "(project (?y)", "  (extend (?y true)", "    (table unit)))");
    }

    @Test
    public void extend_02() {
        this.test(StrUtils.strjoinNL((String[])new String[]{"(project (?z)", "  (extend ((?x true) (?y ?x) (?z ?y))", "    (table unit)))"}), "(project (?z)", "  (extend (?z true)", "    (table unit)))");
    }

    @Test
    public void extend_03() {
        this.test(StrUtils.strjoinNL((String[])new String[]{"(project (?z)", "  (extend ((?a true) (?b ?a) (?c false) (?d ?c) (?z (|| ?b ?d)))", "    (table unit)))"}), "(project (?z)", "  (extend (?z (|| true false))", "    (table unit)))");
    }

    @Test
    public void orderby_01() {
        this.test(StrUtils.strjoinNL((String[])new String[]{"(project (?y)", "  (order (?x)", "    (extend (?x true)", "      (table unit))))"}), "(project (?y)", "  (order (true)", "    (table unit)))");
    }

    @Test
    public void orderby_02() {
        this.testNoChange(StrUtils.strjoinNL((String[])new String[]{"(project (?y)", "  (order (?x)", "    (extend (?x (contains 'foo' 'bar'))", "      (table unit))))"}));
    }

    @Test
    public void orderby_03() {
        this.test(StrUtils.strjoinNL((String[])new String[]{"(project (?y)", "  (order (?x)", "    (extend (?x (contains 'foo' 'bar'))", "      (table unit))))"}), true, "(project (?y)", "  (order ((contains 'foo' 'bar'))", "    (table unit)))");
    }

    @Test
    public void filter_unstable_01() {
        this.testNoChange(StrUtils.strjoinNL((String[])new String[]{"(project (?y)", "  (filter (exprlist ?x)", "    (extend (?x (rand))", "      (table unit))))"}));
    }

    @Test
    public void filter_unstable_02() {
        this.testNoChange(StrUtils.strjoinNL((String[])new String[]{"(project (?y)", "  (filter (exprlist ?x)", "    (extend (?x (uuid))", "      (table unit))))"}));
    }

    @Test
    public void filter_unstable_03() {
        this.testNoChange(StrUtils.strjoinNL((String[])new String[]{"(project (?y)", "  (filter (exprlist ?x)", "    (extend (?x (struuid))", "      (table unit))))"}));
    }

    @Test
    public void filter_unstable_04() {
        this.testNoChange(StrUtils.strjoinNL((String[])new String[]{"(project (?y)", "  (filter (exprlist ?x)", "    (extend (?x (bnode))", "      (table unit))))"}));
    }

    @Test
    public void orderby_unstable_01() {
        this.testNoChangeAggressive(StrUtils.strjoinNL((String[])new String[]{"(project (?y)", "  (order (?x)", "    (extend (?x (rand))", "      (table unit))))"}));
    }

    @Test
    public void orderby_unstable_02() {
        this.testNoChangeAggressive(StrUtils.strjoinNL((String[])new String[]{"(project (?y)", "  (order (?x)", "    (extend (?x (uuid))", "      (table unit))))"}));
    }

    @Test
    public void orderby_unstable_03() {
        this.testNoChangeAggressive(StrUtils.strjoinNL((String[])new String[]{"(project (?y)", "  (order (?x)", "    (extend (?x (struuid))", "      (table unit))))"}));
    }

    @Test
    public void orderby_unstable_04() {
        this.testNoChangeAggressive(StrUtils.strjoinNL((String[])new String[]{"(project (?y)", "  (order (?x)", "    (extend (?x (bnode))", "      (table unit))))"}));
    }

    @Test
    public void ineligible_01() {
        this.testNoChange("(filter (exprlist ?x)", "  (extend (?x true)", "    (table unit)))");
    }

    @Test
    public void ineligible_02() {
        this.testNoChange("(filter (exprlist ?x)", "  (extend ((?x true) (?y false))", "    (table unit)))");
    }

    @Test
    public void ineligible_03() {
        this.testNoChange("(project (?y)", "  (filter (> (* ?x ?x) 16)", "    (extend (?x 3)", "      (table unit))))");
    }

    @Test
    public void ineligible_04() {
        this.testNoChange("(project (?y)", "  (filter (exprlist ?x)", "    (join", "      (extend (?x true)", "        (table unit))", "      (bgp (triple ?x ?y ?z)))))");
    }

    @Test
    public void ineligible_05() {
        this.testNoChange("(project (?s)", "  (filter (exprlist ?x)", "    (union", "      (bgp (triple ?s ?p ?o))", "      (extend (?x true)", "        (table unit)))))");
    }

    @Test
    public void ineligible_06() {
        this.testNoChange("(project (?s)", "  (filter (exprlist ?x)", "    (leftjoin", "      (bgp (triple ?s ?p ?o))", "      (extend (?x true)", "        (table unit)))))");
    }

    @Test
    public void ineligible_07() {
        this.testNoChange("(project (?s)", "  (filter (exprlist ?x)", "    (minus", "      (bgp (triple ?s ?p ?o))", "      (extend (?x true)", "        (table unit)))))");
    }

    @Test
    public void ineligible_08() {
        this.testNoChange("(project (?s)", "  (filter (exprlist ?x)", "    (join", "      (bgp (triple ?s ?p ?o))", "      (extend (?x true)", "        (table unit)))))");
    }

    @Test
    public void ineligible_09() {
        this.testNoChange("(project (?x ?y)", "  (filter (exprlist ?x)", "    (extend (?x true)", "      (bgp (triple ?y <urn:pred> <urn:obj>)))))");
    }

    @Test
    public void ineligible_12() {
        this.testNoChange("(project (?y)", "  (filter (exprlist ?x)", "    (distinct", "      (extend (?x true)", "        (bgp (triple ?s ?p ?o))))))");
    }

    @Test
    public void ineligible_13() {
        this.testNoChange("(project (?y)", "  (filter (exprlist ?x)", "    (reduced", "      (extend (?x true)", "        (bgp (triple ?s ?p ?o))))))");
    }

    @Test
    public void exists_01() {
        this.testNoChange("(project (?y)", "  (filter (exists", "            (filter  ?x (table unit)))", "    (extend (?x true)", "      (table unit))))");
    }

    @Test
    public void exists_02() {
        this.test(StrUtils.strjoinNL((String[])new String[]{"(project (?y)", "  (filter (exists", "            (filter ?z", "              (table unit)))", "    (extend (?x true)", "      (table unit))))"}), "(project (?y)", "  (filter (exprlist (exists", "                      (filter (exprlist ?z)", "                        (table unit))))", "    (table unit)))");
    }

    @Test
    public void exists_03() {
        this.test(StrUtils.strjoinNL((String[])new String[]{"(project (?y)", "  (filter (exists ", "            (filter ?x", "              (extend (?x true)", "                 (table unit))))", "    (table unit)))"}), "(project (?y)", "  (filter (exists (filter true (table unit)))", "     (table unit)", "))");
    }

    @Test
    public void exists_04() {
        this.test(StrUtils.strjoinNL((String[])new String[]{"(project (?y)", "  (filter (exprlist (exists", "                      (project (?y)", "                        (filter (exprlist ?x)", "                          (extend (?x true)", "                            (table unit))))))", "    (table unit)))"}), "(project (?y)", "  (filter (exprlist (exists", "                      (project (?y)", "                        (filter (exprlist true)", "                          (table unit)))))", "    (table unit)))");
    }

    @Test
    public void through_project_01() {
        this.test(StrUtils.strjoinNL((String[])new String[]{"(project (?y)", "  (filter (exprlist ?x)", "    (project (?x)", "      (extend (?x true)", "        (table unit)))))"}), "(project (?y)", "  (filter true", "    (project ()", "      (table unit))))");
    }

    @Test
    public void through_project_02() {
        this.test(StrUtils.strjoinNL((String[])new String[]{"(project (?y)", "  (filter (exprlist ?x)", "    (project (?x ?y)", "      (extend (?x true)", "        (bgp (triple ?y <urn:pred> <urn:obj>))))))"}), "(project (?y)", "  (filter true", "    (project (?y)", "      (bgp (triple ?y <urn:pred> <urn:obj>)))))");
    }

    @Test
    public void through_project_03() {
        this.test(StrUtils.strjoinNL((String[])new String[]{"(project (?y)", "  (filter (exprlist ?x)", "    (project (?y)", "      (extend (?x true)", "        (table unit)))))"}), "(project (?y)", "  (filter (exprlist ?x)", "    (project (?y)", "      (table unit))))");
    }

    @Test
    public void through_project_04() {
        this.testNoChange("(project (?y)", "  (project (?x ?y)", "    (filter (exprlist ?x)", "      (extend (?x true)", "        (bgp (triple ?y <urn:pred> <urn:obj>))))))");
    }

    @Test
    public void no_merge_01() {
        this.testNoChange("(project (?x ?y)", "  (filter (exprlist ?x)", "    (extend (?x true)", "      (extend (?y false)", "        (table unit)))))");
    }

    @Test
    public void scope_01() {
        this.testNoChange(StrUtils.strjoinNL((String[])new String[]{"(filter (exprlist ?x)", "  (project (?x ?y)", "    (extend (?x true)", "      (table unit))))"}));
    }

    @Test
    public void scope_02() {
        this.test(StrUtils.strjoinNL((String[])new String[]{"(filter (exprlist ?x)", "  (project (?y)", "    (extend (?x true)", "      (table unit))))"}), "(filter (exprlist ?x)", "  (project (?y)", "    (table unit)))");
    }

    @Test
    public void scope_03() {
        this.test(StrUtils.strjoinNL((String[])new String[]{"(filter (exprlist ?x)", "  (project (?y)", "    (filter (exprlist ?x)", "      (extend (?x true)", "        (table unit)))))"}), "(filter (exprlist ?x)", "  (project (?y)", "    (filter (exprlist true)", "      (table unit))))");
    }

    @Test
    public void scope_04() {
        this.test(StrUtils.strjoinNL((String[])new String[]{"(project (?y)", "  (filter (exprlist ?x)", "    (extend (?x true)", "      (project (?z)", "         (filter (exprlist (|| ?x (! ?x)))", "           (extend (?x false)", "             (table unit)))))))"}), "(project (?y)", "  (filter (exprlist true)", "    (project (?z)", "      (filter (exprlist (|| ?x (! ?x)))", "        (extend (?x false)", "          (table unit))))))");
    }

    @Test
    public void scope_05() {
        this.testNoChange("(project (?y)", "  (filter (exprlist ?x)", "    (extend (?x true)", "      (project (?x)", "         (filter (exprlist (|| ?x (! ?x)))", "           (extend (?x false)", "             (table unit)))))))");
    }

    @Test
    public void scope_06() {
        this.test(StrUtils.strjoinNL((String[])new String[]{"(project (?y)", "  (filter (exprlist ?x)", "    (extend (?x true)", "      (project (?z)", "         (project (?x)", "           (filter (exprlist (|| ?x (! ?x)))", "             (extend (?x false)", "               (table unit))))))))"}), "(project (?y)", "  (filter (exprlist true)", "    (project (?z)", "       (project (?x)", "         (filter (exprlist (|| ?x (! ?x)))", "           (extend (?x false)", "             (table unit)))))))");
    }
}

