/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.optimize;

import java.util.Objects;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.optimize.TransformFilterPlacement;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropertyFunction;
import org.apache.jena.sparql.pfunction.PropertyFunctionRegistry;
import org.apache.jena.sparql.procedure.Procedure;
import org.apache.jena.sparql.procedure.ProcedureBase;
import org.apache.jena.sparql.procedure.ProcedureRegistry;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;
import org.junit.Test;

public class TestTransformFilterPlacement
extends BaseTest {
    private static String propertyFunctionURI = "http://example/PF";
    private static PropertyFunction dummyPropertyFunction = new PropertyFunction(){

        public QueryIterator exec(QueryIterator input, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
            return null;
        }

        public void build(PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        }
    };
    private static String procedureURI = "http://example/PROC";
    private static Procedure dummyProcedure = new ProcedureBase(){

        public QueryIterator exec(Binding binding, Node name, ExprList args, ExecutionContext execCxt) {
            return null;
        }
    };

    @Test
    public void place_bgp_01() {
        TestTransformFilterPlacement.test("(filter (= ?x 1) (bgp ( ?s ?p ?x)))", "(filter (= ?x 1) (bgp ( ?s ?p ?x)))");
    }

    @Test
    public void place_bgp_02() {
        TestTransformFilterPlacement.test("(filter (= ?x 1) (bgp (?s ?p ?x) (?s1 ?p1 ?x1) ))", "(sequence (filter (= ?x 1) (bgp ( ?s ?p ?x))) (bgp (?s1 ?p1 ?x1)))");
    }

    @Test
    public void place_bgp_03() {
        TestTransformFilterPlacement.test("(filter (= ?x 1) (bgp (?s ?p ?x) (?s1 ?p1 ?x) ))", "(sequence (filter (= ?x 1) (bgp ( ?s ?p ?x))) (bgp (?s1 ?p1 ?x)))");
    }

    @Test
    public void place_bgp_03a() {
        TestTransformFilterPlacement.testNoBGP("(filter (= ?x 1) (bgp (?s ?p ?x) (?s1 ?p1 ?x) ))", null);
    }

    @Test
    public void place_bgp_04() {
        TestTransformFilterPlacement.test("(filter (= ?XX 1) (bgp (?s ?p ?x) (?s1 ?p1 ?XX) ))", "(filter (= ?XX 1) (bgp (?s ?p ?x) (?s1 ?p1 ?XX) ))");
    }

    @Test
    public void place_bgp_05() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (bgp (?s ?p ?x) (?s ?p ?x1) (?s ?p ?x2)) )", "(sequence (filter (= ?x 123) (bgp (?s ?p ?x))) (bgp (?s ?p ?x1) (?s ?p ?x2)) )");
    }

    @Test
    public void place_bgp_05a() {
        TestTransformFilterPlacement.testNoBGP("(filter (= ?x 123) (bgp (?s ?p ?x) (?s ?p ?x1) (?s ?p ?x2)) )", null);
    }

    @Test
    public void place_bgp_06() {
        TestTransformFilterPlacement.testNoChange("(filter (isURI ?g) (quadpattern (?g ?s ?p ?o) ))");
    }

    @Test
    public void place_bgp_06a() {
        TestTransformFilterPlacement.testNoBGP("(filter (isURI ?g) (quadpattern (?g ?s ?p ?o) ))", null);
    }

    @Test
    public void place_bgp_07() {
        TestTransformFilterPlacement.test("(filter (isURI ?g) (quadpattern (?g ?s ?p ?o1) (?g ?s ?p ?o2) ))", "(sequence  (filter (isURI ?g) (quadpattern (?g ?s ?p ?o1) ))  (quadpattern (?g ?s ?p ?o2)) )");
    }

    @Test
    public void place_bgp_07a() {
        TestTransformFilterPlacement.testNoBGP("(filter (isURI ?g) (quadpattern (?g ?s ?p ?o1) (?g ?s ?p ?o2) ))", null);
    }

    @Test
    public void place_bgp_08() {
        TestTransformFilterPlacement.test("(filter (exprlist (isURI ?g) (= ?o2 123)) (quadpattern (?g ?s ?p ?o1) (?g ?s ?p ?o2) (?g ?s ?p ?o3) ))", "(sequence (filter (= ?o2 123) (sequence (filter (isURI ?g) (quadpattern (?g ?s ?p ?o1))) (quadpattern (?g ?s ?p ?o2)))) (quadpattern (?g ?s ?p ?o3)) )");
    }

    @Test
    public void place_bgp_08a() {
        TestTransformFilterPlacement.testNoBGP("(filter (exprlist (isURI ?g) (= ?o2 123)) (quadpattern (?g ?s ?p ?o1) (?g ?s ?p ?o2) (?g ?s ?p ?o3) ))", null);
    }

    @Test
    public void place_bgp_50() {
        TestTransformFilterPlacement.test(StrUtils.strjoinNL((String[])new String[]{"(filter (exprlist (|| (|| (|| (&& (< \"2012-01-01T00:00:00\"^^<http://www.w3.org/2001/XMLSchema#dateTime> ?startDate1) (< ?endDate1 \"2012-12-31T23:59:59\"^^<http://www.w3.org/2001/XMLSchema#dateTime>)) (&& (< ?startDate1 \"2012-01-01T00:00:00\"^^<http://www.w3.org/2001/XMLSchema#dateTime>) (< \"2012-12-31T23:59:59\"^^<http://www.w3.org/2001/XMLSchema#dateTime> ?endDate1))) (&& (&& (<= ?startDate1 \"2012-01-01T00:00:00\"^^<http://www.w3.org/2001/XMLSchema#dateTime>) (<= ?endDate1 \"2012-12-31T23:59:59\"^^<http://www.w3.org/2001/XMLSchema#dateTime>)) (<= \"2012-01-01T00:00:00\"^^<http://www.w3.org/2001/XMLSchema#dateTime> ?endDate1))) (&& (&& (<= \"2012-01-01T00:00:00\"^^<http://www.w3.org/2001/XMLSchema#dateTime> ?startDate1) (<= \"2012-12-31T23:59:59\"^^<http://www.w3.org/2001/XMLSchema#dateTime> ?endDate1)) (<= ?startDate1 \"2012-12-31T23:59:59\"^^<http://www.w3.org/2001/XMLSchema#dateTime>))) (! (sameTerm ?node2 <urn:foo>)))", " (quadpattern", "  (quad <urn:x-arq:DefaultGraphNode> ?inst1 ?arg1Pred1 <urn:foo>)", "  (quad <urn:x-arq:DefaultGraphNode> ?inst1 <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> ?class1)", "  (quad <urn:x-arq:DefaultGraphNode> ?inst1 ?arg2Pred1 ?node2)", "  (quad <urn:x-arq:DefaultGraphNode> ?inst1 ?startDatePred1 ?startDate1)", "  (quad <urn:x-arq:DefaultGraphNode> ?inst1 ?endDatePred1 ?endDate1)", "  (quad <urn:x-arq:DefaultGraphNode> ?class1 <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <urn:class>)", "  (quad <urn:x-arq:DefaultGraphNode> ?class1 <urn:pred1> ?arg1Pred1)", "  (quad <urn:x-arq:DefaultGraphNode> ?class1 <urn:pred2> ?arg2Pred1)", "  (quad <urn:x-arq:DefaultGraphNode> ?class1 <urn:predStartDate> ?startDatePred1)", "  (quad <urn:x-arq:DefaultGraphNode> ?class1 <urn:predEndDate> ?endDatePred1)", "))"}), StrUtils.strjoinNL((String[])new String[]{"(sequence", "  (filter (|| (|| (|| (&& (< \"2012-01-01T00:00:00\"^^<http://www.w3.org/2001/XMLSchema#dateTime> ?startDate1) (< ?endDate1 \"2012-12-31T23:59:59\"^^<http://www.w3.org/2001/XMLSchema#dateTime>)) (&& (< ?startDate1 \"2012-01-01T00:00:00\"^^<http://www.w3.org/2001/XMLSchema#dateTime>) (< \"2012-12-31T23:59:59\"^^<http://www.w3.org/2001/XMLSchema#dateTime> ?endDate1))) (&& (&& (<= ?startDate1 \"2012-01-01T00:00:00\"^^<http://www.w3.org/2001/XMLSchema#dateTime>) (<= ?endDate1 \"2012-12-31T23:59:59\"^^<http://www.w3.org/2001/XMLSchema#dateTime>)) (<= \"2012-01-01T00:00:00\"^^<http://www.w3.org/2001/XMLSchema#dateTime> ?endDate1))) (&& (&& (<= \"2012-01-01T00:00:00\"^^<http://www.w3.org/2001/XMLSchema#dateTime> ?startDate1) (<= \"2012-12-31T23:59:59\"^^<http://www.w3.org/2001/XMLSchema#dateTime> ?endDate1)) (<= ?startDate1 \"2012-12-31T23:59:59\"^^<http://www.w3.org/2001/XMLSchema#dateTime>)))", "   (sequence", "    (filter (! (sameTerm ?node2 <urn:foo>))", "       (quadpattern", "         (quad <urn:x-arq:DefaultGraphNode> ?inst1 ?arg1Pred1 <urn:foo>)", "         (quad <urn:x-arq:DefaultGraphNode> ?inst1 <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> ?class1)", "         (quad <urn:x-arq:DefaultGraphNode> ?inst1 ?arg2Pred1 ?node2)", "       ))", "     (quadpattern", "       (quad <urn:x-arq:DefaultGraphNode> ?inst1 ?startDatePred1 ?startDate1)", "       (quad <urn:x-arq:DefaultGraphNode> ?inst1 ?endDatePred1 ?endDate1)", "     )))", " (quadpattern", "   (quad <urn:x-arq:DefaultGraphNode> ?class1 <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <urn:class>)", "   (quad <urn:x-arq:DefaultGraphNode> ?class1 <urn:pred1> ?arg1Pred1)", "   (quad <urn:x-arq:DefaultGraphNode> ?class1 <urn:pred2> ?arg2Pred1)", "   (quad <urn:x-arq:DefaultGraphNode> ?class1 <urn:predStartDate> ?startDatePred1)", "   (quad <urn:x-arq:DefaultGraphNode> ?class1 <urn:predEndDate> ?endDatePred1)", " ))"}));
    }

    @Test
    public void place_bgp_50a() {
        TestTransformFilterPlacement.testNoBGP(StrUtils.strjoinNL((String[])new String[]{"(filter (exprlist (|| (|| (|| (&& (< \"2012-01-01T00:00:00\"^^<http://www.w3.org/2001/XMLSchema#dateTime> ?startDate1) (< ?endDate1 \"2012-12-31T23:59:59\"^^<http://www.w3.org/2001/XMLSchema#dateTime>)) (&& (< ?startDate1 \"2012-01-01T00:00:00\"^^<http://www.w3.org/2001/XMLSchema#dateTime>) (< \"2012-12-31T23:59:59\"^^<http://www.w3.org/2001/XMLSchema#dateTime> ?endDate1))) (&& (&& (<= ?startDate1 \"2012-01-01T00:00:00\"^^<http://www.w3.org/2001/XMLSchema#dateTime>) (<= ?endDate1 \"2012-12-31T23:59:59\"^^<http://www.w3.org/2001/XMLSchema#dateTime>)) (<= \"2012-01-01T00:00:00\"^^<http://www.w3.org/2001/XMLSchema#dateTime> ?endDate1))) (&& (&& (<= \"2012-01-01T00:00:00\"^^<http://www.w3.org/2001/XMLSchema#dateTime> ?startDate1) (<= \"2012-12-31T23:59:59\"^^<http://www.w3.org/2001/XMLSchema#dateTime> ?endDate1)) (<= ?startDate1 \"2012-12-31T23:59:59\"^^<http://www.w3.org/2001/XMLSchema#dateTime>))) (! (sameTerm ?node2 <urn:foo>)))", " (quadpattern", "  (quad <urn:x-arq:DefaultGraphNode> ?inst1 ?arg1Pred1 <urn:foo>)", "  (quad <urn:x-arq:DefaultGraphNode> ?inst1 <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> ?class1)", "  (quad <urn:x-arq:DefaultGraphNode> ?inst1 ?arg2Pred1 ?node2)", "  (quad <urn:x-arq:DefaultGraphNode> ?inst1 ?startDatePred1 ?startDate1)", "  (quad <urn:x-arq:DefaultGraphNode> ?inst1 ?endDatePred1 ?endDate1)", "  (quad <urn:x-arq:DefaultGraphNode> ?class1 <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <urn:class>)", "  (quad <urn:x-arq:DefaultGraphNode> ?class1 <urn:pred1> ?arg1Pred1)", "  (quad <urn:x-arq:DefaultGraphNode> ?class1 <urn:pred2> ?arg2Pred1)", "  (quad <urn:x-arq:DefaultGraphNode> ?class1 <urn:predStartDate> ?startDatePred1)", "  (quad <urn:x-arq:DefaultGraphNode> ?class1 <urn:predEndDate> ?endDatePred1)", "))"}), null);
    }

    @Test
    public void place_no_match_01() {
        TestTransformFilterPlacement.testNoChange("(filter (= ?x ?unbound) (bgp (?s ?p ?x)))");
    }

    @Test
    public void place_no_match_02() {
        TestTransformFilterPlacement.testNoChange("(filter (= ?x ?unbound) (bgp (?s ?p ?x) (?s ?p ?x)))");
    }

    @Test
    public void place_no_match_03() {
        TestTransformFilterPlacement.testNoChange("(filter (= ?x ?unbound) (bgp (?s ?p ?x) (?s1 ?p1 ?XX)))");
    }

    @Test
    public void place_sequence_01() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (sequence (bgp (?s ?p ?x)) (bgp (?s ?p ?z)) ))", "(sequence (filter (= ?x 123) (bgp (?s ?p ?x))) (bgp (?s ?p ?z)) )");
    }

    @Test
    public void place_sequence_02() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (sequence (bgp (?s ?p ?x)) (bgp (?s ?p ?x)) ))", "(sequence (filter (= ?x 123) (bgp (?s ?p ?x))) (bgp (?s ?p ?x)) )");
    }

    @Test
    public void place_sequence_03() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (sequence  (bgp (?s ?p ?x)) (bgp (?s ?p ?x1)) (bgp (?s ?p ?x2)) ))", "(sequence (filter (= ?x 123) (bgp (?s ?p ?x))) (bgp (?s ?p ?x1)) (bgp (?s ?p ?x2)) )");
    }

    @Test
    public void place_sequence_04() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (sequence (bgp (?s ?p ?x1)) (bgp (?s ?p ?x)) (bgp (?s ?p ?x2)) ))", "(sequence (bgp (?s ?p ?x1)) (filter (= ?x 123) (bgp (?s ?p ?x))) (bgp (?s ?p ?x2)) )");
    }

    @Test
    public void place_sequence_04a() {
        TestTransformFilterPlacement.testNoBGP("(filter (= ?x 123) (sequence (bgp (?s ?p ?x1)) (bgp (?s ?p ?x)) (bgp (?s ?p ?x2)) ))", "(sequence (bgp (?s ?p ?x1)) (filter (= ?x 123) (bgp (?s ?p ?x))) (bgp (?s ?p ?x2)))");
    }

    @Test
    public void place_sequence_05() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (sequence (bgp (?s ?p ?x) (?s ?p ?x1)) (bgp (?s ?p ?x2)) ))", "(sequence (filter (= ?x 123) (bgp (?s ?p ?x))) (bgp (?s ?p ?x1)) (bgp (?s ?p ?x2)) )");
    }

    @Test
    public void place_sequence_05a() {
        TestTransformFilterPlacement.testNoBGP("(filter (= ?x 123) (sequence (bgp (?s ?p ?x) (?s ?p ?x1)) (bgp (?s ?p ?x2)) ))", "(sequence (filter (= ?x 123) (bgp (?s ?p ?x) (?s ?p ?x1))) (bgp (?s ?p ?x2)))");
    }

    @Test
    public void place_sequence_06() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (sequence (bgp (?s ?p ?x1) (?s ?p ?x2)) (bgp (?s ?p ?x)) ))", "(sequence (bgp (?s ?p ?x1) (?s ?p ?x2)) (filter (= ?x 123) (bgp (?s ?p ?x))) )");
    }

    @Test
    public void place_sequence_07() {
        TestTransformFilterPlacement.testNoChange("(filter (= ?A 123) (sequence (bgp (?s ?p ?x)) (bgp (?s ?p ?z)) ))");
    }

    @Test
    public void place_sequence_08() {
        TestTransformFilterPlacement.testNoChange("(sequence (bgp (?s ?p ?x)) (filter (= ?z 123) (bgp (?s ?p ?z))) )");
    }

    @Test
    public void place_sequence_09() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (sequence (bgp (?s ?p ?x1) (?s ?p ?x)) (bgp (?s ?p ?x2)) ))", "(sequence (filter (= ?x 123) (bgp (?s ?p ?x1) (?s ?p ?x))) (bgp (?s ?p ?x2)) )");
    }

    @Test
    public void place_sequence_09a() {
        TestTransformFilterPlacement.testNoBGP("(filter (= ?x 123) (sequence (bgp (?s ?p ?x1) (?s ?p ?x)) (bgp (?s ?p ?x2)) ))", "(sequence (filter (= ?x 123) (bgp (?s ?p ?x1) (?s ?p ?x))) (bgp (?s ?p ?x2)) )");
    }

    @Test
    public void place_join_01() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (join (bgp (?s ?p ?x)) (bgp (?s ?p ?z)) ))", "(join (filter (= ?x 123) (bgp (?s ?p ?x))) (bgp (?s ?p ?z)) )");
    }

    @Test
    public void place_join_02() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (join (bgp (?s ?p ?x)) (bgp (?s ?p ?x)) ))", "(join  (filter (= ?x 123) (bgp (?s ?p ?x))) (filter (= ?x 123) (bgp (?s ?p ?x))) )");
    }

    @Test
    public void place_join_03() {
        String x = StrUtils.strjoinNL((String[])new String[]{"(filter ((= 13 14) (> ?o1 12) (< ?o 56) (< (+ ?o ?o1) 999))", "   (join", "      (bgp (triple ?s ?p ?o))", "      (bgp (triple ?s ?p1 ?o1))))"});
        String y = StrUtils.strjoinNL((String[])new String[]{"(filter (< (+ ?o ?o1) 999)", "  (join", "    (filter ((= 13 14) (< ?o 56))", "      (bgp (triple ?s ?p ?o)))", "    (filter ((= 13 14) (> ?o1 12))", "      (bgp (triple ?s ?p1 ?o1)))))"});
        String y1 = StrUtils.strjoinNL((String[])new String[]{"(filter (< (+ ?o ?o1) 999)", "  (join", "  (filter (< ?o 56)", "    (sequence", "      (filter (= 13 14)", "        (table unit))", "      (bgp (triple ?s ?p ?o))))", "  (filter (> ?o1 12)", "    (sequence", "      (filter (= 13 14)", "        (table unit))", "      (bgp (triple ?s ?p1 ?o1))))", "   ))"});
        TestTransformFilterPlacement.test(x, y1);
    }

    @Test
    public void place_conditional_01() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (conditional (bgp (?s ?p ?x)) (bgp (?s ?p ?z)) ))", "(conditional (filter (= ?x 123) (bgp (?s ?p ?x))) (bgp (?s ?p ?z)) )");
    }

    @Test
    public void place_conditional_02() {
        TestTransformFilterPlacement.test("(filter (= ?z 123) (conditional (bgp (?s ?p ?x)) (bgp (?s ?p ?z)) ))", "(filter (= ?z 123) (conditional (bgp (?s ?p ?x)) (bgp (?s ?p ?z)) ))");
    }

    @Test
    public void place_conditional_03() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (conditional (bgp (?s ?p ?x)) (bgp (?s ?p ?x)) ))", "(conditional (filter (= ?x 123) (bgp (?s ?p ?x))) (bgp (?s ?p ?x)) )");
    }

    @Test
    public void place_leftjoin_01() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (leftjoin (bgp (?s ?p ?x)) (bgp (?s ?p ?z)) ))", "(leftjoin (filter (= ?x 123) (bgp (?s ?p ?x))) (bgp (?s ?p ?z)) )");
    }

    @Test
    public void place_leftjoin_02() {
        TestTransformFilterPlacement.test("(filter (= ?z 123) (leftjoin (bgp (?s ?p ?x)) (bgp (?s ?p ?z)) ))", "(filter (= ?z 123) (leftjoin (bgp (?s ?p ?x)) (bgp (?s ?p ?z)) ))");
    }

    @Test
    public void place_leftjoin_03() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (leftjoin (bgp (?s ?p ?x)) (bgp (?s ?p ?x)) ))", "(leftjoin (filter (= ?x 123) (bgp (?s ?p ?x))) (bgp (?s ?p ?x)) )");
    }

    @Test
    public void place_project_01() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (project (?x) (bgp (?s ?p ?x)) ))", "(project (?x) (filter (= ?x 123) (bgp (?s ?p ?x)) ))");
    }

    @Test
    public void place_project_02() {
        TestTransformFilterPlacement.testNoChange("(filter (= ?x 123) (project (?s) (bgp (?s ?p ?x)) ))");
    }

    @Test
    public void place_project_03() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (project (?x) (bgp (?s ?p ?x) (?s ?p ?z) ) ))", "(project (?x) (sequence (filter (= ?x 123) (bgp (?s ?p ?x)) ) (bgp (?s ?p ?z))) )");
    }

    @Test
    public void place_distinct_01() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (distinct (bgp (?s ?p ?x)) ))", "(distinct (filter (= ?x 123) (bgp (?s ?p ?x)) ))");
    }

    @Test
    public void place_distinct_02() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (distinct (bgp (?s ?p ?o)) ))", null);
    }

    @Test
    public void place_distinct_03() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (distinct (extend ((?x 123)) (bgp (?s ?p ?o)) )))", "(distinct (filter (= ?x 123) (extend ((?x 123)) (bgp (?s ?p ?o)) )))");
    }

    @Test
    public void place_distinct_04() {
        TestTransformFilterPlacement.test("(filter ((= ?o 456) (= ?z 987)) (distinct (bgp (?s ?p ?o) )))", "(filter (= ?z 987) (distinct (filter (= ?o 456) (bgp (?s ?p ?o) ))))");
    }

    @Test
    public void place_reduced_01() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (reduced (bgp (?s ?p ?x)) ))", "(reduced (filter (= ?x 123) (bgp (?s ?p ?x)) ))");
    }

    @Test
    public void place_reduced_02() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (reduced (bgp (?s ?p ?o)) ))", null);
    }

    @Test
    public void place_reduced_04() {
        TestTransformFilterPlacement.test("(filter ((= ?o 456) (= ?z 987)) (reduced (bgp (?s ?p ?o) )))", "(filter (= ?z 987) (reduced (filter (= ?o 456) (bgp (?s ?p ?o) ))))");
    }

    @Test
    public void place_reduced_03() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (reduced (extend ((?x 123)) (bgp (?s ?p ?o)) )))", "(reduced (filter (= ?x 123) (extend ((?x 123)) (bgp (?s ?p ?o)) )))");
    }

    @Test
    public void place_extend_01() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (extend ((?z 123)) (bgp (?s ?p ?x)) ))", "(extend ((?z 123)) (filter (= ?x 123) (bgp (?s ?p ?x)) ))");
    }

    @Test
    public void place_extend_02() {
        TestTransformFilterPlacement.test("(filter ((= ?x1 123) (= ?x2 456)) (extend (?z 789) (bgp (?s ?p ?x1)) ))", "(filter (= ?x2 456) (extend (?z 789) (filter (= ?x1 123) (bgp (?s ?p ?x1)) )))");
    }

    @Test
    public void place_extend_03() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (extend ((?x 123)) (bgp (?s ?p ?z)) ))", null);
    }

    @Test
    public void place_extend_04() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (extend ((?x1 123)) (filter (< ?x 456) (bgp (?s ?p ?x) (?s ?p ?z))) ))", "(extend (?x1 123) (sequence (filter ((= ?x 123) (< ?x 456)) (bgp (?s ?p ?x))) (bgp (?s ?p ?z))) )");
    }

    @Test
    public void place_extend_05() {
        TestTransformFilterPlacement.test("(filter (= ?z 1) (sequence (extend (?x1 123) (bgp (?s ?p ?x))) (bgp (?s ?p ?z))))", "(sequence (extend (?x1 123) (bgp (?s ?p ?x))) (filter (= ?z 1) (bgp (?s ?p ?z)) ))");
    }

    @Test
    public void place_extend_06() {
        TestTransformFilterPlacement.test("(filter (= ?z 1) (join (extend (?x1 123) (bgp (?s ?p ?x))) (bgp (?s ?p ?z))))", "(join (extend (?x1 123) (bgp (?s ?p ?x))) (filter (= ?z 1) (bgp (?s ?p ?z))) )");
    }

    @Test
    public void place_extend_07() {
        String x1 = StrUtils.strjoinNL((String[])new String[]{"(filter ( (= ?s 5) (= ?w 6) (= ?s1 7) )", "  (extend ((?w 2))", "    (extend ((?s 1))", "      (table (vars ?s1)", "        (row [?s1 1])", "))))"});
        String x2 = StrUtils.strjoinNL((String[])new String[]{"(filter (= ?w 6)", "  (extend ((?w 2))", "    (filter (= ?s 5)", "      (extend ((?s 1))", "        (filter (= ?s1 7)", "          (table (vars ?s1)", "            (row [?s1 1])", "          ))))))"});
        TestTransformFilterPlacement.test(x1, x2);
    }

    @Test
    public void place_extend_08() {
        String x1 = StrUtils.strjoinNL((String[])new String[]{"(filter ( (= ?s 'S') (= ?w 'W') (= ?s1 'S1') (= ?a 'A') (= ?b 'B'))", "  (extend ((?w 2))", "    (extend ((?s 1))", "      (distinct", "        (extend ((?a 2))", "          (extend ((?b 1))", "            (table (vars ?s1)", "              (row [?s1 1])", ")))))))"});
        String x2 = StrUtils.strjoinNL((String[])new String[]{"(filter (= ?w 'W')", "  (extend ((?w 2))", "    (filter (= ?s 'S')", "      (extend ((?s 1))", "        (distinct", "          (filter (= ?a 'A')", "            (extend ((?a 2))", "              (filter (= ?b 'B')", "                (extend ((?b 1))", "                  (filter (= ?s1 'S1')", "                    (table (vars ?s1)", "                      (row [?s1 1])", "                    )))))))))))"});
        TestTransformFilterPlacement.test(x1, x2);
    }

    @Test
    public void place_assign_01() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (assign ((?z 123)) (bgp (?s ?p ?x)) ))", "(assign ((?z 123)) (filter (= ?x 123) (bgp (?s ?p ?x)) ))");
    }

    @Test
    public void place_assign_02() {
        TestTransformFilterPlacement.test("(filter ((= ?x1 123) (= ?x2 456)) (assign (?z 789) (bgp (?s ?p ?x1)) ))", "(filter (= ?x2 456) (assign (?z 789) (filter (= ?x1 123) (bgp (?s ?p ?x1)) )))");
    }

    @Test
    public void place_assign_03() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (assign ((?x 123)) (bgp (?s ?p ?z)) ))", null);
    }

    @Test
    public void place_assign_04() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (assign ((?x1 123)) (filter (< ?x 456) (bgp (?s ?p ?x) (?s ?p ?z))) ))", "(assign (?x1 123) (sequence (filter ((= ?x 123) (< ?x 456)) (bgp (?s ?p ?x))) (bgp (?s ?p ?z))) )");
    }

    @Test
    public void place_assign_05() {
        TestTransformFilterPlacement.testNoBGP("(filter (= ?x 123) (assign ((?z 123)) (bgp (?s ?p ?x)) ))", "(assign ((?z 123)) (filter (= ?x 123) (bgp (?s ?p ?x)) ))");
    }

    @Test
    public void place_assign_06() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (assign ((?z 123)) (bgp (?s ?p ?x) (?s ?p ?x1) )))", "(assign ((?z 123)) (sequence (filter (= ?x 123) (bgp (?s ?p ?x)) ) (bgp (?s ?p ?x1)) ) )");
    }

    @Test
    public void place_assign_06a() {
        TestTransformFilterPlacement.testNoBGP("(filter (= ?x 123) (assign ((?z 123)) (bgp (?s ?p ?x) (?s ?p ?x1) )))", "(assign ((?z 123)) (filter (= ?x 123) (bgp (?s ?p ?x) (?s ?p ?x1)) ) )");
    }

    @Test
    public void place_assign_07() {
        String x1 = StrUtils.strjoinNL((String[])new String[]{"(filter ( (= ?s 5) (= ?w 6) (= ?s1 7) )", "  (assign ((?w 2))", "    (assign ((?s 1))", "      (table (vars ?s1)", "        (row [?s1 1])", "))))"});
        String x2 = StrUtils.strjoinNL((String[])new String[]{"(filter (= ?w 6)", "  (assign ((?w 2))", "    (filter (= ?s 5)", "      (assign ((?s 1))", "        (filter (= ?s1 7)", "          (table (vars ?s1)", "            (row [?s1 1])", "          ))))))"});
        TestTransformFilterPlacement.test(x1, x2);
    }

    @Test
    public void place_assign_08() {
        String x1 = StrUtils.strjoinNL((String[])new String[]{"(filter ( (= ?s 'S') (= ?w 'W') (= ?s1 'S1') (= ?a 'A') (= ?b 'B'))", "  (assign ((?w 2))", "    (assign ((?s 1))", "      (distinct", "        (assign ((?a 2))", "          (assign ((?b 1))", "            (table (vars ?s1)", "              (row [?s1 1])", ")))))))"});
        String x2 = StrUtils.strjoinNL((String[])new String[]{"(filter (= ?w 'W')", "  (assign ((?w 2))", "    (filter (= ?s 'S')", "      (assign ((?s 1))", "        (distinct", "          (filter (= ?a 'A')", "            (assign ((?a 2))", "              (filter (= ?b 'B')", "                (assign ((?b 1))", "                  (filter (= ?s1 'S1')", "                    (table (vars ?s1)", "                      (row [?s1 1])", "                    )))))))))))"});
        TestTransformFilterPlacement.test(x1, x2);
    }

    @Test
    public void place_filter_01() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (filter (= ?y 456) (bgp (?s ?p ?x) (?s ?p ?y)) ))", "(filter (= ?y 456) (sequence (filter (= ?x 123) (bgp (?s ?p ?x))) (bgp (?s ?p ?y)) ))");
    }

    @Test
    public void place_filter_02() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (filter (= ?y 456) (bgp (?s ?p ?x) (?s ?p ?y) (?s ?p ?z) )))", "(sequence (filter (= ?y 456) (sequence (filter (= ?x 123) (bgp (?s ?p ?x))) (bgp (?s ?p ?y)))) (bgp (?s ?p ?z)))");
    }

    @Test
    public void place_filter_03() {
        String x1 = StrUtils.strjoinNL((String[])new String[]{"(filter true", "  (union", "    (table empty)", "    (filter (= ?z 3)", "      (table unit))))"});
        String x2 = StrUtils.strjoinNL((String[])new String[]{"(union", "  (filter true", "    (table empty))", "  (filter (exprlist true (= ?z 3))", "    (table unit)))"});
        TestTransformFilterPlacement.test(x1, x2);
    }

    @Test
    public void place_filter_04() {
        String x1 = StrUtils.strjoinNL((String[])new String[]{"(filter true", "  (union", "    (filter false", "      (table unit))", "    (filter (!= ?z 3)", "      (table unit))))"});
        String x2 = StrUtils.strjoinNL((String[])new String[]{"(union", "  (filter (exprlist true false)", "    (table unit))", "  (filter (exprlist true (!= ?z 3))", "    (table unit)))"});
        TestTransformFilterPlacement.test(x1, x2);
    }

    @Test
    public void place_filter_05() {
        String x1 = StrUtils.strjoinNL((String[])new String[]{"(filter (= ?z 3)", "  (sequence", "    (filter (= ?y 3)", "      (table unit))", "    (bgp (triple ?s ?p ?z))))"});
        String x2 = StrUtils.strjoinNL((String[])new String[]{"(sequence", "  (filter (= ?y 3)", "    (table unit))", "  (filter (= ?z 3)", "    (bgp (triple ?s ?p ?z))))"});
        TestTransformFilterPlacement.test(x1, x2);
    }

    @Test
    public void place_union_01() {
        TestTransformFilterPlacement.test("(filter (= ?x 123) (union (bgp (?s ?p ?x) (?s ?p ?y)) (bgp (?s ?p ?z)  (?s1 ?p1 ?x)) ))", "(union  (sequence (filter (= ?x 123) (bgp (?s ?p ?x))) (bgp (?s ?p ?y))) (filter (= ?x 123) (bgp (?s ?p ?z)  (?s1 ?p1 ?x)) ))");
    }

    @Test
    public void place_union_02() {
        String in = StrUtils.strjoinNL((String[])new String[]{"(filter 1", "  (union", "    (bgp (triple ?s ?p ?o))", "     (filter 0 (table unit))", "))"});
        String out = StrUtils.strjoinNL((String[])new String[]{"(union", "  (sequence", "    (filter 1 (table unit))", "   (bgp (triple ?s ?p ?o)))", "  (filter (exprlist 1 0) (table unit))", ")"});
        TestTransformFilterPlacement.test(in, out);
    }

    @Test
    public void place_union_02a() {
        String in = StrUtils.strjoinNL((String[])new String[]{"(filter 1", "  (union", "    (bgp (triple ?s ?p ?o))", "     (filter 0 (table unit))", "))"});
        String out = StrUtils.strjoinNL((String[])new String[]{"(union", "  (filter 1 (bgp (triple ?s ?p ?o)))", "  (filter (exprlist 1 0) (table unit))", ")"});
        TestTransformFilterPlacement.testNoBGP(in, out);
    }

    @Test
    public void place_union_03() {
        String in = StrUtils.strjoinNL((String[])new String[]{"(slice _ 1", "  (project (?s ?p ?o)", "    (filter 1", "      (union", "        (bgp (?s ?p ?o))", "        (filter 0 (table unit))", "    ))", "))"});
        String out = StrUtils.strjoinNL((String[])new String[]{"(slice _ 1", "  (project (?s ?p ?o)", "    (union", "      (sequence", "         (filter 1 (table unit))", "         (bgp (?s ?p ?o)))", "      (filter (exprlist 1 0)", "        (table unit))", ")", "))"});
        TestTransformFilterPlacement.test(in, out);
    }

    @Test
    public void place_union_03a() {
        String in = StrUtils.strjoinNL((String[])new String[]{"(slice _ 1", "  (project (?s ?p ?o)", "    (filter 1", "      (union", "        (bgp (?s ?p ?o))", "        (filter 0 (table unit))", "    ))", "))"});
        String out = StrUtils.strjoinNL((String[])new String[]{"(slice _ 1", "  (project (?s ?p ?o)", "    (union", "      (filter 1 (bgp (?s ?p ?o)))", "      (filter (exprlist 1 0) (table unit))", ")", "))"});
        TestTransformFilterPlacement.testNoBGP(in, out);
    }

    @Test
    public void place_union_04() {
        String in = StrUtils.strjoinNL((String[])new String[]{"(filter (= 1 1)", "  (union", "    (bgp (triple ?s ?p ?o))", "    (filter (!= 0 0)", "      (table unit))))"});
        String out = StrUtils.strjoinNL((String[])new String[]{"(union", "  (sequence", "    (filter (= 1 1)", "      (table unit))", "    (bgp (triple ?s ?p ?o)))", "  (filter (exprlist (= 1 1) (!= 0 0))", "   (table unit)))"});
        TestTransformFilterPlacement.test(in, out);
    }

    @Test
    public void place_union_04a() {
        String in = StrUtils.strjoinNL((String[])new String[]{"(filter (= 1 1)", "    (union", "        (bgp (triple ?s ?p ?o))", "        (filter (!= 0 0)", "          (table unit))))"});
        String out = StrUtils.strjoinNL((String[])new String[]{"(union", "   (filter (= 1 1)", "     (bgp (triple ?s ?p ?o)))", "   (filter (exprlist (= 1 1) (!= 0 0))", "     (table unit)))"});
        TestTransformFilterPlacement.testNoBGP(in, out);
    }

    @Test
    public void place_union_05() {
        String in;
        String out = in = StrUtils.strjoinNL((String[])new String[]{"(filter (= ?x 1)", "  (union", "    (bgp (triple ?s ?p ?o))", "    (bgp (triple ?s ?p ?o))", "))"});
        TestTransformFilterPlacement.test(in, out);
    }

    @Test
    public void place_union_05a() {
        String in;
        String out = in = StrUtils.strjoinNL((String[])new String[]{"(filter (= ?x 1)", "  (union", "    (bgp (triple ?s ?p ?o))", "    (bgp (triple ?s ?p ?o))", "))"});
        TestTransformFilterPlacement.testNoBGP(in, out);
    }

    @Test
    public void place_union_06() {
        String in = StrUtils.strjoinNL((String[])new String[]{"(filter (= ?x 1)", "  (union", "    (bgp (triple ?s ?p ?o))", "    (bgp (triple ?s ?p ?x))", "))"});
        String out = StrUtils.strjoinNL((String[])new String[]{"(filter (= ?x 1)", "  (union", "    (bgp (triple ?s ?p ?o))", "    (filter (= ?x 1) (bgp (triple ?s ?p ?x)))", "))"});
        TestTransformFilterPlacement.test(in, out);
    }

    @Test
    public void place_union_07() {
        String in = StrUtils.strjoinNL((String[])new String[]{"(filter (= ?x 1)", "  (union", "    (bgp (triple ?s ?p ?x))", "    (bgp (triple ?s ?p ?o))", "))"});
        String out = StrUtils.strjoinNL((String[])new String[]{"(filter (= ?x 1)", "  (union", "    (filter (= ?x 1) (bgp (triple ?s ?p ?x)))", "    (bgp (triple ?s ?p ?o))", "))"});
        TestTransformFilterPlacement.test(in, out);
    }

    @Test
    public void place_disjunction_01() {
        String in = StrUtils.strjoinNL((String[])new String[]{"(filter (exprlist (!= ?VAR 123) (regex ?var4 'pat1'))", "  (disjunction", "    (bgp (?var2 :p1 ?var4) (?var2 :p2 ?var3))", "    (bgp (?var2 :p3 ?var4) (?var2 :p4 ?var3))", "    ))"});
        String out = StrUtils.strjoinNL((String[])new String[]{"(filter (!= ?VAR 123)", "    (disjunction", "      (sequence", "        (filter (regex ?var4 'pat1')", "          (bgp (triple ?var2 :p1 ?var4)))", "        (bgp (triple ?var2 :p2 ?var3)))", "      (sequence", "        (filter (regex ?var4 'pat1')", "          (bgp (triple ?var2 :p3 ?var4)))", "        (bgp (triple ?var2 :p4 ?var3)))))"});
        TestTransformFilterPlacement.test(in, out);
    }

    @Test
    public void place_disjunction_02() {
        String in = StrUtils.strjoinNL((String[])new String[]{"(filter (exprlist (!= ?VAR 123) (regex ?var4 'pat1'))", "  (disjunction", "    (bgp (?var2 :p1 ?var4) (?var2 :p2 ?var3))", "    (bgp (?var2 :p4 ?var3) (?var2 :p3 ?var4))", "    (bgp (?var2 :p4 ?var9))", "    ))"});
        String out = StrUtils.strjoinNL((String[])new String[]{"(filter (!= ?VAR 123)", "  (disjunction", "    (sequence", "      (filter (regex ?var4 'pat1')", "        (bgp (triple ?var2 :p1 ?var4)))", "      (bgp (triple ?var2 :p2 ?var3)))", "    (filter (regex ?var4 'pat1')", "      (bgp", "        (triple ?var2 :p4 ?var3)", "        (triple ?var2 :p3 ?var4)", "      ))", "    (filter (regex ?var4 'pat1')", "      (bgp (triple ?var2 :p4 ?var9)))))"});
        TestTransformFilterPlacement.test(in, out);
    }

    private static void test_property_function(Runnable action) {
        PropertyFunctionRegistry.get().put(propertyFunctionURI, dummyPropertyFunction.getClass());
        try {
            action.run();
        }
        finally {
            PropertyFunctionRegistry.get().remove(propertyFunctionURI);
        }
    }

    @Test
    public void place_property_functions_01() {
        TestTransformFilterPlacement.test_property_function(() -> {
            String in;
            String out = in = "(propfunc :PF ?pfSubjArg (?pfObjArg1 ?pfObjArg2) (bgp(?s ?p ?o)))";
            TestTransformFilterPlacement.test(in, out);
        });
    }

    @Test
    public void place_property_functions_02() {
        TestTransformFilterPlacement.test_property_function(() -> {
            String in = StrUtils.strjoinNL((String[])new String[]{"(filter ((= ?x 1)(= ?o 9))", "    (propfunc :PF ?pfSubjArg (?pfObjArg1 ?pfObjArg2)", "       (bgp (?s ?p ?o))", "    ))"});
            String out = StrUtils.strjoinNL((String[])new String[]{"(filter (= ?x 1)", "  (propfunc :PF ?pfSubjArg (?pfObjArg1 ?pfObjArg2)", "    (filter (= ?o 9)", "      (bgp (triple ?s ?p ?o))", "    )))"});
            TestTransformFilterPlacement.test(in, out);
        });
    }

    @Test
    public void place_property_functions_02a() {
        TestTransformFilterPlacement.test_property_function(() -> {
            String in;
            String out = in = StrUtils.strjoinNL((String[])new String[]{"(filter (= ?x 1)", "    (propfunc :PF ?pfSubjArg (?pfObjArg1 ?pfObjArg2)", "       (bgp (?s ?p ?o))", "    ))"});
            TestTransformFilterPlacement.test(in, out);
        });
    }

    @Test
    public void place_property_functions_02b() {
        TestTransformFilterPlacement.test_property_function(() -> {
            String in = StrUtils.strjoinNL((String[])new String[]{"(filter (= ?o 9)", "    (propfunc :PF ?pfSubjArg (?pfObjArg1 ?pfObjArg2)", "       (bgp (?s ?p ?o))", "    ))"});
            String out = StrUtils.strjoinNL((String[])new String[]{"(propfunc :PF ?pfSubjArg (?pfObjArg1 ?pfObjArg2)", "  (filter (= ?o 9)", "   (bgp (triple ?s ?p ?o))", "  ))"});
            TestTransformFilterPlacement.test(in, out);
        });
    }

    @Test
    public void place_property_functions_03() {
        TestTransformFilterPlacement.test_property_function(() -> {
            String in = StrUtils.strjoinNL((String[])new String[]{"(filter ((= ?pfSubjArg 1)(= ?o 9))", "    (propfunc :PF ?pfSubjArg (?pfObjArg1 ?pfObjArg2)", "       (bgp (?s ?p ?o))", "    ))"});
            String out = StrUtils.strjoinNL((String[])new String[]{"(filter (= ?pfSubjArg 1)", "  (propfunc :PF ?pfSubjArg (?pfObjArg1 ?pfObjArg2)", "    (filter (= ?o 9)", "      (bgp (triple ?s ?p ?o))", "    )))"});
            TestTransformFilterPlacement.test(in, out);
        });
    }

    @Test
    public void place_property_functions_04() {
        TestTransformFilterPlacement.test_property_function(() -> {
            String in = StrUtils.strjoinNL((String[])new String[]{"(filter ((= ?pfObjArg 1)(= ?o 9))", "    (propfunc :PF ?pfSubjArg (?pfObjArg1 ?pfObjArg2)", "       (bgp (?s ?p ?o))", "    ))"});
            String out = StrUtils.strjoinNL((String[])new String[]{"(filter (= ?pfObjArg 1)", "  (propfunc :PF ?pfSubjArg (?pfObjArg1 ?pfObjArg2)", "    (filter (= ?o 9)", "      (bgp (triple ?s ?p ?o))", "    )))"});
            TestTransformFilterPlacement.test(in, out);
        });
    }

    private static void test_procedure(Runnable action) {
        ProcedureRegistry.get().put(procedureURI, dummyProcedure.getClass());
        try {
            action.run();
        }
        finally {
            ProcedureRegistry.get().remove(procedureURI);
        }
    }

    @Test
    public void place_procedure_01() {
        TestTransformFilterPlacement.test_procedure(() -> {
            String in;
            String out = in = "(proc :PROC ((+ ?arg1 111) (?arg2)) (bgp (?s ?p ?o)))";
            TestTransformFilterPlacement.test(in, out);
        });
    }

    @Test
    public void place_procedure_02() {
        TestTransformFilterPlacement.test_procedure(() -> {
            String in = StrUtils.strjoinNL((String[])new String[]{"(filter (= ?o 9)", "   (proc :PROC ((+ ?arg1 111) (?arg2))", "      (bgp (?s ?p ?o))", "   ))"});
            String out = StrUtils.strjoinNL((String[])new String[]{"(proc :PROC ((+ ?arg1 111) (?arg2))", "  (filter (= ?o 9)", "    (bgp (?s ?p ?o))", "   ))"});
            TestTransformFilterPlacement.test(in, out);
        });
    }

    @Test
    public void place_procedure_03() {
        TestTransformFilterPlacement.test_procedure(() -> {
            String in;
            String out = in = StrUtils.strjoinNL((String[])new String[]{"(filter (= ?x 9)", "   (proc :PROC ((+ ?arg1 111) (?arg2))", "      (bgp (?s ?p ?o))", "   ))"});
            TestTransformFilterPlacement.test(in, out);
        });
    }

    @Test
    public void place_procedure_04() {
        TestTransformFilterPlacement.test_procedure(() -> {
            String in;
            String out = in = StrUtils.strjoinNL((String[])new String[]{"(filter (= ?arg1 9)", "   (proc :PROC ((+ ?arg1 111) (?arg2))", "      (bgp (?s ?p ?o))", "   ))"});
            TestTransformFilterPlacement.test(in, out);
        });
    }

    @Test
    public void place_procedure_05() {
        TestTransformFilterPlacement.test_procedure(() -> {
            String in = StrUtils.strjoinNL((String[])new String[]{"(filter ((= ?x 9) (= ?o 11) (= ?arg2 19))", "   (proc :PROC ((+ ?arg1 111) (?arg2))", "      (bgp (?s ?p ?o))", "   ))"});
            String out = StrUtils.strjoinNL((String[])new String[]{"(filter ((= ?x 9) (= ?arg2 19))", "   (proc :PROC ((+ ?arg1 111) (?arg2))", "     (filter (= ?o 11)", "       (bgp (?s ?p ?o))", "     )))"});
            TestTransformFilterPlacement.test(in, out);
        });
    }

    @Test
    public void nondeterministic_functions_01() {
        TestTransformFilterPlacement.testNoChange("(filter (= ?x (rand)) (bgp (?s ?p ?x) (?s1 ?p1 ?x)))");
    }

    @Test
    public void nondeterministic_functions_02() {
        TestTransformFilterPlacement.testNoChange("(filter (= ?x (bnode)) (bgp (?s ?p ?x) (?s1 ?p1 ?x)))");
    }

    @Test
    public void nondeterministic_functions_03() {
        TestTransformFilterPlacement.testNoChange("(filter (= ?x (struuid)) (bgp (?s ?p ?x) (?s1 ?p1 ?x)))");
    }

    @Test
    public void nondeterministic_functions_04() {
        TestTransformFilterPlacement.testNoChange("(filter (= ?x (uuid)) (bgp (?s ?p ?x) (?s1 ?p1 ?x)))");
    }

    @Test
    public void nondeterministic_functions_05() {
        TestTransformFilterPlacement.test("(filter (= ?x (now)) (bgp (?s ?p ?x) (?s1 ?p1 ?x)))", "(sequence  (filter (= ?x (now)) (bgp (?s ?p ?x) ))  (bgp (?s1 ?p1 ?x)) )");
    }

    @Test
    public void nondeterministic_functions_06() {
        String in = StrUtils.strjoinNL((String[])new String[]{"(filter ( (!= ?x ?s) (= ?x (rand)) )", "   (bgp (?s ?p ?x) (?s1 ?p1 ?x))", ")"});
        String out = StrUtils.strjoinNL((String[])new String[]{"(filter (= ?x (rand)) ", "  (sequence", "     (filter (!= ?x ?s) (bgp (?s ?p ?x)))", "     (bgp (?s1 ?p1 ?x))", "))"});
        TestTransformFilterPlacement.test(in, out);
    }

    @Test
    public void nondeterministic_functions_07() {
        String in = StrUtils.strjoinNL((String[])new String[]{"(filter ( (!= ?x ?s) (|| ?x (rand)) )", "   (bgp (?s ?p ?x) (?s1 ?p1 ?x))", ")"});
        String out = StrUtils.strjoinNL((String[])new String[]{"(filter (|| ?x (rand)) ", "  (sequence", "     (filter (!= ?x ?s) (bgp (?s ?p ?x)))", "     (bgp (?s1 ?p1 ?x))", "))"});
        TestTransformFilterPlacement.test(in, out);
    }

    public static void testNoChange(String input) {
        TestTransformFilterPlacement.test(input, null);
    }

    public static void test(String input, String output) {
        TestTransformFilterPlacement.test$(input, output, true);
    }

    public static void testNoBGP(String input, String output) {
        TestTransformFilterPlacement.test$(input, output, false);
    }

    public static void test$(String input, String output, boolean includeBGPs) {
        TransformFilterPlacement t_placement = new TransformFilterPlacement(includeBGPs);
        Op op1 = SSE.parseOp((String)input);
        Op op2 = Transformer.transform((Transform)t_placement, (Op)op1);
        if (output == null) {
            Assert.assertEquals((Object)op1, (Object)op2);
            return;
        }
        Op op3 = SSE.parseOp((String)output);
        if (!Objects.equals(op2, op3)) {
            System.out.println("Expected:");
            System.out.println(op3);
            System.out.println("Got:");
            System.out.println(op2);
        }
        Assert.assertEquals((Object)op3, (Object)op2);
    }
}

