/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.optimize;

import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.optimize.TransformMergeBGPs;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Test;

public class TestTransformMergeBGPs
extends BaseTest {
    String pre = "(prefix ((: <http://example/>))";
    String post = ")";

    @Test
    public void collapse_01() {
        this.test("(bgp (:x :p  :z))");
    }

    @Test
    public void collapse_02() {
        this.test("(table unit)");
    }

    @Test
    public void collapse_10() {
        this.test("(join (bgp (:x :p :z1)) (table unit) )");
    }

    @Test
    public void collapse_11() {
        this.test("(join (table unit) (bgp (:x :p :z1)) )");
    }

    @Test
    public void collapse_12() {
        this.test("(join (bgp (:x :p :z1)) (bgp (:x :p :z2)) )", "(bgp (:x :p :z1) (:x :p :z2))");
    }

    @Test
    public void collapse_13() {
        this.test("(join (bgp (:x :p :z1)) (join (bgp (:x :p :z2)) (bgp (:x :p :z3))) )", "(bgp (:x :p :z1) (:x :p :z2) (:x :p :z3) )");
    }

    @Test
    public void collapse_14() {
        this.test("(join (join (bgp (:x :p :z1)) (bgp (:x :p :z2))) (bgp (:x :p :z3)) )", "(bgp (:x :p :z1) (:x :p :z2) (:x :p :z3) )");
    }

    @Test
    public void collapse_20() {
        this.test("(sequence (bgp (:x :p :z1)) (bgp (:x :p :z2)) )", "(bgp (:x :p :z1) (:x :p :z2))");
    }

    @Test
    public void collapse_21() {
        this.test("(sequence (bgp (:x :p :z1)) (bgp (:x :p :z2)) (bgp (:x :p :z3)) )", "(bgp (:x :p :z1) (:x :p :z2) (:x :p :z3))");
    }

    @Test
    public void collapse_22() {
        this.test("(sequence (table unit) (bgp (:x :p :z1)) (bgp (:x :p :z3)) )", "(sequence (table unit) (bgp (:x :p :z1) (:x :p :z3)) )");
    }

    @Test
    public void collapse_23() {
        this.test("(sequence (bgp (:x :p :z1)) (table unit) (bgp (:x :p :z3)) )");
    }

    @Test
    public void collapse_24() {
        this.test("(sequence (bgp (:x :p :z1)) (bgp (:x :p :z3)) (table unit) )", "(sequence (bgp (:x :p :z1) (:x :p :z3)) (table unit) )");
    }

    @Test
    public void collapse_30() {
        this.test("(join (sequence (bgp (:x :p :z1)) (bgp (:x :p :z2)) (bgp (:x :p :z3)) )(sequence (bgp (:x :p :z4)) (bgp (:x :p :z5))))", "(bgp (:x :p :z1) (:x :p :z2) (:x :p :z3) (:x :p :z4) (:x :p :z5) )");
    }

    @Test
    public void collapse_31() {
        this.test("(join (table unit)(sequence (bgp (:x :p :z4)) (bgp (:x :p :z5))))", "(join (table unit) (bgp (:x :p :z4) (:x :p :z5)))");
    }

    @Test
    public void collapse_32() {
        this.test("(join (sequence (bgp (:x :p :z4)) (bgp (:x :p :z5)))(table unit))", "(join (bgp (:x :p :z4) (:x :p :z5)) (table unit) )");
    }

    private void test(String input) {
        this.test(input, input);
    }

    private void test(String input, String output) {
        input = this.pre + input + this.post;
        output = this.pre + output + this.post;
        Op op1 = SSE.parseOp((String)input);
        Op op3 = Transformer.transform((Transform)new TransformMergeBGPs(), (Op)op1);
        Op expected = SSE.parseOp((String)output);
        TestTransformMergeBGPs.assertEquals((Object)expected, (Object)op3);
    }
}

