/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.api;

import java.util.Iterator;
import java.util.Set;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetCloseable;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.AnonId;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.util.IsoMatcher;
import org.apache.jena.sparql.util.ModelUtils;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.junit.Test;

public class TestAPI
extends BaseTest {
    private static final String ns = "http://example/ns#";
    static Model m = GraphFactory.makeJenaDefaultModel();
    static Resource r1 = m.createResource();
    static Property p1 = m.createProperty("http://example/ns#p1");
    static Property p2 = m.createProperty("http://example/ns#p2");
    static Property p3 = m.createProperty("http://example/ns#p3");
    static Model dft = GraphFactory.makeJenaDefaultModel();
    static Resource s = dft.createResource("http://example/ns#s");
    static Property p = dft.createProperty("http://example/ns#p");
    static Resource o = dft.createResource("http://example/ns#o");
    static Resource g1 = dft.createResource("http://example/ns#g1");
    static Dataset d = null;

    @Test
    public void testInitialBindingsConstruct1() {
        try (QueryExecution qExec = this.makeQExec("CONSTRUCT {?s ?p ?z} {?s ?p 'x1'}");){
            QuerySolutionMap init = new QuerySolutionMap();
            init.add("z", (RDFNode)m.createLiteral("zzz"));
            qExec.setInitialBinding((QuerySolution)init);
            Model r = qExec.execConstruct();
            TestAPI.assertTrue((String)"Empty model", (r.size() > 0L ? 1 : 0) != 0);
            Property p1 = m.createProperty("http://example/ns#p1");
            TestAPI.assertTrue((String)"Empty model", (boolean)r.contains(null, p1, init.get("z")));
        }
    }

    @Test
    public void testInitialBindingsConstruct2() {
        try (QueryExecution qExec = this.makeQExec("CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o }");){
            QuerySolutionMap init = new QuerySolutionMap();
            init.add("o", (RDFNode)m.createLiteral("x1"));
            qExec.setInitialBinding((QuerySolution)init);
            Model r = qExec.execConstruct();
            TestAPI.assertTrue((String)"Empty model", (r.size() > 0L ? 1 : 0) != 0);
            Property p1 = m.createProperty("http://example/ns#p1");
            TestAPI.assertTrue((String)"Empty model", (boolean)r.contains(null, p1, init.get("x1")));
        }
    }

    @Test
    public void test_API1() {
        try (QueryExecution qExec = this.makeQExec("SELECT * {?s ?p ?o}");){
            ResultSet rs = qExec.execSelect();
            TestAPI.assertTrue((String)"No results", (boolean)rs.hasNext());
            QuerySolution qs = rs.nextSolution();
            Resource qr = qs.getResource("s");
            Set s1 = qr.getModel().listStatements().toSet();
            Set s2 = m.listStatements().toSet();
            TestAPI.assertEquals((Object)s1, (Object)s2);
        }
    }

    @Test
    public void testInitialBindings0() {
        QuerySolutionMap smap1 = new QuerySolutionMap();
        QuerySolutionMap smap2 = new QuerySolutionMap();
        smap1.add("o", (RDFNode)m.createLiteral("y1"));
        smap2.addAll(smap1);
        TestAPI.assertTrue((boolean)smap2.contains("o"));
        smap2.clear();
        TestAPI.assertFalse((boolean)smap2.contains("o"));
        TestAPI.assertTrue((boolean)smap1.contains("o"));
        QuerySolutionMap smap3 = new QuerySolutionMap();
        smap2.addAll((QuerySolution)smap1);
        TestAPI.assertTrue((boolean)smap2.contains("o"));
    }

    @Test
    public void testInitialBindings1() {
        QueryExecution qExec = this.makeQExec("SELECT * {?s ?p ?o}");
        QuerySolutionMap init = new QuerySolutionMap();
        init.add("o", (RDFNode)m.createLiteral("y1"));
        qExec.setInitialBinding((QuerySolution)init);
        int count = this.queryAndCount(qExec);
        TestAPI.assertEquals((String)"Initial binding didn't restrict query properly", (long)1L, (long)count);
    }

    @Test
    public void testInitialBindings2() {
        QueryExecution qExec = this.makeQExec("SELECT * {?s ?p ?o}");
        QuerySolutionMap init = new QuerySolutionMap();
        init.add("z", (RDFNode)m.createLiteral("zzz"));
        qExec.setInitialBinding((QuerySolution)init);
        int count = this.queryAndCount(qExec);
        TestAPI.assertEquals((String)"Initial binding restricted query improperly", (long)3L, (long)count);
    }

    @Test
    public void testInitialBindings3() {
        try (QueryExecution qExec = this.makeQExec("SELECT * {?s ?p 'x1'}");){
            QuerySolutionMap init = new QuerySolutionMap();
            init.add("z", (RDFNode)m.createLiteral("zzz"));
            qExec.setInitialBinding((QuerySolution)init);
            ResultSet rs = qExec.execSelect();
            QuerySolution qs = rs.nextSolution();
            TestAPI.assertTrue((String)"Initial setting not set correctly now", (boolean)qs.getLiteral("z").getLexicalForm().equals("zzz"));
        }
    }

    @Test
    public void testInitialBindings4() {
        String queryString = "PREFIX : <http://example/ns#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nSELECT * \nWHERE { \n    ?x :p1 ?z .    NOT EXISTS { \n        ?x rdfs:label ?z . \n    }\n}";
        Query query = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)m);){
            QuerySolutionMap map = new QuerySolutionMap();
            map.add("this", (RDFNode)OWL.Thing);
            qexec.setInitialBinding((QuerySolution)map);
            ResultSet rs = qexec.execSelect();
            while (rs.hasNext()) {
                QuerySolution querySolution = rs.nextSolution();
            }
        }
    }

    @Test
    public void testInitialBindings5() {
        Query query = QueryFactory.create((String)"ASK\nWHERE {\n    FILTER (?a = <http://constant>) .\n}");
        Model model = ModelFactory.createDefaultModel();
        model.add(OWL.Thing, RDF.type, (RDFNode)OWL.Class);
        QuerySolutionMap initialBinding = new QuerySolutionMap();
        initialBinding.add("a", (RDFNode)ResourceFactory.createResource((String)"http://constant"));
        QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)model, (QuerySolution)initialBinding);
        boolean result = qexec.execAsk();
        TestAPI.assertTrue((boolean)result);
    }

    @Test
    public void testInitialBindings6() {
        Query query = QueryFactory.create((String)"ASK\nWHERE {\n    FILTER (?a = ?b) .\n}");
        Model model = ModelFactory.createDefaultModel();
        model.add(OWL.Thing, RDF.type, (RDFNode)OWL.Class);
        QuerySolutionMap initialBinding = new QuerySolutionMap();
        initialBinding.add("a", (RDFNode)ResourceFactory.createTypedLiteral((Object)Boolean.TRUE));
        initialBinding.add("b", (RDFNode)ResourceFactory.createTypedLiteral((Object)Boolean.TRUE));
        QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)model, (QuerySolution)initialBinding);
        boolean result = qexec.execAsk();
        TestAPI.assertTrue((boolean)result);
    }

    @Test
    public void testInitialBindings7() {
        Query query = QueryFactory.create((String)"SELECT DISTINCT ?x WHERE {}");
        Dataset ds = DatasetFactory.create();
        QuerySolutionMap initialBinding = new QuerySolutionMap();
        initialBinding.add("a", (RDFNode)ResourceFactory.createTypedLiteral((Object)Boolean.TRUE));
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Dataset)ds, (QuerySolution)initialBinding);){
            TestAPI.assertFalse((boolean)qexec.execSelect().next().contains("a"));
        }
    }

    @Test
    public void testReuseQueryObject1() {
        String queryString = "SELECT * {?s ?p ?o}";
        Query q = QueryFactory.create((String)queryString);
        QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Model)m);
        int count = this.queryAndCount(qExec);
        TestAPI.assertEquals((long)3L, (long)count);
        qExec = QueryExecutionFactory.create((Query)q, (Model)m);
        count = this.queryAndCount(qExec);
        TestAPI.assertEquals((long)3L, (long)count);
    }

    @Test
    public void testReuseQueryObject2() {
        QuerySolution qs;
        ResultSet rs;
        String queryString = "SELECT (count(?o) AS ?c) {?s ?p ?o} GROUP BY ?s";
        Query q = QueryFactory.create((String)queryString);
        try (QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Model)m);){
            rs = qExec.execSelect();
            qs = rs.nextSolution();
            TestAPI.assertEquals((long)3L, (long)qs.getLiteral("c").getInt());
        }
        qExec = QueryExecutionFactory.create((Query)q, (Model)m);
        var4_4 = null;
        try {
            rs = qExec.execSelect();
            qs = rs.nextSolution();
            TestAPI.assertEquals((long)3L, (long)qs.getLiteral("c").getInt());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (qExec != null) {
                if (var4_4 != null) {
                    try {
                        qExec.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    qExec.close();
                }
            }
        }
    }

    @Test
    public void testConstructRejectsBadTriples1() {
        String queryString = "CONSTRUCT { ?s ?p ?o } WHERE { ?o ?p ?s }";
        Query q = QueryFactory.create((String)queryString);
        QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Model)m);
        Model resultModel = qExec.execConstruct();
        TestAPI.assertEquals((long)0L, (long)resultModel.size());
    }

    @Test
    public void testConstructRejectsBadTriples2() {
        String queryString = "CONSTRUCT { ?s ?p ?o } WHERE { ?o ?p ?s }";
        Query q = QueryFactory.create((String)queryString);
        QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Model)m);
        Iterator ts = qExec.execConstructTriples();
        long count = 0L;
        while (ts.hasNext()) {
            ++count;
            ts.next();
        }
        TestAPI.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testARQConstructQuad_a_1() {
        String queryString = "CONSTRUCT { ?s ?p ?o } WHERE { GRAPH ?g { ?s ?p ?o } }";
        Query q = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
        QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Dataset)d);
        Iterator ts = qExec.execConstructTriples();
        Model result = ModelFactory.createDefaultModel();
        while (ts.hasNext()) {
            Triple t = (Triple)ts.next();
            Statement stmt = ModelUtils.tripleToStatement((Model)result, (Triple)t);
            if (stmt == null) continue;
            result.add(stmt);
        }
        TestAPI.assertEquals((long)3L, (long)result.size());
        TestAPI.assertTrue((boolean)m.isIsomorphicWith(result));
    }

    @Test
    public void testARQConstructQuad_b_2() {
        String queryString = "CONSTRUCT { GRAPH ?g1 {?s ?p ?o} } WHERE { ?s ?p ?o. GRAPH ?g1 {?s1 ?p1 'x1'} }";
        Query q = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
        QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Dataset)d);
        Iterator ts = qExec.execConstructQuads();
        DatasetGraph result = DatasetGraphFactory.create();
        long count = 0L;
        while (ts.hasNext()) {
            ++count;
            Quad qd = (Quad)ts.next();
            result.add(qd);
        }
        DatasetGraph expected = DatasetGraphFactory.create();
        expected.add(g1.asNode(), s.asNode(), p.asNode(), o.asNode());
        TestAPI.assertEquals((long)1L, (long)count);
        TestAPI.assertTrue((boolean)IsoMatcher.isomorphic((DatasetGraph)expected, (DatasetGraph)result));
    }

    @Test
    public void testARQConstructQuad_a_2() {
        String queryString = "CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o }";
        Query q = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
        QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Dataset)d);
        Iterator ts = qExec.execConstructQuads();
        DatasetGraph result = DatasetGraphFactory.create();
        long count = 0L;
        while (ts.hasNext()) {
            ++count;
            result.add((Quad)ts.next());
        }
        DatasetGraph expected = DatasetGraphFactory.create();
        expected.add(Quad.defaultGraphNodeGenerated, s.asNode(), p.asNode(), o.asNode());
        TestAPI.assertEquals((long)1L, (long)count);
        TestAPI.assertTrue((boolean)IsoMatcher.isomorphic((DatasetGraph)expected, (DatasetGraph)result));
    }

    @Test
    public void testARQConstructQuad_b_1() {
        String queryString = "CONSTRUCT { ?s ?p ?o GRAPH ?g1 { ?s1 ?p1 ?o1 } } WHERE { ?s ?p ?o. GRAPH ?g1 { ?s1 ?p1 ?o1 } }";
        Query q = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
        QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Dataset)d);
        Iterator ts = qExec.execConstructTriples();
        Model result = ModelFactory.createDefaultModel();
        while (ts.hasNext()) {
            Triple t = (Triple)ts.next();
            Statement stmt = ModelUtils.tripleToStatement((Model)result, (Triple)t);
            if (stmt == null) continue;
            result.add(stmt);
        }
        TestAPI.assertEquals((long)1L, (long)result.size());
        TestAPI.assertTrue((boolean)dft.isIsomorphicWith(result));
    }

    @Test
    public void testARQConstructQuad_bnodes() {
        String queryString = "PREFIX : <http://example/> CONSTRUCT { :s :p :o GRAPH _:a { :s :p :o1 } } WHERE { }";
        Query q = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
        QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Dataset)d);
        Dataset ds = qExec.execConstructDataset();
        TestAPI.assertEquals((long)1L, (long)Iter.count((Iterator)ds.asDatasetGraph().listGraphNodes()));
        Node n = (Node)ds.asDatasetGraph().listGraphNodes().next();
        TestAPI.assertTrue((boolean)n.isBlank());
        Graph g = ds.asDatasetGraph().getGraph(n);
        TestAPI.assertNotNull((Object)g);
        TestAPI.assertFalse((boolean)g.isEmpty());
    }

    @Test
    public void testARQConstructQuad_Duplicate_1() {
        String queryString = "CONSTRUCT { GRAPH ?g1 {?s ?p ?o} } WHERE { ?s ?p ?o. GRAPH ?g1 {?s1 ?p1 ?o1} }";
        Query q = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
        QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Dataset)d);
        Iterator ts = qExec.execConstructQuads();
        long count = 0L;
        Quad expected = Quad.create((Node)g1.asNode(), (Node)s.asNode(), (Node)p.asNode(), (Node)o.asNode());
        while (ts.hasNext()) {
            ++count;
            Quad qd = (Quad)ts.next();
            TestAPI.assertEquals((Object)expected, (Object)qd);
        }
        TestAPI.assertEquals((long)3L, (long)count);
    }

    @Test
    public void testARQConstructQuad_Duplicate_2() {
        String queryString = "CONSTRUCT { GRAPH ?g1 {?s ?p ?o} } WHERE { ?s ?p ?o. GRAPH ?g1 {?s1 ?p1 ?o1} }";
        Query q = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
        QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Dataset)d);
        Dataset result = qExec.execConstructDataset();
        DatasetGraph expected = DatasetGraphFactory.create();
        expected.add(g1.asNode(), s.asNode(), p.asNode(), o.asNode());
        TestAPI.assertEquals((long)1L, (long)result.asDatasetGraph().size());
        TestAPI.assertTrue((boolean)IsoMatcher.isomorphic((DatasetGraph)expected, (DatasetGraph)result.asDatasetGraph()));
    }

    @Test
    public void testARQConstructQuad_Duplicate_3() {
        String queryString = "CONSTRUCT { GRAPH ?g1 {?s ?p ?o} GRAPH ?g1 {?s ?p ?o} } WHERE { ?s ?p ?o. GRAPH ?g1 {?s1 ?p1 ?o1} }";
        Query q = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
        QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Dataset)d);
        Iterator ts = qExec.execConstructQuads();
        long count = 0L;
        Quad expected = Quad.create((Node)g1.asNode(), (Node)s.asNode(), (Node)p.asNode(), (Node)o.asNode());
        while (ts.hasNext()) {
            ++count;
            Quad qd = (Quad)ts.next();
            TestAPI.assertEquals((Object)expected, (Object)qd);
        }
        TestAPI.assertEquals((long)6L, (long)count);
    }

    @Test
    public void testARQConstructQuad_Prefix() {
        String queryString = "PREFIX :   <http://example/ns#> CONSTRUCT { GRAPH :g1 { ?s :p ?o} } WHERE { ?s ?p ?o }";
        Query q = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
        QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Dataset)d);
        Iterator quads = qExec.execConstructQuads();
        DatasetGraph result = DatasetGraphFactory.create();
        long count = 0L;
        while (quads.hasNext()) {
            ++count;
            Quad qd = (Quad)quads.next();
            result.add(qd);
        }
        DatasetGraph expected = DatasetGraphFactory.create();
        expected.add(g1.asNode(), s.asNode(), p.asNode(), o.asNode());
        TestAPI.assertEquals((long)1L, (long)count);
        TestAPI.assertTrue((boolean)IsoMatcher.isomorphic((DatasetGraph)expected, (DatasetGraph)result));
    }

    @Test
    public void testARQConstructQuad_ShortForm_1() {
        String queryString = "CONSTRUCT WHERE {?s ?p ?o }";
        Query q = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
        QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Dataset)d);
        Model result = ModelFactory.createDefaultModel();
        qExec.execConstruct(result);
        TestAPI.assertEquals((long)1L, (long)result.size());
        TestAPI.assertTrue((boolean)dft.isIsomorphicWith(result));
    }

    @Test
    public void testARQConstructQuad_ShortForm_2() {
        String queryString = "CONSTRUCT WHERE { GRAPH ?g {?s ?p ?o} }";
        Query q = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
        QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Dataset)d);
        Dataset result = qExec.execConstructDataset();
        Dataset expected = DatasetFactory.createTxnMem();
        expected.addNamedModel(g1.getURI(), m);
        TestAPI.assertTrue((boolean)IsoMatcher.isomorphic((DatasetGraph)expected.asDatasetGraph(), (DatasetGraph)result.asDatasetGraph()));
    }

    @Test
    public void testARQConstructQuad_ShortForm_3() {
        String queryString = "CONSTRUCT WHERE { ?s ?p ?o. GRAPH ?g1 {?s1 ?p1 ?o1} }";
        Query q = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
        QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Dataset)d);
        Dataset result = qExec.execConstructDataset();
        TestAPI.assertTrue((boolean)IsoMatcher.isomorphic((DatasetGraph)d.asDatasetGraph(), (DatasetGraph)result.asDatasetGraph()));
    }

    @Test
    public void testARQConstructQuad_ShortForm_bad() {
        String queryString = "CONSTRUCT WHERE { GRAPH ?g {?s ?p ?o. FILTER isIRI(?o)}  }";
        try {
            QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
        }
        catch (QueryParseException e) {
            return;
        }
        TestAPI.fail((String)"Short form of construct quad MUST be simple graph patterns!");
    }

    @Test
    public void testResultSetCloseableGood() {
        String queryString = "SELECT * { ?s ?p ?o. }";
        Query q = QueryFactory.create((String)queryString);
        QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Dataset)d);
        try (ResultSetCloseable rs = ResultSetFactory.closeableResultSet((QueryExecution)qExec);){
            int x = ResultSetFormatter.consume((ResultSet)rs);
            TestAPI.assertEquals((long)1L, (long)x);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testResultSetCloseableBad() {
        String queryString = "ASK { ?s ?p ?o. }";
        Query q = QueryFactory.create((String)queryString);
        QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Dataset)d);
        try (ResultSetCloseable rs = ResultSetFactory.closeableResultSet((QueryExecution)qExec);){
            int x = ResultSetFormatter.consume((ResultSet)rs);
            TestAPI.assertEquals((long)1L, (long)x);
        }
    }

    private QueryExecution makeQExec(String queryString) {
        Query q = QueryFactory.create((String)queryString);
        QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Model)m);
        return qExec;
    }

    private int queryAndCount(String queryString) {
        QueryExecution qExec = this.makeQExec(queryString);
        return this.queryAndCount(qExec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int queryAndCount(QueryExecution qExec) {
        try {
            ResultSet rs = qExec.execSelect();
            int n = ResultSetFormatter.consume((ResultSet)rs);
            return n;
        }
        finally {
            qExec.close();
        }
    }

    @Test
    public void testExecJson() {
        Query query = QueryFactory.create((String)"JSON { \"s\": ?s , \"p\": ?p , \"o\" : ?o } WHERE { ?s ?p ?o }", (Syntax)Syntax.syntaxARQ);
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)m);){
            JsonArray jsonArray = qexec.execJson();
            TestAPI.assertNotNull((Object)jsonArray);
            TestAPI.assertEquals((long)3L, (long)jsonArray.size());
        }
    }

    @Test
    public void testExecJsonItems() {
        Model model = ModelFactory.createDefaultModel();
        Resource r = model.createResource(AnonId.create((String)"first"));
        Property p = model.getProperty("");
        Literal node = ResourceFactory.createTypedLiteral((String)"123", (RDFDatatype)XSDDatatype.XSDdecimal);
        model.add(r, p, (RDFNode)node);
        r = model.createResource(AnonId.create((String)"second"));
        p = model.getProperty("");
        node = ResourceFactory.createTypedLiteral((String)"abc", (RDFDatatype)XSDDatatype.XSDstring);
        model.add(r, p, (RDFNode)node);
        r = model.createResource(AnonId.create((String)"third"));
        p = model.getProperty("");
        node = ResourceFactory.createLangLiteral((String)"def", (String)"en");
        model.add(r, p, (RDFNode)node);
        Query query = QueryFactory.create((String)"JSON { \"s\": ?s , \"p\": ?p , \"o\" : ?o } WHERE { ?s ?p ?o }", (Syntax)Syntax.syntaxARQ);
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)model);){
            Iterator execJsonItems = qexec.execJsonItems();
            int size = 0;
            while (execJsonItems.hasNext()) {
                JsonObject next = (JsonObject)execJsonItems.next();
                if (next.get("s").toString().contains("first")) {
                    TestAPI.assertEquals((long)123L, (long)next.get("o").getAsNumber().value().intValue());
                } else if (next.get("s").toString().contains("second")) {
                    TestAPI.assertEquals((Object)"abc", (Object)next.get("o").getAsString().value());
                } else if (next.get("s").toString().contains("third")) {
                    TestAPI.assertEquals((Object)"def", (Object)next.get("o").getAsString().value());
                }
                ++size;
            }
            TestAPI.assertEquals((long)3L, (long)size);
        }
    }

    static {
        m.add(r1, p1, "x1");
        m.add(r1, p2, "X2");
        m.add(r1, p3, "y1");
        dft.add(s, p, (RDFNode)o);
        d = DatasetFactory.create((Model)dft);
        d.addNamedModel(g1.getURI(), m);
    }
}

