/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.Quad;
import org.junit.Test;

public abstract class AbstractTestDataset
extends BaseTest {
    static Model model1 = ModelFactory.createDefaultModel();
    static Model model2 = ModelFactory.createDefaultModel();
    static Resource s1 = model1.createResource("s1");
    static Resource s2 = model1.createResource("s2");
    static Property p1 = model1.createProperty("p1");
    static Property p2 = model1.createProperty("p2");
    static Resource o1 = model1.createResource("o1");
    static Resource o2 = model1.createResource("o2");

    protected abstract Dataset createDataset();

    @Test
    public void dataset_01() {
        Dataset ds = this.createDataset();
        AbstractTestDataset.assertNotNull((Object)ds.getDefaultModel());
        AbstractTestDataset.assertNotNull((Object)ds.asDatasetGraph());
    }

    @Test
    public void dataset_02() {
        Dataset ds = this.createDataset();
        ds.getDefaultModel().add(s1, p1, (RDFNode)o1);
        AbstractTestDataset.assertTrue((boolean)model1.isIsomorphicWith(ds.getDefaultModel()));
    }

    @Test
    public void dataset_03() {
        Dataset ds = this.createDataset();
        ds.setDefaultModel(model2);
        AbstractTestDataset.assertTrue((boolean)model2.isIsomorphicWith(ds.getDefaultModel()));
    }

    @Test
    public void dataset_04() {
        String graphName = "http://example/";
        Dataset ds = this.createDataset();
        ds.addNamedModel(graphName, model1);
        AbstractTestDataset.assertTrue((boolean)ds.containsNamedModel(graphName));
        List x = Iter.toList((Iterator)ds.listNames());
        AbstractTestDataset.assertEquals((long)1L, (long)x.size());
        AbstractTestDataset.assertEquals((Object)graphName, x.get(0));
        AbstractTestDataset.assertFalse((boolean)model1.isIsomorphicWith(ds.getDefaultModel()));
        Model m = ds.getNamedModel(graphName);
        AbstractTestDataset.assertNotNull((Object)m);
        AbstractTestDataset.assertTrue((boolean)model1.isIsomorphicWith(m));
        ds.removeNamedModel(graphName);
        AbstractTestDataset.assertFalse((boolean)ds.containsNamedModel(graphName));
    }

    @Test
    public void dataset_05() {
        String graphName = "http://example/";
        Dataset ds = this.createDataset();
        ds.addNamedModel(graphName, model1);
        ds.replaceNamedModel(graphName, model2);
        AbstractTestDataset.assertTrue((boolean)ds.containsNamedModel(graphName));
        List x = Iter.toList((Iterator)ds.listNames());
        AbstractTestDataset.assertEquals((long)1L, (long)x.size());
        AbstractTestDataset.assertEquals((Object)graphName, x.get(0));
        AbstractTestDataset.assertFalse((boolean)model1.isIsomorphicWith(ds.getNamedModel(graphName)));
        AbstractTestDataset.assertTrue((boolean)model2.isIsomorphicWith(ds.getNamedModel(graphName)));
    }

    @Test
    public void dataset_06() {
        String graphName = "http://example/";
        Dataset ds = this.createDataset();
        ds.addNamedModel(graphName, model1);
        AbstractTestDataset.assertFalse((String)"Dataset should not be empty after a named graph has been added!", (boolean)ds.isEmpty());
    }

    @Test
    public void dataset_07() {
        String graphName = "http://example/";
        Dataset ds = this.createDataset();
        ds.addNamedModel(graphName, model1);
        AbstractTestDataset.assertTrue((String)"Named graph not found", (boolean)ds.containsNamedModel(graphName));
    }

    @Test
    public void dataset_08() {
        Dataset ds = this.createDataset();
        AbstractTestDataset.assertTrue((String)"Union named graph not found", (boolean)ds.containsNamedModel(Quad.unionGraph.getURI()));
    }

    @Test
    public void dataset_09() {
        Dataset ds = this.createDataset();
        AbstractTestDataset.assertTrue((String)("Default graph not found using '<" + Quad.defaultGraphIRI.getURI() + ">'"), (boolean)ds.containsNamedModel(Quad.defaultGraphIRI.getURI()));
    }

    static {
        model1.add(s1, p1, (RDFNode)o1);
        model2.add(s2, p2, (RDFNode)o2);
    }
}

