/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;
import org.junit.Test;

public class TestContext
extends BaseTest {
    static Symbol p1 = Symbol.create((String)"p1");
    static Symbol p2 = Symbol.create((String)"p2");

    @Test
    public void testCxt1() {
        Context cxt = new Context();
    }

    @Test
    public void testCxt2() {
        Context cxt = new Context();
        TestContext.assertTrue((String)"Defined in empty context", (!cxt.isDefined(p1) ? 1 : 0) != 0);
        cxt.set(p1, (Object)"v");
        TestContext.assertTrue((String)"Not defined after .set", (boolean)cxt.isDefined(p1));
        Object v = cxt.get(p1);
        TestContext.assertSame((String)"Not the same", (Object)"v", (Object)v);
    }

    @Test
    public void testCxt3() {
        Context cxt = new Context();
        cxt.set(p1, (Object)"v");
        cxt.setIfUndef(p1, (Object)"w");
        Object v = cxt.get(p1);
        TestContext.assertSame((String)"Not as first set", (Object)"v", (Object)v);
    }

    @Test
    public void testCxt4() {
        Context cxt = new Context();
        cxt.set(p1, (Object)"true");
        TestContext.assertTrue((String)"Not true", (boolean)cxt.isTrue(p1));
        TestContext.assertTrue((String)"Not true or undef", (boolean)cxt.isTrueOrUndef(p1));
        TestContext.assertTrue((String)"Not false or undef", (boolean)cxt.isFalseOrUndef(p2));
        TestContext.assertTrue((String)"False when undef", (!cxt.isFalse(p2) ? 1 : 0) != 0);
    }

    @Test
    public void testCxt5() {
        Context cxt = new Context();
        cxt.set(p1, (Object)"false");
        TestContext.assertTrue((String)"Not false", (boolean)cxt.isFalse(p1));
        TestContext.assertTrue((String)"Not false or undef", (boolean)cxt.isFalseOrUndef(p1));
    }

    @Test
    public void testCxt6() {
        Context cxt = new Context();
        cxt.setTrue(p1);
        TestContext.assertTrue((String)"Not true", (boolean)cxt.isTrue(p1));
        String x = cxt.getAsString(p1);
        TestContext.assertEquals((String)"Not string 'true'", (Object)"true", (Object)x);
    }

    @Test
    public void testCxt7() {
        Context cxt = new Context();
        TestContext.assertEquals((long)-1L, (long)cxt.getInt(p1, -1));
        cxt.set(p1, (Object)1);
        int x = cxt.getInt(p1, -1);
        TestContext.assertEquals((long)1L, (long)x);
    }

    @Test
    public void testCxt8() {
        Context cxt = new Context();
        TestContext.assertEquals((long)-1L, (long)cxt.getLong(p1, -1L));
        cxt.set(p1, (Object)1L);
        long x = cxt.getLong(p1, -2L);
        TestContext.assertEquals((long)1L, (long)x);
    }

    @Test(expected=ARQException.class)
    public void testCxt9() {
        Context cxt = new Context();
        TestContext.assertEquals((long)-1L, (long)cxt.getLong(p1, -1L));
        cxt.set(p1, (Object)1L);
        cxt.getInt(p1, -2);
    }
}

