/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.mem;

import java.io.PrintStream;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.AbstractDatasetGraphTests;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.junit.Assert;
import org.junit.Test;

public class TestDatasetGraphInMemoryBasic
extends AbstractDatasetGraphTests {
    @Test
    public void orderingOfNodesFromFindIsCorrect() {
        DatasetGraph dsg = DatasetGraphFactory.createTxnMem();
        Node p = SSE.parseNode((String)":p");
        Triple triple = SSE.parseTriple((String)"(:s :p :o)");
        dsg.getDefaultGraph().add(triple);
        ExtendedIterator iter = dsg.getDefaultGraph().find(null, p, null);
        Assert.assertTrue((boolean)Iter.some((Iterator)iter, arg_0 -> ((Triple)triple).equals(arg_0)));
        Node p1 = SSE.parseNode((String)":p1");
        Quad quad = SSE.parseQuad((String)"(:g1 :s1 :p1 :o1)");
        dsg.add(quad);
        Iterator iter2 = dsg.find(null, null, p1, null);
        Assert.assertTrue((boolean)Iter.some((Iterator)iter2, arg_0 -> ((Quad)quad).equals(arg_0)));
        Iter.print((PrintStream)System.err, (Iterator)iter2);
    }

    @Test
    public void prefixesAreManaged() {
        Node graphName = NodeFactory.createURI((String)"http://example/g");
        DatasetGraph dsg = this.emptyDataset();
        dsg.addGraph(graphName, GraphFactory.createGraphMem());
        Dataset dataset = DatasetFactory.wrap((DatasetGraph)dsg);
        Model model = dataset.getNamedModel(graphName.getURI());
        String testPrefix = "example";
        String testURI = "http://example/";
        model.setNsPrefix("example", "http://example/");
        Assert.assertEquals((Object)"http://example/", (Object)model.getNsPrefixURI("example"));
        model.close();
        model = dataset.getNamedModel(graphName.getURI());
        String nsURI = dataset.getNamedModel(graphName.getURI()).getNsPrefixURI("example");
        Assert.assertNotNull((Object)nsURI);
        Assert.assertEquals((Object)"http://example/", (Object)nsURI);
    }

    @Test
    public void unionGraphWorksProperly() {
        DatasetGraph dsg = this.emptyDataset();
        Quad q = Quad.create((Node)NodeFactory.createBlankNode(), (Node)NodeFactory.createBlankNode(), (Node)NodeFactory.createBlankNode(), (Node)NodeFactory.createBlankNode());
        dsg.add(q);
        Quad q2 = Quad.create((Node)Quad.unionGraph, (Triple)q.asTriple());
        Assert.assertTrue((boolean)Iter.iter((Iterator)dsg.find(Quad.unionGraph, Node.ANY, Node.ANY, Node.ANY)).some(arg_0 -> ((Quad)q2).equals(arg_0)));
        Triple t = Triple.create((Node)NodeFactory.createBlankNode(), (Node)NodeFactory.createBlankNode(), (Node)NodeFactory.createBlankNode());
        dsg.getDefaultGraph().add(t);
        Assert.assertFalse((boolean)Iter.iter((Iterator)dsg.find(Quad.unionGraph, Node.ANY, Node.ANY, Node.ANY)).some(Quad::isDefaultGraph));
    }

    @Test
    public void listGraphNodesHasNoPhantomEmptyGraphs() {
        DatasetGraph dsg = this.emptyDataset();
        Node g = NodeFactory.createURI((String)"http://example/g");
        Node s = NodeFactory.createURI((String)"http://example/s");
        Node p = NodeFactory.createURI((String)"http://example/p");
        Node o = NodeFactory.createURI((String)"http://example/o");
        dsg.add(g, s, p, o);
        Iterator graphNodes = dsg.listGraphNodes();
        Assert.assertTrue((String)"Missing named graph!", (boolean)graphNodes.hasNext());
        Assert.assertEquals((String)"Wrong graph name!", (Object)g, graphNodes.next());
        Assert.assertFalse((String)"Too many named graphs!", (boolean)graphNodes.hasNext());
        dsg.delete(g, s, p, o);
        graphNodes = dsg.listGraphNodes();
        Assert.assertFalse((String)"Too many named graphs!", (boolean)graphNodes.hasNext());
    }

    @Override
    protected DatasetGraph emptyDataset() {
        return DatasetGraphFactory.createTxnMem();
    }
}

