/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.http;

import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.engine.http.QueryEngineHTTP;
import org.apache.jena.sparql.engine.http.QueryExceptionHTTP;
import org.apache.jena.sparql.engine.http.Service;
import org.apache.jena.sparql.modify.UpdateProcessRemoteBase;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.update.UpdateExecutionFactory;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestService {
    private static final String SERVICE = "http://example.com:40000";
    private static Object value;

    @BeforeClass
    public static void recordContextState() {
        value = ARQ.getContext().get(Service.serviceContext);
    }

    @AfterClass
    public static void restoreContextState() {
        ARQ.getContext().set(Service.serviceContext, value);
    }

    @Test
    public void testNumericTimeout() {
        block2: {
            BasicPattern basicPattern = new BasicPattern();
            basicPattern.add(Triple.ANY);
            Node serviceNode = NodeFactory.createURI((String)SERVICE);
            OpService opService = new OpService(serviceNode, (Op)new OpBGP(basicPattern), false);
            Context context = new Context();
            ARQ.setNormalMode((Context)context);
            context.set(Service.queryTimeout, (Object)10);
            try {
                Service.exec((OpService)opService, (Context)context);
                Assert.fail((String)"Expected QueryExceptionHTTP");
            }
            catch (QueryExceptionHTTP expected) {
                Throwable thrown = expected.getCause();
                if (thrown instanceof SocketException || thrown instanceof ConnectTimeoutException) break block2;
                Assert.fail((String)String.format("Expected SocketException or ConnectTimeoutException, instead got: %s %s", thrown.getClass().getName(), thrown.getMessage()));
            }
        }
    }

    @Test
    public void testStringTimeout() {
        block2: {
            BasicPattern basicPattern = new BasicPattern();
            basicPattern.add(Triple.ANY);
            Node serviceNode = NodeFactory.createURI((String)SERVICE);
            OpService opService = new OpService(serviceNode, (Op)new OpBGP(basicPattern), false);
            Context context = new Context();
            ARQ.setNormalMode((Context)context);
            context.set(Service.queryTimeout, (Object)"10");
            try {
                Service.exec((OpService)opService, (Context)context);
                Assert.fail((String)"Expected QueryExceptionHTTP");
            }
            catch (QueryExceptionHTTP expected) {
                Throwable thrown = expected.getCause();
                if (thrown instanceof SocketException || thrown instanceof ConnectTimeoutException) break block2;
                Assert.fail((String)String.format("Expected SocketException or ConnectTimeoutException, instead got: %s %s", thrown.getClass().getName(), thrown.getMessage()));
            }
        }
    }

    @Test
    public void testStringTimeout2() {
        block2: {
            BasicPattern basicPattern = new BasicPattern();
            basicPattern.add(Triple.ANY);
            Node serviceNode = NodeFactory.createURI((String)SERVICE);
            OpService opService = new OpService(serviceNode, (Op)new OpBGP(basicPattern), false);
            Context context = new Context();
            ARQ.setNormalMode((Context)context);
            context.set(Service.queryTimeout, (Object)"10,10000");
            try {
                Service.exec((OpService)opService, (Context)context);
                Assert.fail((String)"Expected QueryExceptionHTTP");
            }
            catch (QueryExceptionHTTP expected) {
                Throwable thrown = expected.getCause();
                if (thrown instanceof SocketException || thrown instanceof ConnectTimeoutException) break block2;
                Assert.fail((String)String.format("Expected SocketException or ConnectTimeoutException, instead got: %s %s", thrown.getClass().getName(), thrown.getMessage()));
            }
        }
    }

    @Test
    public void query_service_context_application_01() {
        Map serviceContextMap = (Map)ARQ.getContext().get(Service.serviceContext);
        if (serviceContextMap != null) {
            serviceContextMap.remove(SERVICE);
        }
        Query q = QueryFactory.create((String)"ASK { }");
        QueryEngineHTTP engine = QueryExecutionFactory.createServiceRequest((String)SERVICE, (Query)q);
        Assert.assertNotNull((Object)engine);
        Assert.assertEquals((long)-1L, (long)engine.getTimeout1());
        Assert.assertEquals((long)-1L, (long)engine.getTimeout2());
        Assert.assertTrue((boolean)engine.getAllowCompression());
        Assert.assertNull((Object)engine.getClient());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void query_service_context_application_02() {
        Map serviceContextMap = (Map)ARQ.getContext().get(Service.serviceContext);
        if (serviceContextMap == null) {
            ARQ.getContext().put(Service.serviceContext, new HashMap());
            serviceContextMap = (Map)ARQ.getContext().get(Service.serviceContext);
        }
        if (serviceContextMap.get(SERVICE) == null) {
            serviceContextMap.put(SERVICE, new Context(ARQ.getContext()));
        }
        Context serviceContext = (Context)serviceContextMap.get(SERVICE);
        try {
            CloseableHttpClient testClient = HttpClients.custom().build();
            serviceContext.put(Service.queryClient, (Object)testClient);
            Query q = QueryFactory.create((String)"ASK { }");
            QueryEngineHTTP engine = QueryExecutionFactory.createServiceRequest((String)SERVICE, (Query)q);
            Assert.assertNotNull((Object)engine);
            Assert.assertEquals((long)-1L, (long)engine.getTimeout1());
            Assert.assertEquals((long)-1L, (long)engine.getTimeout2());
            Assert.assertTrue((boolean)engine.getAllowCompression());
            Assert.assertEquals((Object)testClient, (Object)engine.getClient());
        }
        finally {
            serviceContext.remove(Service.queryClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void query_service_context_application_03() {
        Map serviceContextMap = (Map)ARQ.getContext().get(Service.serviceContext);
        if (serviceContextMap == null) {
            ARQ.getContext().put(Service.serviceContext, new HashMap());
            serviceContextMap = (Map)ARQ.getContext().get(Service.serviceContext);
        }
        if (serviceContextMap.get(SERVICE) == null) {
            serviceContextMap.put(SERVICE, new Context(ARQ.getContext()));
        }
        Context serviceContext = (Context)serviceContextMap.get(SERVICE);
        try {
            serviceContext.put(Service.queryTimeout, (Object)"10");
            Query q = QueryFactory.create((String)"ASK { }");
            QueryEngineHTTP engine = QueryExecutionFactory.createServiceRequest((String)SERVICE, (Query)q);
            Assert.assertNotNull((Object)engine);
            Assert.assertEquals((long)-1L, (long)engine.getTimeout1());
            Assert.assertEquals((long)10L, (long)engine.getTimeout2());
            Assert.assertTrue((boolean)engine.getAllowCompression());
            Assert.assertNull((Object)engine.getClient());
        }
        finally {
            serviceContext.remove(Service.queryTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void query_service_context_application_04() {
        Map serviceContextMap = (Map)ARQ.getContext().get(Service.serviceContext);
        if (serviceContextMap == null) {
            ARQ.getContext().put(Service.serviceContext, new HashMap());
            serviceContextMap = (Map)ARQ.getContext().get(Service.serviceContext);
        }
        if (serviceContextMap.get(SERVICE) == null) {
            serviceContextMap.put(SERVICE, new Context(ARQ.getContext()));
        }
        Context serviceContext = (Context)serviceContextMap.get(SERVICE);
        try {
            serviceContext.put(Service.queryTimeout, (Object)"10,20");
            Query q = QueryFactory.create((String)"ASK { }");
            QueryEngineHTTP engine = QueryExecutionFactory.createServiceRequest((String)SERVICE, (Query)q);
            Assert.assertNotNull((Object)engine);
            Assert.assertEquals((long)20L, (long)engine.getTimeout1());
            Assert.assertEquals((long)10L, (long)engine.getTimeout2());
            Assert.assertTrue((boolean)engine.getAllowCompression());
            Assert.assertNull((Object)engine.getClient());
        }
        finally {
            serviceContext.remove(Service.queryTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void query_service_context_application_05() {
        Map serviceContextMap = (Map)ARQ.getContext().get(Service.serviceContext);
        if (serviceContextMap == null) {
            ARQ.getContext().put(Service.serviceContext, new HashMap());
            serviceContextMap = (Map)ARQ.getContext().get(Service.serviceContext);
        }
        if (serviceContextMap.get(SERVICE) == null) {
            serviceContextMap.put(SERVICE, new Context(ARQ.getContext()));
        }
        Context serviceContext = (Context)serviceContextMap.get(SERVICE);
        try {
            serviceContext.put(Service.queryCompression, (Object)false);
            Query q = QueryFactory.create((String)"ASK { }");
            QueryEngineHTTP engine = QueryExecutionFactory.createServiceRequest((String)SERVICE, (Query)q);
            Assert.assertNotNull((Object)engine);
            Assert.assertEquals((long)-1L, (long)engine.getTimeout1());
            Assert.assertEquals((long)-1L, (long)engine.getTimeout2());
            Assert.assertFalse((boolean)engine.getAllowCompression());
            Assert.assertNull((Object)engine.getClient());
        }
        finally {
            serviceContext.remove(Service.queryCompression);
        }
    }

    @Test
    public void update_service_context_application_01() {
        Map serviceContextMap = (Map)ARQ.getContext().get(Service.serviceContext);
        if (serviceContextMap != null) {
            serviceContextMap.remove(SERVICE);
        }
        UpdateRequest updates = UpdateFactory.create((String)"CREATE GRAPH <http://example>");
        UpdateProcessRemoteBase engine = (UpdateProcessRemoteBase)UpdateExecutionFactory.createRemote((UpdateRequest)updates, (String)SERVICE);
        Assert.assertNotNull((Object)engine);
        Assert.assertNull((Object)engine.getClient());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void update_service_context_application_02() {
        Map serviceContextMap = (Map)ARQ.getContext().get(Service.serviceContext);
        if (serviceContextMap == null) {
            ARQ.getContext().put(Service.serviceContext, new HashMap());
            serviceContextMap = (Map)ARQ.getContext().get(Service.serviceContext);
        }
        if (serviceContextMap.get(SERVICE) == null) {
            serviceContextMap.put(SERVICE, new Context(ARQ.getContext()));
        }
        Context serviceContext = (Context)serviceContextMap.get(SERVICE);
        try {
            CloseableHttpClient testClient = HttpClients.custom().build();
            serviceContext.put(Service.queryClient, (Object)testClient);
            UpdateRequest updates = UpdateFactory.create((String)"CREATE GRAPH <http://example>");
            UpdateProcessRemoteBase engine = (UpdateProcessRemoteBase)UpdateExecutionFactory.createRemote((UpdateRequest)updates, (String)SERVICE);
            Assert.assertNotNull((Object)engine);
            Assert.assertEquals((Object)testClient, (Object)engine.getClient());
        }
        finally {
            serviceContext.remove(Service.queryClient);
        }
    }
}

