/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.data.DistinctDataBag;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterDistinct;
import org.apache.jena.sparql.engine.iterator.QueryIteratorBase;
import org.apache.jena.sparql.engine.main.OpExecutorFactory;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.Context;
import org.junit.Assert;
import org.junit.Test;

public class TestCancelDistinct {
    final Context params = new Context();
    final Graph activeGraph = null;
    final DatasetGraph dataset = null;
    final OpExecutorFactory factory = null;
    final ExecutionContext c = new ExecutionContext(this.params, this.activeGraph, this.dataset, this.factory);

    @Test
    public void testUnbaggedCancelPropagates() {
        ExecutionContext c = null;
        MockQueryIterator base = new MockQueryIterator();
        QueryIterDistinct d = new QueryIterDistinct((QueryIterator)base, c);
        Assert.assertFalse((boolean)base.getRequestingCancel());
        d.cancel();
        Assert.assertTrue((boolean)base.getRequestingCancel());
    }

    @Test
    public void testBaggedCancelPropagates() {
        this.params.set(ARQ.spillToDiskThreshold, (Object)0);
        MockQueryIterator base = new MockQueryIterator(new Binding[]{BindingFactory.create()});
        QueryIterDistinct d = new QueryIterDistinct((QueryIterator)base, this.c);
        Assert.assertNull((Object)d.db);
        Binding b = d.next();
        Assert.assertNotNull((Object)d.db);
        DistinctDataBag db = d.db;
        Assert.assertFalse((boolean)base.getRequestingCancel());
        d.cancel();
        Assert.assertTrue((boolean)base.getRequestingCancel());
    }

    @Test
    public void testCloseWhenNoBag() {
        this.params.set(ARQ.spillToDiskThreshold, (Object)0);
        MockQueryIterator base = new MockQueryIterator(new Binding[]{BindingFactory.create()});
        QueryIterDistinct d = new QueryIterDistinct((QueryIterator)base, this.c);
        Assert.assertNull((Object)d.db);
        d.close();
        Assert.assertNull((Object)d.db);
    }

    @Test
    public void testCloseWhenBagPresent() {
        this.params.set(ARQ.spillToDiskThreshold, (Object)0);
        MockQueryIterator base = new MockQueryIterator(new Binding[]{BindingFactory.create()});
        QueryIterDistinct d = new QueryIterDistinct((QueryIterator)base, this.c);
        Assert.assertNull((Object)d.db);
        Binding ignored = d.next();
        Assert.assertNotNull((Object)d.db);
        DistinctDataBag bag = d.db;
        d.close();
        Assert.assertTrue((boolean)bag.isClosed());
        Assert.assertNull((Object)d.db);
    }

    private final class MockQueryIterator
    extends QueryIteratorBase {
        Iterator<Binding> bindings;

        MockQueryIterator() {
            this(new ArrayList<Binding>());
        }

        MockQueryIterator(Binding ... bindings) {
            this(Arrays.asList(bindings));
        }

        MockQueryIterator(List<Binding> bindings) {
            this.bindings = bindings.iterator();
        }

        public void output(IndentedWriter out, SerializationContext sCxt) {
        }

        protected boolean hasNextBinding() {
            return this.bindings.hasNext();
        }

        protected Binding moveToNextBinding() {
            return this.bindings.next();
        }

        protected void closeIterator() {
        }

        protected void requestCancel() {
        }
    }
}

