/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.jena.atlas.data.DataBagExaminer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.query.SortCondition;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.ARQNotImplemented;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingComparator;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingMap;
import org.apache.jena.sparql.engine.iterator.QueryIterSort;
import org.apache.jena.sparql.engine.iterator.QueryIterTopN;
import org.apache.jena.sparql.engine.main.OpExecutorFactory;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.Context;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestQueryIterSort {
    private static final String LETTERS = "qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM";
    private Random random;
    private List<Binding> unsorted;
    private BindingComparator comparator;
    private CallbackIterator iterator;

    @Before
    public void setup() {
        this.random = new Random();
        Var[] vars = new Var[]{Var.alloc((String)"1"), Var.alloc((String)"2"), Var.alloc((String)"3"), Var.alloc((String)"4"), Var.alloc((String)"5"), Var.alloc((String)"6"), Var.alloc((String)"7"), Var.alloc((String)"8"), Var.alloc((String)"9"), Var.alloc((String)"0")};
        this.unsorted = new ArrayList<Binding>();
        for (int i = 0; i < 500; ++i) {
            this.unsorted.add(this.randomBinding(vars));
        }
        ArrayList<SortCondition> conditions = new ArrayList<SortCondition>();
        conditions.add(new SortCondition((Expr)new ExprVar("8"), 1));
        this.comparator = new BindingComparator(conditions);
        this.iterator = new CallbackIterator(this.unsorted.iterator(), 25, null);
        this.iterator.setCallback(new Callback(){

            @Override
            public void call() {
                throw new QueryCancelledException();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoSpill() {
        this.iterator.setCallback(() -> {});
        Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
        Context context = new Context();
        ExecutionContext executionContext = new ExecutionContext(context, (Graph)null, (DatasetGraph)null, (OpExecutorFactory)null);
        try (QueryIterSort qIter = new QueryIterSort((QueryIterator)this.iterator, (Comparator)this.comparator, executionContext);){
            Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
            Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
            qIter.hasNext();
            Assert.assertEquals((long)500L, (long)this.iterator.getReturnedElementCount());
            Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCleanAfterClose() {
        this.iterator.setCallback(() -> {});
        Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
        Context context = new Context();
        context.set(ARQ.spillToDiskThreshold, (Object)10L);
        ExecutionContext executionContext = new ExecutionContext(context, (Graph)null, (DatasetGraph)null, (OpExecutorFactory)null);
        try (QueryIterSort qIter = new QueryIterSort((QueryIterator)this.iterator, (Comparator)this.comparator, executionContext);){
            Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
            Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
            qIter.hasNext();
            Assert.assertEquals((long)500L, (long)this.iterator.getReturnedElementCount());
            Assert.assertEquals((long)49L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
        }
        Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
    }

    @Test
    public void testCloseClosesSourceIterator() {
        Context context = new Context();
        ExecutionContext ec = new ExecutionContext(context, (Graph)null, (DatasetGraph)null, (OpExecutorFactory)null);
        QueryIterSort qis = new QueryIterSort((QueryIterator)this.iterator, (Comparator)this.comparator, ec);
        qis.close();
        Assert.assertTrue((String)"source iterator should have been closed", (boolean)this.iterator.isClosed());
    }

    @Test
    public void testExhaustionClosesSourceIterator() {
        this.iterator.setCallback(() -> {});
        Context context = new Context();
        ExecutionContext ec = new ExecutionContext(context, (Graph)null, (DatasetGraph)null, (OpExecutorFactory)null);
        QueryIterSort qis = new QueryIterSort((QueryIterator)this.iterator, (Comparator)this.comparator, ec);
        while (qis.hasNext()) {
            qis.next();
        }
        Assert.assertTrue((String)"source iterator should have been closed", (boolean)this.iterator.isClosed());
    }

    @Test
    public void testCancelClosesSourceIterator() {
        Context context = new Context();
        ExecutionContext ec = new ExecutionContext(context, (Graph)null, (DatasetGraph)null, (OpExecutorFactory)null);
        QueryIterSort qis = new QueryIterSort((QueryIterator)this.iterator, (Comparator)this.comparator, ec);
        try {
            while (qis.hasNext()) {
                qis.next();
            }
            Assert.fail((String)"query should have been cancelled by trigger");
        }
        catch (QueryCancelledException q) {
            Assert.assertTrue((String)"source iterator should have been closed", (boolean)this.iterator.isClosed());
        }
    }

    @Test
    public void testCleanAfterExhaustion() {
        this.iterator.setCallback(() -> {});
        Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
        Context context = new Context();
        context.set(ARQ.spillToDiskThreshold, (Object)10L);
        ExecutionContext executionContext = new ExecutionContext(context, (Graph)null, (DatasetGraph)null, (OpExecutorFactory)null);
        QueryIterSort qIter = new QueryIterSort((QueryIterator)this.iterator, (Comparator)this.comparator, executionContext);
        Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
        Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
        qIter.hasNext();
        Assert.assertEquals((long)500L, (long)this.iterator.getReturnedElementCount());
        Assert.assertEquals((long)49L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
        while (qIter.hasNext()) {
            qIter.next();
        }
        Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
        qIter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=QueryCancelledException.class)
    public void testCancelInterruptsInitialisation() {
        Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
        Context context = new Context();
        context.set(ARQ.spillToDiskThreshold, (Object)10L);
        ExecutionContext executionContext = new ExecutionContext(context, (Graph)null, (DatasetGraph)null, (OpExecutorFactory)null);
        QueryIterSort qIter = new QueryIterSort((QueryIterator)this.iterator, (Comparator)this.comparator, executionContext);
        try {
            Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
            Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
            qIter.cancel();
            qIter.hasNext();
        }
        finally {
            Assert.assertTrue((boolean)this.iterator.isCanceled());
            Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
            Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
            qIter.close();
        }
        Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
    }

    @Test(expected=QueryCancelledException.class)
    public void testCancelInterruptsExternalSortAfterStartingIteration() {
        Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
        Context context = new Context();
        context.set(ARQ.spillToDiskThreshold, (Object)10L);
        ExecutionContext executionContext = new ExecutionContext(context, (Graph)null, (DatasetGraph)null, (OpExecutorFactory)null);
        try (QueryIterSort qIter = new QueryIterSort((QueryIterator)this.iterator, (Comparator)this.comparator, executionContext);){
            Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
            Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
            qIter.hasNext();
        }
        Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=QueryCancelledException.class)
    public void testCancelInterruptsExternalSortAtStartOfIteration() {
        this.iterator = new CallbackIterator(this.unsorted.iterator(), 25, null);
        this.iterator.setCallback(() -> {});
        Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
        Context context = new Context();
        context.set(ARQ.spillToDiskThreshold, (Object)10L);
        ExecutionContext executionContext = new ExecutionContext(context, (Graph)null, (DatasetGraph)null, (OpExecutorFactory)null);
        QueryIterSort qIter = new QueryIterSort((QueryIterator)this.iterator, (Comparator)this.comparator, executionContext);
        try {
            Assert.assertTrue((boolean)qIter.hasNext());
            Assert.assertEquals((long)49L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
            Assert.assertNotNull((Object)qIter.next());
            Assert.assertTrue((boolean)qIter.hasNext());
            qIter.cancel();
            qIter.hasNext();
        }
        finally {
            Assert.assertEquals((long)500L, (long)this.iterator.getReturnedElementCount());
            Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
            qIter.close();
        }
        Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
    }

    @Test
    public void testTopNCloseClosesSource() {
        long numItems = 3L;
        boolean distinct = false;
        Context context = new Context();
        ExecutionContext ec = new ExecutionContext(context, (Graph)null, (DatasetGraph)null, (OpExecutorFactory)null);
        QueryIterTopN tn = new QueryIterTopN((QueryIterator)this.iterator, (Comparator)this.comparator, numItems, distinct, ec);
        tn.close();
        Assert.assertTrue((boolean)this.iterator.isClosed());
    }

    @Test
    public void testTopNExhaustionClosesSource() {
        this.iterator.setCallback(() -> {});
        long numItems = 3L;
        boolean distinct = false;
        Context context = new Context();
        ExecutionContext ec = new ExecutionContext(context, (Graph)null, (DatasetGraph)null, (OpExecutorFactory)null);
        QueryIterTopN tn = new QueryIterTopN((QueryIterator)this.iterator, (Comparator)this.comparator, numItems, distinct, ec);
        while (tn.hasNext()) {
            tn.next();
        }
        Assert.assertTrue((boolean)this.iterator.isClosed());
    }

    private Binding randomBinding(Var[] vars) {
        BindingMap binding = BindingFactory.create();
        binding.add(vars[0], NodeFactory.createBlankNode());
        binding.add(vars[1], NodeFactory.createURI((String)this.randomURI()));
        binding.add(vars[2], NodeFactory.createURI((String)this.randomURI()));
        binding.add(vars[3], NodeFactory.createLiteral((String)this.randomString(20)));
        binding.add(vars[4], NodeFactory.createBlankNode());
        binding.add(vars[5], NodeFactory.createURI((String)this.randomURI()));
        binding.add(vars[6], NodeFactory.createURI((String)this.randomURI()));
        binding.add(vars[7], NodeFactory.createLiteral((String)this.randomString(5)));
        binding.add(vars[8], NodeFactory.createLiteral((String)("" + this.random.nextInt()), (RDFDatatype)XSDDatatype.XSDinteger));
        binding.add(vars[9], NodeFactory.createBlankNode());
        return binding;
    }

    private String randomURI() {
        return String.format("http://%s.example.com/%s", this.randomString(10), this.randomString(10));
    }

    private String randomString(int length) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append(LETTERS.charAt(this.random.nextInt(LETTERS.length())));
        }
        return builder.toString();
    }

    public static interface Callback {
        public void call();
    }

    private static class CallbackIterator
    implements QueryIterator {
        int elementsReturned = 0;
        Callback callback;
        int trigger;
        Iterator<Binding> delegate;
        boolean canceled = false;
        boolean closed = false;

        public CallbackIterator(Iterator<Binding> delegate, int trigger, Callback callback) {
            this.delegate = delegate;
            this.callback = callback;
            this.trigger = trigger;
        }

        public void setCallback(Callback callback) {
            this.callback = callback;
        }

        public boolean hasNext() {
            boolean has = this.delegate.hasNext();
            if (!has) {
                this.closed = true;
            }
            return has;
        }

        public Binding next() {
            if (this.elementsReturned++ >= this.trigger) {
                this.callback.call();
            }
            return this.delegate.next();
        }

        public void remove() {
            this.delegate.remove();
        }

        public int getReturnedElementCount() {
            return this.elementsReturned;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public Binding nextBinding() {
            if (this.elementsReturned++ >= this.trigger) {
                this.callback.call();
            }
            return this.delegate.next();
        }

        public void cancel() {
            this.canceled = true;
        }

        public void close() {
            this.closed = true;
        }

        public void output(IndentedWriter out, SerializationContext sCxt) {
            throw new ARQNotImplemented();
        }

        public String toString(PrefixMapping pmap) {
            throw new ARQNotImplemented();
        }

        public void output(IndentedWriter out) {
            throw new ARQNotImplemented();
        }
    }
}

