/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.impl.GraphPlain;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingComparator;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingMap;
import org.apache.jena.sparql.engine.iterator.QueryIterSort;
import org.apache.jena.sparql.engine.iterator.QueryIteratorBase;
import org.apache.jena.sparql.engine.main.OpExecutor;
import org.apache.jena.sparql.engine.main.OpExecutorFactory;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.Context;
import org.junit.Assert;
import org.junit.Test;

public class TestSortedDataBagCancellation {
    static final BindingMap b1 = BindingFactory.create();
    static final BindingMap b2 = BindingFactory.create();
    static final BindingMap b3 = BindingFactory.create();
    static final BindingMap b4 = BindingFactory.create();
    final Context params = new Context();
    final OpExecutorFactory factory = new OpExecutorFactory(){

        public OpExecutor create(ExecutionContext ec) {
            throw new UnsupportedOperationException();
        }
    };
    final Graph activeGraph = GraphPlain.plain();
    final DatasetGraph dataset = DatasetGraphFactory.create();
    final List<SortCondition> conditions = new ArrayList<SortCondition>();
    final ExecutionContext ec = new ExecutionContext(this.params, this.activeGraph, this.dataset, this.factory);
    final BindingComparator base_bc = new BindingComparator(this.conditions, this.ec);
    final SpecialBindingComparator bc = new SpecialBindingComparator(this.base_bc, this.ec);
    QueryIteratorItems baseIter = new QueryIteratorItems();
    QueryIterSort qs;

    public TestSortedDataBagCancellation() {
        this.baseIter.bindings.add((Binding)b1);
        this.baseIter.bindings.add((Binding)b2);
        this.baseIter.bindings.add((Binding)b3);
        this.baseIter.bindings.add((Binding)b4);
        this.qs = new QueryIterSort((QueryIterator)this.baseIter, (Comparator)((Object)this.bc), this.ec);
    }

    @Test
    public void testIteratesToCompletion() {
        int count = 0;
        count = this.bc.count;
        Assert.assertEquals((long)0L, (long)count);
        HashSet<Binding> results = new HashSet<Binding>();
        Assert.assertTrue((boolean)this.qs.hasNext());
        Assert.assertTrue((this.bc.count >= count ? 1 : 0) != 0);
        count = this.bc.count;
        results.add(this.qs.next());
        Assert.assertTrue((boolean)this.qs.hasNext());
        Assert.assertTrue((this.bc.count >= count ? 1 : 0) != 0);
        count = this.bc.count;
        results.add(this.qs.next());
        Assert.assertTrue((boolean)this.qs.hasNext());
        Assert.assertTrue((this.bc.count >= count ? 1 : 0) != 0);
        count = this.bc.count;
        results.add(this.qs.next());
        Assert.assertTrue((boolean)this.qs.hasNext());
        Assert.assertTrue((this.bc.count >= count ? 1 : 0) != 0);
        count = this.bc.count;
        results.add(this.qs.next());
        Assert.assertFalse((boolean)this.qs.hasNext());
        HashSet<BindingMap> expected = new HashSet<BindingMap>();
        expected.add(b1);
        expected.add(b2);
        expected.add(b3);
        expected.add(b4);
        Assert.assertEquals(expected, results);
    }

    @Test
    public void testIteratesWithCancellation() {
        int count = 0;
        count = this.bc.count;
        Assert.assertEquals((long)0L, (long)count);
        HashSet<Binding> results = new HashSet<Binding>();
        Assert.assertTrue((boolean)this.qs.hasNext());
        Assert.assertTrue((this.bc.count >= count ? 1 : 0) != 0);
        count = this.bc.count;
        results.add(this.qs.next());
        this.qs.cancel();
        try {
            this.bc.noMoreCalls();
            while (this.qs.hasNext()) {
                this.qs.next();
            }
        }
        catch (QueryCancelledException qe) {
            Assert.assertTrue((boolean)this.qs.db.isCancelled());
            return;
        }
        Assert.fail((String)"query was not cancelled");
    }

    static {
        b1.add(Var.alloc((String)"v1"), NodeFactory.createLiteral((String)"alpha"));
        b2.add(Var.alloc((String)"v2"), NodeFactory.createLiteral((String)"beta"));
        b3.add(Var.alloc((String)"v3"), NodeFactory.createLiteral((String)"gamma"));
        b4.add(Var.alloc((String)"v4"), NodeFactory.createLiteral((String)"delta"));
    }

    static class SpecialBindingComparator
    extends BindingComparator {
        final BindingComparator base;
        int count = 0;
        boolean trapCompare = false;

        public SpecialBindingComparator(BindingComparator base, ExecutionContext ec) {
            super(base.getConditions(), ec);
            this.base = base;
        }

        public void noMoreCalls() {
            this.trapCompare = true;
        }

        public int compare(Binding x, Binding y) {
            if (this.trapCompare) {
                throw new RuntimeException("compare() no longer allowed.");
            }
            ++this.count;
            return this.base.compare(x, y);
        }
    }

    private static final class QueryIteratorItems
    extends QueryIteratorBase {
        List<Binding> bindings = new ArrayList<Binding>();
        int index = 0;

        private QueryIteratorItems() {
        }

        public void output(IndentedWriter out, SerializationContext sCxt) {
            out.write("a QueryIteratorItems");
        }

        protected boolean hasNextBinding() {
            return this.index < this.bindings.size();
        }

        protected Binding moveToNextBinding() {
            ++this.index;
            return this.bindings.get(this.index - 1);
        }

        protected void closeIterator() {
        }

        protected void requestCancel() {
        }
    }
}

