/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import org.apache.jena.graph.Node;
import org.apache.jena.query.ARQ;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.function.FunctionEnvBase;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.junit.Assert;

public class LibTestExpr {
    private static PrefixMapping pmap = new PrefixMappingImpl();

    static void testExpr(String exprExpected, String expectedResult) {
        NodeValue actual = LibTestExpr.eval(exprExpected);
        NodeValue expected = LibTestExpr.eval(expectedResult);
        Assert.assertEquals((String)exprExpected, (Object)expected, (Object)actual);
    }

    static Expr parse(String exprString) {
        return ExprUtils.parse((String)exprString, (PrefixMapping)pmap);
    }

    public static FunctionEnv createTest() {
        Context cxt = ARQ.getContext().copy();
        cxt.set(ARQConstants.sysCurrentTime, (Object)NodeFactoryExtra.nowAsDateTime());
        return new FunctionEnvBase(cxt);
    }

    static NodeValue eval(String exprString) {
        Expr expr = ExprUtils.parse((String)exprString, (PrefixMapping)pmap);
        NodeValue result = expr.eval(null, (FunctionEnv)new FunctionEnvBase());
        return result;
    }

    static void test(String exprString, String result) {
        Node r = NodeFactoryExtra.parseNode((String)result);
        LibTestExpr.test(exprString, r);
    }

    static void test(String exprString, Node result) {
        Expr expr = ExprUtils.parse((String)exprString, (PrefixMapping)pmap);
        NodeValue actual = expr.eval(null, (FunctionEnv)new FunctionEnvBase());
        NodeValue expected = NodeValue.makeNode((Node)result);
        Assert.assertTrue((String)("Expected = " + expected + " : Actual = " + actual), (boolean)NodeValue.sameAs((NodeValue)expected, (NodeValue)actual));
    }

    static void testDouble(String exprString, String result, double delta) {
        Node r = NodeFactoryExtra.parseNode((String)result);
        LibTestExpr.testDouble(exprString, r, delta);
    }

    static void testDouble(String exprString, Node result, double delta) {
        Expr expr = ExprUtils.parse((String)exprString, (PrefixMapping)pmap);
        NodeValue actual = expr.eval(null, (FunctionEnv)new FunctionEnvBase());
        NodeValue expected = NodeValue.makeNode((Node)result);
        if (NodeValue.sameAs((NodeValue)expected, (NodeValue)actual)) {
            return;
        }
        LibTestExpr.testDouble(exprString, expected.getDouble(), delta);
    }

    static void testDouble(String exprString, double expected, double delta) {
        Expr expr = ExprUtils.parse((String)exprString, (PrefixMapping)pmap);
        NodeValue actual = expr.eval(null, (FunctionEnv)new FunctionEnvBase());
        Assert.assertTrue((String)("Not a double: " + actual), (boolean)actual.isDouble());
        double result = actual.getDouble();
        if (Double.isInfinite(expected)) {
            Assert.assertTrue((String)("Expected INF: Got " + result), (boolean)Double.isInfinite(result));
            return;
        }
        if (Double.isNaN(expected)) {
            Assert.assertTrue((String)("Expected NaN: Got " + result), (boolean)Double.isNaN(result));
            return;
        }
        double difference = Math.abs(result - expected);
        Assert.assertTrue((String)("Values not within given delta " + delta + ": Expected = " + expected + " : Actual = " + actual), (difference <= delta ? 1 : 0) != 0);
    }

    static void testError(String exprString) {
        Expr expr = ExprUtils.parse((String)exprString, (PrefixMapping)pmap);
        expr.eval(null, (FunctionEnv)new FunctionEnvBase());
    }

    static {
        pmap.setNsPrefixes(ARQConstants.getGlobalPrefixMap());
        pmap.setNsPrefix("lfn", "http://www.dotnetrdf.org/leviathan#");
    }
}

