/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.function.Predicate;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprException;
import org.apache.jena.sparql.expr.LibTestExpr;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.util.ExprUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestFunctions {
    private static final NodeValue INT_ZERO = NodeValue.makeInteger((long)0L);
    private static final NodeValue INT_ONE = NodeValue.makeInteger((long)1L);
    private static final NodeValue TRUE = NodeValue.TRUE;
    private static final NodeValue FALSE = NodeValue.FALSE;
    String hw_ka = "\uff76";
    String hw_ten = "\uff9f";
    static Node xyz_en = NodeFactory.createLiteral((String)"xyz", (String)"en");
    static NodeValue nv_xyz_en = NodeValue.makeNode((Node)xyz_en);
    static Node xyz_xsd_string = NodeFactory.createLiteral((String)"xyz", (RDFDatatype)XSDDatatype.XSDstring);
    static NodeValue nv_xyz_string = NodeValue.makeNode((Node)xyz_xsd_string);
    static Node n_uri = NodeFactory.createURI((String)"http://example/");
    static NodeValue nv_uri = NodeValue.makeNode((Node)n_uri);

    @Test
    public void expr1() {
        this.test("1", NodeValue.makeInteger((long)1L));
    }

    @Test
    public void exprStrLen1() {
        this.test("fn:string-length('')", INT_ZERO);
    }

    @Test
    public void exprStrLen2() {
        this.test("fn:string-length('a')", INT_ONE);
    }

    @Test
    public void exprStrLen3() {
        this.test("fn:string-length('\ud801\udc08\ud801\udc4c\ud801\udc3b\ud801\udc2a\ud801\udc49\ud801\udc3f\ud801\udc3b\ud801\udc2e\ud801\udc3f\ud801\udc32')", NodeValue.makeInteger((long)10L));
    }

    @Test
    public void exprSubstring1() {
        this.test("fn:substring('',0)", NodeValue.makeString((String)""));
    }

    @Test
    public void exprSubstring2() {
        this.test("fn:substring('',1)", NodeValue.makeString((String)""));
    }

    @Test
    public void exprSubstring3() {
        this.test("fn:substring('',1,0)", NodeValue.makeString((String)""));
    }

    @Test
    public void exprSubstring4() {
        this.test("fn:substring('',1,1)", NodeValue.makeString((String)""));
    }

    @Test
    public void exprSubstring5() {
        this.test("fn:substring('abc',1)", NodeValue.makeString((String)"abc"));
    }

    @Test
    public void exprSubstring6() {
        this.test("fn:substring('abc',2)", NodeValue.makeString((String)"bc"));
    }

    @Test
    public void exprSubstring7() {
        this.test("fn:substring('a',1,1)", NodeValue.makeString((String)"a"));
    }

    @Test
    public void exprSubstring8() {
        this.test("fn:substring('a',1,2)", NodeValue.makeString((String)"a"));
    }

    @Test
    public void exprSubstring9() {
        this.test("fn:substring('a',0)", NodeValue.makeString((String)""));
    }

    @Test
    public void exprSubstring10() {
        this.test("fn:substring('abc',1.6,1.33)", NodeValue.makeString((String)"b"));
    }

    @Test
    public void exprSubstring11() {
        this.test("fn:substring('abc',-1, -15.3)", NodeValue.makeString((String)""));
    }

    @Test
    public void exprSubstring12() {
        this.test("fn:substring('\ud801\udc08\ud801\udc4c\ud801\udc3b\ud801\udc2a\ud801\udc49\ud801\udc3f\ud801\udc3b\ud801\udc2e\ud801\udc3f\ud801\udc32', 1, 1)", NodeValue.makeString((String)"\ud801\udc08"));
    }

    @Test
    public void exprJavaSubstring1() {
        this.test("afn:substr('abc',0,0)", NodeValue.makeString((String)""));
    }

    @Test
    public void exprJavaSubstring2() {
        this.test("afn:substr('abc',0,1)", NodeValue.makeString((String)"a"));
    }

    @Test
    public void exprJavaSubstring3() {
        this.test("<java:org.apache.jena.sparql.function.library.substr>('abc',0,0)", NodeValue.makeString((String)""));
    }

    @Test
    public void exprJavaSubstring4() {
        this.test("<java:org.apache.jena.sparql.function.library.substr>('abc',0,1)", NodeValue.makeString((String)"a"));
    }

    @Test
    public void exprJavaSubstring5() {
        this.test("afn:substr('\ud801\udc08\ud801\udc4c\ud801\udc3b\ud801\udc2a\ud801\udc49\ud801\udc3f\ud801\udc3b\ud801\udc2e\ud801\udc3f\ud801\udc32', 0, 1)", NodeValue.makeString((String)"\ud801\udc08"));
    }

    @Test
    public void exprSprintf_01() {
        this.test("afn:sprintf('%06d', 11)", NodeValue.makeString((String)"000011"));
    }

    @Test
    public void exprSprintf_02() {
        this.test("afn:sprintf('%s', 'abcdefghi')", NodeValue.makeString((String)"abcdefghi"));
    }

    @Test
    public void exprSprintf_03() {
        this.test("afn:sprintf('sometext %s', 'abcdefghi')", NodeValue.makeString((String)"sometext abcdefghi"));
    }

    @Test
    public void exprSprintf_04() {
        this.test("afn:sprintf('%1$tm %1$te,%1$tY', '2016-03-17'^^xsd:date)", NodeValue.makeString((String)"03 17,2016"));
    }

    @Test
    public void exprSprintf_06() {
        this.test("afn:sprintf('this is %s', 'false'^^xsd:boolean)", NodeValue.makeString((String)"this is false"));
    }

    @Test
    public void exprSprintf_07() {
        this.test("afn:sprintf('this number is equal to %.2f', '11.22'^^xsd:decimal)", NodeValue.makeString((String)("this number is equal to " + String.format("%.2f", 11.22))));
    }

    @Test
    public void exprSprintf_08() {
        this.test("afn:sprintf('%.3f', '1.23456789'^^xsd:float)", NodeValue.makeString((String)String.format("%.3f", 1.23456789)));
    }

    @Test
    public void exprSprintf_09() {
        this.test("afn:sprintf('this number is equal to %o in the octal system', '11'^^xsd:integer)", NodeValue.makeString((String)"this number is equal to 13 in the octal system"));
    }

    @Test
    public void exprSprintf_10() {
        this.test("afn:sprintf('this number is equal to %.5f', '1.23456789'^^xsd:double)", NodeValue.makeString((String)("this number is equal to " + String.format("%.5f", 1.23456789))));
    }

    @Test
    public void exprSprintf_11() {
        this.test("afn:sprintf('%.0f != %s', '12.23456789'^^xsd:double,'15')", NodeValue.makeString((String)"12 != 15"));
    }

    @Test
    public void exprSprintf_12() {
        this.test("afn:sprintf('(%.0f,%s,%d) %4$tm %4$te,%4$tY', '12.23456789'^^xsd:double,'12',11,'2016-03-17'^^xsd:date)", NodeValue.makeString((String)"(12,12,11) 03 17,2016"));
    }

    @Test
    public void exprSprintf_20() {
        TestFunctions.test_exprSprintf_tz_exact("2005-10-14T14:09:43-11:00");
    }

    @Test
    public void exprSprintf_21() {
        TestFunctions.test_exprSprintf_tz_exact("2005-10-14T12:09:43+00:00");
    }

    @Test
    public void exprSprintf_22() {
        TestFunctions.test_exprSprintf_tz_exact("2005-10-14T10:09:43+11:00");
    }

    private static void test_exprSprintf_tz_exact(String nodeStr) {
        String exprStr = "afn:sprintf('%1$tm %1$te,%1$tY', " + NodeValue.makeDateTime((String)nodeStr).toString() + ")";
        Expr expr = ExprUtils.parse((String)exprStr);
        NodeValue r = expr.eval(null, LibTestExpr.createTest());
        Assert.assertTrue((boolean)r.isString());
        String s = r.getString();
        String dtFormat = "yyyy-MM-dd'T'HH:mm:ssXXX";
        SimpleDateFormat sdtFormat = new SimpleDateFormat(dtFormat);
        Date dtDate = null;
        try {
            dtDate = sdtFormat.parse(nodeStr);
        }
        catch (ParseException e) {
            Assert.assertFalse((String)("Cannot parse the input date string. Message:" + e.getMessage()), (boolean)false);
        }
        SimpleDateFormat stdFormatOut = new SimpleDateFormat("MM dd,yyyy");
        stdFormatOut.setTimeZone(TimeZone.getDefault());
        String outDate = stdFormatOut.format(dtDate);
        Assert.assertEquals((Object)s, (Object)outDate);
    }

    private static void test_exprSprintf_tz_possibilites(String nodeStr, String ... possible) {
        String exprStr = "afn:sprintf('%1$tm %1$te,%1$tY', " + NodeValue.makeDateTime((String)nodeStr).toString() + ")";
        Expr expr = ExprUtils.parse((String)exprStr);
        NodeValue r = expr.eval(null, LibTestExpr.createTest());
        Assert.assertTrue((boolean)r.isString());
        String s = r.getString();
        boolean b = false;
        for (String poss : possible) {
            if (!poss.equals(s)) continue;
            b = true;
        }
        Assert.assertTrue((boolean)b);
    }

    @Test
    public void exprSprintf_23() {
        TestFunctions.test_exprSprintf_tz_possibilites("2005-10-14T14:09:43-11:00", "10 14,2005", "10 15,2005");
    }

    @Test
    public void exprSprintf_24() {
        TestFunctions.test_exprSprintf_tz_possibilites("2005-10-14T12:09:43Z", "10 13,2005", "10 14,2005", "10 15,2005");
    }

    @Test
    public void exprSprintf_25() {
        TestFunctions.test_exprSprintf_tz_possibilites("2005-10-14T10:09:43+11:00", "10 13,2005", "10 14,2005");
    }

    @Test
    public void exprStrStart0() {
        this.test("fn:starts-with('abc', '')", TRUE);
    }

    @Test
    public void exprStrStart1() {
        this.test("fn:starts-with('abc', 'a')", TRUE);
    }

    @Test
    public void exprStrStart2() {
        this.test("fn:starts-with('abc', 'ab')", TRUE);
    }

    @Test
    public void exprStrStart3() {
        this.test("fn:starts-with('abc', 'abc')", TRUE);
    }

    @Test
    public void exprStrStart4() {
        this.test("fn:starts-with('abc', 'abcd')", FALSE);
    }

    @Test
    public void exprStrStart10() {
        this.test("STRSTARTS('abc', 'abcd')", FALSE);
    }

    @Test
    public void exprStrStart11() {
        this.test("STRSTARTS('abc'@en, 'ab')", TRUE);
    }

    @Test
    public void exprStrStart12() {
        this.test("STRSTARTS('abc'^^xsd:string, 'ab')", TRUE);
    }

    @Test
    public void exprStrStart13() {
        this.test("STRSTARTS('abc'^^xsd:string, 'ab'^^xsd:string)", TRUE);
    }

    @Test
    public void exprStrStart14() {
        this.test("STRSTARTS('abc', 'ab'^^xsd:string)", TRUE);
    }

    @Test
    public void exprStrStart15() {
        this.test("STRSTARTS('abc'@en, 'ab'@en)", TRUE);
    }

    @Test
    public void exprStrStart16() {
        this.testEvalException("STRSTARTS('ab'@en, 'ab'@fr)");
    }

    @Test
    public void exprStrStart17() {
        this.testEvalException("STRSTARTS(123, 'ab'@fr)");
    }

    @Test
    public void exprStrStart18() {
        this.testEvalException("STRSTARTS('123'^^xsd:string, 12.3)");
    }

    @Test
    public void exprStrBefore0() {
        this.test("STRBEFORE('abc', 'abcd')", NodeValue.nvEmptyString);
    }

    @Test
    public void exprStrBefore1() {
        this.test("STRBEFORE('abc'@en, 'b')", NodeValue.makeNode((String)"a", (String)"en", (String)null));
    }

    @Test
    public void exprStrBefore2() {
        this.test("STRBEFORE('abc'^^xsd:string, 'c')", NodeValue.makeNode((String)"ab", (RDFDatatype)XSDDatatype.XSDstring));
    }

    @Test
    public void exprStrBefore3() {
        this.test("STRBEFORE('abc'^^xsd:string, ''^^xsd:string)", NodeValue.makeNode((String)"", (RDFDatatype)XSDDatatype.XSDstring));
    }

    @Test
    public void exprStrBefore4() {
        this.test("STRBEFORE('abc', 'ab'^^xsd:string)", NodeValue.nvEmptyString);
    }

    @Test
    public void exprStrBefore5() {
        this.test("STRBEFORE('abc'@en, 'b'@en)", NodeValue.makeNode((String)"a", (String)"en", (String)null));
    }

    @Test
    public void exprStrBefore6() {
        this.testEvalException("STRBEFORE('ab'@en, 'ab'@fr)");
    }

    @Test
    public void exprStrBefore7() {
        this.testEvalException("STRBEFORE(123, 'ab'@fr)");
    }

    @Test
    public void exprStrBefore8() {
        this.testEvalException("STRBEFORE('123'^^xsd:string, 12.3)");
    }

    @Test
    public void exprStrBefore9() {
        this.test("STRBEFORE('abc'^^xsd:string, 'z')", NodeValue.nvEmptyString);
    }

    @Test
    public void exprStrBefore10() {
        this.test("STRBEFORE('abc'^^xsd:string, '')", NodeValue.makeNode((String)"", (RDFDatatype)XSDDatatype.XSDstring));
    }

    @Test
    public void exprStrAfter0() {
        this.test("STRAFTER('abc', 'abcd')", NodeValue.nvEmptyString);
    }

    @Test
    public void exprStrAfter1() {
        this.test("STRAFTER('abc'@en, 'b')", NodeValue.makeNode((String)"c", (String)"en", (String)null));
    }

    @Test
    public void exprStrAfter2() {
        this.test("STRAFTER('abc'^^xsd:string, 'a')", NodeValue.makeNode((String)"bc", (RDFDatatype)XSDDatatype.XSDstring));
    }

    @Test
    public void exprStrAfter3() {
        this.test("STRAFTER('abc'^^xsd:string, ''^^xsd:string)", NodeValue.makeNode((String)"abc", (RDFDatatype)XSDDatatype.XSDstring));
    }

    @Test
    public void exprStrAfter4() {
        this.test("STRAFTER('abc', 'bc'^^xsd:string)", NodeValue.nvEmptyString);
    }

    @Test
    public void exprStrAfter5() {
        this.test("STRAFTER('abc'@en, 'b'@en)", NodeValue.makeNode((String)"c", (String)"en", (String)null));
    }

    @Test
    public void exprStrAfter6() {
        this.testEvalException("STRAFTER('ab'@en, 'ab'@fr)");
    }

    @Test
    public void exprStrAfter7() {
        this.testEvalException("STRAFTER(123, 'ab'@fr)");
    }

    @Test
    public void exprStrAfter8() {
        this.testEvalException("STRAFTER('123'^^xsd:string, 12.3)");
    }

    @Test
    public void exprStrAfter9() {
        this.test("STRAFTER('abc'^^xsd:string, 'z')", NodeValue.nvEmptyString);
    }

    @Test
    public void exprStrAfter10() {
        this.test("STRAFTER('abc'^^xsd:string, '')", NodeValue.makeNode((String)"abc", (RDFDatatype)XSDDatatype.XSDstring));
    }

    @Test
    public void exprStrEnds0() {
        this.test("fn:ends-with('abc', '')", TRUE);
    }

    @Test
    public void exprStrEnds1() {
        this.test("fn:ends-with('abc', 'c')", TRUE);
    }

    @Test
    public void exprStrEnds2() {
        this.test("fn:ends-with('abc', 'bc')", TRUE);
    }

    @Test
    public void exprStrEnds3() {
        this.test("fn:ends-with('abc', 'abc')", TRUE);
    }

    @Test
    public void exprStrEnds4() {
        this.test("fn:ends-with('abc', 'zabc')", FALSE);
    }

    @Test
    public void exprStrEnds10() {
        this.test("STRENDS('abc', 'abcd')", FALSE);
    }

    @Test
    public void exprStrEnds11() {
        this.test("STRENDS('abc'@en, 'bc')", TRUE);
    }

    @Test
    public void exprStrEnds12() {
        this.test("STRENDS('abc'^^xsd:string, 'c')", TRUE);
    }

    @Test
    public void exprStrEnds13() {
        this.test("STRENDS('abc'^^xsd:string, 'c'^^xsd:string)", TRUE);
    }

    @Test
    public void exprStrEnds14() {
        this.test("STRENDS('abc', 'ab'^^xsd:string)", FALSE);
    }

    @Test
    public void exprStrEnds15() {
        this.test("STRENDS('abc'@en, 'abc'@en)", TRUE);
    }

    @Test
    public void exprStrEnds16() {
        this.testEvalException("STRENDS('ab'@en, 'ab'@fr)");
    }

    @Test
    public void exprStrEnds17() {
        this.testEvalException("STRENDS(123, 'ab'@fr)");
    }

    @Test
    public void exprStrEnds18() {
        this.testEvalException("STRENDS('123'^^xsd:string, 12.3)");
    }

    @Test
    public void exprStrCase1() {
        this.test("fn:lower-case('aBc')", NodeValue.makeString((String)"abc"));
    }

    @Test
    public void exprStrCase2() {
        this.test("fn:lower-case('abc')", NodeValue.makeString((String)"abc"));
    }

    @Test
    public void exprStrCase3() {
        this.test("fn:upper-case('abc')", NodeValue.makeString((String)"ABC"));
    }

    @Test
    public void exprStrCase4() {
        this.test("fn:upper-case('ABC')", NodeValue.makeString((String)"ABC"));
    }

    @Test
    public void exprStrContains0() {
        this.test("fn:contains('abc', '')", TRUE);
    }

    @Test
    public void exprStrContains1() {
        this.test("fn:contains('abc', 'a')", TRUE);
    }

    @Test
    public void exprStrContains2() {
        this.test("fn:contains('abc', 'b')", TRUE);
    }

    @Test
    public void exprStrContains3() {
        this.test("fn:contains('abc', 'c')", TRUE);
    }

    @Test
    public void exprStrContains4() {
        this.test("fn:contains('abc', 'ab')", TRUE);
    }

    @Test
    public void exprStrContains5() {
        this.test("fn:contains('abc', 'bc')", TRUE);
    }

    @Test
    public void exprStrContains6() {
        this.test("fn:contains('abc', 'abc')", TRUE);
    }

    @Test
    public void exprStrContains7() {
        this.test("fn:contains('abc', 'Xc')", FALSE);
    }

    @Test
    public void exprStrContains8() {
        this.test("fn:contains('abc', 'Xa')", FALSE);
    }

    @Test
    public void exprContains10() {
        this.test("Contains('abc', 'abcd')", FALSE);
    }

    @Test
    public void exprContains11() {
        this.test("Contains('abc'@en, 'bc')", TRUE);
    }

    @Test
    public void exprContains12() {
        this.test("Contains('abc'^^xsd:string, 'c')", TRUE);
    }

    @Test
    public void exprContains13() {
        this.test("Contains('abc'^^xsd:string, 'c'^^xsd:string)", TRUE);
    }

    @Test
    public void exprContains14() {
        this.test("Contains('abc', 'z'^^xsd:string)", FALSE);
    }

    @Test
    public void exprContains15() {
        this.test("Contains('abc'@en, 'abc'@en)", TRUE);
    }

    @Test
    public void exprContains16() {
        this.testEvalException("Contains('ab'@en, 'ab'@fr)");
    }

    @Test
    public void exprContains17() {
        this.testEvalException("Contains(123, 'ab'@fr)");
    }

    @Test
    public void exprContains18() {
        this.testEvalException("STRENDS('123'^^xsd:string, 12.3)");
    }

    @Test
    public void exprStrNormalizeSpace0() {
        this.test("fn:normalize-space(' The    wealthy curled darlings                                         of    our    nation. ')", NodeValue.makeString((String)"The wealthy curled darlings of our nation."));
    }

    @Test
    public void exprStrNormalizeSpace1() {
        this.test("fn:normalize-space('')", NodeValue.nvEmptyString);
    }

    @Test
    public void exprStrNormalizeSpace2() {
        this.test("fn:normalize-space('   Aaa     ')", NodeValue.makeString((String)"Aaa"));
    }

    @Test
    public void exprStrNormalizeSpace3() {
        this.test("fn:normalize-space('A a   a    a a    ')", NodeValue.makeString((String)"A a a a a"));
    }

    @Test
    public void exprStrNormalizeUnicode0() {
        this.test("fn:normalize-unicode('\u00c4ffin','nfd')", NodeValue.makeString((String)"A\u0308ffin"));
    }

    @Test
    public void exprStrNormalizeUnicode1() {
        this.test("fn:normalize-unicode('\u00c4ffin','nfc')", NodeValue.makeString((String)"\u00c4ffin"));
    }

    @Test
    public void exprStrNormalizeUnicode2() {
        this.test("fn:normalize-unicode('\u00c4\\uFB03n','nfd')", NodeValue.makeString((String)"A\u0308\ufb03n"));
    }

    @Test
    public void exprStrNormalizeUnicode3() {
        this.test("fn:normalize-unicode('\u00c4\\uFB03n','nfc')", NodeValue.makeString((String)"\u00c4\ufb03n"));
    }

    @Test
    public void exprStrNormalizeUnicode4() {
        this.test("fn:normalize-unicode('Henry IV','nfd')", NodeValue.makeString((String)"Henry IV"));
    }

    @Test
    public void exprStrNormalizeUnicode5() {
        this.test("fn:normalize-unicode('Henry IV','nfc')", NodeValue.makeString((String)"Henry IV"));
    }

    @Test
    public void exprStrNormalizeUnicode6() {
        this.test("fn:normalize-unicode('\u00c4ffin','nfkd')", NodeValue.makeString((String)"A\u0308ffin"));
    }

    @Test
    public void exprStrNormalizeUnicode7() {
        this.test("fn:normalize-unicode('\u00c4ffin','nfkc')", NodeValue.makeString((String)"\u00c4ffin"));
    }

    @Test
    public void exprStrNormalizeUnicode8() {
        this.test("fn:normalize-unicode('" + this.hw_ka + this.hw_ten + "','nfd')", NodeValue.makeString((String)(this.hw_ka + this.hw_ten)));
    }

    @Test
    public void exprStrNormalizeUnicode9() {
        this.test("fn:normalize-unicode('" + this.hw_ka + this.hw_ten + "','nfc')", NodeValue.makeString((String)(this.hw_ka + this.hw_ten)));
    }

    @Test
    public void exprStrNormalizeUnicode12() {
        this.test("fn:normalize-unicode('some word','')", NodeValue.makeString((String)"some word"));
    }

    @Test
    public void exprStrNormalizeUnicode13() {
        this.test("fn:normalize-unicode('\u00c4ffin')", NodeValue.makeString((String)"\u00c4ffin"));
    }

    @Test
    public void exprReplace01() {
        this.test("REPLACE('abc', 'b', 'Z')", NodeValue.makeString((String)"aZc"));
    }

    @Test
    public void exprReplace02() {
        this.test("REPLACE('abc', 'b.', 'Z')", NodeValue.makeString((String)"aZ"));
    }

    @Test
    public void exprReplace03() {
        this.test("REPLACE('abcbd', 'b.', 'Z')", NodeValue.makeString((String)"aZZ"));
    }

    @Test
    public void exprReplace04() {
        this.test("REPLACE('abcbd'^^xsd:string, 'b.', 'Z')", NodeValue.makeNode((String)"aZZ", (RDFDatatype)XSDDatatype.XSDstring));
    }

    @Test
    public void exprReplace05() {
        this.test("REPLACE('abcbd'@en, 'b.', 'Z')", NodeValue.makeNode((String)"aZZ", (String)"en", (String)null));
    }

    @Test
    public void exprReplace06() {
        this.test("REPLACE('abcbd', 'B.', 'Z', 'i')", NodeValue.makeString((String)"aZZ"));
    }

    @Test
    public void exprReplace07() {
        this.test("REPLACE('abc', '.*', 'Z')", NodeValue.makeString((String)"Z"));
    }

    @Test
    public void exprReplace08() {
        this.test("REPLACE('', '.*', 'Z')", NodeValue.makeString((String)"Z"));
    }

    @Test
    public void exprReplace09() {
        this.test("REPLACE('abc', '.?', 'Z')", NodeValue.makeString((String)"ZZZ"));
    }

    @Test
    public void exprReplace10() {
        this.test("REPLACE('abc', 'XXX', 'Z')", NodeValue.makeString((String)"abc"));
    }

    @Test
    public void exprReplace11() {
        this.test("REPLACE('', '.', 'Z')", NodeValue.makeString((String)""));
    }

    @Test
    public void exprReplace12() {
        this.test("REPLACE('', '(a|b)?', 'Z')", NodeValue.makeString((String)"Z"));
    }

    @Test
    public void exprFnReplace01() {
        this.test("fn:replace('abc', 'b', 'Z')", NodeValue.makeString((String)"aZc"));
    }

    @Test
    public void exprFnReplace02() {
        this.test("fn:replace('abc', 'b.', 'Z')", NodeValue.makeString((String)"aZ"));
    }

    @Test
    public void exprFnReplace03() {
        this.test("fn:replace('abcbd', 'b.', 'Z')", NodeValue.makeString((String)"aZZ"));
    }

    @Test
    public void exprFnReplace04() {
        this.test("fn:replace('abcbd'^^xsd:string, 'b.', 'Z')", NodeValue.makeNode((String)"aZZ", (RDFDatatype)XSDDatatype.XSDstring));
    }

    @Test
    public void exprFnReplace05() {
        this.test("fn:replace('abcbd'@en, 'b.', 'Z')", NodeValue.makeNode((String)"aZZ", (String)"en", (String)null));
    }

    @Test
    public void exprFnReplace06() {
        this.test("fn:replace('abcbd', 'B.', 'Z', 'i')", NodeValue.makeString((String)"aZZ"));
    }

    @Test
    public void exprReplace13() {
        this.testEvalException("REPLACE('abc', '.*', '$1')");
    }

    @Test(expected=ExprException.class)
    public void exprReplace14() {
        ExprUtils.parse((String)"REPLACE('abc', '^(a){-9}', 'ABC')");
    }

    @Test
    public void exprReplace15() {
        this.testEvalException("fn:replace('abc', '^(a){-9}', 'ABC')");
    }

    @Test
    public void exprBoolean1() {
        this.test("fn:boolean('')", FALSE);
    }

    @Test
    public void exprBoolean2() {
        this.test("fn:boolean(0)", FALSE);
    }

    @Test
    public void exprBoolean3() {
        this.test("fn:boolean(''^^xsd:string)", FALSE);
    }

    @Test
    public void exprBoolean4() {
        this.test("fn:boolean('X')", TRUE);
    }

    @Test
    public void exprBoolean5() {
        this.test("fn:boolean('X'^^xsd:string)", TRUE);
    }

    @Test
    public void exprBoolean6() {
        this.test("fn:boolean(1)", TRUE);
    }

    @Test
    public void exprBoolean7() {
        this.test("fn:not('')", TRUE);
    }

    @Test
    public void exprBoolean8() {
        this.test("fn:not('X')", FALSE);
    }

    @Test
    public void exprBoolean9() {
        this.test("fn:not(1)", FALSE);
    }

    @Test
    public void exprBoolean10() {
        this.test("fn:not(0)", TRUE);
    }

    @Test
    public void exprRound_01() {
        this.test("fn:round(123)", NodeValue.makeInteger((long)123L));
    }

    @Test
    public void exprRound_02() {
        this.test("fn:round(123.5)", NodeValue.makeDecimal((long)124L));
    }

    @Test
    public void exprRound_03() {
        this.test("fn:round(-0.5e0)", NodeValue.makeDouble((double)0.0));
    }

    @Test
    public void exprRound_04() {
        this.test("fn:round(-1.5)", NodeValue.makeDecimal((long)-1L));
    }

    @Test
    public void exprRound_05() {
        this.test("fn:round(-0)", NodeValue.makeInteger((String)"-0"));
    }

    @Test
    public void exprRound_06() {
        this.test("fn:round(1.125, 2)", NodeValue.makeDecimal((double)1.13));
    }

    @Test
    public void exprRound_07() {
        this.test("fn:round(8452, -2)", NodeValue.makeInteger((long)8500L));
    }

    @Test
    public void exprRound_08() {
        this.test("fn:round(3.1415e0, 2)", NodeValue.makeDouble((double)3.14));
    }

    @Test
    public void exprRound_09() {
        this.test("fn:round(35.425e0, 2)", NodeValue.makeDouble((double)35.42));
    }

    @Test
    public void exprRoundHalfEven_01() {
        this.test("fn:round-half-to-even(0.5)", NodeValue.makeDecimal((long)0L));
    }

    @Test
    public void exprRoundHalfEven_02() {
        this.test("fn:round-half-to-even(1.5)", NodeValue.makeDecimal((long)2L));
    }

    @Test
    public void exprRoundHalfEven_03() {
        this.test("fn:round-half-to-even(2.5)", NodeValue.makeDecimal((long)2L));
    }

    @Test
    public void exprRoundHalfEven_04() {
        this.test("fn:round-half-to-even(3.567812e+3, 2)", NodeValue.makeDouble((double)3567.81));
    }

    @Test
    public void exprRoundHalfEven_05() {
        this.test("fn:round-half-to-even(-0)", NodeValue.makeInteger((long)0L));
    }

    @Test
    public void exprRoundHalfEven_06() {
        this.test("fn:round-half-to-even(4.7564e-3, 2)", NodeValue.makeDouble((double)0.0));
    }

    @Test
    public void exprRoundHalfEven_07() {
        this.test("fn:round-half-to-even(35612.25, -2)", NodeValue.makeDecimal((long)35600L));
    }

    @Test
    public void exprRoundHalfEven_08() {
        this.test("fn:round-half-to-even('150.015'^^xsd:float, 2)", NodeValue.makeFloat((float)150.01f));
    }

    private String getDynamicDurationString() {
        int tzOffset = TimeZone.getDefault().getOffset(new Date().getTime()) / 60000;
        String off = "PT" + Math.abs(tzOffset) + "M";
        if (tzOffset < 0) {
            off = "-" + off;
        }
        return off;
    }

    @Test
    public void exprAdjustDatetimeToTz_01() {
        this.testEqual("fn:adjust-dateTime-to-timezone('2002-03-07T10:00:00'^^xsd:dateTime)", "fn:adjust-dateTime-to-timezone('2002-03-07T10:00:00'^^xsd:dateTime,'" + this.getDynamicDurationString() + "'^^xsd:dayTimeDuration)");
    }

    @Test
    public void exprAdjustDatetimeToTz_02() {
        this.testEqual("fn:adjust-dateTime-to-timezone('2002-03-07T10:00:00-07:00'^^xsd:dateTime)", "fn:adjust-dateTime-to-timezone('2002-03-07T10:00:00-07:00'^^xsd:dateTime,'" + this.getDynamicDurationString() + "'^^xsd:dayTimeDuration)");
    }

    @Test
    public void exprAdjustDatetimeToTz_03() {
        this.test("fn:adjust-dateTime-to-timezone('2002-03-07T10:00:00'^^xsd:dateTime,'-PT10H'^^xsd:dayTimeDuration)", NodeValue.makeDateTime((String)"2002-03-07T10:00:00-10:00"));
    }

    @Test
    public void exprAdjustDatetimeToTz_04() {
        this.test("fn:adjust-dateTime-to-timezone('2002-03-07T10:00:00-07:00'^^xsd:dateTime,'-PT10H'^^xsd:dayTimeDuration)", NodeValue.makeDateTime((String)"2002-03-07T07:00:00-10:00"));
    }

    @Test
    public void exprAdjustDatetimeToTz_05() {
        this.test("fn:adjust-dateTime-to-timezone('2002-03-07T10:00:00-07:00'^^xsd:dateTime,'PT10H'^^xsd:dayTimeDuration)", NodeValue.makeDateTime((String)"2002-03-08T03:00:00+10:00"));
    }

    @Test
    public void exprAdjustDatetimeToTz_06() {
        this.test("fn:adjust-dateTime-to-timezone('2002-03-07T00:00:00+01:00'^^xsd:dateTime,'-PT8H'^^xsd:dayTimeDuration)", NodeValue.makeDateTime((String)"2002-03-06T15:00:00-08:00"));
    }

    @Test
    public void exprAdjustDatetimeToTz_07() {
        this.test("fn:adjust-dateTime-to-timezone('2002-03-07T10:00:00'^^xsd:dateTime,'')", NodeValue.makeDateTime((String)"2002-03-07T10:00:00"));
    }

    @Test
    public void exprAdjustDatetimeToTz_08() {
        this.test("fn:adjust-dateTime-to-timezone('2002-03-07T10:00:00-07:00'^^xsd:dateTime,'')", NodeValue.makeDateTime((String)"2002-03-07T10:00:00"));
    }

    @Test
    public void exprAdjustDateToTz_01() {
        this.testEqual("fn:adjust-date-to-timezone('2002-03-07'^^xsd:date)", "fn:adjust-date-to-timezone('2002-03-07'^^xsd:date,'" + this.getDynamicDurationString() + "'^^xsd:dayTimeDuration)");
    }

    @Test
    public void exprAdjustDateToTz_02() {
        this.testEqual("fn:adjust-date-to-timezone('2002-03-07-07:00'^^xsd:date)", "fn:adjust-date-to-timezone('2002-03-07-07:00'^^xsd:date,'" + this.getDynamicDurationString() + "'^^xsd:dayTimeDuration)");
    }

    @Test
    public void exprAdjustDateToTz_03() {
        this.test("fn:adjust-date-to-timezone('2002-03-07'^^xsd:date,'-PT10H'^^xsd:dayTimeDuration)", NodeValue.makeDate((String)"2002-03-07-10:00"));
    }

    @Test
    public void exprAdjustDateToTz_04() {
        this.test("fn:adjust-date-to-timezone('2002-03-07-07:00'^^xsd:date,'-PT10H'^^xsd:dayTimeDuration)", NodeValue.makeDate((String)"2002-03-06-10:00"));
    }

    @Test
    public void exprAdjustDateToTz_05() {
        this.test("fn:adjust-date-to-timezone('2002-03-07'^^xsd:date,'')", NodeValue.makeDate((String)"2002-03-07"));
    }

    @Test
    public void exprAdjustDateToTz_06() {
        this.test("fn:adjust-date-to-timezone('2002-03-07-07:00'^^xsd:date,'')", NodeValue.makeDate((String)"2002-03-07"));
    }

    @Test
    public void exprAdjustTimeToTz_01() {
        this.testEqual("fn:adjust-time-to-timezone('10:00:00'^^xsd:time)", "fn:adjust-time-to-timezone('10:00:00'^^xsd:time,'" + this.getDynamicDurationString() + "'^^xsd:dayTimeDuration)");
    }

    @Test
    public void exprAdjustTimeToTz_02() {
        this.testEqual("fn:adjust-time-to-timezone('10:00:00-07:00'^^xsd:time)", "fn:adjust-time-to-timezone('10:00:00-07:00'^^xsd:time,'" + this.getDynamicDurationString() + "'^^xsd:dayTimeDuration)");
    }

    @Test
    public void exprAdjustTimeToTz_03() {
        this.test("fn:adjust-time-to-timezone('10:00:00'^^xsd:time,'-PT10H'^^xsd:dayTimeDuration)", NodeValue.makeNode((String)"10:00:00-10:00", (RDFDatatype)XSDDatatype.XSDtime));
    }

    @Test
    public void exprAdjustTimeToTz_04() {
        this.test("fn:adjust-time-to-timezone('10:00:00-07:00'^^xsd:time,'-PT10H'^^xsd:dayTimeDuration)", NodeValue.makeNode((String)"07:00:00-10:00", (RDFDatatype)XSDDatatype.XSDtime));
    }

    @Test
    public void exprAdjustTimeToTz_05() {
        this.test("fn:adjust-time-to-timezone('10:00:00'^^xsd:time,'')", NodeValue.makeNode((String)"10:00:00", (RDFDatatype)XSDDatatype.XSDtime));
    }

    @Test
    public void exprAdjustTimeToTz_06() {
        this.test("fn:adjust-time-to-timezone('10:00:00-07:00'^^xsd:time,'')", NodeValue.makeNode((String)"10:00:00", (RDFDatatype)XSDDatatype.XSDtime));
    }

    @Test
    public void exprAdjustTimeToTz_07() {
        this.test("fn:adjust-time-to-timezone('10:00:00-07:00'^^xsd:time,'PT10H'^^xsd:dayTimeDuration)", NodeValue.makeNode((String)"03:00:00+10:00", (RDFDatatype)XSDDatatype.XSDtime));
    }

    @Test
    public void localTimezone_1() {
        this.test("fn:implicit-timezone()", (NodeValue nv) -> nv.isDayTimeDuration());
    }

    @Test
    public void localTimezone_2() {
        this.test("afn:timezone()", (NodeValue nv) -> nv.isDayTimeDuration());
    }

    @Test
    public void localDateTime_1() {
        this.test("afn:nowtz()", (NodeValue nv) -> nv.isDateTime());
    }

    @Test
    public void localDateTime_2() {
        this.test("afn:nowtz()", (NodeValue nv) -> nv.getDateTime().getTimezone() >= -840);
    }

    @Test
    public void localDateTime_3() {
        this.test("afn:nowtz() = NOW()", NodeValue.TRUE);
    }

    private static void testNumberFormat(String expression, String expected) {
        Expr expr = ExprUtils.parse((String)expression);
        NodeValue r = expr.eval(null, LibTestExpr.createTest());
        Assert.assertTrue((boolean)r.isString());
        Assert.assertEquals((Object)expected, (Object)r.getString());
    }

    @Test
    public void formatNumber_01() {
        TestFunctions.testNumberFormat("fn:format-number(0,'#')", "0");
    }

    @Test
    public void formatNumber_02() {
        TestFunctions.testNumberFormat("fn:format-number(1234, '#')", "1234");
    }

    @Test
    public void formatNumber_03() {
        TestFunctions.testNumberFormat("fn:format-number(1234, '#,###')", "1,234");
    }

    @Test
    public void formatNumber_04() {
        TestFunctions.testNumberFormat("fn:format-number(1e3, '#,###,###.#')", "1,000");
    }

    @Test
    public void formatNumber_05() {
        TestFunctions.testNumberFormat("fn:format-number(10.5, '##.#')", "10.5");
    }

    @Test
    public void formatNumber_06() {
        TestFunctions.testNumberFormat("fn:format-number(-10.5, '##.##')", "-10.5");
    }

    @Test
    public void formatNumber_08() {
        TestFunctions.testNumberFormat("fn:format-number(123, 'NotAPattern')", "NotAPattern123");
    }

    @Test
    public void formatNumber_11() {
        TestFunctions.testNumberFormat("fn:format-number(0, '#', 'fr')", "0");
    }

    @Test
    public void formatNumber_12() {
        TestFunctions.testNumberFormat("fn:format-number(1234.5,'#,###.#', 'fr')", "1\u00a0234,5");
    }

    @Test
    public void formatNumber_13() {
        TestFunctions.testNumberFormat("fn:format-number(1234.5,'#,###.#', 'de')", "1.234,5");
    }

    @Test
    public void formatNumber_14() {
        TestFunctions.testNumberFormat("fn:format-number(12, '0,000.0', 'en')", "0,012.0");
    }

    @Test
    public void formatNumber_15() {
        TestFunctions.testNumberFormat("fn:format-number(0, '00,000', 'fr')", "00\u00a0000");
    }

    @Test(expected=ExprEvalException.class)
    public void formatNumber_20() {
        TestFunctions.testNumberFormat("fn:format-number('String', '#')", null);
    }

    @Test(expected=ExprEvalException.class)
    public void formatNumber_21() {
        TestFunctions.testNumberFormat("fn:format-number(123, <uri>)", null);
    }

    @Test(expected=ExprEvalException.class)
    public void formatNumber_22() {
        TestFunctions.testNumberFormat("fn:format-number(123, '###', 123)", null);
    }

    public void formatNumber_23() {
        TestFunctions.testNumberFormat("fn:format-number(123, '###', 'WhereAmI?')", null);
    }

    @Test
    public void exprSameTerm1() {
        this.test("sameTerm(1,1)", TRUE);
    }

    @Test
    public void exprSameTerm2() {
        this.test("sameTerm(1,1.0)", FALSE);
    }

    @Test
    public void exprSameTerm3() {
        this.test("sameTerm(1,1e0)", FALSE);
    }

    @Test
    public void exprSameTerm4() {
        this.test("sameTerm(<_:a>, <_:a>)", TRUE);
    }

    @Test
    public void exprSameTerm5() {
        this.test("sameTerm(<x>, <x>)", TRUE);
    }

    @Test
    public void exprSameTerm6() {
        this.test("sameTerm(<x>, <y>)", FALSE);
    }

    @Test
    public void exprOneOf_01() {
        this.test("57 in (xsd:integer, '123')", FALSE);
    }

    @Test
    public void exprOneOf_02() {
        this.test("57 in (57)", TRUE);
    }

    @Test
    public void exprOneOf_03() {
        this.test("57 in (123, 57)", TRUE);
    }

    @Test
    public void exprOneOf_04() {
        this.test("57 in (57, 456)", TRUE);
    }

    @Test
    public void exprOneOf_05() {
        this.test("57 in (123, 57, 456)", TRUE);
    }

    @Test
    public void exprOneOf_06() {
        this.test("57 in (1,2,3)", FALSE);
    }

    @Test
    public void exprNotOneOf_01() {
        this.test("57 not in (xsd:integer, '123')", TRUE);
    }

    @Test
    public void exprNotOneOf_02() {
        this.test("57 not in (57)", FALSE);
    }

    @Test
    public void exprNotOneOf_03() {
        this.test("57 not in (123, 57)", FALSE);
    }

    @Test
    public void exprNotOneOf_04() {
        this.test("57 not in (57, 456)", FALSE);
    }

    @Test
    public void exprNotOneOf_05() {
        this.test("57 not in (123, 57, 456)", FALSE);
    }

    @Test
    public void exprNotOneOf_06() {
        this.test("57 not in (1,2,3)", TRUE);
    }

    @Test
    public void exprStrLang1() {
        this.test("strlang('xyz', 'en')", nv_xyz_en);
    }

    @Test
    public void exprStrDatatype1() {
        this.test("strdt('123', xsd:integer)", NodeValue.makeInteger((long)123L));
    }

    @Test
    public void exprStrDatatype2() {
        this.test("strdt('xyz', xsd:string)", nv_xyz_string);
    }

    @Test
    public void exprStrDatatype3() {
        this.testEvalException("strdt('123', 'datatype')");
    }

    @Test
    public void exprIRI1() {
        this.test("iri('http://example/')", nv_uri);
    }

    private void test(String exprStr, NodeValue result) {
        Expr expr = ExprUtils.parse((String)exprStr);
        NodeValue r = expr.eval(null, LibTestExpr.createTest());
        Assert.assertEquals((Object)result, (Object)r);
    }

    private void test(String exprStr, Predicate<NodeValue> test) {
        Expr expr = ExprUtils.parse((String)exprStr);
        NodeValue r = expr.eval(null, LibTestExpr.createTest());
        Assert.assertTrue((String)exprStr, (boolean)test.test(r));
    }

    private void testEqual(String exprStr, String exprStrExpected) {
        Expr expr = ExprUtils.parse((String)exprStrExpected);
        NodeValue rExpected = expr.eval(null, LibTestExpr.createTest());
        this.test(exprStr, rExpected);
    }

    private void testEvalException(String exprStr) {
        Expr expr = ExprUtils.parse((String)exprStr);
        try {
            NodeValue r = expr.eval(null, LibTestExpr.createTest());
            Assert.fail((String)"No exception raised");
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
    }
}

