/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.graph.Node;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.function.FunctionEnvBase;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestFunctions2
extends BaseTest {
    static boolean warnOnBadLexicalForms = true;
    private static PrefixMapping pmap = ARQConstants.getGlobalPrefixMap();

    @BeforeClass
    public static void beforeClass() {
        warnOnBadLexicalForms = NodeValue.VerboseWarnings;
        NodeValue.VerboseWarnings = false;
    }

    @AfterClass
    public static void afterClass() {
        NodeValue.VerboseWarnings = warnOnBadLexicalForms;
    }

    @Test
    public void round_01() {
        TestFunctions2.test("round(123)", "123");
    }

    @Test
    public void round_02() {
        TestFunctions2.test("round(123.5)", "'124'^^xsd:decimal");
    }

    @Test
    public void round_03() {
        TestFunctions2.test("round(-0.5e0)", "0.0e0");
    }

    @Test
    public void round_04() {
        TestFunctions2.test("round(-1.5)", "'-1'^^xsd:decimal");
    }

    @Test
    public void round_05() {
        TestFunctions2.test("round(-0)", "-0");
    }

    @Test
    public void abs_01() {
        TestFunctions2.test("abs(1)", "1");
    }

    @Test
    public void abs_02() {
        TestFunctions2.test("abs(1.0)", "1.0");
    }

    @Test
    public void abs_03() {
        TestFunctions2.test("abs(1.0e0)", "1.0e0");
    }

    @Test
    public void abs_04() {
        TestFunctions2.test("abs(-1)", "1");
    }

    @Test
    public void abs_05() {
        TestFunctions2.test("abs(+0)", "0");
    }

    @Test
    public void abs_06() {
        TestFunctions2.test("abs(-0)", "0");
    }

    @Test
    public void ceil_01() {
        TestFunctions2.test("ceil(1)", "1");
    }

    @Test
    public void ceil_02() {
        TestFunctions2.test("ceil(1.0)", "'1'^^xsd:decimal");
    }

    @Test
    public void ceil_03() {
        TestFunctions2.test("ceil(1e0)", "1.0e0");
    }

    @Test
    public void ceil_04() {
        TestFunctions2.test("ceil(1.5e0)", "2.0e0");
    }

    @Test
    public void ceil_05() {
        TestFunctions2.test("ceil(-0.9)", "'0'^^xsd:decimal");
    }

    @Test
    public void ceil_06() {
        TestFunctions2.test("ceil(-9)", "-9");
    }

    @Test
    public void ceil_07() {
        TestFunctions2.test("ceil(-9.5)", "'-9'^^xsd:decimal");
    }

    @Test
    public void ceil_08() {
        TestFunctions2.test("ceil(0)", "0");
    }

    @Test
    public void floor_01() {
        TestFunctions2.test("floor(1)", "1");
    }

    @Test
    public void floor_02() {
        TestFunctions2.test("floor(1.0)", "'1'^^xsd:decimal");
    }

    @Test
    public void floor_03() {
        TestFunctions2.test("floor(1e0)", "1.0e0");
    }

    @Test
    public void floor_04() {
        TestFunctions2.test("floor(1.5e0)", "1.0e0");
    }

    @Test
    public void floor_05() {
        TestFunctions2.test("floor(-0.9)", "'-1'^^xsd:decimal");
    }

    @Test
    public void floor_06() {
        TestFunctions2.test("floor(-9)", "-9");
    }

    @Test
    public void floor_07() {
        TestFunctions2.test("floor(-9.5)", "'-10'^^xsd:decimal");
    }

    @Test
    public void floor_08() {
        TestFunctions2.test("floor(0)", "0");
    }

    @Test
    public void concat_01() {
        TestFunctions2.test("concat('a')", "'a'");
    }

    @Test
    public void concat_02() {
        TestFunctions2.test("concat('a', 'b')", "'ab'");
    }

    @Test
    public void concat_03() {
        TestFunctions2.test("concat('a'@en, 'b')", "'ab'");
    }

    @Test
    public void concat_04() {
        TestFunctions2.test("concat('a'@en, 'b'@en)", "'ab'@en");
    }

    @Test
    public void concat_05() {
        TestFunctions2.test("concat('a'^^xsd:string, 'b')", "'ab'");
    }

    @Test
    public void concat_06() {
        TestFunctions2.test("concat('a'^^xsd:string, 'b'^^xsd:string)", "'ab'^^xsd:string");
    }

    @Test
    public void concat_07() {
        TestFunctions2.test("concat('a'^^xsd:string, 'b'^^xsd:string)", "'ab'^^xsd:string");
    }

    @Test
    public void concat_08() {
        TestFunctions2.test("concat('a', 'b'^^xsd:string)", "'ab'");
    }

    @Test
    public void concat_09() {
        TestFunctions2.test("concat('a'@en, 'b'^^xsd:string)", "'ab'");
    }

    @Test
    public void concat_10() {
        TestFunctions2.test("concat('a'^^xsd:string, 'b'@en)", "'ab'");
    }

    @Test
    public void concat_11() {
        TestFunctions2.test("concat()", "''");
    }

    @Test(expected=ExprEvalException.class)
    public void concat_90() {
        TestFunctions2.test("concat(1)", "1");
    }

    @Test
    public void concat_91() {
        TestFunctions2.test("concat('a'@en, 'b'@fr)", "'ab'");
    }

    @Test
    public void substr_01() {
        TestFunctions2.test("substr('abc',1)", "'abc'");
    }

    @Test
    public void substr_02() {
        TestFunctions2.test("substr('abc',2)", "'bc'");
    }

    @Test
    public void substr_03() {
        TestFunctions2.test("substr('abc',2,1)", "'b'");
    }

    @Test
    public void substr_04() {
        TestFunctions2.test("substr('abc',2,0)", "''");
    }

    @Test
    public void substr_05() {
        TestFunctions2.test("substr('12345',0,3)", "'12'");
    }

    @Test
    public void substr_06() {
        TestFunctions2.test("substr('12345',-1,3)", "'1'");
    }

    @Test
    public void substr_10() {
        TestFunctions2.test("substr('motor car', 6)", "' car'");
    }

    @Test
    public void substr_11() {
        TestFunctions2.test("substr('metadata', 4, 3)", "'ada'");
    }

    @Test
    public void substr_12() {
        TestFunctions2.test("substr('12345', 1.5, 2.6)", "'234'");
    }

    @Test
    public void substr_13() {
        TestFunctions2.test("substr('12345', 0, 3)", "'12'");
    }

    @Test
    public void substr_14() {
        TestFunctions2.test("substr('12345', 5, -3)", "''");
    }

    @Test
    public void substr_15() {
        TestFunctions2.test("substr('12345', -3, 5)", "'1'");
    }

    @Test
    public void substr_16() {
        TestFunctions2.test("substr('12345', 0/0E0, 3)", "''");
    }

    @Test
    public void substr_17() {
        TestFunctions2.test("substr('12345', 1, 0/0E0)", "''");
    }

    @Test
    public void substr_18() {
        TestFunctions2.test("substr('', 1, 3)", "''");
    }

    @Test(expected=ExprEvalException.class)
    public void substr_20() {
        TestFunctions2.test("substr(1, 1, 3)", "''");
    }

    @Test(expected=ExprEvalException.class)
    public void substr_21() {
        TestFunctions2.test("substr('', 'one', 3)", "''");
    }

    @Test(expected=ExprEvalException.class)
    public void substr_22() {
        TestFunctions2.test("substr('', 1, 'three')", "''");
    }

    @Test
    public void strlen_01() {
        TestFunctions2.test("strlen('abc')", "3");
    }

    @Test
    public void strlen_02() {
        TestFunctions2.test("strlen('')", "0");
    }

    @Test
    public void ucase_01() {
        TestFunctions2.test("ucase('abc')", "'ABC'");
    }

    @Test
    public void ucase_02() {
        TestFunctions2.test("ucase('ABC')", "'ABC'");
    }

    @Test
    public void ucase_03() {
        TestFunctions2.test("ucase('Ab 123 Cd')", "'AB 123 CD'");
    }

    @Test
    public void ucase_04() {
        TestFunctions2.test("ucase('')", "''");
    }

    @Test
    public void lcase_01() {
        TestFunctions2.test("lcase('abc')", "'abc'");
    }

    @Test
    public void lcase_02() {
        TestFunctions2.test("lcase('ABC')", "'abc'");
    }

    @Test
    public void lcase_03() {
        TestFunctions2.test("lcase('Ab 123 Cd')", "'ab 123 cd'");
    }

    @Test
    public void lcase_04() {
        TestFunctions2.test("lcase('')", "''");
    }

    @Test
    public void encodeURI_01() {
        TestFunctions2.test("encode_for_uri('a:b cd/~')", "'a%3Ab%20cd%2F~'");
    }

    @Test
    public void encodeURI_02() {
        TestFunctions2.test("encode_for_uri('\\n')", "'%0A'");
    }

    @Test
    public void encodeURI_03() {
        TestFunctions2.test("encode_for_uri('\\t')", "'%09'");
    }

    @Test
    public void encodeURI_04() {
        TestFunctions2.test("encode_for_uri('abc')", "'abc'");
    }

    @Test
    public void encodeURI_05() {
        TestFunctions2.test("encode_for_uri('abc'@en)", "'abc'");
    }

    @Test(expected=ExprEvalException.class)
    public void encodeURI_09() {
        TestFunctions2.test("encode_for_uri(1234)", "'1234'");
    }

    @Test
    public void contains_01() {
        TestFunctions2.test("contains('abc', 'a')", "true");
    }

    @Test
    public void contains_02() {
        TestFunctions2.test("contains('abc', 'b')", "true");
    }

    @Test
    public void contains_03() {
        TestFunctions2.test("contains('ABC', 'a')", "false");
    }

    @Test
    public void contains_04() {
        TestFunctions2.test("contains('abc', '')", "true");
    }

    @Test
    public void contains_05() {
        TestFunctions2.test("contains('', '')", "true");
    }

    @Test
    public void contains_06() {
        TestFunctions2.test("contains('', 'a')", "false");
    }

    @Test
    public void contains_07() {
        TestFunctions2.test("contains('12345', '34')", "true");
    }

    @Test
    public void contains_08() {
        TestFunctions2.test("contains('12345', '123456')", "false");
    }

    @Test
    public void contains_10() {
        TestFunctions2.test("contains('abc', 'a'^^xsd:string)", "true");
    }

    @Test(expected=ExprEvalException.class)
    public void contains_11() {
        TestFunctions2.test("contains('abc', 'a'@en)", "true");
    }

    @Test
    public void contains_12() {
        TestFunctions2.test("contains('abc'@en, 'a')", "true");
    }

    @Test
    public void contains_13() {
        TestFunctions2.test("contains('abc'@en, 'a'^^xsd:string)", "true");
    }

    @Test
    public void contains_14() {
        TestFunctions2.test("contains('abc'@en, 'a'@en)", "true");
    }

    @Test(expected=ExprEvalException.class)
    public void contains_15() {
        TestFunctions2.test("contains('abc'@en, 'a'@fr)", "true");
    }

    @Test
    public void contains_16() {
        TestFunctions2.test("contains('abc'^^xsd:string, 'a')", "true");
    }

    @Test(expected=ExprEvalException.class)
    public void contains_17() {
        TestFunctions2.test("contains('abc'^^xsd:string, 'a'@en)", "true");
    }

    @Test
    public void contains_18() {
        TestFunctions2.test("contains('abc'^^xsd:string, 'a'^^xsd:string)", "true");
    }

    @Test(expected=ExprEvalException.class)
    public void contains_20() {
        TestFunctions2.test("contains(1816, 'a'^^xsd:string)", "true");
    }

    @Test(expected=ExprEvalException.class)
    public void contains_21() {
        TestFunctions2.test("contains('abc', 1066)", "true");
    }

    @Test
    public void strstarts_01() {
        TestFunctions2.test("strstarts('abc', 'a')", "true");
    }

    @Test
    public void strstarts_02() {
        TestFunctions2.test("strstarts('abc', 'b')", "false");
    }

    @Test
    public void strstarts_03() {
        TestFunctions2.test("strstarts('ABC', 'a')", "false");
    }

    @Test
    public void strstarts_04() {
        TestFunctions2.test("strstarts('abc', '')", "true");
    }

    @Test
    public void strstarts_05() {
        TestFunctions2.test("strstarts('', '')", "true");
    }

    @Test
    public void strstarts_06() {
        TestFunctions2.test("strstarts('', 'a')", "false");
    }

    @Test
    public void strstarts_10() {
        TestFunctions2.test("strstarts('abc', 'a'^^xsd:string)", "true");
    }

    @Test(expected=ExprEvalException.class)
    public void strstarts_11() {
        TestFunctions2.test("strstarts('abc', 'a'@en)", "true");
    }

    @Test
    public void strstarts_12() {
        TestFunctions2.test("strstarts('abc'@en, 'a')", "true");
    }

    @Test
    public void strstarts_13() {
        TestFunctions2.test("strstarts('abc'@en, 'a'^^xsd:string)", "true");
    }

    @Test
    public void strstarts_14() {
        TestFunctions2.test("strstarts('abc'@en, 'a'@en)", "true");
    }

    @Test(expected=ExprEvalException.class)
    public void strstarts_15() {
        TestFunctions2.test("strstarts('abc'@en, 'a'@fr)", "true");
    }

    @Test
    public void strstarts_16() {
        TestFunctions2.test("strstarts('abc'^^xsd:string, 'a')", "true");
    }

    @Test(expected=ExprEvalException.class)
    public void strstarts_17() {
        TestFunctions2.test("strstarts('abc'^^xsd:string, 'a'@en)", "true");
    }

    @Test
    public void strstarts_18() {
        TestFunctions2.test("strstarts('abc'^^xsd:string, 'a'^^xsd:string)", "true");
    }

    @Test(expected=ExprEvalException.class)
    public void strstarts_20() {
        TestFunctions2.test("strstarts(1816, 'a'^^xsd:string)", "true");
    }

    @Test(expected=ExprEvalException.class)
    public void strstarts_21() {
        TestFunctions2.test("strstarts('abc', 1066)", "true");
    }

    @Test
    public void strends_01() {
        TestFunctions2.test("strends('abc', 'c')", "true");
    }

    @Test
    public void strends_02() {
        TestFunctions2.test("strends('abc', 'b')", "false");
    }

    @Test
    public void strends_03() {
        TestFunctions2.test("strends('ABC', 'c')", "false");
    }

    @Test
    public void strends_04() {
        TestFunctions2.test("strends('abc', '')", "true");
    }

    @Test
    public void strends_05() {
        TestFunctions2.test("strends('', '')", "true");
    }

    @Test
    public void strends_06() {
        TestFunctions2.test("strends('', 'a')", "false");
    }

    @Test
    public void strends_10() {
        TestFunctions2.test("strends('abc', 'c'^^xsd:string)", "true");
    }

    @Test(expected=ExprEvalException.class)
    public void strends11() {
        TestFunctions2.test("strends('abc', 'c'@en)", "true");
    }

    @Test
    public void strends_12() {
        TestFunctions2.test("strends('abc'@en, 'c')", "true");
    }

    @Test
    public void strends_13() {
        TestFunctions2.test("strends('abc'@en, 'c'^^xsd:string)", "true");
    }

    @Test
    public void strends_14() {
        TestFunctions2.test("strends('abc'@en, 'c'@en)", "true");
    }

    @Test(expected=ExprEvalException.class)
    public void strends_15() {
        TestFunctions2.test("strends('abc'@en, 'c'@fr)", "true");
    }

    @Test
    public void strends_16() {
        TestFunctions2.test("strends('abc'^^xsd:string, 'bc')", "true");
    }

    @Test(expected=ExprEvalException.class)
    public void strends_17() {
        TestFunctions2.test("strends('abc'^^xsd:string, 'a'@en)", "true");
    }

    @Test
    public void strends_18() {
        TestFunctions2.test("strends('abc'^^xsd:string, 'abc'^^xsd:string)", "true");
    }

    @Test(expected=ExprEvalException.class)
    public void strends_20() {
        TestFunctions2.test("strends(1816, '6'^^xsd:string)", "true");
    }

    @Test(expected=ExprEvalException.class)
    public void strends_21() {
        TestFunctions2.test("strends('abc', 1066)", "true");
    }

    @Test
    public void year_01() {
        TestFunctions2.test("year('2010-12-24T16:24:01.123'^^xsd:dateTime)", "2010");
    }

    @Test
    public void year_02() {
        TestFunctions2.test("year('2010-12-24'^^xsd:date)", "2010");
    }

    @Test
    public void year_03() {
        TestFunctions2.test("year('2010'^^xsd:gYear)", "2010");
    }

    @Test
    public void year_04() {
        TestFunctions2.test("year('2010-12'^^xsd:gYearMonth)", "2010");
    }

    @Test(expected=ExprEvalException.class)
    public void year_05() {
        TestFunctions2.test("year('--12'^^xsd:gMonth)", "2010");
    }

    @Test(expected=ExprEvalException.class)
    public void year_06() {
        TestFunctions2.test("year('--12-24'^^xsd:gMonthDay)", "2010");
    }

    @Test(expected=ExprEvalException.class)
    public void year_07() {
        TestFunctions2.test("year('---24'^^xsd:gDay)", "2010");
    }

    @Test
    public void year_11() {
        TestFunctions2.test("year('2010-12-24T16:24:01.123Z'^^xsd:dateTime)", "2010");
    }

    @Test
    public void year_12() {
        TestFunctions2.test("year('2010-12-24Z'^^xsd:date)", "2010");
    }

    @Test
    public void year_13() {
        TestFunctions2.test("year('2010Z'^^xsd:gYear)", "2010");
    }

    @Test
    public void year_14() {
        TestFunctions2.test("year('2010-12Z'^^xsd:gYearMonth)", "2010");
    }

    @Test(expected=ExprEvalException.class)
    public void year_15() {
        TestFunctions2.test("year('--12Z'^^xsd:gMonth)", "2010");
    }

    @Test(expected=ExprEvalException.class)
    public void year_16() {
        TestFunctions2.test("year('--12-24Z'^^xsd:gMonthDay)", "2010");
    }

    @Test(expected=ExprEvalException.class)
    public void year_17() {
        TestFunctions2.test("year('---24Z'^^xsd:gDay)", "2010");
    }

    @Test
    public void year_21() {
        TestFunctions2.test("year('2010-12-24T16:24:01.123-08:00'^^xsd:dateTime)", "2010");
    }

    @Test
    public void year_22() {
        TestFunctions2.test("year('2010-12-24-08:00'^^xsd:date)", "2010");
    }

    @Test
    public void year_23() {
        TestFunctions2.test("year('2010-08:00'^^xsd:gYear)", "2010");
    }

    @Test
    public void year_24() {
        TestFunctions2.test("year('2010-12-08:00'^^xsd:gYearMonth)", "2010");
    }

    @Test(expected=ExprEvalException.class)
    public void year_25() {
        TestFunctions2.test("year('--12-08:00'^^xsd:gMonth)", "2010");
    }

    @Test(expected=ExprEvalException.class)
    public void year_26() {
        TestFunctions2.test("year('--12-24-08:00'^^xsd:gMonthDay)", "2010");
    }

    @Test(expected=ExprEvalException.class)
    public void year_27() {
        TestFunctions2.test("year('---24-08:00'^^xsd:gDay)", "2010");
    }

    @Test
    public void year_dur_01() {
        TestFunctions2.test("year('P1Y2M3DT4H5M6S'^^xsd:duration)", "1");
    }

    @Test
    public void month_01() {
        TestFunctions2.test("month('2010-12-24T16:24:01.123'^^xsd:dateTime)", "12");
    }

    @Test
    public void month_02() {
        TestFunctions2.test("month('2010-12-24'^^xsd:date)", "12");
    }

    @Test(expected=ExprEvalException.class)
    public void month_03() {
        TestFunctions2.test("month('2010'^^xsd:gYear)", "12");
    }

    @Test
    public void month_04() {
        TestFunctions2.test("month('2010-12'^^xsd:gYearMonth)", "12");
    }

    @Test
    public void month_05() {
        TestFunctions2.test("month('--12'^^xsd:gMonth)", "12");
    }

    @Test
    public void month_06() {
        TestFunctions2.test("month('--12-24'^^xsd:gMonthDay)", "12");
    }

    @Test(expected=ExprEvalException.class)
    public void month_07() {
        TestFunctions2.test("month('---24'^^xsd:gDay)", "12");
    }

    @Test
    public void month_11() {
        TestFunctions2.test("month('2010-12-24T16:24:01.123Z'^^xsd:dateTime)", "12");
    }

    @Test
    public void month_12() {
        TestFunctions2.test("month('2010-12-24Z'^^xsd:date)", "12");
    }

    @Test(expected=ExprEvalException.class)
    public void month_13() {
        TestFunctions2.test("month('2010Z'^^xsd:gYear)", "12");
    }

    @Test
    public void month_14() {
        TestFunctions2.test("month('2010-12Z'^^xsd:gYearMonth)", "12");
    }

    @Test
    public void month_15() {
        TestFunctions2.test("month('--12Z'^^xsd:gMonth)", "12");
    }

    @Test
    public void month_16() {
        TestFunctions2.test("month('--12-24Z'^^xsd:gMonthDay)", "12");
    }

    @Test(expected=ExprEvalException.class)
    public void month_17() {
        TestFunctions2.test("month('---24Z'^^xsd:gDay)", "12");
    }

    @Test
    public void month_21() {
        TestFunctions2.test("month('2010-12-24T16:24:01.123-08:00'^^xsd:dateTime)", "12");
    }

    @Test
    public void month_22() {
        TestFunctions2.test("month('2010-12-24-08:00'^^xsd:date)", "12");
    }

    @Test(expected=ExprEvalException.class)
    public void month_23() {
        TestFunctions2.test("month('2010-08:00'^^xsd:gYear)", "12");
    }

    @Test
    public void month_24() {
        TestFunctions2.test("month('2010-12-08:00'^^xsd:gYearMonth)", "12");
    }

    @Test
    public void month_25() {
        TestFunctions2.test("month('--12-08:00'^^xsd:gMonth)", "12");
    }

    public void month_26() {
        TestFunctions2.test("month('--12-24-08:00'^^xsd:gMonthDay)", "12");
    }

    @Test(expected=ExprEvalException.class)
    public void month_27() {
        TestFunctions2.test("month('---24-08:00'^^xsd:gDay)", "12");
    }

    @Test
    public void month_dur_01() {
        TestFunctions2.test("month('P1Y2M3DT4H5M6S'^^xsd:duration)", "2");
    }

    @Test
    public void day_01() {
        TestFunctions2.test("day('2010-12-24T16:24:01.123'^^xsd:dateTime)", "24");
    }

    @Test
    public void day_02() {
        TestFunctions2.test("day('2010-12-24'^^xsd:date)", "24");
    }

    @Test(expected=ExprEvalException.class)
    public void day_03() {
        TestFunctions2.test("day('2010'^^xsd:gYear)", "24");
    }

    @Test(expected=ExprEvalException.class)
    public void day_04() {
        TestFunctions2.test("day('2010-12'^^xsd:gYearMonth)", "24");
    }

    @Test(expected=ExprEvalException.class)
    public void day_05() {
        TestFunctions2.test("day('--12'^^xsd:gMonth)", "24");
    }

    @Test
    public void day_06() {
        TestFunctions2.test("day('--12-24'^^xsd:gMonthDay)", "24");
    }

    @Test
    public void day_07() {
        TestFunctions2.test("day('---24'^^xsd:gDay)", "24");
    }

    @Test
    public void day_11() {
        TestFunctions2.test("day('2010-12-24T16:24:01.123Z'^^xsd:dateTime)", "24");
    }

    @Test
    public void day_12() {
        TestFunctions2.test("day('2010-12-24Z'^^xsd:date)", "24");
    }

    @Test(expected=ExprEvalException.class)
    public void day_13() {
        TestFunctions2.test("day('2010Z'^^xsd:gYear)", "24");
    }

    @Test(expected=ExprEvalException.class)
    public void day_14() {
        TestFunctions2.test("day('2010-12Z'^^xsd:gYearMonth)", "24");
    }

    @Test(expected=ExprEvalException.class)
    public void day_15() {
        TestFunctions2.test("day('--12Z'^^xsd:gMonth)", "24");
    }

    @Test
    public void day_16() {
        TestFunctions2.test("day('--12-24Z'^^xsd:gMonthDay)", "24");
    }

    @Test
    public void day_17() {
        TestFunctions2.test("day('---24Z'^^xsd:gDay)", "24");
    }

    @Test
    public void day_21() {
        TestFunctions2.test("day('2010-12-24T16:24:01.123-08:00'^^xsd:dateTime)", "24");
    }

    @Test
    public void day_22() {
        TestFunctions2.test("day('2010-12-24-08:00'^^xsd:date)", "24");
    }

    @Test(expected=ExprEvalException.class)
    public void day_23() {
        TestFunctions2.test("day('2010-08:00'^^xsd:gYear)", "24");
    }

    @Test(expected=ExprEvalException.class)
    public void day_24() {
        TestFunctions2.test("day('2010-12-08:00'^^xsd:gYearMonth)", "24");
    }

    @Test(expected=ExprEvalException.class)
    public void day_25() {
        TestFunctions2.test("day('--12-08:00'^^xsd:gMonth)", "24");
    }

    @Test
    public void day_26() {
        TestFunctions2.test("day('--12-24-08:00'^^xsd:gMonthDay)", "24");
    }

    @Test
    public void day_27() {
        TestFunctions2.test("day('---24-08:00'^^xsd:gDay)", "24");
    }

    @Test
    public void day_dur_01() {
        TestFunctions2.test("day('P1Y2M3DT4H5M6S'^^xsd:duration)", "3");
    }

    @Test
    public void hours_01() {
        TestFunctions2.test("hours('2010-12-24T16:24:01.123'^^xsd:dateTime)", "16");
    }

    @Test(expected=ExprEvalException.class)
    public void hours_02() {
        TestFunctions2.test("hours('2010-12-24'^^xsd:date)", "16");
    }

    @Test
    public void hours_03() {
        TestFunctions2.test("hours('16:24:01'^^xsd:time)", "16");
    }

    @Test
    public void hours_10() {
        TestFunctions2.test("hours('2010-12-24T16:24:01.123Z'^^xsd:dateTime)", "16");
    }

    @Test
    public void hours_11() {
        TestFunctions2.test("hours('16:24:24Z'^^xsd:time)", "16");
    }

    @Test
    public void hours_20() {
        TestFunctions2.test("hours('2010-12-24T16:24:01.123-08:00'^^xsd:dateTime)", "16");
    }

    @Test
    public void hours_21() {
        TestFunctions2.test("hours('16:24:24-08:00'^^xsd:time)", "16");
    }

    @Test
    public void hours_dur_01() {
        TestFunctions2.test("hours('P1Y2M3DT4H5M6S'^^xsd:duration)", "4");
    }

    @Test
    public void minutes_01() {
        TestFunctions2.test("minutes('2010-12-24T16:24:01.123'^^xsd:dateTime)", "24");
    }

    @Test(expected=ExprEvalException.class)
    public void minutes_02() {
        TestFunctions2.test("minutes('2010-12-24'^^xsd:date)", "");
    }

    @Test
    public void minutes_03() {
        TestFunctions2.test("minutes('16:24:01'^^xsd:time)", "24");
    }

    @Test
    public void minutes_10() {
        TestFunctions2.test("minutes('2010-12-24T16:24:01.123Z'^^xsd:dateTime)", "24");
    }

    @Test
    public void minutes_11() {
        TestFunctions2.test("minutes('16:24:01.1Z'^^xsd:time)", "24");
    }

    @Test
    public void minutes_20() {
        TestFunctions2.test("minutes('2010-12-24T16:24:01.123-08:00'^^xsd:dateTime)", "24");
    }

    @Test
    public void minutes_21() {
        TestFunctions2.test("minutes('16:24:01.01-08:00'^^xsd:time)", "24");
    }

    @Test
    public void minutes_dur_01() {
        TestFunctions2.test("minutes('P1Y2M3DT4H5M6S'^^xsd:duration)", "5");
    }

    @Test
    public void seconds_01() {
        TestFunctions2.test("seconds('2010-12-24T16:24:01.123'^^xsd:dateTime)", "01.123");
    }

    @Test(expected=ExprEvalException.class)
    public void seconds_02() {
        TestFunctions2.test("seconds('2010-12-24'^^xsd:date)", "");
    }

    @Test
    public void seconds_03() {
        TestFunctions2.test("seconds('16:24:01'^^xsd:time)", "'01'^^xsd:decimal");
    }

    @Test
    public void seconds_10() {
        TestFunctions2.test("seconds('2010-12-24T16:24:31.123Z'^^xsd:dateTime)", "31.123");
    }

    @Test
    public void seconds_11() {
        TestFunctions2.test("seconds('16:24:01.1Z'^^xsd:time)", "'01.1'^^xsd:decimal");
    }

    @Test
    public void seconds_20() {
        TestFunctions2.test("seconds('2010-12-24T16:24:35.123-08:00'^^xsd:dateTime)", "35.123");
    }

    @Test
    public void seconds_21() {
        TestFunctions2.test("seconds('16:24:01.01-08:00'^^xsd:time)", "'01.01'^^xsd:decimal");
    }

    @Test
    public void seconds_dur_01() {
        TestFunctions2.test("seconds('P1Y2M3DT4H5M6S'^^xsd:duration)", "'6'^^xsd:decimal");
    }

    @Test
    public void timezone_01() {
        TestFunctions2.test("timezone('2010-12-24T16:24:35.123Z'^^xsd:dateTime)", "'PT0S'^^xsd:dayTimeDuration");
    }

    @Test
    public void timezone_02() {
        TestFunctions2.test("timezone('2010-12-24T16:24:35.123-08:00'^^xsd:dateTime)", "'-PT8H'^^xsd:dayTimeDuration");
    }

    @Test
    public void timezone_03() {
        TestFunctions2.test("timezone('2010-12-24T16:24:35.123+01:00'^^xsd:dateTime)", "'PT1H'^^xsd:dayTimeDuration");
    }

    @Test
    public void timezone_04() {
        TestFunctions2.test("timezone('2010-12-24T16:24:35.123-00:00'^^xsd:dateTime)", "'-PT0S'^^xsd:dayTimeDuration");
    }

    @Test
    public void timezone_05() {
        TestFunctions2.test("timezone('2010-12-24T16:24:35.123+00:00'^^xsd:dateTime)", "'PT0S'^^xsd:dayTimeDuration");
    }

    @Test(expected=ExprEvalException.class)
    public void timezone_09() {
        TestFunctions2.test("timezone('2010-12-24T16:24:35'^^xsd:dateTime)", "'PT0S'^^xsd:dayTimeDuration");
    }

    @Test(expected=ExprEvalException.class)
    public void timezone_10() {
        TestFunctions2.test("timezone(2010)", "'PT0S'^^xsd:dayTimeDuration");
    }

    @Test(expected=ExprEvalException.class)
    public void timezone_11() {
        TestFunctions2.test("timezone('2010-junk'^^xsd:gYear)", "'PT0S'^^xsd:dayTimeDuration");
    }

    @Test
    public void tz_01() {
        TestFunctions2.test("tz('2010-12-24T16:24:35.123Z'^^xsd:dateTime)", "'Z'");
    }

    @Test
    public void tz_02() {
        TestFunctions2.test("tz('2010-12-24T16:24:35.123-08:00'^^xsd:dateTime)", "'-08:00'");
    }

    @Test
    public void tz_03() {
        TestFunctions2.test("tz('2010-12-24T16:24:35.123+01:00'^^xsd:dateTime)", "'+01:00'");
    }

    @Test
    public void tz_04() {
        TestFunctions2.test("tz('2010-12-24T16:24:35.123-00:00'^^xsd:dateTime)", "'-00:00'");
    }

    @Test
    public void tz_05() {
        TestFunctions2.test("tz('2010-12-24T16:24:35.123+00:00'^^xsd:dateTime)", "'+00:00'");
    }

    @Test
    public void tz_06() {
        TestFunctions2.test("tz('2010-12-24T16:24:35.123'^^xsd:dateTime)", "''");
    }

    @Test(expected=ExprEvalException.class)
    public void tz_10() {
        TestFunctions2.test("tz(2010)", "''");
    }

    @Test(expected=ExprEvalException.class)
    public void tz_11() {
        TestFunctions2.test("tz('2010-junk'^^xsd:gYear)", "''");
    }

    @Test
    public void md5_01() {
        TestFunctions2.test("md5('abcd')", "'e2fc714c4727ee9395f324cd2e7f331f'");
    }

    @Test
    public void md5_02() {
        TestFunctions2.test("md5('abcd'^^xsd:string)", "'e2fc714c4727ee9395f324cd2e7f331f'");
    }

    @Test(expected=ExprEvalException.class)
    public void md5_03() {
        TestFunctions2.test("md5('abcd'@en)", "'e2fc714c4727ee9395f324cd2e7f331f'");
    }

    @Test(expected=ExprEvalException.class)
    public void md5_04() {
        TestFunctions2.test("md5(1234)", "'e2fc714c4727ee9395f324cd2e7f331f'");
    }

    @Test
    public void sha1_01() {
        TestFunctions2.test("sha1('abcd')", "'81fe8bfe87576c3ecb22426f8e57847382917acf'");
    }

    @Test
    public void sha1_02() {
        TestFunctions2.test("sha1('abcd'^^xsd:string)", "'81fe8bfe87576c3ecb22426f8e57847382917acf'");
    }

    @Test(expected=ExprEvalException.class)
    public void sha1_03() {
        TestFunctions2.test("sha1('abcd'@en)", "'81fe8bfe87576c3ecb22426f8e57847382917acf'");
    }

    @Test(expected=ExprEvalException.class)
    public void sha1_04() {
        TestFunctions2.test("sha1(123)", "'81fe8bfe87576c3ecb22426f8e57847382917acf'");
    }

    @Test
    public void sha256_01() {
        TestFunctions2.test("sha256('abcd')", "'88d4266fd4e6338d13b845fcf289579d209c897823b9217da3e161936f031589'");
    }

    @Test
    public void sha256_02() {
        TestFunctions2.test("sha256('abcd'^^xsd:string)", "'88d4266fd4e6338d13b845fcf289579d209c897823b9217da3e161936f031589'");
    }

    @Test(expected=ExprEvalException.class)
    public void sha256_03() {
        TestFunctions2.test("sha256('abcd'@en)", "'88d4266fd4e6338d13b845fcf289579d209c897823b9217da3e161936f031589'");
    }

    @Test(expected=ExprEvalException.class)
    public void sha256_04() {
        TestFunctions2.test("sha256(<uri>)", "'88d4266fd4e6338d13b845fcf289579d209c897823b9217da3e161936f031589'");
    }

    @Test
    public void sha384_01() {
        TestFunctions2.test("sha384('abcd')", "'1165b3406ff0b52a3d24721f785462ca2276c9f454a116c2b2ba20171a7905ea5a026682eb659c4d5f115c363aa3c79b'");
    }

    @Test
    public void sha384_02() {
        TestFunctions2.test("sha384('abcd'^^xsd:string)", "'1165b3406ff0b52a3d24721f785462ca2276c9f454a116c2b2ba20171a7905ea5a026682eb659c4d5f115c363aa3c79b'");
    }

    @Test(expected=ExprEvalException.class)
    public void sha384_03() {
        TestFunctions2.test("sha384('abcd'@en)", "'1165b3406ff0b52a3d24721f785462ca2276c9f454a116c2b2ba20171a7905ea5a026682eb659c4d5f115c363aa3c79b'");
    }

    @Test(expected=ExprEvalException.class)
    public void sha384_04() {
        TestFunctions2.test("sha384(123.45)", "'1165b3406ff0b52a3d24721f785462ca2276c9f454a116c2b2ba20171a7905ea5a026682eb659c4d5f115c363aa3c79b'");
    }

    @Test
    public void sha512_01() {
        TestFunctions2.test("sha512('abcd')", "'d8022f2060ad6efd297ab73dcc5355c9b214054b0d1776a136a669d26a7d3b14f73aa0d0ebff19ee333368f0164b6419a96da49e3e481753e7e96b716bdccb6f'");
    }

    @Test
    public void sha512_02() {
        TestFunctions2.test("sha512('abcd'^^xsd:string)", "'d8022f2060ad6efd297ab73dcc5355c9b214054b0d1776a136a669d26a7d3b14f73aa0d0ebff19ee333368f0164b6419a96da49e3e481753e7e96b716bdccb6f'");
    }

    @Test(expected=ExprEvalException.class)
    public void sha512_03() {
        TestFunctions2.test("md5('abcd'@en)", "'d8022f2060ad6efd297ab73dcc5355c9b214054b0d1776a136a669d26a7d3b14f73aa0d0ebff19ee333368f0164b6419a96da49e3e481753e7e96b716bdccb6f'");
    }

    @Test(expected=ExprEvalException.class)
    public void sha512_04() {
        TestFunctions2.test("md5(0.0e0)", "'d8022f2060ad6efd297ab73dcc5355c9b214054b0d1776a136a669d26a7d3b14f73aa0d0ebff19ee333368f0164b6419a96da49e3e481753e7e96b716bdccb6f'");
    }

    private static void test(String string, String result) {
        Expr expr = ExprUtils.parse((String)string, (PrefixMapping)pmap);
        NodeValue nv = expr.eval(null, (FunctionEnv)new FunctionEnvBase());
        Node r = NodeFactoryExtra.parseNode((String)result);
        NodeValue nvr = NodeValue.makeNode((Node)r);
        TestFunctions2.assertTrue((String)("Not same value: Expected: " + nvr + " : Actual = " + nv), (boolean)NodeValue.sameAs((NodeValue)nvr, (NodeValue)nv));
        TestFunctions2.assertEquals((Object)r, (Object)nv.asNode());
    }
}

