/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.TimeZone;
import org.apache.jena.JenaRuntime;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.XSDFuncOp;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestNodeValue
extends BaseTest {
    static final double doubleAccuracy = 1.0E-8;
    static boolean warningSetting;

    @BeforeClass
    public static void beforeClass() {
        warningSetting = NodeValue.VerboseWarnings;
        NodeValue.VerboseWarnings = false;
    }

    @AfterClass
    public static void afterClass() {
        NodeValue.VerboseWarnings = warningSetting;
    }

    @Test
    public void testInt1() {
        NodeValue v = NodeValue.makeInteger((long)5L);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        TestNodeValue.assertFalse((String)("Is a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testInt2() {
        NodeValue v = NodeValue.makeNodeInteger((long)5L);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testInt3() {
        NodeValue v1 = NodeValue.makeNodeInteger((long)5L);
        NodeValue v2 = NodeValue.makeInteger((long)5L);
        TestNodeValue.assertTrue((String)("Not same integer: " + v1 + " & " + v2), (boolean)v1.getInteger().equals(v2.getInteger()));
    }

    @Test
    public void testFloat1() {
        NodeValue v = NodeValue.makeFloat((float)5.0f);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a float: " + v), (boolean)v.isFloat());
        TestNodeValue.assertTrue((String)("Float not a double: " + v), (boolean)v.isDouble());
        TestNodeValue.assertFalse((String)("No node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testFloat2() {
        NodeValue v = NodeValue.makeNodeFloat((float)5.0f);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a float: " + v), (boolean)v.isDouble());
        TestNodeValue.assertTrue((String)("Float not a double: " + v), (boolean)v.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testFloat3() {
        NodeValue v1 = NodeValue.makeNodeFloat((float)5.7f);
        NodeValue v2 = NodeValue.makeFloat((float)5.7f);
        TestNodeValue.assertTrue((String)("Not same float: " + v1 + " & " + v2), (v1.getFloat() == v2.getFloat() ? 1 : 0) != 0);
        TestNodeValue.assertTrue((String)("Not same float as double: " + v1 + " & " + v2), (v1.getDouble() == v2.getDouble() ? 1 : 0) != 0);
    }

    @Test
    public void testDouble1() {
        NodeValue v = NodeValue.makeDouble((double)5.0);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        TestNodeValue.assertFalse((String)("No node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testDouble2() {
        NodeValue v = NodeValue.makeNodeDouble((double)5.0);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testDouble3() {
        NodeValue v1 = NodeValue.makeNodeDouble((double)5.7);
        NodeValue v2 = NodeValue.makeDouble((double)5.7);
        TestNodeValue.assertTrue((String)("Not same double: " + v1 + " & " + v2), (v1.getDouble() == v2.getDouble() ? 1 : 0) != 0);
    }

    @Test
    public void testDecimal1() {
        NodeValue v = NodeValue.makeDecimal((BigDecimal)new BigDecimal("1.3"));
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + v), (boolean)v.isDecimal());
        TestNodeValue.assertFalse((String)("Is a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testDecimal2() {
        NodeValue v = NodeValue.makeNodeDecimal((String)"1.3");
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + v), (boolean)v.isDecimal());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testDecimal3() {
        NodeValue v1 = NodeValue.makeDecimal((BigDecimal)new BigDecimal("1.3"));
        NodeValue v2 = NodeValue.makeNodeDecimal((String)"1.3");
        TestNodeValue.assertTrue((String)("Not same decimal: " + v1 + " & " + v2), (v1.getDecimal().compareTo(v2.getDecimal()) == 0 ? 1 : 0) != 0);
        TestNodeValue.assertEquals((String)("Not same decimal by equals: " + v1 + " & " + v2), (Object)v1, (Object)v2);
    }

    @Test
    public void testDateTime1() {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.setTimeInMillis(0L);
        cal.set(2005, 1, 18, 20, 39, 10);
        NodeValue v = NodeValue.makeDateTime((Calendar)cal);
        TestNodeValue.assertTrue((String)("Not a dateTime: " + v), (boolean)v.isDateTime());
        TestNodeValue.assertFalse((String)("A date: " + v), (boolean)v.isDate());
    }

    @Test
    public void testDateTime2() {
        NodeValue v = NodeValue.makeNodeDateTime((String)"2005-02-18T20:39:10Z");
        TestNodeValue.assertTrue((String)("Not a dateTime: " + v), (boolean)v.isDateTime());
        TestNodeValue.assertFalse((String)("A date: " + v), (boolean)v.isDate());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testDateTime3() {
        NodeValue v1 = NodeValue.makeDateTime((String)"2005-02-18T20:39:10Z");
        NodeValue v2 = NodeValue.makeNodeDateTime((String)"2005-02-18T20:39:10Z");
        TestNodeValue.assertEquals((String)"Not Calendar.equals: ", (Object)v1.getDateTime(), (Object)v2.getDateTime());
    }

    @Test
    public void testDateTime4() {
        GregorianCalendar cal1 = new GregorianCalendar();
        ((Calendar)cal1).setTimeZone(TimeZone.getTimeZone("GMT"));
        cal1.setTimeInMillis(0L);
        cal1.set(2005, 1, 18, 20, 39, 10);
        NodeValue v = NodeValue.makeNode((String)"2005-02-18T20:39:10Z", (RDFDatatype)XSDDatatype.XSDdateTime);
        TestNodeValue.assertTrue((String)("Not a dateTime: " + v), (boolean)v.isDateTime());
        TestNodeValue.assertFalse((String)("A date: " + v), (boolean)v.isDate());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        GregorianCalendar cal2 = v.getDateTime().toGregorianCalendar();
        TestNodeValue.assertEquals((String)("Not equal: " + v), (long)0L, (long)cal1.compareTo(cal2));
    }

    @Test
    public void testDateTime5() {
        boolean b = NodeValue.VerboseWarnings;
        try {
            NodeValue.VerboseWarnings = false;
            NodeValue v = NodeValue.makeNode((String)"2005-02-18", (RDFDatatype)XSDDatatype.XSDdateTime);
            TestNodeValue.assertFalse((String)("Date!: " + v), (boolean)v.isDate());
            TestNodeValue.assertFalse((String)("Datetime!: " + v), (boolean)v.isDateTime());
        }
        finally {
            NodeValue.VerboseWarnings = b;
        }
    }

    @Test
    public void testDateTime6() {
        NodeValue v0 = NodeValue.makeDateTime((String)"2005-02-18T20:39:10Z");
        NodeValue v1 = NodeValue.makeDateTime((String)"2005-02-18T20:39:10.0Z");
        NodeValue v2 = NodeValue.makeDateTime((String)"2005-02-18T20:39:10.00Z");
        NodeValue v3 = NodeValue.makeDateTime((String)"2005-02-18T20:39:10.000Z");
        TestNodeValue.assertEquals((String)"Not Calendar.equals: ", (Object)v0.getDateTime(), (Object)v1.getDateTime());
        TestNodeValue.assertEquals((String)"Not Calendar.equals: ", (Object)v0.getDateTime(), (Object)v2.getDateTime());
        TestNodeValue.assertEquals((String)"Not Calendar.equals: ", (Object)v0.getDateTime(), (Object)v3.getDateTime());
    }

    @Test
    public void testDateTime7() {
        NodeValue v0 = NodeValue.makeDateTime((String)"2005-02-18T20:39:10Z");
        NodeValue v1 = NodeValue.makeDateTime((String)"2005-02-18T20:39:10.001Z");
        TestNodeValue.assertNotSame((String)"Calendar.equals: ", (Object)v0.getDateTime(), (Object)v1.getDateTime());
    }

    @Test
    public void testDateTime8() {
        NodeValue v0 = NodeValue.makeDateTime((String)"2005-02-18T20:39:10-05:00");
        NodeValue v1 = NodeValue.makeDateTime((String)"2005-02-18T17:39:10.000-08:00");
        TestNodeValue.assertEquals((String)"Not Calendar.equals: ", (Object)v0.getDateTime(), (Object)v1.getDateTime());
    }

    @Test
    public void testDate1() {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.setTimeInMillis(0L);
        cal.set(2005, 1, 18, 0, 0, 0);
        NodeValue v = NodeValue.makeDate((Calendar)cal);
        TestNodeValue.assertTrue((String)("Not a date: " + v), (boolean)v.isDate());
        TestNodeValue.assertFalse((String)("A dateTime: " + v), (boolean)v.isDateTime());
    }

    @Test
    public void testDate2() {
        NodeValue v = NodeValue.makeNodeDate((String)"2005-02-18");
        TestNodeValue.assertTrue((String)("Not a date: " + v), (boolean)v.isDate());
        TestNodeValue.assertFalse((String)("A dateTime: " + v), (boolean)v.isDateTime());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testDate3() {
        NodeValue v1 = NodeValue.makeDate((String)"2005-02-18+01:00");
        NodeValue v2 = NodeValue.makeNodeDate((String)"2005-02-18+01:00");
        TestNodeValue.assertEquals((String)"Not Calendar.equals: ", (Object)v1.getDateTime(), (Object)v2.getDateTime());
    }

    @Test
    public void testDate4() {
        GregorianCalendar cal1 = new GregorianCalendar();
        ((Calendar)cal1).setTimeZone(TimeZone.getTimeZone("GMT"));
        cal1.setTimeInMillis(0L);
        cal1.set(2005, 1, 18, 0, 0, 0);
        NodeValue v = NodeValue.makeNode((String)"2005-02-18Z", (RDFDatatype)XSDDatatype.XSDdate);
        TestNodeValue.assertTrue((String)("Not a date: " + v), (boolean)v.isDate());
        TestNodeValue.assertFalse((String)("A dateTime: " + v), (boolean)v.isDateTime());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        GregorianCalendar cal2 = v.getDateTime().toGregorianCalendar();
        TestNodeValue.assertEquals((String)("Not equal: " + v), (long)0L, (long)cal1.compareTo(cal2));
    }

    @Test
    public void testDate5() {
        boolean b = NodeValue.VerboseWarnings;
        try {
            NodeValue.VerboseWarnings = false;
            NodeValue v = NodeValue.makeNode((String)"2005-02-18T20:39:10Z", (RDFDatatype)XSDDatatype.XSDdate);
            TestNodeValue.assertFalse((String)("Datetime!: " + v), (boolean)v.isDateTime());
            TestNodeValue.assertFalse((String)("Date!: " + v), (boolean)v.isDate());
        }
        finally {
            NodeValue.VerboseWarnings = b;
        }
    }

    @Test
    public void testNodeInt1() {
        NodeValue v = NodeValue.makeNode((String)"57", (RDFDatatype)XSDDatatype.XSDinteger);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testNodeInt2() {
        NodeValue v = NodeValue.makeNode((String)"57", (RDFDatatype)XSDDatatype.XSDdouble);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testNodeInt3() {
        NodeValue v = NodeValue.makeNode((String)"57", (RDFDatatype)XSDDatatype.XSDinteger);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (Object)"57", (Object)actualStr);
    }

    @Test
    public void testNodeInt4() {
        NodeValue v = NodeValue.makeNodeInteger((long)18L);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (Object)"18", (Object)actualStr);
    }

    @Test
    public void testNodeInt5() {
        NodeValue v = NodeValue.makeNodeInteger((String)"018");
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (Object)"018", (Object)actualStr);
    }

    @Test
    public void testNodeInt6() {
        NodeValue v = NodeValue.makeNodeInteger((String)" 18");
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testNodeInt7() {
        NodeValue v = NodeValue.makeNodeInteger((String)" 18 ");
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testNodeInt8() {
        NodeValue v = NodeValue.makeNodeInteger((String)"1 8");
        TestNodeValue.assertFalse((String)("A number!: " + v), (boolean)v.isNumber());
        TestNodeValue.assertFalse((String)("An integer!: " + v), (boolean)v.isInteger());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testNodeFloat1() {
        NodeValue v = NodeValue.makeNode((String)"57.0", (RDFDatatype)XSDDatatype.XSDfloat);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a float: " + v), (boolean)v.isFloat());
        TestNodeValue.assertTrue((String)("Not a double(float): " + v), (boolean)v.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (Object)("\"57.0\"^^<" + XSDDatatype.XSDfloat.getURI() + ">"), (Object)actualStr);
    }

    @Test
    public void testNodeDouble1() {
        NodeValue v = NodeValue.makeNode((String)"57.0e0", (RDFDatatype)XSDDatatype.XSDdouble);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (Object)"57.0e0", (Object)actualStr);
    }

    @Test
    public void testNodeDouble2() {
        NodeValue v = NodeValue.makeNode((String)"57", (RDFDatatype)XSDDatatype.XSDdouble);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (Object)("\"57\"^^<" + XSDDatatype.XSDdouble.getURI() + ">"), (Object)actualStr);
    }

    @Test
    public void testNodeDouble3() {
        NodeValue v = NodeValue.makeNode((String)"057.0e0", (RDFDatatype)XSDDatatype.XSDdouble);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (Object)"057.0e0", (Object)actualStr);
    }

    @Test
    public void testNodeDouble4() {
        NodeValue v = NodeValue.makeNode((String)" 057.0e0 ", (RDFDatatype)XSDDatatype.XSDdouble);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testNodeBool1() {
        NodeValue v = NodeValue.makeNode((String)"true", (RDFDatatype)XSDDatatype.XSDboolean);
        TestNodeValue.assertTrue((String)("Not a boolean: " + v), (boolean)v.isBoolean());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        TestNodeValue.assertTrue((String)("Not satisfied: " + v), (boolean)v.getBoolean());
    }

    @Test
    public void testNodeBool2() {
        NodeValue v = NodeValue.makeNode((String)"false", (RDFDatatype)XSDDatatype.XSDboolean);
        TestNodeValue.assertTrue((String)("Not a boolean: " + v), (boolean)v.isBoolean());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        TestNodeValue.assertFalse((String)("Satisfied: " + v), (boolean)v.getBoolean());
    }

    @Test
    public void testNodeBool3() {
        NodeValue v = NodeValue.makeBoolean((boolean)true);
        TestNodeValue.assertTrue((String)("Not a boolean: " + v), (boolean)v.isBoolean());
        TestNodeValue.assertTrue((String)("Not true: " + v), (boolean)v.getBoolean());
        TestNodeValue.assertTrue((String)("Not true: " + v), (boolean)XSDFuncOp.booleanEffectiveValue((NodeValue)v));
    }

    @Test
    public void testNodeBool4() {
        NodeValue v = NodeValue.makeBoolean((boolean)false);
        TestNodeValue.assertTrue((String)("Not a boolean: " + v), (boolean)v.isBoolean());
        TestNodeValue.assertFalse((String)("Not false: " + v), (boolean)v.getBoolean());
        TestNodeValue.assertFalse((String)("Not false: " + v), (boolean)XSDFuncOp.booleanEffectiveValue((NodeValue)v));
    }

    static NodeValue make(String str) {
        Node n = NodeFactoryExtra.parseNode((String)str);
        NodeValue nv = NodeValue.makeNode((Node)n);
        return nv;
    }

    @Test
    public void gregorian_01() {
        NodeValue nv = TestNodeValue.make("'1999'^^xsd:gYear");
        TestNodeValue.assertTrue((boolean)nv.isGYear());
        TestNodeValue.assertFalse((boolean)nv.isGYearMonth());
        TestNodeValue.assertFalse((boolean)nv.isGMonth());
        TestNodeValue.assertFalse((boolean)nv.isGMonthDay());
        TestNodeValue.assertFalse((boolean)nv.isGDay());
    }

    @Test
    public void gregorian_02() {
        NodeValue nv = TestNodeValue.make("'1999-01'^^xsd:gYearMonth");
        TestNodeValue.assertFalse((boolean)nv.isGYear());
        TestNodeValue.assertTrue((boolean)nv.isGYearMonth());
        TestNodeValue.assertFalse((boolean)nv.isGMonth());
        TestNodeValue.assertFalse((boolean)nv.isGMonthDay());
        TestNodeValue.assertFalse((boolean)nv.isGDay());
    }

    @Test
    public void gregorian_03() {
        NodeValue nv = TestNodeValue.make("'--01'^^xsd:gMonth");
        TestNodeValue.assertFalse((boolean)nv.isGYear());
        TestNodeValue.assertFalse((boolean)nv.isGYearMonth());
        TestNodeValue.assertTrue((boolean)nv.isGMonth());
        TestNodeValue.assertFalse((boolean)nv.isGMonthDay());
        TestNodeValue.assertFalse((boolean)nv.isGDay());
    }

    @Test
    public void gregorian_04() {
        NodeValue nv = TestNodeValue.make("'--01-30'^^xsd:gMonthDay");
        TestNodeValue.assertFalse((boolean)nv.isGYear());
        TestNodeValue.assertFalse((boolean)nv.isGYearMonth());
        TestNodeValue.assertFalse((boolean)nv.isGMonth());
        TestNodeValue.assertTrue((boolean)nv.isGMonthDay());
        TestNodeValue.assertFalse((boolean)nv.isGDay());
    }

    @Test
    public void gregorian_05() {
        NodeValue nv = TestNodeValue.make("'---30'^^xsd:gDay");
        TestNodeValue.assertFalse((boolean)nv.isGYear());
        TestNodeValue.assertFalse((boolean)nv.isGYearMonth());
        TestNodeValue.assertFalse((boolean)nv.isGMonth());
        TestNodeValue.assertFalse((boolean)nv.isGMonthDay());
        TestNodeValue.assertTrue((boolean)nv.isGDay());
    }

    @Test
    public void langString_01() {
        NodeValue nv = TestNodeValue.make("''@en");
        TestNodeValue.assertFalse((boolean)nv.isString());
        TestNodeValue.assertTrue((boolean)nv.isLangString());
        TestNodeValue.assertEquals((Object)"en", (Object)nv.getLang());
        TestNodeValue.assertEquals((Object)"", (Object)nv.getString());
        TestNodeValue.assertEquals((Object)"", (Object)nv.asString());
    }

    @Test
    public void langString_02() {
        NodeValue nv = TestNodeValue.make("'not empty'@cy");
        TestNodeValue.assertFalse((boolean)nv.isString());
        TestNodeValue.assertTrue((boolean)nv.isLangString());
        TestNodeValue.assertEquals((Object)"cy", (Object)nv.getLang());
        TestNodeValue.assertEquals((Object)"not empty", (Object)nv.getString());
        TestNodeValue.assertEquals((Object)"not empty", (Object)nv.asString());
    }

    @Test
    public void testBadLexcial1() {
        boolean b = NodeValue.VerboseWarnings;
        try {
            NodeValue.VerboseWarnings = false;
            NodeValue v = NodeValue.makeNodeInteger((String)"abc");
            TestNodeValue.assertFalse((String)("Good integer: " + v), (boolean)v.isInteger());
            TestNodeValue.assertFalse((String)("Good number: " + v), (boolean)v.isNumber());
        }
        finally {
            NodeValue.VerboseWarnings = b;
        }
    }

    @Test
    public void testBadLexcial2() {
        boolean b = NodeValue.VerboseWarnings;
        try {
            NodeValue.VerboseWarnings = false;
            NodeValue v = NodeValue.makeNodeInteger((String)"1.8");
            TestNodeValue.assertFalse((String)("Good integer: " + v), (boolean)v.isInteger());
            TestNodeValue.assertFalse((String)("Good number: " + v), (boolean)v.isNumber());
        }
        finally {
            NodeValue.VerboseWarnings = b;
        }
    }

    @Test
    public void testBadLexcial3() {
        boolean b = NodeValue.VerboseWarnings;
        try {
            NodeValue.VerboseWarnings = false;
            NodeValue v = NodeValue.makeDateTime((String)"2005-10-34T00:00:01Z");
            TestNodeValue.assertFalse((String)("Good date: " + v), (boolean)v.isDateTime());
        }
        finally {
            NodeValue.VerboseWarnings = b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBadLexcial4() {
        boolean b = NodeValue.VerboseWarnings;
        try {
            String s = "2005-10-14T 09:30:23+01:00";
            NodeValue.VerboseWarnings = false;
            NodeValue v1 = NodeValue.makeDateTime((String)s);
            TestNodeValue.assertFalse((String)("Good date: " + v1), (boolean)v1.isDateTime());
            s = s.replaceAll(" ", "");
            NodeValue v2 = NodeValue.makeDateTime((String)s);
            TestNodeValue.assertTrue((String)("Bad date: " + v2), (boolean)v2.isDateTime());
        }
        finally {
            NodeValue.VerboseWarnings = b;
        }
    }

    @Test
    public void testEBV1() {
        TestNodeValue.assertTrue((String)"Not a boolean", (boolean)NodeValue.TRUE.isBoolean());
        TestNodeValue.assertTrue((String)"Not true", (boolean)NodeValue.TRUE.getBoolean());
        TestNodeValue.assertTrue((String)"Not true", (boolean)XSDFuncOp.booleanEffectiveValue((NodeValue)NodeValue.TRUE));
    }

    @Test
    public void testEBV2() {
        TestNodeValue.assertTrue((String)"Not a boolean", (boolean)NodeValue.FALSE.isBoolean());
        TestNodeValue.assertFalse((String)"Not false", (boolean)NodeValue.FALSE.getBoolean());
        TestNodeValue.assertFalse((String)"Not false", (boolean)XSDFuncOp.booleanEffectiveValue((NodeValue)NodeValue.FALSE));
    }

    @Test
    public void testEBV3() {
        NodeValue v = NodeValue.makeInteger((long)1L);
        TestNodeValue.assertFalse((String)("It's a boolean: " + v), (boolean)v.isBoolean());
        TestNodeValue.assertTrue((String)("Not EBV true: " + v), (boolean)XSDFuncOp.booleanEffectiveValue((NodeValue)v));
    }

    @Test
    public void testEBV4() {
        NodeValue v = NodeValue.makeInteger((long)0L);
        TestNodeValue.assertFalse((String)("It's a boolean: " + v), (boolean)v.isBoolean());
        try {
            v.getBoolean();
            TestNodeValue.fail((String)"getBoolean should fail");
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
        TestNodeValue.assertFalse((String)("Not EBV false: " + v), (boolean)XSDFuncOp.booleanEffectiveValue((NodeValue)v));
    }

    @Test
    public void testEBV5() {
        NodeValue v = NodeValue.makeString((String)"xyz");
        TestNodeValue.assertFalse((String)("It's a boolean: " + v), (boolean)v.isBoolean());
        try {
            v.getBoolean();
            TestNodeValue.fail((String)"getBoolean should fail");
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
        TestNodeValue.assertTrue((String)("Not EBV true: " + v), (boolean)XSDFuncOp.booleanEffectiveValue((NodeValue)v));
    }

    @Test
    public void testEBV6() {
        NodeValue v = NodeValue.makeString((String)"");
        TestNodeValue.assertFalse((String)("It's a boolean: " + v), (boolean)v.isBoolean());
        try {
            v.getBoolean();
            TestNodeValue.fail((String)"getBoolean should fail");
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
        TestNodeValue.assertFalse((String)("Not EBV false: " + v), (boolean)XSDFuncOp.booleanEffectiveValue((NodeValue)v));
    }

    @Test
    public void testEBV7() {
        Node x = NodeFactory.createLiteral((String)"", (String)"en");
        NodeValue v = NodeValue.makeNode((Node)x);
        TestNodeValue.assertFalse((String)("Not EBV false: " + v), (boolean)XSDFuncOp.booleanEffectiveValue((NodeValue)v));
    }

    @Test
    public void testEBV8() {
        Node x = NodeFactory.createLiteral((String)"not empty", (String)"en");
        NodeValue v = NodeValue.makeNode((Node)x);
        TestNodeValue.assertTrue((String)("Not EBV true: " + v), (boolean)XSDFuncOp.booleanEffectiveValue((NodeValue)v));
    }

    static boolean ebvDouble(double d) {
        return XSDFuncOp.booleanEffectiveValue((NodeValue)NodeValue.makeDouble((double)d));
    }

    @Test
    public void testEBV9() {
        TestNodeValue.assertTrue((boolean)TestNodeValue.ebvDouble(0.01));
        TestNodeValue.assertFalse((boolean)TestNodeValue.ebvDouble(0.0));
        TestNodeValue.assertFalse((boolean)TestNodeValue.ebvDouble(-0.0));
        TestNodeValue.assertFalse((boolean)TestNodeValue.ebvDouble(Double.NaN));
        TestNodeValue.assertTrue((boolean)TestNodeValue.ebvDouble(Double.MIN_NORMAL));
        TestNodeValue.assertTrue((boolean)TestNodeValue.ebvDouble(Double.MIN_VALUE));
        TestNodeValue.assertTrue((boolean)TestNodeValue.ebvDouble(Double.MAX_VALUE));
        TestNodeValue.assertTrue((boolean)TestNodeValue.ebvDouble(Double.POSITIVE_INFINITY));
        TestNodeValue.assertTrue((boolean)TestNodeValue.ebvDouble(Double.NEGATIVE_INFINITY));
        Node x = NodeFactory.createLiteral((String)"NaN", (RDFDatatype)XSDDatatype.XSDdouble);
        NodeValue v = NodeValue.makeNode((Node)x);
        TestNodeValue.assertFalse((boolean)XSDFuncOp.booleanEffectiveValue((NodeValue)v));
    }

    static boolean ebvFloat(float f) {
        return XSDFuncOp.booleanEffectiveValue((NodeValue)NodeValue.makeFloat((float)f));
    }

    @Test
    public void testEBV10() {
        TestNodeValue.assertTrue((boolean)TestNodeValue.ebvFloat(0.01f));
        TestNodeValue.assertFalse((boolean)TestNodeValue.ebvFloat(0.0f));
        TestNodeValue.assertFalse((boolean)TestNodeValue.ebvFloat(-0.0f));
        TestNodeValue.assertFalse((boolean)TestNodeValue.ebvFloat(Float.NaN));
        TestNodeValue.assertTrue((boolean)TestNodeValue.ebvFloat(Float.MIN_NORMAL));
        TestNodeValue.assertTrue((boolean)TestNodeValue.ebvFloat(Float.MIN_VALUE));
        TestNodeValue.assertTrue((boolean)TestNodeValue.ebvFloat(Float.MAX_VALUE));
        TestNodeValue.assertTrue((boolean)TestNodeValue.ebvFloat(Float.POSITIVE_INFINITY));
        TestNodeValue.assertTrue((boolean)TestNodeValue.ebvFloat(Float.NEGATIVE_INFINITY));
        Node x = NodeFactory.createLiteral((String)"NaN", (RDFDatatype)XSDDatatype.XSDfloat);
        NodeValue v = NodeValue.makeNode((Node)x);
        TestNodeValue.assertFalse((boolean)XSDFuncOp.booleanEffectiveValue((NodeValue)v));
    }

    private static boolean filterEBV(NodeValue nv) {
        try {
            return XSDFuncOp.booleanEffectiveValue((NodeValue)nv);
        }
        catch (ExprEvalException ex) {
            return false;
        }
    }

    @Test
    public void testFloatDouble1() {
        NodeValue v1 = NodeValue.makeNodeDouble((String)"1.5");
        NodeValue v2 = NodeValue.makeNode((String)"1.5", (RDFDatatype)XSDDatatype.XSDfloat);
        TestNodeValue.assertTrue((String)"Should be equal: 1.5 float and 1.5 double", (boolean)NodeValue.sameAs((NodeValue)v1, (NodeValue)v2));
    }

    @Test
    public void testFloatDouble5() {
        NodeValue v1 = NodeValue.makeNodeDouble((String)"1.3");
        NodeValue v2 = NodeValue.makeNode((String)"1.3", (RDFDatatype)XSDDatatype.XSDfloat);
        TestNodeValue.assertFalse((String)"Should not be equal: 1.3 float and 1.3 double", (boolean)NodeValue.sameAs((NodeValue)v1, (NodeValue)v2));
    }

    @Test
    public void testString1() {
        NodeValue v = NodeValue.makeString((String)"string");
        TestNodeValue.assertTrue((String)("Not a string: " + v), (boolean)v.isString());
        TestNodeValue.assertFalse((String)("Is a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testNodeString1() {
        NodeValue v = NodeValue.makeNode((String)"string", null, (String)null);
        TestNodeValue.assertTrue((String)("Not a string: " + v), (boolean)v.isString());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testNodeString2() {
        NodeValue v = NodeValue.makeNode((String)"string", null, (String)null);
        TestNodeValue.assertTrue((String)("Not a string: " + v), (boolean)v.isString());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (Object)"\"string\"", (Object)actualStr);
    }

    @Test
    public void testNodeString3() {
        NodeValue v = NodeValue.makeNode((String)"string", (RDFDatatype)XSDDatatype.XSDstring);
        TestNodeValue.assertTrue((String)("Not a string: " + v), (boolean)v.isString());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        String rightAnswer = JenaRuntime.isRDF11 ? "\"string\"" : "\"string\"^^<" + XSDDatatype.XSDstring.getURI() + ">";
        TestNodeValue.assertEquals((String)"Print form mismatch", (Object)rightAnswer, (Object)actualStr);
    }

    @Test
    public void testNodeSortKey1() {
        NodeValue nv = NodeValue.makeSortKey((String)"Wagen", (String)"de");
        TestNodeValue.assertTrue((String)("Not a sort key: " + nv), (boolean)nv.isSortKey());
        String actualStr = nv.asQuotedString();
        String rightAnswer = "\"Wagen\"";
        TestNodeValue.assertEquals((String)"Print form mismatch", (Object)rightAnswer, (Object)actualStr);
    }

    @Test
    public void testNodeSortKey2() {
        String[] unordered = new String[]{"Broager", "\u00c5kirkeby", "B\u00f8rkop", "\u00c6r\u00f8sk\u00f8bing", "Br\u00e6dstrup", "Wandsbek"};
        Object[] ordered = new String[]{"'Broager'", "'Br\u00e6dstrup'", "'B\u00f8rkop'", "'Wandsbek'", "'\u00c6r\u00f8sk\u00f8bing'", "'\u00c5kirkeby'"};
        String collation2 = "da";
        LinkedList<NodeValue> nodeValues = new LinkedList<NodeValue>();
        for (String string : unordered) {
            nodeValues.add(NodeValue.makeSortKey((String)string, (String)"da"));
        }
        nodeValues.sort(new Comparator<NodeValue>(){

            @Override
            public int compare(NodeValue o1, NodeValue o2) {
                return NodeValue.compare((NodeValue)o1, (NodeValue)o2);
            }
        });
        LinkedList<String> result = new LinkedList<String>();
        for (NodeValue nv : nodeValues) {
            String s = nv.toString();
            result.add(s);
        }
        TestNodeValue.assertArrayEquals((Object[])ordered, (Object[])result.toArray(new String[0]));
    }

    @Test
    public void testNodeSortKey3() {
        String[] unordered = new String[]{"Broager", "\u00c5kirkeby", "B\u00f8rkop", "\u00c6r\u00f8sk\u00f8bing", "Br\u00e6dstrup", "Wandsbek"};
        Object[] ordered = new String[]{"'\u00c6r\u00f8sk\u00f8bing'", "'\u00c5kirkeby'", "'Br\u00e6dstrup'", "'Broager'", "'B\u00f8rkop'", "'Wandsbek'"};
        String collation2 = "en-NZ";
        LinkedList<NodeValue> nodeValues = new LinkedList<NodeValue>();
        for (String string : unordered) {
            nodeValues.add(NodeValue.makeSortKey((String)string, (String)"en-NZ"));
        }
        nodeValues.sort(new Comparator<NodeValue>(){

            @Override
            public int compare(NodeValue o1, NodeValue o2) {
                return NodeValue.compare((NodeValue)o1, (NodeValue)o2);
            }
        });
        LinkedList<String> result = new LinkedList<String>();
        for (NodeValue nv : nodeValues) {
            String s = nv.toString();
            result.add(s);
        }
        TestNodeValue.assertArrayEquals((Object[])ordered, (Object[])result.toArray(new String[0]));
    }

    @Test
    public void testNodeSortKey4() {
        String collation2 = "fi";
        Object[] ordered = new String[]{"tsahurin kieli", "t\u0161ekin kieli", "tulun kieli", "t\u00f6yht\u00f6hyypp\u00e4"};
        String queryString = "PREFIX skos: <http://www.w3.org/2004/02/skos/core#>\nPREFIX arq: <http://jena.apache.org/ARQ/function#>\nSELECT ?label WHERE {\n   VALUES ?label { \"tulun kieli\"@es \"t\u0161ekin kieli\" \"tsahurin kieli\"@en \"t\u00f6yht\u00f6hyypp\u00e4\"@fi }\n}\nORDER BY arq:collation(\"fi\", ?label)";
        Model model = ModelFactory.createDefaultModel();
        Query query = QueryFactory.create((String)"PREFIX skos: <http://www.w3.org/2004/02/skos/core#>\nPREFIX arq: <http://jena.apache.org/ARQ/function#>\nSELECT ?label WHERE {\n   VALUES ?label { \"tulun kieli\"@es \"t\u0161ekin kieli\" \"tsahurin kieli\"@en \"t\u00f6yht\u00f6hyypp\u00e4\"@fi }\n}\nORDER BY arq:collation(\"fi\", ?label)");
        LinkedList<String> result = new LinkedList<String>();
        try (QueryExecution qExec = QueryExecutionFactory.create((Query)query, (Model)model);){
            ResultSet results = qExec.execSelect();
            while (results.hasNext()) {
                QuerySolution solution = results.nextSolution();
                result.add(solution.getLiteral((String)solution.varNames().next()).getLexicalForm());
            }
        }
        TestNodeValue.assertArrayEquals((Object[])ordered, (Object[])result.toArray(new String[0]));
    }

    @Test
    public void testNodeSortKey5() {
        String collation2 = "en-BZ";
        Object[] ordered = new String[]{"t\u00f6yht\u00f6hyypp\u00e4", "tsahurin kieli", "t\u0161ekin kieli", "tulun kieli"};
        String queryString = "PREFIX skos: <http://www.w3.org/2004/02/skos/core#>\nPREFIX arq: <http://jena.apache.org/ARQ/function#>\nSELECT ?label WHERE {\n   VALUES ?label { \"tulun kieli\"@es \"t\u0161ekin kieli\" \"tsahurin kieli\"@en \"t\u00f6yht\u00f6hyypp\u00e4\"@fi }\n}\nORDER BY arq:collation(\"en-BZ\", ?label)";
        Model model = ModelFactory.createDefaultModel();
        Query query = QueryFactory.create((String)"PREFIX skos: <http://www.w3.org/2004/02/skos/core#>\nPREFIX arq: <http://jena.apache.org/ARQ/function#>\nSELECT ?label WHERE {\n   VALUES ?label { \"tulun kieli\"@es \"t\u0161ekin kieli\" \"tsahurin kieli\"@en \"t\u00f6yht\u00f6hyypp\u00e4\"@fi }\n}\nORDER BY arq:collation(\"en-BZ\", ?label)");
        LinkedList<String> result = new LinkedList<String>();
        try (QueryExecution qExec = QueryExecutionFactory.create((Query)query, (Model)model);){
            ResultSet results = qExec.execSelect();
            while (results.hasNext()) {
                QuerySolution solution = results.nextSolution();
                result.add(solution.getLiteral((String)solution.varNames().next()).getLexicalForm());
            }
        }
        TestNodeValue.assertArrayEquals((Object[])ordered, (Object[])result.toArray(new String[0]));
    }

    @Test
    public void testSameValue1() {
        NodeValue nv1 = NodeValue.makeInteger((long)5L);
        NodeValue nv2 = NodeValue.makeInteger((long)7L);
        TestNodeValue.assertTrue((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
        TestNodeValue.assertFalse((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        NodeValue nv3 = NodeValue.makeInteger((long)5L);
        TestNodeValue.assertTrue((String)("Different values (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv3));
        TestNodeValue.assertFalse((String)("Different values - notNotSame (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv3));
    }

    @Test
    public void testSameValue2() {
        NodeValue nv1 = NodeValue.makeInteger((long)5L);
        NodeValue nv2 = NodeValue.makeNodeInteger((long)7L);
        TestNodeValue.assertTrue((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
        TestNodeValue.assertFalse((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        NodeValue nv3 = NodeValue.makeNodeInteger((long)5L);
        TestNodeValue.assertTrue((String)("Different values (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv3));
        TestNodeValue.assertFalse((String)("Different values - notNotSame (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv3));
    }

    @Test
    public void testSameValue3() {
        NodeValue nv1 = NodeValue.makeDecimal((String)"1.5");
        NodeValue nv2 = NodeValue.makeDecimal((String)"1.6");
        TestNodeValue.assertTrue((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
        TestNodeValue.assertFalse((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        NodeValue nv3 = NodeValue.makeDecimal((String)"1.50");
        TestNodeValue.assertTrue((String)("Different values (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv3));
        TestNodeValue.assertFalse((String)("Different values - notNotSame (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv3));
    }

    @Test
    public void testSameValue4() {
        NodeValue nv1 = NodeValue.makeDecimal((String)"3");
        NodeValue nv2 = NodeValue.makeInteger((long)4L);
        TestNodeValue.assertTrue((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
        TestNodeValue.assertFalse((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        NodeValue nv3 = NodeValue.makeInteger((long)3L);
        TestNodeValue.assertTrue((String)("Different values (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv3));
        TestNodeValue.assertFalse((String)("Different values - notNotSame (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv3));
    }

    @Test
    public void testSameValue5() {
        NodeValue nv1 = NodeValue.makeDecimal((String)"-1.5");
        NodeValue nv2 = NodeValue.makeDouble((double)1.5);
        TestNodeValue.assertTrue((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
        TestNodeValue.assertFalse((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        NodeValue nv3 = NodeValue.makeDouble((double)-1.5);
        TestNodeValue.assertTrue((String)("Different values (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv3));
        TestNodeValue.assertFalse((String)("Different values - notNotSame (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv3));
    }

    @Test
    public void testSameValue6() {
        NodeValue nv1 = NodeValue.makeNodeInteger((long)17L);
        NodeValue nv2 = NodeValue.makeDouble((double)34.0);
        TestNodeValue.assertTrue((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
        TestNodeValue.assertFalse((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        NodeValue nv3 = NodeValue.makeDouble((double)17.0);
        TestNodeValue.assertTrue((String)("Different values (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv3));
        TestNodeValue.assertFalse((String)("Different values - notNotSame (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv3));
    }

    @Test
    public void testSameValue7() {
        NodeValue nv1 = NodeValue.makeBoolean((boolean)true);
        NodeValue nv2 = NodeValue.makeString((String)"a");
        TestNodeValue.assertTrue((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
        TestNodeValue.assertFalse((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        NodeValue nv3 = NodeValue.makeNodeBoolean((boolean)true);
        TestNodeValue.assertTrue((String)("Different values (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv3));
        TestNodeValue.assertFalse((String)("Different values - notNotSame (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv3));
    }

    @Test
    public void testLang1() {
        Node n1 = NodeFactory.createLiteral((String)"xyz", (String)"en");
        NodeValue nv1 = NodeValue.makeNode((Node)n1);
        Node n2 = NodeFactory.createLiteral((String)"xyz", (String)"en");
        NodeValue nv2 = NodeValue.makeNode((Node)n2);
        TestNodeValue.assertTrue((boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
    }

    @Test
    public void testLang2() {
        Node n1 = NodeFactory.createLiteral((String)"xyz", (String)"en");
        NodeValue nv1 = NodeValue.makeNode((Node)n1);
        Node n2 = NodeFactory.createLiteral((String)"xyz", (String)"EN");
        NodeValue nv2 = NodeValue.makeNode((Node)n2);
        TestNodeValue.assertTrue((boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        TestNodeValue.assertFalse((boolean)nv1.equals((Object)nv2));
    }

    @Test
    public void testLang3() {
        Node n1 = NodeFactory.createLiteral((String)"xyz", (String)"en");
        NodeValue nv1 = NodeValue.makeNode((Node)n1);
        Node n2 = NodeFactory.createLiteral((String)"xyz", (String)"en");
        NodeValue nv2 = NodeValue.makeNode((Node)n2);
        TestNodeValue.assertFalse((boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
    }

    @Test
    public void testLang4() {
        Node n1 = NodeFactory.createLiteral((String)"xyz", (String)"en");
        NodeValue nv1 = NodeValue.makeNode((Node)n1);
        Node n2 = NodeFactory.createLiteral((String)"xyz", (String)"EN");
        NodeValue nv2 = NodeValue.makeNode((Node)n2);
        TestNodeValue.assertFalse((boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
        TestNodeValue.assertFalse((boolean)nv1.equals((Object)nv2));
    }

    @Test
    public void testEquals1() {
        NodeValue nv1 = NodeValue.makeInteger((long)1L);
        NodeValue nv2 = NodeValue.makeInteger((long)1L);
        TestNodeValue.assertEquals((String)"Not NodeValue.equals()", (Object)nv1, (Object)nv2);
    }

    @Test
    public void testEquals2() {
        NodeValue nv1 = NodeValue.makeNodeInteger((long)1L);
        NodeValue nv2 = NodeValue.makeInteger((long)1L);
        TestNodeValue.assertEquals((String)"Not NodeValue.equals()", (Object)nv1, (Object)nv2);
    }

    @Test
    public void testEquals3() {
        NodeValue nv1 = NodeValue.makeInteger((long)1L);
        NodeValue nv2 = NodeValue.makeNodeInteger((long)1L);
        TestNodeValue.assertEquals((String)"Not NodeValue.equals()", (Object)nv1, (Object)nv2);
    }

    @Test
    public void testEquals4() {
        NodeValue nv1 = NodeValue.makeNode((Node)NodeFactory.createURI((String)"http://example"));
        NodeValue nv2 = NodeValue.makeNode((Node)NodeFactory.createURI((String)"http://example"));
        TestNodeValue.assertEquals((String)"Not NodeValue.equals()", (Object)nv1, (Object)nv2);
    }

    @Test
    public void testNotEquals1() {
        NodeValue nv1 = NodeValue.makeInteger((long)1L);
        NodeValue nv2 = NodeValue.makeInteger((long)2L);
        TestNodeValue.assertFalse((String)"NodeValue.equals()", (boolean)nv1.equals((Object)nv2));
    }

    @Test
    public void testNotEquals2() {
        NodeValue nv1 = NodeValue.makeNodeInteger((long)1L);
        NodeValue nv2 = NodeValue.makeNodeString((String)"1");
        TestNodeValue.assertFalse((String)"NodeValue.equals()", (boolean)nv1.equals((Object)nv2));
    }

    @Test
    public void testNotEquals3() {
        NodeValue nv1 = NodeValue.makeNode((Node)NodeFactory.createURI((String)"http://example"));
        NodeValue nv2 = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"http://example"));
        TestNodeValue.assertFalse((String)"NodeValue.equals()", (boolean)nv1.equals((Object)nv2));
    }
}

