/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.nodevalue;

import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.nodevalue.NodeValueSortKey;
import org.junit.Assert;
import org.junit.Test;

public class TestNodeValueSortKey {
    @Test
    public void testCreateNodeValueSortKey() {
        NodeValueSortKey nv = new NodeValueSortKey("", null);
        Assert.assertTrue((boolean)nv.isSortKey());
    }

    @Test
    public void testCreateNodeValueSortKeyWithNode() {
        Node n = Node.ANY;
        NodeValueSortKey nv = new NodeValueSortKey("", null, n);
        Assert.assertEquals((Object)n, (Object)nv.getNode());
    }

    @Test
    public void testGetCollation() {
        NodeValueSortKey nv = new NodeValueSortKey("", null);
        Assert.assertNull((Object)nv.getCollation());
        nv = new NodeValueSortKey("", "fi");
        Assert.assertEquals((Object)"fi", (Object)nv.getCollation());
    }

    @Test
    public void testGetString() {
        NodeValueSortKey nv = new NodeValueSortKey("Casa", "pt-BR");
        Assert.assertEquals((Object)"Casa", (Object)nv.asString());
        Assert.assertEquals((Object)"Casa", (Object)nv.getString());
    }

    @Test
    public void testMakeNode() {
        NodeValueSortKey nv = new NodeValueSortKey("Casa", "pt-BR");
        Node n = nv.makeNode();
        Assert.assertTrue((boolean)n.isLiteral());
        Assert.assertEquals((Object)"Casa", (Object)n.getLiteral().toString());
    }

    @Test
    public void testToString() {
        NodeValueSortKey nv = new NodeValueSortKey("Tutte", "it");
        Assert.assertEquals((Object)"'Tutte'", (Object)nv.toString());
    }

    @Test
    public void testCompareTo() {
        String languageTag = "pt";
        NodeValueSortKey nv = new NodeValueSortKey("Bonito", "pt");
        Assert.assertEquals((long)0L, (long)nv.compareTo(null));
        Assert.assertEquals((long)1L, (long)nv.compareTo(new NodeValueSortKey("Bonita", "pt")));
        Assert.assertEquals((long)-1L, (long)nv.compareTo(new NodeValueSortKey("Bonitos", "pt")));
        Assert.assertEquals((long)1L, (long)nv.compareTo(new NodeValueSortKey("Bonita", "es")));
        Assert.assertEquals((long)0L, (long)nv.compareTo(new NodeValueSortKey("Bonito", "es")));
    }
}

