/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.js;

import java.util.Arrays;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.js.EnvJavaScript;
import org.apache.jena.sparql.function.js.FunctionJavaScript;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.Context;
import org.junit.Assert;
import org.junit.Test;

public class TestJavaScriptFunctions {
    static final String JS_LIB_FILE = "testing/ARQ/JS/test-library.js";
    static final String CamelCaseJS = StrUtils.strjoinNL((String[])new String[]{"function toCamelCase(str) { return str.split(' ').map(cc).join('');}", "function ucFirst(word)    { return word.charAt(0).toUpperCase() + word.slice(1).toLowerCase();}", "function lcFirst(word)    { return word.toLowerCase(); }", "function cc(word,index)   { return (index == 0) ? lcFirst(word) : ucFirst(word); }"});
    private EnvJavaScript envJS = TestJavaScriptFunctions.setupJS();

    private static EnvJavaScript setupJS() {
        Context cxt = ARQ.getContext().copy();
        cxt.set(EnvJavaScript.symJavaScriptFunctions, (Object)CamelCaseJS);
        cxt.set(EnvJavaScript.symJavaScriptLibFile, (Object)JS_LIB_FILE);
        return EnvJavaScript.create((Context)cxt);
    }

    @Test
    public void js_dt_boolean() {
        NodeValue nv = this.eval("rtnBoolean", new String[0]);
        Assert.assertTrue((boolean)nv.isBoolean());
    }

    @Test
    public void js_dt_string() {
        NodeValue nv = this.eval("rtnString", new String[0]);
        Assert.assertTrue((boolean)nv.isString());
    }

    @Test
    public void js_dt_integer() {
        NodeValue nv = this.eval("rtnInteger", new String[0]);
        this.assertDatatype(nv, XSDDatatype.XSDinteger);
    }

    @Test
    public void js_dt_double() {
        NodeValue nv = this.eval("rtnDouble", new String[0]);
        this.assertDatatype(nv, XSDDatatype.XSDdouble);
    }

    @Test(expected=ExprEvalException.class)
    public void js_dt_undef() {
        NodeValue nv = this.eval("rtnUndef", new String[0]);
    }

    @Test(expected=ExprEvalException.class)
    public void js_dt_null() {
        NodeValue nv = this.eval("rtnNull", new String[0]);
    }

    @Test
    public void js_dt_1() {
        NodeValue nv = this.eval("identity", "'2018-01-06T17:56:41.293+00:00'^^xsd:dateTime");
    }

    @Test
    public void js_1() {
        NodeValue nv = this.eval("identity", "1");
        Assert.assertNotNull((Object)nv);
    }

    @Test
    public void js_2() {
        NodeValue nv = this.eval("value", "<http://example/xyz>");
        Assert.assertNotNull((Object)nv);
        Assert.assertTrue((boolean)nv.isString());
    }

    @Test
    public void js_3() {
        NodeValue nv = this.eval("combine", "1", "2");
        NodeValue nvx = TestJavaScriptFunctions.nv("3");
        Assert.assertTrue((boolean)nv.isNumber());
        this.assertDatatype(nv, XSDDatatype.XSDinteger);
        Assert.assertEquals((Object)nvx, (Object)nv);
    }

    @Test
    public void js_4() {
        NodeValue nv = this.eval("combine", "'a'", "2");
        NodeValue nvx = TestJavaScriptFunctions.nv("'a2'");
        Assert.assertTrue((boolean)nv.isString());
        Assert.assertEquals((Object)nvx, (Object)nv);
    }

    @Test
    public void js_5() {
        NodeValue nv = this.eval("combine", "2", "'a'");
        NodeValue nvx = TestJavaScriptFunctions.nv("'2a'");
        Assert.assertTrue((boolean)nv.isString());
        Assert.assertEquals((Object)nvx, (Object)nv);
    }

    @Test
    public void js_6() {
        NodeValue nv = this.eval("combine", "2", "2.5");
        NodeValue nvx = TestJavaScriptFunctions.nv("4.5e0");
        this.assertDatatype(nv, XSDDatatype.XSDdouble);
        Assert.assertEquals((Object)nvx, (Object)nv);
    }

    @Test
    public void js_7() {
        NodeValue nv = this.eval("combine", "2.5", "3.5");
        NodeValue nvx = TestJavaScriptFunctions.nv("6");
        this.assertDatatype(nv, XSDDatatype.XSDinteger);
        Assert.assertEquals((Object)nvx, (Object)nv);
    }

    @Test
    public void js_8() {
        NodeValue nv = this.eval("toCamelCase", "'abc def ghi'");
        NodeValue nvx = TestJavaScriptFunctions.nv("'abcDefGhi'");
        this.assertDatatype(nv, XSDDatatype.XSDstring);
        Assert.assertEquals((Object)nvx, (Object)nv);
    }

    private void assertDatatype(NodeValue nv, XSDDatatype xsdDatatype) {
        Assert.assertEquals((Object)nv.asNode().getLiteralDatatype(), (Object)xsdDatatype);
    }

    @Test(expected=ExprEvalException.class)
    public void js_err_1() {
        NodeValue nv = this.eval("no_such_function()", new String[0]);
    }

    @Test(expected=ExprEvalException.class)
    public void js_err_2() {
        NodeValue nv = this.eval("identity", new String[0]);
    }

    @Test
    public void js_err_3() {
        NodeValue nv = this.eval("combine", "'a'");
        Assert.assertNotNull((Object)nv);
    }

    @Test
    public void js_err_4() {
        NodeValue nv = this.eval("identity", "3", "2");
        NodeValue nvx = TestJavaScriptFunctions.nv("3");
        Assert.assertEquals((Object)nvx, (Object)nv);
    }

    private NodeValue eval(String fn, String ... args) {
        NodeValue[] nvs = new NodeValue[args.length];
        for (int i = 0; i < args.length; ++i) {
            nvs[i] = TestJavaScriptFunctions.nv(args[i]);
        }
        FunctionJavaScript x = new FunctionJavaScript(fn, this.envJS);
        NodeValue nvr = x.exec(Arrays.asList(nvs));
        return nvr;
    }

    private static NodeValue nv(String str) {
        return NodeValue.makeNode((Node)SSE.parseNode((String)str));
    }
}

