/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.js;

import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.js.NV;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;
import org.junit.Test;

public class TestNV {
    @Test
    public void nv_1() {
        this.test("'abc'");
    }

    @Test
    public void nv_2() {
        this.test("true");
    }

    @Test
    public void nv_3() {
        this.test("123");
    }

    @Test
    public void nv_4() {
        this.test("123.5");
    }

    @Test
    public void nv_5() {
        this.test("'2018-01-06T17:56:41.293+00:00'^^xsd:dateTime");
    }

    @Test
    public void nv_6() {
        this.test("<http://jena.apache.org/>");
    }

    @Test
    public void nv_7() {
        this.test("_:abc123");
    }

    @Test
    public void nv_10() {
        NodeValue nodeValue = TestNV.nv("'abc'");
        NV nv = new NV(nodeValue);
        Assert.assertEquals((Object)"abc", (Object)nv.getLex());
        Assert.assertEquals((Object)"abc", (Object)nv.getValue());
        Assert.assertEquals((Object)"Literal", (Object)nv.getTermType());
    }

    @Test
    public void nv_12() {
        NodeValue nodeValue = TestNV.nv("<http://jena.apache.org/>");
        NV nv = new NV(nodeValue);
        Assert.assertEquals((Object)"http://jena.apache.org/", (Object)nv.getUri());
        Assert.assertEquals((Object)"http://jena.apache.org/", (Object)nv.getValue());
        Assert.assertEquals((Object)"NamedNode", (Object)nv.getTermType());
    }

    @Test
    public void nv_13() {
        NodeValue nodeValue = TestNV.nv("_:a");
        NV nv = new NV(nodeValue);
        Assert.assertEquals((Object)nv.getLabel(), (Object)nv.getValue());
        Assert.assertEquals((Object)"BlankNode", (Object)nv.getTermType());
    }

    private void test(String str) {
        NodeValue nv = TestNV.nv(str);
        Object x = NV.fromNodeValue((NodeValue)nv);
        NodeValue nv2 = NV.toNodeValue((Object)x);
        Assert.assertEquals((Object)nv, (Object)nv2);
    }

    private static NodeValue nv(String str) {
        return NodeValue.makeNode((Node)SSE.parseNode((String)str));
    }
}

