/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.library;

import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprException;
import org.apache.jena.sparql.expr.VariableNotBoundException;
import org.apache.jena.sparql.function.library.LibTest;
import org.apache.jena.sys.JenaSystem;
import org.junit.Test;

public class TestFnFunctions {
    @Test
    public void apply_1() {
        LibTest.test("fn:apply(math:sqrt, 9)", "3.0e0");
    }

    @Test(expected=ExprEvalException.class)
    public void apply_2() {
        LibTest.test("fn:apply(math:sqrt)", "3.0e0");
    }

    @Test(expected=ExprEvalException.class)
    public void apply_3() {
        LibTest.test("fn:apply(math:sqrt, 9, 10)", "3.0e0");
    }

    @Test(expected=ExprEvalException.class)
    public void apply_4() {
        LibTest.test("fn:apply('bicycle', 9, 10)", "3.0e0");
    }

    @Test(expected=VariableNotBoundException.class)
    public void apply_5() {
        LibTest.test("fn:apply(?var)", "3.0e0");
    }

    @Test(expected=ExprEvalException.class)
    public void apply_6() {
        LibTest.test("fn:apply(<x:unregistered>)", "false");
    }

    @Test(expected=ExprException.class)
    public void apply_7() {
        LibTest.test("fn:apply()", "false");
    }

    @Test
    public void collationKey_1() {
        LibTest.test("fn:collation-key('foo', 'en') = 'Zm9vQGVu'^^xsd:base64Binary");
    }

    @Test(expected=ExprEvalException.class)
    public void collationKey_2() {
        LibTest.test("fn:collation-key('foo', 22) = 'Zm9vQGVu'^^xsd:base64Binary");
    }

    @Test(expected=ExprEvalException.class)
    public void collationKey_3() {
        LibTest.test("fn:collation-key(<x:bar>, 'en') = 'Zm9vQGVu'^^xsd:base64Binary");
    }

    @Test
    public void datetime_1() {
        LibTest.test("fn:dateTime('2017-09-14'^^xsd:date, '10:11:23'^^xsd:time) = '2017-09-14T10:11:23'^^xsd:dateTime");
    }

    @Test
    public void datetime_2() {
        LibTest.test("fn:dateTime('2017-09-14+01:00'^^xsd:date, '10:11:23'^^xsd:time) = '2017-09-14T10:11:23+01:00'^^xsd:dateTime");
    }

    @Test
    public void datetime_3() {
        LibTest.test("fn:dateTime('2017-09-14'^^xsd:date, '10:11:23+01:00'^^xsd:time) = '2017-09-14T10:11:23+01:00'^^xsd:dateTime");
    }

    @Test
    public void datetime_4() {
        LibTest.test("fn:dateTime('2017-09-14+01:00'^^xsd:date, '10:11:23+01:00'^^xsd:time) = '2017-09-14T10:11:23+01:00'^^xsd:dateTime");
    }

    @Test(expected=ExprEvalException.class)
    public void datetime_5() {
        LibTest.test("fn:dateTime('2017-09-14+09:00'^^xsd:date, '10:11:23+01:00'^^xsd:time) = '2017-09-14T10:11:23+01:00'^^xsd:dateTime");
    }

    @Test(expected=ExprEvalException.class)
    public void datetime_6() {
        LibTest.test("fn:dateTime('xyz', '10:11:23+01:00'^^xsd:time) = '2017-09-14T10:11:23+01:00'^^xsd:dateTime");
    }

    @Test(expected=ExprEvalException.class)
    public void datetime_7() {
        LibTest.test("fn:dateTime('2017-09-14+09:00', 'now'^^xsd:time) = '2017-09-14T10:11:23+01:00'^^xsd:dateTime");
    }

    static {
        JenaSystem.init();
    }
}

