/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.user;

import java.util.ArrayList;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.E_Multiply;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.function.user.UserDefinedFunctionFactory;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestUserFunctionsInSparql {
    @BeforeClass
    public static void setup() {
        UserDefinedFunctionFactory.getFactory().clear();
        E_Multiply square = new E_Multiply((Expr)new ExprVar("x"), (Expr)new ExprVar("x"));
        UserDefinedFunctionFactory.getFactory().add("http://example/square", (Expr)square, new ArrayList(square.getVarsMentioned()));
    }

    @AfterClass
    public static void teardown() {
        UserDefinedFunctionFactory.getFactory().clear();
    }

    @Test
    public void test_user_functions_in_sparql() {
        Assert.assertTrue((boolean)UserDefinedFunctionFactory.getFactory().isRegistered("http://example/square"));
        String query = "SELECT (<http://example/square>(2) AS ?square) { }";
        Query q = QueryFactory.create((String)query);
        try (QueryExecution qe = QueryExecutionFactory.create((Query)q, (Model)ModelFactory.createDefaultModel());){
            ResultSet rset = qe.execSelect();
            Assert.assertTrue((boolean)rset.hasNext());
            Binding b = rset.nextBinding();
            Assert.assertFalse((boolean)rset.hasNext());
            Node actual = b.get(Var.alloc((String)"square"));
            Assert.assertEquals((Object)NodeFactoryExtra.intToNode((int)4), (Object)actual);
        }
    }
}

