/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.graph;

import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.shared.PrefixMapping;
import org.junit.Test;

public abstract class AbstractTestPrefixMappingView
extends BaseTest {
    static final String defaultPrefixURI = "";

    protected abstract PrefixMapping create();

    protected abstract PrefixMapping view();

    @Test
    public void prefix1() {
        PrefixMapping pmap = this.create();
    }

    @Test
    public void prefix2() {
        PrefixMapping pmap = this.create();
        pmap.setNsPrefix("ex", "http://example/");
        AbstractTestPrefixMappingView.assertNotNull((Object)pmap.getNsPrefixURI("ex"));
    }

    @Test
    public void prefix3() {
        String uri = "http://example/";
        PrefixMapping pmap = this.create();
        pmap.setNsPrefix("ex", uri);
        PrefixMapping pmap2 = this.view();
        String x = pmap2.getNsPrefixURI("ex");
        AbstractTestPrefixMappingView.assertNotNull((Object)x);
        AbstractTestPrefixMappingView.assertEquals((Object)uri, (Object)x);
    }

    @Test
    public void prefix4() {
        String uri = "http://example/";
        PrefixMapping pmap = this.create();
        pmap.setNsPrefix("ex", uri);
        AbstractTestPrefixMappingView.assertEquals((Object)"ex", (Object)pmap.getNsURIPrefix("http://example/"));
    }

    @Test
    public void prefix5() {
        String uri = "http://example/";
        PrefixMapping pmap = this.create();
        pmap.setNsPrefix("ex", uri);
        AbstractTestPrefixMappingView.assertEquals((Object)(uri + "foo"), (Object)pmap.expandPrefix("ex:foo"));
    }

    @Test
    public void prefix6() {
        String uri = "http://example/";
        PrefixMapping pmap = this.create();
        pmap.setNsPrefix("ex", uri);
        AbstractTestPrefixMappingView.assertEquals((Object)"ex:foo", (Object)pmap.qnameFor("http://example/foo"));
    }

    @Test
    public void prefix7() {
        String uri1 = "http://example/";
        String uri2 = "http://example/ns#";
        PrefixMapping pmap = this.create();
        pmap.setNsPrefix("ex1", uri1);
        pmap.setNsPrefix("ex2", uri2);
        AbstractTestPrefixMappingView.assertEquals((Object)"ex2:foo", (Object)pmap.qnameFor("http://example/ns#foo"));
    }

    @Test
    public void prefix8() {
        PrefixMapping pmap = this.create();
        String x = "scheme:i_do_not_exist";
        AbstractTestPrefixMappingView.assertEquals((Object)x, (Object)pmap.expandPrefix(x));
        AbstractTestPrefixMappingView.assertEquals((Object)x, (Object)pmap.expandPrefix(x));
    }
}

