/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.graph;

import org.apache.jena.atlas.data.ThresholdPolicy;
import org.apache.jena.atlas.data.ThresholdPolicyFactory;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.shared.DeleteDeniedException;
import org.apache.jena.sparql.graph.GraphDefaultDataBag;
import org.apache.jena.sparql.graph.GraphDistinctDataBag;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestGraphsDataBag
extends BaseTest {
    protected Graph distinct;
    protected Graph duplicates;

    @Before
    public void setup() {
        ThresholdPolicy policy = ThresholdPolicyFactory.never();
        this.distinct = new GraphDistinctDataBag(policy);
        ThresholdPolicy policy2 = ThresholdPolicyFactory.never();
        this.duplicates = new GraphDefaultDataBag(policy2);
    }

    @After
    public void shutdown() {
        if (null != this.distinct) {
            this.distinct.close();
        }
        if (null != this.duplicates) {
            this.duplicates.close();
        }
    }

    @Test
    public void add_1() {
        this.distinct.add(SSE.parseTriple((String)"(<x> <p> 'ZZZ')"));
        TestGraphsDataBag.assertEquals((long)1L, (long)this.count(this.distinct));
    }

    @Test
    public void add_2() {
        this.distinct.add(SSE.parseTriple((String)"(<x> <p> 'ZZZ')"));
        this.distinct.add(SSE.parseTriple((String)"(<x> <p> 'ZZZ')"));
        TestGraphsDataBag.assertEquals((long)1L, (long)this.count(this.distinct));
    }

    @Test
    public void add_3() {
        this.duplicates.add(SSE.parseTriple((String)"(<x> <p> 'ZZZ')"));
        this.duplicates.add(SSE.parseTriple((String)"(<x> <p> 'ZZZ')"));
        TestGraphsDataBag.assertEquals((long)2L, (long)this.count(this.duplicates));
    }

    @Test
    public void empty_0() {
        TestGraphsDataBag.assertEquals((long)0L, (long)this.count(this.distinct));
    }

    @Test
    public void removeAll_1() {
        this.distinct.add(SSE.parseTriple((String)"(<x> <p> 'ZZZ')"));
        TestGraphsDataBag.assertEquals((long)1L, (long)this.count(this.distinct));
        this.distinct.clear();
        TestGraphsDataBag.assertEquals((long)0L, (long)this.count(this.distinct));
    }

    @Test(expected=DeleteDeniedException.class)
    public void delete_1() {
        Triple t = SSE.parseTriple((String)"(<x> <p> 'ZZZ')");
        this.distinct.add(t);
        this.distinct.delete(t);
    }

    @Test
    public void complexQuery_1() {
        for (int i = 0; i < 2; ++i) {
            this.distinct.add(SSE.parseTriple((String)"(<http://example.org/a> <http://example.org/p> 'YYY')"));
            this.distinct.add(SSE.parseTriple((String)"(<http://example.org/a> <http://example.org/p2> 'ZZZ')"));
            this.distinct.add(SSE.parseTriple((String)"(<http://example.org/b> <http://example.org/p> 'YYY')"));
            this.distinct.add(SSE.parseTriple((String)"(<http://example.org/b> <http://example.org/p2> 'ZZZ')"));
        }
        TestGraphsDataBag.assertEquals((long)2L, (long)this.query("select * where { ?a <http://example.org/p> ?v ; <http://example.org/p2> ?v2 }", this.distinct));
        TestGraphsDataBag.assertEquals((long)2L, (long)this.query("select distinct * where { ?a <http://example.org/p> ?v ; <http://example.org/p2> ?v2 }", this.distinct));
    }

    @Test
    public void complexQuery_2() {
        for (int i = 0; i < 2; ++i) {
            this.duplicates.add(SSE.parseTriple((String)"(<http://example.org/a> <http://example.org/p> 'YYY')"));
            this.duplicates.add(SSE.parseTriple((String)"(<http://example.org/a> <http://example.org/p2> 'ZZZ')"));
            this.duplicates.add(SSE.parseTriple((String)"(<http://example.org/b> <http://example.org/p> 'YYY')"));
            this.duplicates.add(SSE.parseTriple((String)"(<http://example.org/b> <http://example.org/p2> 'ZZZ')"));
        }
        TestGraphsDataBag.assertEquals((long)8L, (long)this.query("select * where { ?a <http://example.org/p> ?v ; <http://example.org/p2> ?v2 }", this.duplicates));
        TestGraphsDataBag.assertEquals((long)2L, (long)this.query("select distinct * where { ?a <http://example.org/p> ?v ; <http://example.org/p2> ?v2 }", this.duplicates));
    }

    private int query(String str, Graph g) {
        Model model = ModelFactory.createModelForGraph((Graph)g);
        Query q = QueryFactory.create((String)str, (Syntax)Syntax.syntaxARQ);
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)q, (Model)model);){
            ResultSet rs = qexec.execSelect();
            int n = ResultSetFormatter.consume((ResultSet)rs);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int count(Graph g) {
        int toReturn = 0;
        try (ExtendedIterator it = g.find(null, null, null);){
            while (it.hasNext()) {
                it.next();
                ++toReturn;
            }
        }
        return toReturn;
    }
}

