/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.junit;

import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.sparql.vocabulary.DOAP;
import org.apache.jena.sparql.vocabulary.EARL;
import org.apache.jena.sparql.vocabulary.FOAF;
import org.apache.jena.vocabulary.DC;
import org.apache.jena.vocabulary.DCTerms;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.XSD;

public class EarlReport {
    Model earl = ModelFactory.createDefaultModel();
    Resource system = null;
    Resource reporter = null;

    public EarlReport(String systemURI, String name, String version, String homepage) {
        this.earl.setNsPrefix("earl", EARL.getURI());
        this.earl.setNsPrefix("foaf", FOAF.getURI());
        this.earl.setNsPrefix("rdf", RDF.getURI());
        this.earl.setNsPrefix("dc", DC.getURI());
        this.earl.setNsPrefix("dct", DCTerms.getURI());
        this.earl.setNsPrefix("doap", DOAP.getURI());
        this.earl.setNsPrefix("xsd", XSD.getURI());
        Resource resource = this.system = systemURI == null ? this.earl.createResource(EARL.Software) : this.earl.createResource(systemURI, EARL.Software);
        if (name != null) {
            this.system.addProperty(DC.title, name);
        }
        if (version != null) {
            this.system.addProperty(DCTerms.hasVersion, version);
        }
        if (homepage != null) {
            this.system.addProperty(FOAF.homepage, (RDFNode)this.earl.createResource(homepage));
        }
        this.reporter = this.system;
    }

    public Resource getSystem() {
        return this.system;
    }

    public Resource getReporter() {
        return this.reporter;
    }

    public void setReporter(Resource reporter) {
        this.reporter = reporter;
    }

    public void success(String testURI) {
        this.createAssertionResult(testURI, EARL.passed);
    }

    public void failure(String testURI) {
        this.createAssertionResult(testURI, EARL.failed);
    }

    public void notApplicable(String testURI) {
        this.createAssertionResult(testURI, EARL.inapplicable);
    }

    public void notTested(String testURI) {
        this.createAssertionResult(testURI, EARL.untested);
    }

    private void createAssertionResult(String testURI, Resource outcome) {
        Resource result = this.createResult(outcome);
        Resource assertion = this.createAssertion(testURI, result);
    }

    private Resource createAssertion(String testURI, Resource result) {
        Resource thisTest = this.earl.createResource(testURI);
        return this.earl.createResource(EARL.Assertion).addProperty(EARL.test, (RDFNode)thisTest).addProperty(EARL.result, (RDFNode)result).addProperty(EARL.subject, (RDFNode)this.system).addProperty(EARL.assertedBy, (RDFNode)this.system).addProperty(EARL.mode, (RDFNode)EARL.automatic);
    }

    private Resource createResult(Resource outcome) {
        String todayStr = DateTimeUtils.todayAsXSDDateString();
        Literal now = ResourceFactory.createTypedLiteral((String)todayStr, (RDFDatatype)XSDDatatype.XSDdate);
        return this.earl.createResource(EARL.TestResult).addProperty(EARL.outcome, (RDFNode)outcome).addProperty(DC.date, (RDFNode)now);
    }

    public Model getModel() {
        return this.earl;
    }

    public Model getDescription() {
        return this.earl;
    }
}

