/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.junit;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.junit.EarlReport;
import org.apache.jena.sparql.junit.QueryTest;
import org.apache.jena.sparql.junit.QueryTestException;
import org.apache.jena.sparql.junit.SurpressedTest;
import org.apache.jena.sparql.junit.SyntaxTest;
import org.apache.jena.sparql.junit.SyntaxUpdateTest;
import org.apache.jena.sparql.junit.TestItem;
import org.apache.jena.sparql.junit.TestQueryUtils;
import org.apache.jena.sparql.junit.TestSerialization;
import org.apache.jena.sparql.junit.UpdateTest;
import org.apache.jena.sparql.vocabulary.TestManifest;
import org.apache.jena.sparql.vocabulary.TestManifestUpdate_11;
import org.apache.jena.sparql.vocabulary.TestManifestX;
import org.apache.jena.sparql.vocabulary.TestManifest_11;
import org.apache.jena.util.FileManager;
import org.apache.jena.util.junit.TestFactoryManifest;
import org.apache.jena.util.junit.TestUtils;

public class ScriptTestSuiteFactory
extends TestFactoryManifest {
    private FileManager fileManager = FileManager.get();
    public static EarlReport results = null;

    public static TestSuite make(String filename) {
        ScriptTestSuiteFactory tFact = new ScriptTestSuiteFactory();
        return tFact.process(filename);
    }

    public static TestSuite make(String query, String data, String result) {
        TestItem item = TestItem.create(query, query, data, result);
        QueryTest t = new QueryTest(item.getName(), null, item);
        TestSuite ts = new TestSuite();
        ts.setName(TestUtils.safeName((String)query));
        ts.addTest((Test)t);
        return ts;
    }

    public Test makeTest(Resource manifest, Resource entry, String testName, Resource action, Resource result) {
        if (action == null) {
            System.out.println("Null action: " + entry);
            return null;
        }
        Syntax querySyntax = TestQueryUtils.getQuerySyntax(manifest);
        if (!(querySyntax == null || querySyntax.equals((Object)Syntax.syntaxARQ) || querySyntax.equals((Object)Syntax.syntaxSPARQL_10) || querySyntax.equals((Object)Syntax.syntaxSPARQL_11))) {
            throw new QueryTestException("Unknown syntax: " + querySyntax);
        }
        TestItem item = TestItem.create(entry, TestManifest.QueryEvaluationTest);
        Resource testType = item.getTestType();
        QueryTest test = null;
        if (testType != null) {
            if (testType.equals((Object)TestManifest.PositiveSyntaxTest)) {
                return new SyntaxTest(testName, results, item);
            }
            if (testType.equals((Object)TestManifest_11.PositiveSyntaxTest11)) {
                return new SyntaxTest(testName, results, item);
            }
            if (testType.equals((Object)TestManifestX.PositiveSyntaxTestARQ)) {
                return new SyntaxTest(testName, results, item);
            }
            if (testType.equals((Object)TestManifest.NegativeSyntaxTest)) {
                return new SyntaxTest(testName, results, item, false);
            }
            if (testType.equals((Object)TestManifest_11.NegativeSyntaxTest11)) {
                return new SyntaxTest(testName, results, item, false);
            }
            if (testType.equals((Object)TestManifestX.NegativeSyntaxTestARQ)) {
                return new SyntaxTest(testName, results, item, false);
            }
            if (testType.equals((Object)TestManifest_11.PositiveUpdateSyntaxTest11)) {
                return new SyntaxUpdateTest(testName, results, item, true);
            }
            if (testType.equals((Object)TestManifest_11.NegativeUpdateSyntaxTest11)) {
                return new SyntaxUpdateTest(testName, results, item, false);
            }
            if (testType.equals((Object)TestManifestUpdate_11.UpdateEvaluationTest)) {
                return UpdateTest.create(testName, results, entry, action, result);
            }
            if (testType.equals((Object)TestManifest_11.UpdateEvaluationTest)) {
                return UpdateTest.create(testName, results, entry, action, result);
            }
            if (testType.equals((Object)TestManifestX.TestSerialization)) {
                return new TestSerialization(testName, results, item);
            }
            if (testType.equals((Object)TestManifest.QueryEvaluationTest) || testType.equals((Object)TestManifestX.TestQuery)) {
                return new QueryTest(testName, results, item);
            }
            if (testType.equals((Object)TestManifest.ReducedCardinalityTest)) {
                return new QueryTest(testName, results, item);
            }
            if (testType.equals((Object)TestManifestX.TestSurpressed)) {
                return new SurpressedTest(testName, results, item);
            }
            if (testType.equals((Object)TestManifest_11.CSVResultFormatTest)) {
                Log.warn((String)"Tests", (String)("Skip CSV test: " + testName));
                return null;
            }
            System.err.println("Test type '" + testType + "' not recognized");
        }
        test = new QueryTest(testName, results, item);
        return test;
    }
}

