/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.junit;

import org.apache.jena.query.QueryException;
import org.apache.jena.sparql.junit.EarlReport;
import org.apache.jena.sparql.junit.EarlTestCase;
import org.apache.jena.sparql.junit.TestItem;

public class SyntaxTest
extends EarlTestCase {
    static int count = 0;
    String queryString;
    boolean expectLegalSyntax;
    TestItem testItem;

    public SyntaxTest(String testName, EarlReport earl, TestItem t) {
        this(testName, earl, t, true);
    }

    public SyntaxTest(String testName, EarlReport earl, TestItem t, boolean positiveTest) {
        super(testName, t.getURI(), earl);
        this.testItem = t;
        this.expectLegalSyntax = positiveTest;
    }

    public SyntaxTest(String testName, EarlReport earl, String queryString, boolean positiveTest) {
        super(testName, TestItem.fakeURI(), earl);
        this.setTest(testName, queryString, positiveTest);
    }

    private void setTest(String testName, String _queryString, boolean positiveTest) {
        super.setName(testName);
        this.queryString = _queryString;
        this.expectLegalSyntax = positiveTest;
    }

    @Override
    protected void runTestForReal() {
        try {
            if (this.queryString == null) {
                this.queryFromTestItem(this.testItem);
            } else {
                this.queryFromString(this.queryString);
            }
            if (!this.expectLegalSyntax) {
                SyntaxTest.fail((String)"Expected parse failure");
            }
        }
        catch (QueryException qEx) {
            if (this.expectLegalSyntax) {
                throw qEx;
            }
        }
        catch (Exception ex) {
            SyntaxTest.fail((String)("Exception: " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }
}

